/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.Integrator;
import ffx.openmm.LangevinIntegrator;
import ffx.openmm.VerletIntegrator;
import ffx.potential.openmm.CustomMTSIntegrator;
import ffx.potential.openmm.CustomMTSLangevinIntegrator;
import ffx.potential.openmm.OpenMMSystem;
import ffx.potential.parameters.ForceField;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;

public class OpenMMIntegrator {
    private static final Logger logger = Logger.getLogger(OpenMMIntegrator.class.getName());
    private static final double constraintTolerance = 1.0E-4;

    private OpenMMIntegrator() {
    }

    public static Integrator createIntegrator(String name, double timeStep, double temperature, OpenMMSystem openMMSystem) {
        switch (name) {
            default: {
                return OpenMMIntegrator.createVerletIntegrator(timeStep);
            }
            case "LANGEVIN": {
                return OpenMMIntegrator.createLangevinIntegrator(timeStep, temperature, openMMSystem.getForceField());
            }
            case "MTS": {
                return OpenMMIntegrator.createCustomMTSIntegrator(timeStep, openMMSystem);
            }
            case "LANGEVIN-MTS": 
        }
        return OpenMMIntegrator.createCustomMTSLangevinIntegrator(timeStep, temperature, openMMSystem);
    }

    public static LangevinIntegrator createLangevinIntegrator(double dt, double temperature, ForceField forceField) {
        CompositeConfiguration properties = forceField.getProperties();
        int seed = 0;
        if (properties.containsKey("integrator-seed")) {
            seed = properties.getInt("integrator-seed", 0);
        }
        double frictionCoeff = forceField.getDouble("FRICTION_COEFF", 91.0);
        LangevinIntegrator langevinIntegrator = new LangevinIntegrator(dt, temperature, frictionCoeff);
        langevinIntegrator.setRandomNumberSeed(seed);
        langevinIntegrator.setConstraintTolerance(1.0E-4);
        logger.info("  Langevin Integrator");
        logger.info(String.format("  Target Temperature:   %6.2f (K)", temperature));
        logger.info(String.format("  Friction Coefficient: %6.2f (1/psec)", frictionCoeff));
        logger.info(String.format("  Time step:            %6.2f (fsec)", dt * 1000.0));
        return langevinIntegrator;
    }

    public static CustomMTSIntegrator createCustomMTSIntegrator(double dt, OpenMMSystem openMMSystem) {
        return new CustomMTSIntegrator(dt, 1.0E-4, openMMSystem.hasAmoebaCavitationForce());
    }

    public static CustomMTSLangevinIntegrator createCustomMTSLangevinIntegrator(double dt, double temperature, OpenMMSystem openMMSystem) {
        ForceField forceField = openMMSystem.getForceField();
        double frictionCoeff = forceField.getDouble("FRICTION_COEFF", 91.0);
        CustomMTSLangevinIntegrator customMTSLangevinIntegrator = new CustomMTSLangevinIntegrator(dt, temperature, frictionCoeff, openMMSystem.hasAmoebaCavitationForce());
        return customMTSLangevinIntegrator;
    }

    public static VerletIntegrator createVerletIntegrator(double dt) {
        VerletIntegrator verletIntegrator = new VerletIntegrator(dt);
        verletIntegrator.setConstraintTolerance(1.0E-4);
        logger.info("\n  Verlet Integrator");
        logger.info(String.format("  Time step:            %6.2f (fsec)", dt * 1000.0));
        return verletIntegrator;
    }
}

