/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import edu.uiowa.jopenmm.OpenMM_Vec3;
import ffx.crystal.Crystal;
import ffx.numerics.Potential;
import ffx.openmm.Force;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.TorsionTorsion;
import ffx.potential.nonbonded.ParticleMeshEwald;
import ffx.potential.nonbonded.VanDerWaals;
import ffx.potential.openmm.AmoebaMultipoleForce;
import ffx.potential.openmm.AmoebaTorsionTorsionForce;
import ffx.potential.openmm.AmoebaVdwForce;
import ffx.potential.openmm.AngleForce;
import ffx.potential.openmm.AngleTorsionForce;
import ffx.potential.openmm.BondForce;
import ffx.potential.openmm.ImproperTorsionForce;
import ffx.potential.openmm.InPlaneAngleForce;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMSystem;
import ffx.potential.openmm.OutOfPlaneBendForce;
import ffx.potential.openmm.PiOrbitalTorsionForce;
import ffx.potential.openmm.RestrainTorsionsForce;
import ffx.potential.openmm.StretchBendForce;
import ffx.potential.openmm.StretchTorsionForce;
import ffx.potential.openmm.TorsionForce;
import ffx.potential.openmm.UreyBradleyForce;
import ffx.potential.terms.TorsionTorsionPotentialEnergy;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class OpenMMDualTopologySystem
extends OpenMMSystem {
    private static final Logger logger = Logger.getLogger(OpenMMDualTopologySystem.class.getName());
    private final OpenMMDualTopologyEnergy openMMDualTopologyEnergy;
    protected ForceFieldEnergy forceFieldEnergy;
    protected ForceFieldEnergy forceFieldEnergy2;
    protected BondForce bondForce2 = null;
    protected AngleForce angleForce2 = null;
    protected InPlaneAngleForce inPlaneAngleForce2 = null;
    protected StretchBendForce stretchBendForce2 = null;
    protected UreyBradleyForce ureyBradleyForce2 = null;
    protected OutOfPlaneBendForce outOfPlaneBendForce2 = null;
    protected PiOrbitalTorsionForce piOrbitalTorsionForce2 = null;
    protected TorsionForce torsionForce2 = null;
    protected ImproperTorsionForce improperTorsionForce2 = null;
    protected StretchTorsionForce stretchTorsionForce2 = null;
    protected AngleTorsionForce angleTorsionForce2 = null;
    protected RestrainTorsionsForce restrainTorsionsForce2 = null;
    protected AmoebaTorsionTorsionForce amoebaTorsionTorsionForce2 = null;
    private AmoebaVdwForce amoebaVDWForce2 = null;
    private AmoebaMultipoleForce amoebaMultipoleForce2 = null;

    public OpenMMDualTopologySystem(OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        this.openMMDualTopologyEnergy = openMMDualTopologyEnergy;
        this.forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(0);
        this.forceFieldEnergy2 = openMMDualTopologyEnergy.getForceFieldEnergy(1);
        this.forceField = openMMDualTopologyEnergy.getMolecularAssembly(0).getForceField();
        this.atoms = openMMDualTopologyEnergy.getDualTopologyAtoms(0);
        try {
            this.addAtoms();
        }
        catch (Exception e) {
            logger.severe(" Atom without mass encountered.");
        }
        logger.info(String.format("\n OpenMM dual-topology system created with %d atoms.", this.atoms.length));
    }

    @Override
    public Potential getPotential() {
        return this.openMMDualTopologyEnergy;
    }

    @Override
    public Crystal getCrystal() {
        return this.forceFieldEnergy.getCrystal();
    }

    @Override
    protected void setDefaultPeriodicBoxVectors() {
        Crystal crystal = this.forceFieldEnergy.getCrystal();
        if (!crystal.aperiodic()) {
            OpenMM_Vec3 a = new OpenMM_Vec3();
            OpenMM_Vec3 b = new OpenMM_Vec3();
            OpenMM_Vec3 c = new OpenMM_Vec3();
            double[][] Ai = crystal.Ai;
            a.x = Ai[0][0] * 0.1;
            a.y = Ai[0][1] * 0.1;
            a.z = Ai[0][2] * 0.1;
            b.x = Ai[1][0] * 0.1;
            b.y = Ai[1][1] * 0.1;
            b.z = Ai[1][2] * 0.1;
            c.x = Ai[2][0] * 0.1;
            c.y = Ai[2][1] * 0.1;
            c.z = Ai[2][2] * 0.1;
            this.setDefaultPeriodicBoxVectors(a, b, c);
        }
    }

    @Override
    public void addForces() {
        this.setDefaultPeriodicBoxVectors();
        boolean rigidHydrogen = this.forceField.getBoolean("RIGID_HYDROGEN", false);
        boolean rigidBonds = this.forceField.getBoolean("RIGID_BONDS", false);
        boolean rigidHydrogenAngles = this.forceField.getBoolean("RIGID_HYDROGEN_ANGLES", false);
        if (rigidHydrogen || rigidBonds || rigidHydrogenAngles) {
            logger.severe(" Dual Topology does not support rigid hydrogen atoms.");
        }
        logger.info("\n Bonded Terms\n");
        this.bondForce = (BondForce)BondForce.constructForce(0, this.openMMDualTopologyEnergy);
        this.bondForce2 = (BondForce)BondForce.constructForce(1, this.openMMDualTopologyEnergy);
        this.addForce((Force)this.bondForce);
        this.addForce((Force)this.bondForce2);
        this.angleForce = (AngleForce)AngleForce.constructForce(0, this.openMMDualTopologyEnergy);
        this.angleForce2 = (AngleForce)AngleForce.constructForce(1, this.openMMDualTopologyEnergy);
        this.addForce((Force)this.angleForce);
        this.addForce((Force)this.angleForce2);
        this.inPlaneAngleForce = (InPlaneAngleForce)InPlaneAngleForce.constructForce(0, this.openMMDualTopologyEnergy);
        this.inPlaneAngleForce2 = (InPlaneAngleForce)InPlaneAngleForce.constructForce(1, this.openMMDualTopologyEnergy);
        this.addForce((Force)this.inPlaneAngleForce);
        this.addForce((Force)this.inPlaneAngleForce2);
        this.stretchBendForce = (StretchBendForce)StretchBendForce.constructForce(0, this.openMMDualTopologyEnergy);
        this.stretchBendForce2 = (StretchBendForce)StretchBendForce.constructForce(1, this.openMMDualTopologyEnergy);
        this.addForce((Force)this.stretchBendForce);
        this.addForce((Force)this.stretchBendForce2);
        this.ureyBradleyForce = (UreyBradleyForce)UreyBradleyForce.constructForce(0, this.openMMDualTopologyEnergy);
        this.ureyBradleyForce2 = (UreyBradleyForce)UreyBradleyForce.constructForce(1, this.openMMDualTopologyEnergy);
        this.addForce((Force)this.ureyBradleyForce);
        this.addForce((Force)this.ureyBradleyForce2);
        this.outOfPlaneBendForce = (OutOfPlaneBendForce)OutOfPlaneBendForce.constructForce(0, this.openMMDualTopologyEnergy);
        this.outOfPlaneBendForce2 = (OutOfPlaneBendForce)OutOfPlaneBendForce.constructForce(1, this.openMMDualTopologyEnergy);
        this.addForce((Force)this.outOfPlaneBendForce);
        this.addForce((Force)this.outOfPlaneBendForce2);
        this.piOrbitalTorsionForce = (PiOrbitalTorsionForce)PiOrbitalTorsionForce.constructForce(0, this.openMMDualTopologyEnergy);
        this.piOrbitalTorsionForce2 = (PiOrbitalTorsionForce)PiOrbitalTorsionForce.constructForce(1, this.openMMDualTopologyEnergy);
        this.addForce((Force)this.piOrbitalTorsionForce);
        this.addForce((Force)this.piOrbitalTorsionForce2);
        this.torsionForce = (TorsionForce)TorsionForce.constructForce(0, this.openMMDualTopologyEnergy);
        this.torsionForce2 = (TorsionForce)TorsionForce.constructForce(1, this.openMMDualTopologyEnergy);
        this.addForce((Force)this.torsionForce);
        this.addForce((Force)this.torsionForce2);
        this.improperTorsionForce = (ImproperTorsionForce)ImproperTorsionForce.constructForce(0, this.openMMDualTopologyEnergy);
        this.improperTorsionForce2 = (ImproperTorsionForce)ImproperTorsionForce.constructForce(1, this.openMMDualTopologyEnergy);
        this.addForce((Force)this.improperTorsionForce);
        this.addForce((Force)this.improperTorsionForce2);
        this.stretchTorsionForce = (StretchTorsionForce)StretchTorsionForce.constructForce(0, this.openMMDualTopologyEnergy);
        this.stretchTorsionForce2 = (StretchTorsionForce)StretchTorsionForce.constructForce(1, this.openMMDualTopologyEnergy);
        this.addForce((Force)this.stretchTorsionForce);
        this.addForce((Force)this.stretchTorsionForce2);
        this.angleTorsionForce = (AngleTorsionForce)AngleTorsionForce.constructForce(0, this.openMMDualTopologyEnergy);
        this.angleTorsionForce2 = (AngleTorsionForce)AngleTorsionForce.constructForce(1, this.openMMDualTopologyEnergy);
        this.addForce((Force)this.angleTorsionForce);
        this.addForce((Force)this.angleTorsionForce2);
        if (this.openMMDualTopologyEnergy.getForceFieldEnergy(0).getRestrainMode() == ForceFieldEnergy.RestrainMode.ALCHEMICAL) {
            this.restrainTorsionsForce = (RestrainTorsionsForce)RestrainTorsionsForce.constructForce(0, this.openMMDualTopologyEnergy);
            this.restrainTorsionsForce2 = (RestrainTorsionsForce)RestrainTorsionsForce.constructForce(1, this.openMMDualTopologyEnergy);
            this.addForce((Force)this.restrainTorsionsForce);
            this.addForce((Force)this.restrainTorsionsForce2);
        }
        this.amoebaTorsionTorsionForce = (AmoebaTorsionTorsionForce)AmoebaTorsionTorsionForce.constructForce(0, this.openMMDualTopologyEnergy);
        this.addForce((Force)this.amoebaTorsionTorsionForce);
        TorsionTorsionPotentialEnergy torsionTorsionPotentialEnergy = this.openMMDualTopologyEnergy.getForceFieldEnergy(0).getTorsionTorsionPotentialEnergy();
        TorsionTorsionPotentialEnergy torsionTorsionPotentialEnergy2 = this.openMMDualTopologyEnergy.getForceFieldEnergy(0).getTorsionTorsionPotentialEnergy();
        int numTorsionTorsions = 0;
        int numTorsionTorsions2 = 0;
        if (torsionTorsionPotentialEnergy != null) {
            numTorsionTorsions = torsionTorsionPotentialEnergy.getNumberOfTorsionTorsions();
        }
        if (torsionTorsionPotentialEnergy2 != null) {
            numTorsionTorsions2 = torsionTorsionPotentialEnergy2.getNumberOfTorsionTorsions();
        }
        if (numTorsionTorsions != numTorsionTorsions2) {
            logger.severe(" The number of Torsion-Torsion forces in the two topologies do not match: " + numTorsionTorsions + " vs. " + numTorsionTorsions2);
        } else if (numTorsionTorsions != 0) {
            TorsionTorsion[] torsionTorsion = torsionTorsionPotentialEnergy.getTorsionTorsionArray();
            TorsionTorsion[] torsionTorsion2 = torsionTorsionPotentialEnergy2.getTorsionTorsionArray();
            for (int i = 0; i < numTorsionTorsions; ++i) {
                TorsionTorsion tt1 = torsionTorsion[i];
                TorsionTorsion tt2 = torsionTorsion2[i];
                if (tt1.equals(tt2)) continue;
                logger.severe(" The Torsion-Torsion terms in the two topologies do not match: " + String.valueOf(tt1) + " vs. " + String.valueOf(tt2));
            }
        }
        VanDerWaals vdW1 = this.forceFieldEnergy.getVdwNode();
        VanDerWaals vdW2 = this.forceFieldEnergy2.getVdwNode();
        if (vdW1 != null || vdW2 != null) {
            logger.info("\n Non-Bonded Terms");
            if (vdW1 != null) {
                this.amoebaVDWForce = (AmoebaVdwForce)AmoebaVdwForce.constructForce(0, this.openMMDualTopologyEnergy);
                this.addForce((Force)this.amoebaVDWForce);
            }
            if (vdW2 != null) {
                this.amoebaVDWForce2 = (AmoebaVdwForce)AmoebaVdwForce.constructForce(1, this.openMMDualTopologyEnergy);
                this.amoebaVDWForce2.setLambdaName("AmoebaVdwLambda2");
                this.addForce((Force)this.amoebaVDWForce2);
            }
            ParticleMeshEwald pme = this.forceFieldEnergy.getPmeNode();
            ParticleMeshEwald pme2 = this.forceFieldEnergy2.getPmeNode();
            if (pme != null) {
                this.amoebaMultipoleForce = (AmoebaMultipoleForce)AmoebaMultipoleForce.constructForce(0, this.openMMDualTopologyEnergy);
                this.addForce((Force)this.amoebaMultipoleForce);
            }
            if (pme2 != null) {
                this.amoebaMultipoleForce2 = (AmoebaMultipoleForce)AmoebaMultipoleForce.constructForce(1, this.openMMDualTopologyEnergy);
                this.addForce((Force)this.amoebaMultipoleForce2);
            }
        }
    }

    @Override
    public int getNumberOfVariables() {
        int nActive = 0;
        int nAtoms = this.atoms.length;
        for (int i = 0; i < nAtoms; ++i) {
            if (!this.atoms[i].isActive()) continue;
            ++nActive;
        }
        int ret = nActive * 3;
        return ret;
    }

    @Override
    public int calculateDegreesOfFreedom() {
        int dof = this.getNumberOfVariables();
        dof -= this.getNumConstraints();
        if (this.cmMotionRemover != null) {
            dof -= 3;
        }
        return dof;
    }

    @Override
    public void free() {
        if (this.getPointer() != null) {
            logger.fine(" Free OpenMM dual-topology system.");
            this.destroy();
            logger.fine(" Free OpenMM dual-topology system completed.");
        }
    }

    @Override
    public void updateParameters(@Nullable Atom[] atoms) {
        double lambdaVDW;
        VanDerWaals vanDerWaals;
        if (this.bondForce != null) {
            this.bondForce.updateForce(0, this.openMMDualTopologyEnergy);
        }
        if (this.bondForce2 != null) {
            this.bondForce2.updateForce(1, this.openMMDualTopologyEnergy);
        }
        if (this.angleForce != null) {
            this.angleForce.updateForce(0, this.openMMDualTopologyEnergy);
        }
        if (this.angleForce2 != null) {
            this.angleForce2.updateForce(1, this.openMMDualTopologyEnergy);
        }
        if (this.inPlaneAngleForce != null) {
            this.inPlaneAngleForce.updateForce(0, this.openMMDualTopologyEnergy);
        }
        if (this.inPlaneAngleForce2 != null) {
            this.inPlaneAngleForce2.updateForce(1, this.openMMDualTopologyEnergy);
        }
        if (this.stretchBendForce != null) {
            this.stretchBendForce.updateForce(0, this.openMMDualTopologyEnergy);
        }
        if (this.stretchBendForce2 != null) {
            this.stretchBendForce2.updateForce(1, this.openMMDualTopologyEnergy);
        }
        if (this.ureyBradleyForce != null) {
            this.ureyBradleyForce.updateForce(0, this.openMMDualTopologyEnergy);
        }
        if (this.ureyBradleyForce2 != null) {
            this.ureyBradleyForce2.updateForce(1, this.openMMDualTopologyEnergy);
        }
        if (this.outOfPlaneBendForce != null) {
            this.outOfPlaneBendForce.updateForce(0, this.openMMDualTopologyEnergy);
        }
        if (this.outOfPlaneBendForce2 != null) {
            this.outOfPlaneBendForce2.updateForce(1, this.openMMDualTopologyEnergy);
        }
        if (this.piOrbitalTorsionForce != null) {
            this.piOrbitalTorsionForce.updateForce(0, this.openMMDualTopologyEnergy);
        }
        if (this.piOrbitalTorsionForce2 != null) {
            this.piOrbitalTorsionForce2.updateForce(1, this.openMMDualTopologyEnergy);
        }
        if (this.torsionForce != null) {
            this.torsionForce.updateForce(0, this.openMMDualTopologyEnergy);
        }
        if (this.torsionForce2 != null) {
            this.torsionForce2.updateForce(1, this.openMMDualTopologyEnergy);
        }
        if (this.improperTorsionForce != null) {
            this.improperTorsionForce.updateForce(0, this.openMMDualTopologyEnergy);
        }
        if (this.improperTorsionForce2 != null) {
            this.improperTorsionForce2.updateForce(1, this.openMMDualTopologyEnergy);
        }
        if (this.stretchTorsionForce != null) {
            this.stretchTorsionForce.updateForce(0, this.openMMDualTopologyEnergy);
        }
        if (this.stretchTorsionForce2 != null) {
            this.stretchTorsionForce2.updateForce(1, this.openMMDualTopologyEnergy);
        }
        if (this.angleTorsionForce != null) {
            this.angleTorsionForce.updateForce(0, this.openMMDualTopologyEnergy);
        }
        if (this.angleTorsionForce2 != null) {
            this.angleTorsionForce2.updateForce(1, this.openMMDualTopologyEnergy);
        }
        if (this.restrainTorsionsForce != null) {
            this.restrainTorsionsForce.updateForce(0, this.openMMDualTopologyEnergy);
        }
        if (this.restrainTorsionsForce2 != null) {
            this.restrainTorsionsForce2.updateForce(1, this.openMMDualTopologyEnergy);
        }
        if (this.amoebaVDWForce != null) {
            vanDerWaals = this.forceFieldEnergy.getVdwNode();
            if (vanDerWaals.getLambdaTerm()) {
                lambdaVDW = vanDerWaals.getLambda();
                this.openMMDualTopologyEnergy.getContext().setParameter("AmoebaVdwLambda", lambdaVDW);
            }
            atoms = this.forceFieldEnergy.getAtomArray();
            this.amoebaVDWForce.updateForce(atoms, 0, this.openMMDualTopologyEnergy);
        }
        if (this.amoebaVDWForce2 != null) {
            vanDerWaals = this.forceFieldEnergy2.getVdwNode();
            if (vanDerWaals.getLambdaTerm()) {
                lambdaVDW = vanDerWaals.getLambda();
                this.openMMDualTopologyEnergy.getContext().setParameter("AmoebaVdwLambda2", lambdaVDW);
            }
            atoms = this.forceFieldEnergy2.getAtomArray();
            this.amoebaVDWForce2.updateForce(atoms, 1, this.openMMDualTopologyEnergy);
        }
        if (this.amoebaMultipoleForce != null) {
            atoms = this.forceFieldEnergy.getAtomArray();
            this.amoebaMultipoleForce.updateForce(atoms, 0, this.openMMDualTopologyEnergy);
        }
        if (this.amoebaMultipoleForce2 != null) {
            atoms = this.forceFieldEnergy2.getAtomArray();
            this.amoebaMultipoleForce2.updateForce(atoms, 1, this.openMMDualTopologyEnergy);
        }
    }
}

