/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.Force;
import ffx.openmm.PeriodicTorsionForce;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.ImproperTorsion;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.ImproperTorsionType;
import ffx.potential.terms.ImproperTorsionPotentialEnergy;
import java.util.logging.Logger;

public class ImproperTorsionForce
extends PeriodicTorsionForce {
    private static final Logger logger = Logger.getLogger(ImproperTorsionForce.class.getName());

    public ImproperTorsionForce(ImproperTorsionPotentialEnergy improperTorsionPotentialEnergy) {
        ImproperTorsion[] improperTorsions;
        for (ImproperTorsion improperTorsion : improperTorsions = improperTorsionPotentialEnergy.getImproperTorsionArray()) {
            int a1 = improperTorsion.getAtom(0).getArrayIndex();
            int a2 = improperTorsion.getAtom(1).getArrayIndex();
            int a3 = improperTorsion.getAtom(2).getArrayIndex();
            int a4 = improperTorsion.getAtom(3).getArrayIndex();
            ImproperTorsionType type = improperTorsion.improperType;
            double forceConstant = 4.184 * type.impTorUnit * improperTorsion.scaleFactor * type.k;
            this.addTorsion(a1, a2, a3, a4, type.periodicity, type.phase * (Math.PI / 180), forceConstant);
        }
        int forceGroup = improperTorsionPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Improper Torsions:                 %10d", improperTorsions.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public ImproperTorsionForce(ImproperTorsionPotentialEnergy improperTorsionPotentialEnergy, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ImproperTorsion[] improperTorsions = improperTorsionPotentialEnergy.getImproperTorsionArray();
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        for (ImproperTorsion improperTorsion : improperTorsions) {
            int a1 = improperTorsion.getAtom(0).getArrayIndex();
            int a2 = improperTorsion.getAtom(1).getArrayIndex();
            int a3 = improperTorsion.getAtom(2).getArrayIndex();
            int a4 = improperTorsion.getAtom(3).getArrayIndex();
            a1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a1);
            a2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a2);
            a3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a3);
            a4 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a4);
            ImproperTorsionType type = improperTorsion.improperType;
            double forceConstant = 4.184 * type.impTorUnit * improperTorsion.scaleFactor * type.k;
            if (!improperTorsion.applyLambda()) {
                forceConstant *= scale;
            }
            this.addTorsion(a1, a2, a3, a4, type.periodicity, type.phase * (Math.PI / 180), forceConstant);
        }
        int forceGroup = improperTorsionPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Improper Torsions:                 %10d", improperTorsions.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        ImproperTorsionPotentialEnergy improperTorsionPotentialEnergy = openMMEnergy.getImproperTorsionPotentialEnergy();
        if (improperTorsionPotentialEnergy == null) {
            return null;
        }
        return new ImproperTorsionForce(improperTorsionPotentialEnergy);
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        ImproperTorsionPotentialEnergy improperTorsionPotentialEnergy = forceFieldEnergy.getImproperTorsionPotentialEnergy();
        if (improperTorsionPotentialEnergy == null) {
            return null;
        }
        return new ImproperTorsionForce(improperTorsionPotentialEnergy, topology, openMMDualTopologyEnergy);
    }

    public void updateForce(OpenMMEnergy openMMEnergy) {
        ImproperTorsionPotentialEnergy improperTorsionPotentialEnergy = openMMEnergy.getImproperTorsionPotentialEnergy();
        if (improperTorsionPotentialEnergy == null) {
            return;
        }
        ImproperTorsion[] improperTorsions = improperTorsionPotentialEnergy.getImproperTorsionArray();
        int nImproperTorsions = improperTorsions.length;
        for (int i = 0; i < nImproperTorsions; ++i) {
            ImproperTorsion improperTorsion = improperTorsions[i];
            int a1 = improperTorsion.getAtom(0).getXyzIndex() - 1;
            int a2 = improperTorsion.getAtom(1).getXyzIndex() - 1;
            int a3 = improperTorsion.getAtom(2).getXyzIndex() - 1;
            int a4 = improperTorsion.getAtom(3).getXyzIndex() - 1;
            ImproperTorsionType type = improperTorsion.improperType;
            double forceConstant = 4.184 * type.impTorUnit * improperTorsion.scaleFactor * type.k;
            this.setTorsionParameters(i, a1, a2, a3, a4, type.periodicity, type.phase * (Math.PI / 180), forceConstant);
        }
        this.updateParametersInContext(openMMEnergy.getContext());
    }

    public void updateForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        ImproperTorsionPotentialEnergy improperTorsionPotentialEnergy = forceFieldEnergy.getImproperTorsionPotentialEnergy();
        if (improperTorsionPotentialEnergy == null) {
            return;
        }
        ImproperTorsion[] improperTorsions = improperTorsionPotentialEnergy.getImproperTorsionArray();
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        int nImproperTorsions = improperTorsions.length;
        for (int i = 0; i < nImproperTorsions; ++i) {
            ImproperTorsion improperTorsion = improperTorsions[i];
            int a1 = improperTorsion.getAtom(0).getArrayIndex();
            int a2 = improperTorsion.getAtom(1).getArrayIndex();
            int a3 = improperTorsion.getAtom(2).getArrayIndex();
            int a4 = improperTorsion.getAtom(3).getArrayIndex();
            a1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a1);
            a2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a2);
            a3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a3);
            a4 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a4);
            ImproperTorsionType type = improperTorsion.improperType;
            double forceConstant = 4.184 * type.impTorUnit * improperTorsion.scaleFactor * type.k;
            if (!improperTorsion.applyLambda()) {
                forceConstant *= scale;
            }
            this.setTorsionParameters(i, a1, a2, a3, a4, type.periodicity, type.phase * (Math.PI / 180), forceConstant);
        }
        this.updateParametersInContext(openMMDualTopologyEnergy.getContext());
    }
}

