/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.CustomIntegrator;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class CustomMTSLangevinIntegrator
extends CustomIntegrator {
    private static final Logger logger = Logger.getLogger(CustomMTSLangevinIntegrator.class.getName());

    public CustomMTSLangevinIntegrator(double dt, double temperature, double frictionCoeff, boolean hasAmoebaCavitationForce) {
        super(dt);
        int n = 4;
        int[] forceGroups = new int[]{1, 0};
        int[] subSteps = new int[]{1, 4};
        if (hasAmoebaCavitationForce) {
            n = 8;
            forceGroups = new int[]{2, 1, 0};
            subSteps = new int[]{1, 2, 8};
        }
        this.addGlobalVariable("a", Math.exp(-frictionCoeff * dt / (double)n));
        this.addGlobalVariable("b", FastMath.sqrt((double)(1.0 - Math.exp(-2.0 * frictionCoeff * dt / (double)n))));
        this.addGlobalVariable("kT", 0.0019872042586408316 * temperature * 4.184);
        this.addPerDofVariable("x1", 0.0);
        StringBuilder sb = new StringBuilder(" Update Context State\n");
        this.addUpdateContextState();
        this.createMTSLangevinSubStep(1, forceGroups, subSteps, sb);
        logger.finest(" Langevin-MTS steps:" + String.valueOf(sb));
        this.addConstrainVelocities();
        logger.info("  Custom MTS Langevin Integrator");
        logger.info(String.format("  Time step:            %6.2f (fsec)", dt * 1000.0));
        logger.info(String.format("  Inner Time step:      %6.2f (fsec)", dt / (double)n * 1000.0));
        logger.info(String.format("  Friction Coefficient: %6.2f (1/psec)", frictionCoeff));
    }

    public void createMTSLangevinSubStep(int parentSubsteps, int[] forceGroups, int[] subSteps, StringBuilder sb) {
        int forceGroup = forceGroups[0];
        int steps = subSteps[0];
        int stepsPerParentStep = steps / parentSubsteps;
        if (stepsPerParentStep < 1 || steps % parentSubsteps != 0) {
            throw new IllegalArgumentException("The number for substeps for each group must be a multiple of the number for the previous group");
        }
        if (forceGroup < 0 || forceGroup > 31) {
            throw new IllegalArgumentException("Force group must be between 0 and 31");
        }
        sb.append(" Force Group: ").append(forceGroup).append(" ForceGroup length: ").append(forceGroups.length).append(" Steps: ").append(steps).append(" Step Per Parent Step: ").append(stepsPerParentStep).append(" Parent Sub Steps: ").append(parentSubsteps).append("\n");
        for (int i = 0; i < stepsPerParentStep; ++i) {
            Object step = "v+0.5*(dt/" + steps + ")*f" + forceGroup + "/m";
            sb.append(" v = ").append((String)step).append("\n");
            this.addComputePerDof("v", (String)step);
            if (forceGroups.length == 1) {
                step = "x+(dt/" + 2 * steps + ")*v";
                sb.append(" x = ").append((String)step).append("\n");
                this.addComputePerDof("x", (String)step);
                step = "a*v + b*sqrt(kT/m)*gaussian";
                sb.append(" v = ").append((String)step).append("\n");
                this.addComputePerDof("v", (String)step);
                step = "x+(dt/" + 2 * steps + ")*v";
                sb.append(" x = ").append((String)step).append("\n");
                this.addComputePerDof("x", (String)step);
                step = "x";
                sb.append(" x1 = ").append((String)step).append("\n");
                this.addComputePerDof("x1", (String)step);
                sb.append(" Constrain Positions\n");
                this.addConstrainPositions();
                step = "v+(x-x1)/(dt/" + steps + ")";
                sb.append(" v = ").append((String)step).append("\n");
                this.addComputePerDof("v", (String)step);
                sb.append(" Constrain Velocities\n");
                this.addConstrainVelocities();
            } else {
                this.createMTSLangevinSubStep(steps, Arrays.copyOfRange(forceGroups, 1, forceGroups.length), Arrays.copyOfRange(subSteps, 1, subSteps.length), sb);
            }
            step = "v+0.5*(dt/" + steps + ")*f" + forceGroup + "/m";
            sb.append(" v = ").append((String)step).append("\n");
            this.addComputePerDof("v", (String)step);
        }
    }
}

