/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.CustomBondForce;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.Bond;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.BondType;
import ffx.potential.terms.BondPotentialEnergy;
import java.util.logging.Logger;

public class BondForce
extends CustomBondForce {
    private static final Logger logger = Logger.getLogger(BondForce.class.getName());

    public BondForce(BondPotentialEnergy bondPotentialEnergy) {
        super(bondPotentialEnergy.getBondEnergyString());
        Bond[] bonds = bondPotentialEnergy.getBondArray();
        this.addPerBondParameter("r0");
        this.addPerBondParameter("k");
        this.setName("AmoebaBond");
        double kParameterConversion = 418.3999999999999;
        DoubleArray parameters = new DoubleArray(0);
        for (Bond bond : bonds) {
            int i1 = bond.getAtom(0).getArrayIndex();
            int i2 = bond.getAtom(1).getArrayIndex();
            BondType bondType = bond.bondType;
            double r0 = bondType.distance * 0.1;
            double k = kParameterConversion * bondType.forceConstant * bond.bondType.bondUnit;
            parameters.append(r0);
            parameters.append(k);
            this.addBond(i1, i2, parameters);
            parameters.resize(0);
        }
        parameters.destroy();
        int forceGroup = bondPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Bonds:                             %10d", bonds.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public BondForce(BondPotentialEnergy bondPotentialEnergy, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        super(bondPotentialEnergy.getBondEnergyString());
        Bond[] bonds = bondPotentialEnergy.getBondArray();
        this.addPerBondParameter("r0");
        this.addPerBondParameter("k");
        this.setName("AmoebaBond");
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        double kParameterConversion = 418.3999999999999;
        DoubleArray parameters = new DoubleArray(0);
        for (Bond bond : bonds) {
            int i1 = bond.getAtom(0).getArrayIndex();
            int i2 = bond.getAtom(1).getArrayIndex();
            BondType bondType = bond.bondType;
            double r0 = bondType.distance * 0.1;
            double k = kParameterConversion * bondType.forceConstant * bond.bondType.bondUnit;
            if (!bond.applyLambda()) {
                k *= scale;
            }
            parameters.append(r0);
            parameters.append(k);
            i1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i1);
            i2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i2);
            this.addBond(i1, i2, parameters);
            parameters.resize(0);
        }
        parameters.destroy();
        int forceGroup = bondPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Bonds:                             %10d", bonds.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        BondPotentialEnergy bondPotentialEnergy = openMMEnergy.getBondPotentialEnergy();
        if (bondPotentialEnergy == null) {
            return null;
        }
        return new BondForce(bondPotentialEnergy);
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        BondPotentialEnergy bondPotentialEnergy = forceFieldEnergy.getBondPotentialEnergy();
        if (bondPotentialEnergy == null) {
            return null;
        }
        return new BondForce(bondPotentialEnergy, topology, openMMDualTopologyEnergy);
    }

    public void updateForce(OpenMMEnergy openMMEnergy) {
        BondPotentialEnergy bondPotentialEnergy = openMMEnergy.getBondPotentialEnergy();
        if (bondPotentialEnergy == null) {
            return;
        }
        Bond[] bonds = bondPotentialEnergy.getBondArray();
        double kParameterConversion = 418.3999999999999;
        DoubleArray parameters = new DoubleArray(0);
        int index = 0;
        for (Bond bond : bonds) {
            int i1 = bond.getAtom(0).getArrayIndex();
            int i2 = bond.getAtom(1).getArrayIndex();
            BondType bondType = bond.bondType;
            double r0 = bondType.distance * 0.1;
            double k = kParameterConversion * bondType.forceConstant * bondType.bondUnit;
            parameters.append(r0);
            parameters.append(k);
            this.setBondParameters(index++, i1, i2, parameters);
            parameters.resize(0);
        }
        parameters.destroy();
        this.updateParametersInContext(openMMEnergy.getContext());
    }

    public void updateForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        BondPotentialEnergy bondPotentialEnergy = forceFieldEnergy.getBondPotentialEnergy();
        if (bondPotentialEnergy == null) {
            return;
        }
        Bond[] bonds = bondPotentialEnergy.getBondArray();
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        double kParameterConversion = 418.3999999999999;
        DoubleArray parameters = new DoubleArray(0);
        int index = 0;
        for (Bond bond : bonds) {
            int i1 = bond.getAtom(0).getArrayIndex();
            int i2 = bond.getAtom(1).getArrayIndex();
            BondType bondType = bond.bondType;
            double r0 = bondType.distance * 0.1;
            double k = kParameterConversion * bondType.forceConstant * bondType.bondUnit;
            if (!bond.applyLambda()) {
                k *= scale;
            }
            parameters.append(r0);
            parameters.append(k);
            i1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i1);
            i2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i2);
            this.setBondParameters(index++, i1, i2, parameters);
            parameters.resize(0);
        }
        parameters.destroy();
        this.updateParametersInContext(openMMDualTopologyEnergy.getContext());
    }
}

