/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.CustomCompoundBondForce;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.openmm.IntArray;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.AngleTorsion;
import ffx.potential.bonded.Atom;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.terms.AngleTorsionPotentialEnergy;
import java.util.logging.Logger;

public class AngleTorsionForce
extends CustomCompoundBondForce {
    private static final Logger logger = Logger.getLogger(AngleTorsionForce.class.getName());

    public AngleTorsionForce(AngleTorsionPotentialEnergy angleTorsionPotentialEnergy) {
        super(4, AngleTorsion.angleTorsionForm());
        int m;
        AngleTorsion[] angleTorsions = angleTorsionPotentialEnergy.getAngleTorsionArray();
        this.addGlobalParameter("phi1", 0.0);
        this.addGlobalParameter("phi2", Math.PI);
        this.addGlobalParameter("phi3", 0.0);
        for (m = 1; m < 3; ++m) {
            for (int n = 1; n < 4; ++n) {
                this.addPerBondParameter(String.format("k%d%d", m, n));
            }
        }
        for (m = 1; m < 3; ++m) {
            this.addPerBondParameter(String.format("a%d", m));
        }
        for (AngleTorsion angleTorsion : angleTorsions) {
            double[] constants = angleTorsion.getConstants();
            DoubleArray parameters = new DoubleArray(0);
            for (int m2 = 0; m2 < 2; ++m2) {
                for (int n = 0; n < 3; ++n) {
                    int index = 3 * m2 + n;
                    parameters.append(constants[index] * 4.184);
                }
            }
            Atom[] atoms = angleTorsion.getAtomArray(true);
            parameters.append(angleTorsion.angleType1.angle[0] * (Math.PI / 180));
            parameters.append(angleTorsion.angleType2.angle[0] * (Math.PI / 180));
            IntArray particles = new IntArray(0);
            for (int i = 0; i < 4; ++i) {
                particles.append(atoms[i].getArrayIndex());
            }
            this.addBond(particles, parameters);
            parameters.destroy();
            particles.destroy();
        }
        int forceGroup = angleTorsionPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Angle-Torsions:                    %10d", angleTorsions.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public AngleTorsionForce(AngleTorsionPotentialEnergy angleTorsionPotentialEnergy, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        super(4, AngleTorsion.angleTorsionForm());
        int m;
        AngleTorsion[] angleTorsions = angleTorsionPotentialEnergy.getAngleTorsionArray();
        this.addGlobalParameter("phi1", 0.0);
        this.addGlobalParameter("phi2", Math.PI);
        this.addGlobalParameter("phi3", 0.0);
        for (m = 1; m < 3; ++m) {
            for (int n = 1; n < 4; ++n) {
                this.addPerBondParameter(String.format("k%d%d", m, n));
            }
        }
        for (m = 1; m < 3; ++m) {
            this.addPerBondParameter(String.format("a%d", m));
        }
        double scaleDT = openMMDualTopologyEnergy.getTopologyScale(topology);
        for (AngleTorsion angleTorsion : angleTorsions) {
            double scale = 1.0;
            if (!angleTorsion.applyLambda()) {
                scale = scaleDT;
            }
            double[] constants = angleTorsion.getConstants();
            DoubleArray parameters = new DoubleArray(0);
            for (int m2 = 0; m2 < 2; ++m2) {
                for (int n = 0; n < 3; ++n) {
                    int index = 3 * m2 + n;
                    parameters.append(constants[index] * 4.184 * scale);
                }
            }
            Atom[] atoms = angleTorsion.getAtomArray(true);
            parameters.append(angleTorsion.angleType1.angle[0] * (Math.PI / 180));
            parameters.append(angleTorsion.angleType2.angle[0] * (Math.PI / 180));
            IntArray particles = new IntArray(0);
            for (int i = 0; i < 4; ++i) {
                int atomIndex = atoms[i].getArrayIndex();
                atomIndex = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, atomIndex);
                particles.append(atomIndex);
            }
            this.addBond(particles, parameters);
            parameters.destroy();
            particles.destroy();
        }
        int forceGroup = angleTorsionPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Angle-Torsions:                    %10d", angleTorsions.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        AngleTorsionPotentialEnergy angleTorsionPotentialEnergy = openMMEnergy.getAngleTorsionPotentialEnergy();
        if (angleTorsionPotentialEnergy == null) {
            return null;
        }
        return new AngleTorsionForce(angleTorsionPotentialEnergy);
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        AngleTorsionPotentialEnergy angleTorsionPotentialEnergy = forceFieldEnergy.getAngleTorsionPotentialEnergy();
        if (angleTorsionPotentialEnergy == null) {
            return null;
        }
        return new AngleTorsionForce(angleTorsionPotentialEnergy, topology, openMMDualTopologyEnergy);
    }

    public void updateForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        AngleTorsionPotentialEnergy angleTorsionPotentialEnergy = forceFieldEnergy.getAngleTorsionPotentialEnergy();
        if (angleTorsionPotentialEnergy == null) {
            return;
        }
        AngleTorsion[] angleTorsions = angleTorsionPotentialEnergy.getAngleTorsionArray();
        double scaleDT = openMMDualTopologyEnergy.getTopologyScale(topology);
        int atIndex = 0;
        for (AngleTorsion angleTorsion : angleTorsions) {
            double scale = 1.0;
            if (!angleTorsion.applyLambda()) {
                scale = scaleDT;
            }
            double[] constants = angleTorsion.getConstants();
            DoubleArray parameters = new DoubleArray(0);
            for (int m = 0; m < 2; ++m) {
                for (int n = 0; n < 3; ++n) {
                    int index = 3 * m + n;
                    parameters.append(constants[index] * 4.184 * scale);
                }
            }
            Atom[] atoms = angleTorsion.getAtomArray(true);
            parameters.append(angleTorsion.angleType1.angle[0] * (Math.PI / 180));
            parameters.append(angleTorsion.angleType2.angle[0] * (Math.PI / 180));
            IntArray particles = new IntArray(0);
            for (int i = 0; i < 4; ++i) {
                int atomIndex = atoms[i].getArrayIndex();
                atomIndex = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, atomIndex);
                particles.append(atomIndex);
            }
            this.setBondParameters(atIndex++, particles, parameters);
            parameters.destroy();
            particles.destroy();
        }
        this.updateParametersInContext(openMMDualTopologyEnergy.getContext());
    }
}

