/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.openmm.amoeba.DoubleArray3D;
import ffx.openmm.amoeba.TorsionTorsionForce;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.TorsionTorsion;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.TorsionTorsionType;
import ffx.potential.terms.TorsionTorsionPotentialEnergy;
import java.util.LinkedHashMap;
import java.util.logging.Logger;

public class AmoebaTorsionTorsionForce
extends TorsionTorsionForce {
    private static final Logger logger = Logger.getLogger(AmoebaTorsionTorsionForce.class.getName());

    public AmoebaTorsionTorsionForce(TorsionTorsionPotentialEnergy torsionTorsionPotentialEnergy) {
        TorsionTorsion[] torsionTorsions = torsionTorsionPotentialEnergy.getTorsionTorsionArray();
        LinkedHashMap<String, TorsionTorsionType> torTorTypes = new LinkedHashMap<String, TorsionTorsionType>();
        for (TorsionTorsion torsionTorsion : torsionTorsions) {
            int ia = torsionTorsion.getAtom(0).getArrayIndex();
            int ib = torsionTorsion.getAtom(1).getArrayIndex();
            int ic = torsionTorsion.getAtom(2).getArrayIndex();
            int id = torsionTorsion.getAtom(3).getArrayIndex();
            int ie = torsionTorsion.getAtom(4).getArrayIndex();
            TorsionTorsionType torsionTorsionType = torsionTorsion.torsionTorsionType;
            String key = torsionTorsionType.getKey();
            int gridIndex = 0;
            if (torTorTypes.containsKey(key)) {
                int index = 0;
                for (String entry : torTorTypes.keySet()) {
                    if (entry.equalsIgnoreCase(key)) {
                        gridIndex = index;
                        break;
                    }
                    ++index;
                }
            } else {
                torTorTypes.put(key, torsionTorsionType);
                gridIndex = torTorTypes.size() - 1;
            }
            Atom atom = torsionTorsion.getChiralAtom();
            int iChiral = -1;
            if (atom != null) {
                iChiral = atom.getArrayIndex();
            }
            this.addTorsionTorsion(ia, ib, ic, id, ie, iChiral, gridIndex);
        }
        DoubleArray values = new DoubleArray(6);
        int gridIndex = 0;
        for (String key : torTorTypes.keySet()) {
            TorsionTorsionType torTorType = (TorsionTorsionType)torTorTypes.get(key);
            int nx = torTorType.nx;
            int ny = torTorType.ny;
            double[] tx = torTorType.tx;
            double[] ty = torTorType.ty;
            double[] f = torTorType.energy;
            double[] dx = torTorType.dx;
            double[] dy = torTorType.dy;
            double[] dxy = torTorType.dxy;
            DoubleArray3D grid3D = new DoubleArray3D(nx, ny, 6);
            int xIndex = 0;
            int yIndex = 0;
            for (int j = 0; j < nx * ny; ++j) {
                int addIndex = 0;
                values.set(addIndex++, tx[xIndex]);
                values.set(addIndex++, ty[yIndex]);
                values.set(addIndex++, 4.184 * f[j]);
                values.set(addIndex++, 4.184 * dx[j]);
                values.set(addIndex++, 4.184 * dy[j]);
                values.set(addIndex, 4.184 * dxy[j]);
                grid3D.set(yIndex, xIndex, values);
                if (++xIndex != nx) continue;
                xIndex = 0;
                ++yIndex;
            }
            this.setTorsionTorsionGrid(gridIndex++, grid3D.getPointer());
            grid3D.destroy();
        }
        values.destroy();
        int forceGroup = torsionTorsionPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Torsion-Torsions:                  %10d", torsionTorsions.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public AmoebaTorsionTorsionForce(TorsionTorsionPotentialEnergy torsionTorsionPotentialEnergy, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        TorsionTorsion[] torsionTorsions = torsionTorsionPotentialEnergy.getTorsionTorsionArray();
        LinkedHashMap<String, TorsionTorsionType> torTorTypes = new LinkedHashMap<String, TorsionTorsionType>();
        for (TorsionTorsion torsionTorsion : torsionTorsions) {
            int ia = torsionTorsion.getAtom(0).getArrayIndex();
            int ib = torsionTorsion.getAtom(1).getArrayIndex();
            int ic = torsionTorsion.getAtom(2).getArrayIndex();
            int id = torsionTorsion.getAtom(3).getArrayIndex();
            int ie = torsionTorsion.getAtom(4).getArrayIndex();
            TorsionTorsionType torsionTorsionType = torsionTorsion.torsionTorsionType;
            String key = torsionTorsionType.getKey();
            int gridIndex = 0;
            if (torTorTypes.containsKey(key)) {
                int index = 0;
                for (String entry : torTorTypes.keySet()) {
                    if (entry.equalsIgnoreCase(key)) {
                        gridIndex = index;
                        break;
                    }
                    ++index;
                }
            } else {
                torTorTypes.put(key, torsionTorsionType);
                gridIndex = torTorTypes.size() - 1;
            }
            Atom atom = torsionTorsion.getChiralAtom();
            int iChiral = -1;
            if (atom != null) {
                iChiral = atom.getArrayIndex();
                iChiral = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, iChiral);
            }
            ia = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, ia);
            ib = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, ib);
            ic = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, ic);
            id = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, id);
            ie = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, ie);
            this.addTorsionTorsion(ia, ib, ic, id, ie, iChiral, gridIndex);
        }
        DoubleArray values = new DoubleArray(6);
        int gridIndex = 0;
        for (String key : torTorTypes.keySet()) {
            TorsionTorsionType torTorType = (TorsionTorsionType)torTorTypes.get(key);
            int nx = torTorType.nx;
            int ny = torTorType.ny;
            double[] tx = torTorType.tx;
            double[] ty = torTorType.ty;
            double[] f = torTorType.energy;
            double[] dx = torTorType.dx;
            double[] dy = torTorType.dy;
            double[] dxy = torTorType.dxy;
            DoubleArray3D grid3D = new DoubleArray3D(nx, ny, 6);
            int xIndex = 0;
            int yIndex = 0;
            for (int j = 0; j < nx * ny; ++j) {
                int addIndex = 0;
                values.set(addIndex++, tx[xIndex]);
                values.set(addIndex++, ty[yIndex]);
                values.set(addIndex++, 4.184 * f[j]);
                values.set(addIndex++, 4.184 * dx[j]);
                values.set(addIndex++, 4.184 * dy[j]);
                values.set(addIndex, 4.184 * dxy[j]);
                grid3D.set(yIndex, xIndex, values);
                if (++xIndex != nx) continue;
                xIndex = 0;
                ++yIndex;
            }
            this.setTorsionTorsionGrid(gridIndex++, grid3D.getPointer());
            grid3D.destroy();
        }
        values.destroy();
        int forceGroup = torsionTorsionPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Torsion-Torsions:                  %10d", torsionTorsions.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        TorsionTorsionPotentialEnergy torsionTorsionPotentialEnergy = openMMEnergy.getTorsionTorsionPotentialEnergy();
        if (torsionTorsionPotentialEnergy == null) {
            return null;
        }
        return new AmoebaTorsionTorsionForce(torsionTorsionPotentialEnergy);
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        TorsionTorsionPotentialEnergy torsionTorsionPotentialEnergy = forceFieldEnergy.getTorsionTorsionPotentialEnergy();
        if (torsionTorsionPotentialEnergy == null) {
            return null;
        }
        return new AmoebaTorsionTorsionForce(torsionTorsionPotentialEnergy, topology, openMMDualTopologyEnergy);
    }
}

