/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.crystal.Crystal;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.openmm.IntArray;
import ffx.openmm.amoeba.MultipoleForce;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.ParticleMeshEwald;
import ffx.potential.nonbonded.ReciprocalSpace;
import ffx.potential.nonbonded.pme.AlchemicalParameters;
import ffx.potential.nonbonded.pme.Polarization;
import ffx.potential.nonbonded.pme.SCFAlgorithm;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.MultipoleType;
import ffx.potential.parameters.PolarizeType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class AmoebaMultipoleForce
extends MultipoleForce {
    private static final Logger logger = Logger.getLogger(AmoebaMultipoleForce.class.getName());

    public AmoebaMultipoleForce(OpenMMEnergy openMMEnergy) {
        ParticleMeshEwald pme = openMMEnergy.getPmeNode();
        if (pme == null) {
            this.destroy();
            return;
        }
        double doPolarization = this.configureForce(openMMEnergy);
        int[][] axisAtom = pme.getAxisAtoms();
        double quadrupoleConversion = 0.010000000000000002;
        double polarityConversion = 0.0010000000000000002;
        double dampingFactorConversion = FastMath.sqrt((double)0.1);
        boolean lambdaTerm = pme.getLambdaTerm();
        AlchemicalParameters alchemicalParameters = pme.getAlchemicalParameters();
        double permLambda = alchemicalParameters.permLambda;
        double polarLambda = alchemicalParameters.polLambda;
        DoubleArray dipoles = new DoubleArray(3);
        DoubleArray quadrupoles = new DoubleArray(9);
        Atom[] atoms = openMMEnergy.getMolecularAssembly().getAtomArray();
        int nAtoms = atoms.length;
        for (int i = 0; i < nAtoms; ++i) {
            Atom atom = atoms[i];
            MultipoleType multipoleType = pme.getMultipoleType(i);
            PolarizeType polarType = pme.getPolarizeType(i);
            int axisType = switch (multipoleType.frameDefinition) {
                default -> throw new MatchException(null, null);
                case MultipoleType.MultipoleFrameDefinition.NONE -> 5;
                case MultipoleType.MultipoleFrameDefinition.ZONLY -> 4;
                case MultipoleType.MultipoleFrameDefinition.ZTHENX -> 0;
                case MultipoleType.MultipoleFrameDefinition.BISECTOR -> 1;
                case MultipoleType.MultipoleFrameDefinition.ZTHENBISECTOR -> 2;
                case MultipoleType.MultipoleFrameDefinition.THREEFOLD -> 3;
            };
            double useFactor = 1.0;
            if (!atom.getUse() || !atom.getElectrostatics()) {
                useFactor = 0.0;
            }
            double permScale = useFactor;
            double polarScale = doPolarization * useFactor;
            if (lambdaTerm && atom.applyLambda()) {
                permScale *= permLambda;
                polarScale *= polarLambda;
            }
            for (int j = 0; j < 3; ++j) {
                dipoles.set(j, multipoleType.dipole[j] * 0.1 * permScale);
            }
            int l = 0;
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    quadrupoles.set(l++, multipoleType.quadrupole[j][k] * quadrupoleConversion * permScale / 3.0);
                }
            }
            int zaxis = -1;
            int xaxis = -1;
            int yaxis = -1;
            int[] refAtoms = axisAtom[i];
            if (refAtoms != null) {
                zaxis = refAtoms[0];
                if (refAtoms.length > 1) {
                    xaxis = refAtoms[1];
                    if (refAtoms.length > 2) {
                        yaxis = refAtoms[2];
                    }
                }
            } else {
                axisType = 5;
            }
            double charge = multipoleType.charge * permScale;
            this.addMultipole(charge, dipoles, quadrupoles, axisType, zaxis, xaxis, yaxis, polarType.thole, polarType.pdamp * dampingFactorConversion, polarType.polarizability * polarityConversion * polarScale);
        }
        dipoles.destroy();
        quadrupoles.destroy();
        int[][] ip11 = pme.getPolarization11();
        IntArray covalentMap = new IntArray(0);
        for (int i = 0; i < nAtoms; ++i) {
            Atom ai = atoms[i];
            covalentMap.resize(0);
            for (Atom ak : ai.get12List()) {
                covalentMap.append(ak.getIndex() - 1);
            }
            this.setCovalentMap(i, 0, covalentMap);
            covalentMap.resize(0);
            for (Atom ak : ai.get13List()) {
                covalentMap.append(ak.getIndex() - 1);
            }
            this.setCovalentMap(i, 1, covalentMap);
            covalentMap.resize(0);
            for (Atom ak : ai.get14List()) {
                covalentMap.append(ak.getIndex() - 1);
            }
            this.setCovalentMap(i, 2, covalentMap);
            covalentMap.resize(0);
            for (Atom ak : ai.get15List()) {
                covalentMap.append(ak.getIndex() - 1);
            }
            this.setCovalentMap(i, 3, covalentMap);
            covalentMap.resize(0);
            for (int j = 0; j < ip11[i].length; ++j) {
                covalentMap.append(ip11[i][j]);
            }
            this.setCovalentMap(i, 4, covalentMap);
        }
        covalentMap.destroy();
    }

    public AmoebaMultipoleForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        int otherTopology = 1 - topology;
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        ForceFieldEnergy otherForceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(otherTopology);
        ParticleMeshEwald pme = forceFieldEnergy.getPmeNode();
        ParticleMeshEwald otherPME = otherForceFieldEnergy.getPmeNode();
        if (pme == null || otherPME == null) {
            this.destroy();
            return;
        }
        double doPolarization = this.configureForce(forceFieldEnergy);
        double quadrupoleConversion = 0.010000000000000002;
        double polarityConversion = 0.0010000000000000002;
        double dampingFactorConversion = FastMath.sqrt((double)0.1);
        boolean lambdaTerm = pme.getLambdaTerm();
        AlchemicalParameters alchemicalParameters = pme.getAlchemicalParameters();
        double permLambda = alchemicalParameters.permLambda;
        double polarLambda = alchemicalParameters.polLambda;
        DoubleArray dipoles = new DoubleArray(3);
        DoubleArray quadrupoles = new DoubleArray(9);
        int nAtoms = openMMDualTopologyEnergy.getNumberOfAtoms();
        for (int i = 0; i < nAtoms; ++i) {
            Atom atom = openMMDualTopologyEnergy.getDualTopologyAtom(topology, i);
            if (atom.getTopologyIndex() == topology) {
                int index = atom.getArrayIndex();
                MultipoleType multipoleType = pme.getMultipoleType(index);
                PolarizeType polarType = pme.getPolarizeType(index);
                int axisType = switch (multipoleType.frameDefinition) {
                    default -> throw new MatchException(null, null);
                    case MultipoleType.MultipoleFrameDefinition.NONE -> 5;
                    case MultipoleType.MultipoleFrameDefinition.ZONLY -> 4;
                    case MultipoleType.MultipoleFrameDefinition.ZTHENX -> 0;
                    case MultipoleType.MultipoleFrameDefinition.BISECTOR -> 1;
                    case MultipoleType.MultipoleFrameDefinition.ZTHENBISECTOR -> 2;
                    case MultipoleType.MultipoleFrameDefinition.THREEFOLD -> 3;
                };
                double useFactor = 1.0;
                if (!atom.getUse() || !atom.getElectrostatics()) {
                    useFactor = 0.0;
                }
                double permScale = useFactor;
                double polarScale = doPolarization * useFactor;
                if (lambdaTerm && atom.applyLambda()) {
                    permScale *= permLambda;
                    polarScale *= polarLambda;
                }
                double charge = multipoleType.charge * permScale;
                for (int j = 0; j < 3; ++j) {
                    dipoles.set(j, multipoleType.dipole[j] * 0.1 * permScale);
                }
                int l = 0;
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        quadrupoles.set(l++, multipoleType.quadrupole[j][k] * quadrupoleConversion * permScale / 3.0);
                    }
                }
                int zaxis = -1;
                int xaxis = -1;
                int yaxis = -1;
                int[] refAtoms = atom.getAxisAtomIndices();
                if (refAtoms != null) {
                    zaxis = refAtoms[0];
                    zaxis = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, zaxis);
                    if (refAtoms.length > 1) {
                        xaxis = refAtoms[1];
                        xaxis = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, xaxis);
                        if (refAtoms.length > 2) {
                            yaxis = refAtoms[2];
                            yaxis = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, yaxis);
                        }
                    }
                } else {
                    axisType = 5;
                }
                this.addMultipole(charge, dipoles, quadrupoles, axisType, zaxis, xaxis, yaxis, polarType.thole, polarType.pdamp * dampingFactorConversion, polarType.polarizability * polarityConversion * polarScale);
                continue;
            }
            int axisType = 5;
            double charge = 0.0;
            for (int j = 0; j < 3; ++j) {
                dipoles.set(j, 0.0);
            }
            int l = 0;
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    quadrupoles.set(l++, 0.0);
                }
            }
            int zaxis = -1;
            int xaxis = -1;
            int yaxis = -1;
            double thole = 0.39;
            double pdamp = 1.0;
            this.addMultipole(charge, dipoles, quadrupoles, axisType, zaxis, xaxis, yaxis, thole, pdamp, 0.0);
        }
        dipoles.destroy();
        quadrupoles.destroy();
        int[][] ip11 = pme.getPolarization11();
        int[][] ip11Other = otherPME.getPolarization11();
        IntArray covalentMap = new IntArray(0);
        HashSet<Integer> covalentSet = new HashSet<Integer>();
        for (int i = 0; i < nAtoms; ++i) {
            int value;
            Atom atom = openMMDualTopologyEnergy.getDualTopologyAtom(topology, i);
            Atom otherAtom = openMMDualTopologyEnergy.getDualTopologyAtom(otherTopology, i);
            int index = atom.getArrayIndex();
            int otherIndex = otherAtom.getArrayIndex();
            covalentSet.clear();
            for (Atom ak : atom.get12List()) {
                covalentSet.add(ak.getTopologyAtomIndex());
            }
            for (Atom ak : otherAtom.get12List()) {
                covalentSet.add(ak.getTopologyAtomIndex());
            }
            covalentMap.resize(0);
            Iterator iterator = covalentSet.iterator();
            while (iterator.hasNext()) {
                int ak = (Integer)((Object)iterator.next());
                covalentMap.append(ak);
            }
            this.setCovalentMap(i, 0, covalentMap);
            covalentSet.clear();
            for (Atom ak : atom.get13List()) {
                covalentSet.add(ak.getTopologyAtomIndex());
            }
            for (Atom ak : otherAtom.get13List()) {
                covalentSet.add(ak.getTopologyAtomIndex());
            }
            covalentMap.resize(0);
            iterator = covalentSet.iterator();
            while (iterator.hasNext()) {
                int ak = (Integer)((Object)iterator.next());
                covalentMap.append(ak);
            }
            this.setCovalentMap(i, 1, covalentMap);
            covalentSet.clear();
            for (Atom ak : atom.get14List()) {
                covalentSet.add(ak.getTopologyAtomIndex());
            }
            for (Atom ak : otherAtom.get14List()) {
                covalentSet.add(ak.getTopologyAtomIndex());
            }
            covalentMap.resize(0);
            iterator = covalentSet.iterator();
            while (iterator.hasNext()) {
                int ak = (Integer)((Object)iterator.next());
                covalentMap.append(ak);
            }
            this.setCovalentMap(i, 2, covalentMap);
            covalentSet.clear();
            for (Atom ak : atom.get15List()) {
                covalentSet.add(ak.getTopologyAtomIndex());
            }
            for (Atom ak : otherAtom.get15List()) {
                covalentSet.add(ak.getTopologyAtomIndex());
            }
            covalentMap.resize(0);
            iterator = covalentSet.iterator();
            while (iterator.hasNext()) {
                int ak = (Integer)((Object)iterator.next());
                covalentMap.append(ak);
            }
            this.setCovalentMap(i, 3, covalentMap);
            covalentSet.clear();
            for (Object k : (Iterator)ip11[index]) {
                value = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, (int)k);
                covalentSet.add(value);
            }
            for (Object k : (Iterator)ip11Other[otherIndex]) {
                value = openMMDualTopologyEnergy.mapToDualTopologyIndex(otherTopology, (int)k);
                covalentSet.add(value);
            }
            covalentMap.resize(0);
            iterator = covalentSet.iterator();
            while (iterator.hasNext()) {
                int k = (Integer)iterator.next();
                covalentMap.append(k);
            }
            this.setCovalentMap(i, 4, covalentMap);
        }
        covalentMap.destroy();
    }

    private double configureForce(ForceFieldEnergy forceFieldEnergy) {
        ParticleMeshEwald pme = forceFieldEnergy.getPmeNode();
        ForceField forceField = forceFieldEnergy.getMolecularAssembly().getForceField();
        Polarization polarization = pme.getPolarizationType();
        double doPolarization = 1.0;
        SCFAlgorithm scfAlgorithm = null;
        if (polarization != Polarization.MUTUAL) {
            this.setPolarizationType(1);
            if (pme.getPolarizationType() == Polarization.NONE) {
                doPolarization = 0.0;
            }
        } else {
            String algorithm = forceField.getString("SCF_ALGORITHM", "CG");
            try {
                algorithm = algorithm.replaceAll("-", "_").toUpperCase();
                scfAlgorithm = SCFAlgorithm.valueOf(algorithm);
            }
            catch (Exception e) {
                scfAlgorithm = SCFAlgorithm.CG;
            }
            if (scfAlgorithm == SCFAlgorithm.EPT) {
                this.setPolarizationType(2);
                DoubleArray exptCoefficients = new DoubleArray(4);
                exptCoefficients.set(0, -0.154);
                exptCoefficients.set(1, 0.017);
                exptCoefficients.set(2, 0.657);
                exptCoefficients.set(3, 0.475);
                this.setExtrapolationCoefficients(exptCoefficients);
                exptCoefficients.destroy();
            } else {
                this.setPolarizationType(0);
            }
        }
        Crystal crystal = forceFieldEnergy.getCrystal();
        double cutoff = pme.getEwaldCutoff();
        double aewald = pme.getEwaldCoefficient();
        if (!crystal.aperiodic()) {
            this.setNonbondedMethod(1);
            this.setCutoffDistance(cutoff * 0.1);
            double ewaldTolerance = 1.0E-4;
            this.setEwaldErrorTolerance(ewaldTolerance);
            ReciprocalSpace recip = pme.getReciprocalSpace();
            int nx = recip.getXDim();
            int ny = recip.getYDim();
            int nz = recip.getZDim();
            this.setPMEParameters(aewald / 0.1, nx, ny, nz);
        } else {
            this.setNonbondedMethod(0);
        }
        this.setMutualInducedMaxIterations(500);
        double poleps = pme.getPolarEps();
        this.setMutualInducedTargetEpsilon(poleps);
        AlchemicalParameters alchemicalParameters = pme.getAlchemicalParameters();
        boolean lambdaTerm = pme.getLambdaTerm();
        int forceGroup = forceField.getInteger("PME_FORCE_GROUP", 1);
        this.setForceGroup(forceGroup);
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n  Electrostatics\n");
            sb.append(String.format("   Polarization:                       %8s\n", polarization.toString()));
            if (polarization == Polarization.MUTUAL) {
                sb.append(String.format("    SCF Convergence Criteria:         %8.3e\n", poleps));
            } else if (scfAlgorithm == SCFAlgorithm.EPT) {
                sb.append(String.format("    SCF Algorithm:                     %8s\n", new Object[]{scfAlgorithm}));
            }
            if (aewald > 0.0) {
                sb.append("   Particle-mesh Ewald\n");
                sb.append(String.format("    Ewald Coefficient:                 %8.3f\n", aewald));
                sb.append(String.format("    Particle Cut-Off:                  %8.3f (A)", cutoff));
            } else if (cutoff != Double.POSITIVE_INFINITY) {
                sb.append(String.format("    Electrostatics Cut-Off:            %8.3f (A)", cutoff));
            } else {
                sb.append("    Electrostatics Cut-Off:                NONE");
            }
            logger.info(sb.toString());
            if (lambdaTerm) {
                boolean doLigandGKElec;
                sb = new StringBuilder("   Alchemical Parameters\n");
                double permLambdaStart = alchemicalParameters.permLambdaStart;
                double permLambdaEnd = alchemicalParameters.permLambdaEnd;
                sb.append(String.format("    Permanent Multipole Range:      %5.3f-%5.3f\n", permLambdaStart, permLambdaEnd));
                double permLambdaAlpha = alchemicalParameters.permLambdaAlpha;
                if (permLambdaAlpha != 0.0) {
                    logger.severe(" Permanent multipole softcore not supported for OpenMM.");
                }
                double permLambdaExponent = alchemicalParameters.permLambdaExponent;
                sb.append(String.format("    Permanent Multipole Lambda Exponent:  %5.3f\n", permLambdaExponent));
                if (polarization != Polarization.NONE) {
                    double polLambdaExponent = alchemicalParameters.polLambdaExponent;
                    double polLambdaStart = alchemicalParameters.polLambdaStart;
                    double polLambdaEnd = alchemicalParameters.polLambdaEnd;
                    sb.append(String.format("    Polarization Lambda Exponent:         %5.3f\n", polLambdaExponent));
                    sb.append(String.format("    Polarization Range:             %5.3f-%5.3f\n", polLambdaStart, polLambdaEnd));
                    boolean doNoLigandCondensedSCF = alchemicalParameters.doNoLigandCondensedSCF;
                    if (doNoLigandCondensedSCF) {
                        logger.severe(" Condensed SCF without a ligand is not supported for OpenMM.");
                    }
                }
                if (doLigandGKElec = alchemicalParameters.doLigandGKElec) {
                    logger.severe(" Isolated ligand electrostatics are not supported for OpenMM.");
                }
                logger.info(sb.toString());
            }
            logger.log(Level.FINE, String.format("   Force group:\t\t%d\n", forceGroup));
        }
        return doPolarization;
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        ParticleMeshEwald pme = openMMEnergy.getPmeNode();
        if (pme == null) {
            return null;
        }
        return new AmoebaMultipoleForce(openMMEnergy);
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        ParticleMeshEwald pme = forceFieldEnergy.getPmeNode();
        if (pme == null) {
            return null;
        }
        return new AmoebaMultipoleForce(topology, openMMDualTopologyEnergy);
    }

    public void updateForce(Atom[] atoms, OpenMMEnergy openMMEnergy) {
        ParticleMeshEwald pme = openMMEnergy.getPmeNode();
        double quadrupoleConversion = 0.010000000000000002;
        double polarityConversion = 0.0010000000000000002;
        double dampingFactorConversion = FastMath.sqrt((double)0.1);
        double doPolarization = 1.0;
        if (pme.getPolarizationType() == Polarization.NONE) {
            doPolarization = 0.0;
        }
        DoubleArray dipoles = new DoubleArray(3);
        DoubleArray quadrupoles = new DoubleArray(9);
        AlchemicalParameters alchemicalParameters = pme.getAlchemicalParameters();
        boolean lambdaTerm = pme.getLambdaTerm();
        if (lambdaTerm) {
            AlchemicalParameters.AlchemicalMode alchemicalMode = alchemicalParameters.mode;
            if (alchemicalMode != AlchemicalParameters.AlchemicalMode.SCALE) {
                logger.severe(String.format(" Alchemical mode %s not supported for OpenMM.", new Object[]{alchemicalMode}));
            }
            if (alchemicalParameters.permLambdaAlpha != 0.0) {
                logger.severe(" Permanent multipole softcore not supported for OpenMM.");
            }
            if (alchemicalParameters.doLigandGKElec || alchemicalParameters.doLigandVaporElec) {
                logger.severe(" Isolated ligand electrostatics are not supported for OpenMM.");
            }
            if (alchemicalParameters.doNoLigandCondensedSCF) {
                logger.severe(" Condensed SCF without a ligand is not supported for OpenMM.");
            }
        }
        double permLambda = alchemicalParameters.permLambda;
        double polarLambda = alchemicalParameters.polLambda;
        for (Atom atom : atoms) {
            int index = atom.getXyzIndex() - 1;
            MultipoleType multipoleType = pme.getMultipoleType(index);
            PolarizeType polarizeType = pme.getPolarizeType(index);
            int[] axisAtoms = atom.getAxisAtomIndices();
            double permScale = 1.0;
            double polarScale = doPolarization;
            if (!atom.getUse() || !atom.getElectrostatics()) {
                permScale = 0.0;
                polarScale = 0.0;
            }
            if (atom.applyLambda()) {
                permScale *= permLambda;
                polarScale *= polarLambda;
            }
            int axisType = switch (multipoleType.frameDefinition) {
                default -> throw new MatchException(null, null);
                case MultipoleType.MultipoleFrameDefinition.NONE -> 5;
                case MultipoleType.MultipoleFrameDefinition.ZONLY -> 4;
                case MultipoleType.MultipoleFrameDefinition.ZTHENX -> 0;
                case MultipoleType.MultipoleFrameDefinition.BISECTOR -> 1;
                case MultipoleType.MultipoleFrameDefinition.ZTHENBISECTOR -> 2;
                case MultipoleType.MultipoleFrameDefinition.THREEFOLD -> 3;
            };
            for (int j = 0; j < 3; ++j) {
                dipoles.set(j, multipoleType.dipole[j] * 0.1 * permScale);
            }
            int l = 0;
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    quadrupoles.set(l++, multipoleType.quadrupole[j][k] * quadrupoleConversion / 3.0 * permScale);
                }
            }
            int zaxis = 1;
            int xaxis = 1;
            int yaxis = 1;
            if (axisAtoms != null) {
                zaxis = axisAtoms[0];
                if (axisAtoms.length > 1) {
                    xaxis = axisAtoms[1];
                    if (axisAtoms.length > 2) {
                        yaxis = axisAtoms[2];
                    }
                }
            } else {
                axisType = 5;
            }
            this.setMultipoleParameters(index, multipoleType.charge * permScale, dipoles, quadrupoles, axisType, zaxis, xaxis, yaxis, polarizeType.thole, polarizeType.pdamp * dampingFactorConversion, polarizeType.polarizability * polarityConversion * polarScale);
        }
        dipoles.destroy();
        quadrupoles.destroy();
        this.updateParametersInContext(openMMEnergy.getContext());
    }

    public void updateForce(Atom[] atoms, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        ParticleMeshEwald pme = forceFieldEnergy.getPmeNode();
        double quadrupoleConversion = 0.010000000000000002;
        double polarityConversion = 0.0010000000000000002;
        double dampingFactorConversion = FastMath.sqrt((double)0.1);
        double doPolarization = 1.0;
        if (pme.getPolarizationType() == Polarization.NONE) {
            doPolarization = 0.0;
        }
        double scaleDT = Math.sqrt(openMMDualTopologyEnergy.getTopologyScale(topology));
        DoubleArray dipoles = new DoubleArray(3);
        DoubleArray quadrupoles = new DoubleArray(9);
        AlchemicalParameters alchemicalParameters = pme.getAlchemicalParameters();
        boolean lambdaTerm = pme.getLambdaTerm();
        if (lambdaTerm) {
            AlchemicalParameters.AlchemicalMode alchemicalMode = alchemicalParameters.mode;
            if (alchemicalMode != AlchemicalParameters.AlchemicalMode.SCALE) {
                logger.severe(String.format(" Alchemical mode %s not supported for OpenMM.", new Object[]{alchemicalMode}));
            }
            if (alchemicalParameters.permLambdaAlpha != 0.0) {
                logger.severe(" Permanent multipole softcore not supported for OpenMM.");
            }
            if (alchemicalParameters.doLigandGKElec || alchemicalParameters.doLigandVaporElec) {
                logger.severe(" Isolated ligand electrostatics are not supported for OpenMM.");
            }
            if (alchemicalParameters.doNoLigandCondensedSCF) {
                logger.severe(" Condensed SCF without a ligand is not supported for OpenMM.");
            }
        }
        double permLambda = alchemicalParameters.permLambda;
        double polarLambda = alchemicalParameters.polLambda;
        for (Atom atom : atoms) {
            if (atom.getTopologyIndex() != topology) continue;
            int index = atom.getArrayIndex();
            MultipoleType multipoleType = pme.getMultipoleType(index);
            PolarizeType polarizeType = pme.getPolarizeType(index);
            int[] axisAtoms = atom.getAxisAtomIndices();
            double permScale = scaleDT;
            double polarScale = doPolarization;
            if (!atom.getUse() || !atom.getElectrostatics()) {
                permScale = 0.0;
                polarScale = 0.0;
            }
            if (atom.applyLambda()) {
                permScale *= permLambda;
                polarScale *= polarLambda;
            }
            int axisType = switch (multipoleType.frameDefinition) {
                default -> throw new MatchException(null, null);
                case MultipoleType.MultipoleFrameDefinition.NONE -> 5;
                case MultipoleType.MultipoleFrameDefinition.ZONLY -> 4;
                case MultipoleType.MultipoleFrameDefinition.ZTHENX -> 0;
                case MultipoleType.MultipoleFrameDefinition.BISECTOR -> 1;
                case MultipoleType.MultipoleFrameDefinition.ZTHENBISECTOR -> 2;
                case MultipoleType.MultipoleFrameDefinition.THREEFOLD -> 3;
            };
            for (int j = 0; j < 3; ++j) {
                dipoles.set(j, multipoleType.dipole[j] * 0.1 * permScale);
            }
            int l = 0;
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    quadrupoles.set(l++, multipoleType.quadrupole[j][k] * quadrupoleConversion / 3.0 * permScale);
                }
            }
            int zaxis = 1;
            int xaxis = 1;
            int yaxis = 1;
            if (axisAtoms != null) {
                zaxis = axisAtoms[0];
                zaxis = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, zaxis);
                if (axisAtoms.length > 1) {
                    xaxis = axisAtoms[1];
                    xaxis = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, xaxis);
                    if (axisAtoms.length > 2) {
                        yaxis = axisAtoms[2];
                        yaxis = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, yaxis);
                    }
                }
            } else {
                axisType = 5;
            }
            int dualTopologyIndex = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, index);
            this.setMultipoleParameters(dualTopologyIndex, multipoleType.charge * permScale, dipoles, quadrupoles, axisType, zaxis, xaxis, yaxis, polarizeType.thole, polarizeType.pdamp * dampingFactorConversion, polarizeType.polarizability * polarityConversion * polarScale);
        }
        dipoles.destroy();
        quadrupoles.destroy();
        this.updateParametersInContext(openMMDualTopologyEnergy.getContext());
    }
}

