/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.Force;
import ffx.openmm.amoeba.GKCavitationForce;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.GeneralizedKirkwood;
import ffx.potential.nonbonded.ParticleMeshEwald;
import ffx.potential.nonbonded.implicit.ChandlerCavitation;
import ffx.potential.nonbonded.implicit.DispersionRegion;
import ffx.potential.nonbonded.implicit.GaussVol;
import ffx.potential.openmm.OpenMMEnergy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmoebaGKCavitationForce
extends GKCavitationForce {
    private static final Logger logger = Logger.getLogger(AmoebaGKCavitationForce.class.getName());

    public AmoebaGKCavitationForce(OpenMMEnergy openMMEnergy) {
        Atom[] atoms;
        logger.severe(" The AmoebaGKCavitationForce is not currently supported.");
        GeneralizedKirkwood generalizedKirkwood = openMMEnergy.getGK();
        if (generalizedKirkwood == null) {
            this.destroy();
            return;
        }
        ChandlerCavitation chandlerCavitation = generalizedKirkwood.getChandlerCavitation();
        if (chandlerCavitation == null) {
            this.destroy();
            return;
        }
        GaussVol gaussVol = chandlerCavitation.getGaussVol();
        if (gaussVol == null) {
            this.destroy();
            return;
        }
        double surfaceTension = chandlerCavitation.getSurfaceTension() * 4.184 / 0.1 / 0.1;
        double[] rad = gaussVol.getRadii();
        int index = 0;
        for (Atom atom : atoms = openMMEnergy.getMolecularAssembly().getAtomArray()) {
            int isHydrogen = 0;
            double radius = rad[index++];
            if (atom.isHydrogen()) {
                isHydrogen = 1;
                radius = 0.0;
            }
            this.addParticle(radius * 0.1, surfaceTension, isHydrogen);
        }
        int forceGroup = openMMEnergy.getMolecularAssembly().getForceField().getInteger("GK_FORCE_GROUP", 2);
        this.setForceGroup(forceGroup);
        logger.log(Level.INFO, String.format("  GaussVol cavitation force \t\t%d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        GeneralizedKirkwood gk = openMMEnergy.getGK();
        if (gk == null) {
            return null;
        }
        DispersionRegion dispersionRegion = gk.getDispersionRegion();
        if (dispersionRegion == null) {
            return null;
        }
        return new AmoebaGKCavitationForce(openMMEnergy);
    }

    public void updateForce(Atom[] atoms, OpenMMEnergy openMMEnergy) {
        GeneralizedKirkwood generalizedKirkwood = openMMEnergy.getGK();
        if (generalizedKirkwood == null) {
            return;
        }
        ChandlerCavitation chandlerCavitation = generalizedKirkwood.getChandlerCavitation();
        if (chandlerCavitation == null) {
            return;
        }
        GaussVol gaussVol = chandlerCavitation.getGaussVol();
        if (gaussVol == null) {
            return;
        }
        double surfaceTension = chandlerCavitation.getSurfaceTension() * 4.184 / 0.1 / 0.1;
        ParticleMeshEwald pme = openMMEnergy.getPmeNode();
        double lambdaElec = pme.getAlchemicalParameters().permLambda;
        double[] rad = gaussVol.getRadii();
        for (Atom atom : atoms) {
            int index = atom.getXyzIndex() - 1;
            double useFactor = 1.0;
            if (!atom.getUse()) {
                useFactor = 0.0;
            }
            double lambdaScale = lambdaElec * lambdaElec;
            if (!atom.applyLambda()) {
                lambdaScale = 1.0;
            }
            useFactor *= lambdaScale;
            double radius = rad[index];
            int isHydrogen = 0;
            if (atom.isHydrogen()) {
                isHydrogen = 1;
                radius = 0.0;
            }
            this.setParticleParameters(index, radius * 0.1, surfaceTension * useFactor, isHydrogen);
        }
        this.updateParametersInContext(openMMEnergy.getContext());
    }
}

