/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import ffx.numerics.math.DoubleMath;
import ffx.potential.parameters.MultipoleType;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class Torque {
    private static final Logger logger = Logger.getLogger(Torque.class.getName());
    private final double[] vecZ = new double[3];
    private final double[] vecX = new double[3];
    private final double[] vecY = new double[3];
    private final double[] sumXY = new double[3];
    private final double[] sumZXY = new double[3];
    private final double[] r = new double[3];
    private final double[] del = new double[3];
    private final double[] eps = new double[3];
    private final double[] xZXY = new double[3];
    private final double[] xXZ = new double[3];
    private final double[] xYZ = new double[3];
    private final double[] xYX = new double[3];
    private final double[] xXYZ = new double[3];
    private final double[] xxZXYZ = new double[3];
    private final double[] xxZXYX = new double[3];
    private final double[] xxZXYY = new double[3];
    private final double[] t1 = new double[3];
    private final double[] t2 = new double[3];
    private final double[] localOrigin = new double[3];
    private int[][] axisAtom;
    private MultipoleType.MultipoleFrameDefinition[] frame;
    private double[][][] coordinates;

    public void init(int[][] axisAtom, MultipoleType.MultipoleFrameDefinition[] frame, double[][][] coordinates) {
        this.axisAtom = axisAtom;
        this.frame = frame;
        this.coordinates = coordinates;
    }

    public void torque(int i, int iSymm, double[] trq, int[] frameIndex, double[][] g) {
        int[] ax = this.axisAtom[i];
        if (this.frame[i] == MultipoleType.MultipoleFrameDefinition.NONE) {
            return;
        }
        int nAxisAtoms = ax.length;
        int iz = ax[0];
        int ix = -1;
        int iy = -1;
        if (nAxisAtoms > 1) {
            ix = ax[1];
            if (nAxisAtoms > 2) {
                iy = ax[2];
            }
        }
        frameIndex[0] = iz;
        frameIndex[1] = ix;
        frameIndex[2] = iy;
        frameIndex[3] = i;
        double[] x = this.coordinates[iSymm][0];
        double[] y = this.coordinates[iSymm][1];
        double[] z = this.coordinates[iSymm][2];
        this.localOrigin[0] = x[i];
        this.localOrigin[1] = y[i];
        this.localOrigin[2] = z[i];
        this.vecZ[0] = x[iz];
        this.vecZ[1] = y[iz];
        this.vecZ[2] = z[iz];
        DoubleMath.sub((double[])this.vecZ, (double[])this.localOrigin, (double[])this.vecZ);
        double rZ = DoubleMath.length((double[])this.vecZ);
        if (this.frame[i] != MultipoleType.MultipoleFrameDefinition.ZONLY) {
            this.vecX[0] = x[ix];
            this.vecX[1] = y[ix];
            this.vecX[2] = z[ix];
            DoubleMath.sub((double[])this.vecX, (double[])this.localOrigin, (double[])this.vecX);
        } else {
            this.vecX[0] = 1.0;
            this.vecX[1] = 0.0;
            this.vecX[2] = 0.0;
            double dot = this.vecZ[0] / rZ;
            if (FastMath.abs((double)dot) > 0.866) {
                this.vecX[0] = 0.0;
                this.vecX[1] = 1.0;
            }
        }
        double rX = DoubleMath.length((double[])this.vecX);
        if (this.frame[i] == MultipoleType.MultipoleFrameDefinition.ZTHENBISECTOR || this.frame[i] == MultipoleType.MultipoleFrameDefinition.THREEFOLD) {
            this.vecY[0] = x[iy];
            this.vecY[1] = y[iy];
            this.vecY[2] = z[iy];
            DoubleMath.sub((double[])this.vecY, (double[])this.localOrigin, (double[])this.vecY);
        } else {
            DoubleMath.X((double[])this.vecZ, (double[])this.vecX, (double[])this.vecY);
        }
        double rY = DoubleMath.length((double[])this.vecY);
        DoubleMath.scale((double[])this.vecZ, (double)(1.0 / rZ), (double[])this.vecZ);
        DoubleMath.scale((double[])this.vecX, (double)(1.0 / rX), (double[])this.vecX);
        DoubleMath.scale((double[])this.vecY, (double)(1.0 / rY), (double[])this.vecY);
        DoubleMath.X((double[])this.vecX, (double[])this.vecZ, (double[])this.xXZ);
        DoubleMath.X((double[])this.vecY, (double[])this.vecZ, (double[])this.xYZ);
        DoubleMath.X((double[])this.vecY, (double[])this.vecX, (double[])this.xYX);
        DoubleMath.normalize((double[])this.xXZ, (double[])this.xXZ);
        DoubleMath.normalize((double[])this.xYZ, (double[])this.xYZ);
        DoubleMath.normalize((double[])this.xYX, (double[])this.xYX);
        double cosZX = DoubleMath.dot((double[])this.vecZ, (double[])this.vecX);
        double sinZX = FastMath.sqrt((double)(1.0 - cosZX * cosZX));
        double dPhidZ = -(trq[0] * this.vecZ[0] + trq[1] * this.vecZ[1] + trq[2] * this.vecZ[2]);
        double dPhidX = -(trq[0] * this.vecX[0] + trq[1] * this.vecX[1] + trq[2] * this.vecX[2]);
        double dPhidY = -(trq[0] * this.vecY[0] + trq[1] * this.vecY[1] + trq[2] * this.vecY[2]);
        switch (this.frame[i]) {
            case ZONLY: {
                for (int j = 0; j < 3; ++j) {
                    double dZ;
                    g[0][j] = dZ = this.xXZ[j] * dPhidX / (rZ * sinZX) + this.xYZ[j] * dPhidY / rZ;
                    g[3][j] = -dZ;
                }
                break;
            }
            case ZTHENX: {
                for (int j = 0; j < 3; ++j) {
                    double dZ = this.xXZ[j] * dPhidX / (rZ * sinZX) + this.xYZ[j] * dPhidY / rZ;
                    double dX = -this.xXZ[j] * dPhidZ / (rX * sinZX);
                    g[0][j] = dZ;
                    g[1][j] = dX;
                    g[3][j] = -(dZ + dX);
                }
                break;
            }
            case BISECTOR: {
                for (int j = 0; j < 3; ++j) {
                    double dZ = this.xXZ[j] * dPhidX / (rZ * sinZX) + 0.5 * this.xYZ[j] * dPhidY / rZ;
                    double dX = -this.xXZ[j] * dPhidZ / (rX * sinZX) + 0.5 * this.xYX[j] * dPhidY / rX;
                    g[0][j] = dZ;
                    g[1][j] = dX;
                    g[3][j] = -(dZ + dX);
                }
                break;
            }
            case ZTHENBISECTOR: {
                DoubleMath.add((double[])this.vecX, (double[])this.vecY, (double[])this.sumXY);
                DoubleMath.X((double[])this.vecZ, (double[])this.sumXY, (double[])this.xZXY);
                DoubleMath.normalize((double[])this.sumXY, (double[])this.sumXY);
                DoubleMath.normalize((double[])this.xZXY, (double[])this.xZXY);
                DoubleMath.X((double[])this.sumXY, (double[])this.vecZ, (double[])this.xXYZ);
                DoubleMath.X((double[])this.xZXY, (double[])this.vecZ, (double[])this.xxZXYZ);
                DoubleMath.X((double[])this.xZXY, (double[])this.vecX, (double[])this.xxZXYX);
                DoubleMath.X((double[])this.xZXY, (double[])this.vecY, (double[])this.xxZXYY);
                DoubleMath.normalize((double[])this.xXYZ, (double[])this.xXYZ);
                DoubleMath.normalize((double[])this.xxZXYZ, (double[])this.xxZXYZ);
                DoubleMath.normalize((double[])this.xxZXYX, (double[])this.xxZXYX);
                DoubleMath.normalize((double[])this.xxZXYY, (double[])this.xxZXYY);
                double cosZXY = DoubleMath.dot((double[])this.vecZ, (double[])this.sumXY);
                double sinZXY = FastMath.sqrt((double)(1.0 - cosZXY * cosZXY));
                double cosXZXY = DoubleMath.dot((double[])this.vecX, (double[])this.xZXY);
                double sinXZXY = FastMath.sqrt((double)(1.0 - cosXZXY * cosXZXY));
                double cosYZXY = DoubleMath.dot((double[])this.vecY, (double[])this.xZXY);
                double sinYZXY = FastMath.sqrt((double)(1.0 - cosYZXY * cosYZXY));
                DoubleMath.scale((double[])this.xZXY, (double)(-cosXZXY), (double[])this.t1);
                DoubleMath.scale((double[])this.xZXY, (double)(-cosYZXY), (double[])this.t2);
                DoubleMath.add((double[])this.vecX, (double[])this.t1, (double[])this.t1);
                DoubleMath.add((double[])this.vecY, (double[])this.t2, (double[])this.t2);
                DoubleMath.normalize((double[])this.t1, (double[])this.t1);
                DoubleMath.normalize((double[])this.t2, (double[])this.t2);
                double ut1cos = DoubleMath.dot((double[])this.vecZ, (double[])this.t1);
                double ut1sin = FastMath.sqrt((double)(1.0 - ut1cos * ut1cos));
                double ut2cos = DoubleMath.dot((double[])this.vecZ, (double[])this.t2);
                double ut2sin = FastMath.sqrt((double)(1.0 - ut2cos * ut2cos));
                double dPhidR = -(trq[0] * this.sumXY[0] + trq[1] * this.sumXY[1] + trq[2] * this.sumXY[2]);
                double dPhidZXY = -(trq[0] * this.xZXY[0] + trq[1] * this.xZXY[1] + trq[2] * this.xZXY[2]);
                for (int j = 0; j < 3; ++j) {
                    double dZ = this.xXYZ[j] * dPhidR / (rZ * sinZXY) + this.xxZXYZ[j] * dPhidZXY / rZ;
                    double dX = (sinXZXY * this.xZXY[j] - cosXZXY * this.t1[j]) * dPhidZ / (rX * (ut1sin + ut2sin));
                    double dY = (sinYZXY * this.xZXY[j] - cosYZXY * this.t2[j]) * dPhidZ / (rY * (ut1sin + ut2sin));
                    g[0][j] = dZ;
                    g[1][j] = dX;
                    g[2][j] = dY;
                    g[3][j] = -(dZ + dX + dY);
                }
                break;
            }
            case THREEFOLD: {
                DoubleMath.add((double[])this.vecZ, (double[])this.vecX, (double[])this.sumZXY);
                DoubleMath.add((double[])this.vecY, (double[])this.sumZXY, (double[])this.sumZXY);
                double rZXY = DoubleMath.length((double[])this.sumZXY);
                DoubleMath.scale((double[])this.sumZXY, (double)(1.0 / rZXY), (double[])this.sumZXY);
                double cosYSum = DoubleMath.dot((double[])this.vecY, (double[])this.sumZXY);
                double cosZSum = DoubleMath.dot((double[])this.vecZ, (double[])this.sumZXY);
                double cosXSum = DoubleMath.dot((double[])this.vecX, (double[])this.sumZXY);
                DoubleMath.add((double[])this.vecX, (double[])this.vecY, (double[])this.r);
                DoubleMath.normalize((double[])this.r, (double[])this.r);
                double cosRZ = DoubleMath.dot((double[])this.r, (double[])this.vecZ);
                double sinRZ = FastMath.sqrt((double)(1.0 - cosRZ * cosRZ));
                double dPhidR = -trq[0] * this.r[0] - trq[1] * this.r[1] - trq[2] * this.r[2];
                DoubleMath.X((double[])this.r, (double[])this.vecZ, (double[])this.del);
                DoubleMath.normalize((double[])this.del, (double[])this.del);
                double dPhidDel = -trq[0] * this.del[0] - trq[1] * this.del[1] - trq[2] * this.del[2];
                DoubleMath.X((double[])this.del, (double[])this.vecZ, (double[])this.eps);
                for (int j = 0; j < 3; ++j) {
                    double dZ;
                    g[0][j] = dZ = this.del[j] * dPhidR / (rZ * sinRZ) + this.eps[j] * dPhidDel * cosZSum / (rZ * rZXY);
                    g[3][j] = -dZ;
                }
                DoubleMath.add((double[])this.vecZ, (double[])this.vecY, (double[])this.r);
                DoubleMath.normalize((double[])this.r, (double[])this.r);
                double cosRX = DoubleMath.dot((double[])this.r, (double[])this.vecX);
                double sinRX = FastMath.sqrt((double)(1.0 - cosRX * cosRX));
                dPhidR = -trq[0] * this.r[0] - trq[1] * this.r[1] - trq[2] * this.r[2];
                DoubleMath.X((double[])this.r, (double[])this.vecX, (double[])this.del);
                DoubleMath.normalize((double[])this.del, (double[])this.del);
                dPhidDel = -trq[0] * this.del[0] - trq[1] * this.del[1] - trq[2] * this.del[2];
                DoubleMath.X((double[])this.del, (double[])this.vecX, (double[])this.eps);
                int j = 0;
                while (j < 3) {
                    double dX;
                    g[1][j] = dX = this.del[j] * dPhidR / (rX * sinRX) + this.eps[j] * dPhidDel * cosXSum / (rX * rZXY);
                    double[] dArray = g[3];
                    int n = j++;
                    dArray[n] = dArray[n] - dX;
                }
                DoubleMath.add((double[])this.vecZ, (double[])this.vecX, (double[])this.r);
                DoubleMath.normalize((double[])this.r, (double[])this.r);
                double cosRY = DoubleMath.dot((double[])this.r, (double[])this.vecY);
                double sinRY = FastMath.sqrt((double)(1.0 - cosRY * cosRY));
                dPhidR = -trq[0] * this.r[0] - trq[1] * this.r[1] - trq[2] * this.r[2];
                DoubleMath.X((double[])this.r, (double[])this.vecY, (double[])this.del);
                DoubleMath.normalize((double[])this.del, (double[])this.del);
                dPhidDel = -trq[0] * this.del[0] - trq[1] * this.del[1] - trq[2] * this.del[2];
                DoubleMath.X((double[])this.del, (double[])this.vecY, (double[])this.eps);
                int j2 = 0;
                while (j2 < 3) {
                    double dY;
                    g[2][j2] = dY = this.del[j2] * dPhidR / (rY * sinRY) + this.eps[j2] * dPhidDel * cosYSum / (rY * rZXY);
                    double[] dArray = g[3];
                    int n = j2++;
                    dArray[n] = dArray[n] - dY;
                }
                break;
            }
            default: {
                String message = "Fatal exception: Unsupported frame definition: " + String.valueOf((Object)this.frame[i]) + "\n";
                logger.log(Level.SEVERE, message);
            }
        }
    }
}

