/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperties;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.logging.Logger;

public class ScaleParameters {
    private static final Logger logger = Logger.getLogger(ScaleParameters.class.getName());
    @FFXProperties(value={@FFXProperty(name="mpole-12-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="0.0", description="Provides a multiplicative scale factor that is applied to permanent atomic multipole\nelectrostatic interactions between 1-2 connected atoms, i.e., atoms that are directly bonded.\nThe default value of 0.0 is used, if the mpole-12-scale property is not given\nin either the parameter file or the property file.\n"), @FFXProperty(name="chg-12-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="0.0", description="Provides a multiplicative scale factor that is applied to charge-charge electrostatic\ninteractions between 1-2 connected atoms, i.e., atoms that are directly bonded.\nThe default value of 0.0 is used, if the chg-12-scale keyword is not given\nin either the parameter file or the property file.\n")})
    public final double m12scale;
    @FFXProperties(value={@FFXProperty(name="mpole-13-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="0.0", description="Provides a multiplicative scale factor that is applied to permanent atomic multipole\nelectrostatic interactions between 1-3 connected atoms, i.e., atoms separated by two covalent bonds.\nThe default value of 0.0 is used, if the mpole-13-scale keyword is not given\nin either the parameter file or the property file.\n"), @FFXProperty(name="chg-13-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="0.0", description="Provides a multiplicative scale factor that is applied to charge-charge electrostatic\ninteractions between 1-3 connected atoms, i.e., atoms separated by two covalent bonds.\nThe default value of 0.0 is used, if the chg-13-scale keyword is not given\nin either the parameter file or the property file.\n")})
    public final double m13scale;
    @FFXProperties(value={@FFXProperty(name="mpole-14-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="1.0", description="Provides a multiplicative scale factor that is applied to permanent atomic multipole\nelectrostatic interactions between 1-4 connected atoms, i.e., atoms separated by three covalent bonds.\nThe default value of 1.0 is used, if the mpole-14-scale keyword is not given\nin either the parameter file or the property file.\n"), @FFXProperty(name="chg-14-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="1.0", description="Provides a multiplicative scale factor that is applied to charge-charge electrostatic\ninteractions between 1-4 connected atoms, i.e., atoms separated by three covalent bonds.\nThe default value of 1.0 is used, if the chg-14-scale keyword is not given\nin either the parameter file or the property file.\n")})
    public final double m14scale;
    @FFXProperties(value={@FFXProperty(name="mpole-15-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="1.0", description="Provides a multiplicative scale factor that is applied to permanent atomic multipole\nelectrostatic interactions between 1-5 connected atoms, i.e., atoms separated by four covalent bonds.\nThe default value of 1.0 is used, if the mpole-15-scale keyword is not given\nin either the parameter file or the property file.\n"), @FFXProperty(name="chg-15-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="1.0", description="Provides a multiplicative scale factor that is applied to charge-charge electrostatic\ninteractions between 1-5 connected atoms, i.e., atoms separated by four covalent bonds.\nThe default value of 1.0 is used, if the chg-15-scale keyword is not given\nin either the parameter file or the property file.\n")})
    public final double m15scale;
    @FFXProperty(name="direct-11-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="0.0", description="Provides a multiplicative scale factor that is applied to the permanent (direct) field\ndue to atoms within a polarization group during an induced dipole calculation,\ni.e., atoms that are in the same polarization group as the atom being polarized.\nThe default value of 0.0 is used, if the direct-11-scale keyword is not given\nin either the parameter file or the property file.\n")
    public final double d11scale;
    @FFXProperty(name="direct-12-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="1.0", description="Provides a multiplicative scale factor that is applied to the permanent (direct) field\ndue to atoms in 1-2 polarization groups during an induced dipole calculation,\ni.e., atoms that are in polarization groups directly connected to the group containing the atom being polarized.\nThe default value of 0.0 is used, if the direct-12-scale keyword is not given\nin either the parameter file or the property file.\n")
    public final double d12scale;
    @FFXProperty(name="direct-13-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="1.0", description="Provides a multiplicative scale factor that is applied to the permanent (direct) field\ndue to atoms in 1-3 polarization groups during an induced dipole calculation,\ni.e., atoms that are in polarization groups separated by one group from the group containing the atom being polarized.\nThe default value of 0.0 is used, if the direct-13-scale keyword is not given\nin either the parameter file or the property file.\n")
    public final double d13scale;
    @FFXProperty(name="direct-14-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="1.0", description="Provides a multiplicative scale factor that is applied to the permanent (direct) field\ndue to atoms in 1-4 polarization groups during an induced dipole calculation,\ni.e., atoms that are in polarization groups separated by two groups from the group containing the atom being polarized.\nThe default value of 1.0 is used, if the direct-14-scale keyword is not given\nin either the parameter file or the property file.\n")
    public final double d14scale;
    @FFXProperty(name="polar-12-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="0.0", description="Provides a multiplicative scale factor that is applied to polarization interactions\nbetween 1-2 connected atoms located in different polarization groups.\nThe default value of 0.0 is used, if the polar-12-scale keyword is not given\nin either the parameter file or the property file.\n")
    public final double p12scale;
    @FFXProperty(name="polar-13-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="0.0", description="Provides a multiplicative scale factor that is applied to polarization interactions\nbetween 1-3 connected atoms located in different polarization groups.\nThe default value of 0.0 is used, if the polar-13-scale keyword is not given\nin either the parameter file or the property file.\n")
    public final double p13scale;
    @FFXProperty(name="polar-14-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="1.0", description="Provides a multiplicative scale factor that is applied to polarization interactions\nbetween 1-4 connected atoms located in different polarization groups.\nThe default value of 1.0 is used, if the polar-14-scale keyword is not given\nin either the parameter file or the property file.\n")
    public final double p14scale;
    @FFXProperty(name="polar-15-scale", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="1.0", description="Provides a multiplicative scale factor that is applied to polarization interactions\nbetween 1-5 connected atoms located in different polarization groups.\nThe default value of 1.0 is used, if the polar-15-scale keyword is not given\nin either the parameter file or the property file.\n")
    public final double p15scale;
    @FFXProperty(name="polar-12-intra", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="0.0", description="Provides a multiplicative scale factor that is applied to polarization interactions\nbetween 1-2 connected atoms located in the same polarization group.\nThe default value of 0.0 is used, if the polar-12-intra keyword is not given\nin either the parameter file or the property file.\n")
    public final double intra12Scale;
    @FFXProperty(name="polar-13-intra", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="0.0", description="Provides a multiplicative scale factor that is applied to polarization interactions\nbetween 1-3 connected atoms located in the same polarization group.\nThe default value of 0.0 is used, if the polar-13-intra keyword is not given\nin either the parameter file or the property file.\n")
    public final double intra13Scale;
    @FFXProperty(name="polar-14-intra", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="0.5", description="Provides a multiplicative scale factor that is applied to polarization interactions\nbetween 1-4 connected atoms located in the same polarization group.\nThe default value of 0.5 is used, if the polar-14-intra keyword is not given\nin either the parameter file or the property file.\n")
    public final double intra14Scale;
    @FFXProperty(name="polar-15-intra", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="1.0", description="Provides a multiplicative scale factor that is applied to polarization interactions\nbetween 1-5 connected atoms located in the same polarization group.\nThe default value of 1.0 is used, if the polar-15-intra keyword is not given\nin either the parameter file or the property file.\n")
    public final double intra15Scale;

    public ScaleParameters(ForceField.ELEC_FORM elecForm, ForceField forceField) {
        if (elecForm == ForceField.ELEC_FORM.PAM) {
            double m12 = forceField.getDouble("MPOLE_12_SCALE", 0.0);
            if (m12 > 1.0) {
                m12 = 1.0 / m12;
            }
            this.m12scale = m12;
            double m13 = forceField.getDouble("MPOLE_13_SCALE", 0.0);
            if (m13 > 1.0) {
                m13 = 1.0 / m13;
            }
            this.m13scale = m13;
            double m14 = forceField.getDouble("MPOLE_14_SCALE", 1.0);
            if (m14 > 1.0) {
                m14 = 1.0 / m14;
            }
            this.m14scale = m14;
            double m15 = forceField.getDouble("MPOLE_15_SCALE", 1.0);
            if (m15 > 1.0) {
                m15 = 1.0 / m15;
            }
            this.m15scale = m15;
        } else {
            double m12 = forceField.getDouble("CHG_12_SCALE", 0.0);
            if (m12 > 1.0) {
                m12 = 1.0 / m12;
            }
            this.m12scale = m12;
            double m13 = forceField.getDouble("CHG_13_SCALE", 0.0);
            if (m13 > 1.0) {
                m13 = 1.0 / m13;
            }
            this.m13scale = m13;
            double m14 = forceField.getDouble("CHG_14_SCALE", 2.0);
            if (m14 > 1.0) {
                m14 = 1.0 / m14;
            }
            this.m14scale = m14;
            double m15 = forceField.getDouble("CHG_15_SCALE", 1.0);
            if (m15 > 1.0) {
                m15 = 1.0 / m15;
            }
            this.m15scale = m15;
        }
        this.intra12Scale = forceField.getDouble("POLAR_12_INTRA", 0.0);
        if (this.intra12Scale != 0.0) {
            logger.severe(String.format(" Unsupported polar-12-intra parameter: %8.6f", this.intra12Scale));
        }
        this.intra13Scale = forceField.getDouble("POLAR_13_INTRA", 0.0);
        if (this.intra13Scale != 0.0) {
            logger.severe(String.format(" Unsupported polar-13-intra parameter: %8.6f", this.intra13Scale));
        }
        this.intra14Scale = forceField.getDouble("POLAR_14_INTRA", 0.5);
        this.intra15Scale = forceField.getDouble("POLAR_15_INTRA", 1.0);
        if (this.intra15Scale != 1.0) {
            logger.severe(String.format(" Unsupported polar-15-intra parameter: %8.6f", this.intra15Scale));
        }
        this.d11scale = forceField.getDouble("DIRECT_11_SCALE", 0.0);
        this.d12scale = forceField.getDouble("DIRECT_12_SCALE", 1.0);
        this.d13scale = forceField.getDouble("DIRECT_13_SCALE", 1.0);
        this.d14scale = forceField.getDouble("DIRECT_14_SCALE", 1.0);
        if (this.d12scale != 1.0) {
            logger.severe(String.format(" Unsupported direct-12-scale parameter: %8.6f", this.d12scale));
        }
        if (this.d13scale != 1.0) {
            logger.severe(String.format(" Unsupported direct-13-scale parameter: %8.6f", this.d13scale));
        }
        if (this.d14scale != 1.0) {
            logger.severe(String.format(" Unsupported direct-14-scale parameter: %8.6f", this.d14scale));
        }
        this.p12scale = forceField.getDouble("POLAR_12_SCALE", 0.0);
        this.p13scale = forceField.getDouble("POLAR_13_SCALE", 0.0);
        this.p14scale = forceField.getDouble("POLAR_14_SCALE", 1.0);
        this.p15scale = forceField.getDouble("POLAR_15_SCALE", 1.0);
        if (this.p15scale != 1.0) {
            logger.severe(String.format(" Unsupported polar-15-scale parameter: %8.6f", this.p15scale));
        }
    }
}

