/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.reduction.SharedDouble;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.GeneralizedKirkwood;
import ffx.potential.nonbonded.pme.EwaldParameters;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class SORRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(SORRegion.class.getName());
    private final int maxThreads;
    private static final double DEFAULT_POLAR_SOR = 0.7;
    @FFXProperty(name="polar-sor", propertyGroup=PropertyGroup.ElectrostaticsFunctionalForm, defaultValue="0.7", description="The induced dipole successive over-relaxation convergence acceleration factor.")
    private double polsor;
    private final SORLoop[] sorLoop;
    private final SharedDouble sharedEps;
    private final SharedDouble sharedEpsCR;
    public double[][][] inducedDipole;
    public double[][][] inducedDipoleCR;
    public double[][] directDipole;
    public double[][] directDipoleCR;
    private Atom[] atoms;
    private double[] polarizability;
    private double[][] cartesianDipolePhi;
    private double[][] cartesianDipolePhiCR;
    private AtomicDoubleArray3D field;
    private AtomicDoubleArray3D fieldCR;
    private boolean generalizedKirkwoodTerm;
    private GeneralizedKirkwood generalizedKirkwood;
    private double aewald;
    private double aewald3;

    public SORRegion(int nt, ForceField forceField) {
        this.maxThreads = nt;
        this.sorLoop = new SORLoop[nt];
        this.sharedEps = new SharedDouble();
        this.sharedEpsCR = new SharedDouble();
        this.polsor = forceField.getDouble("POLAR_SOR", 0.7);
    }

    public double getPolarSOR() {
        return this.polsor;
    }

    public void setPolarSOR(double polarSOR) {
        this.polsor = polarSOR;
    }

    public double getEps() {
        double eps = this.sharedEps.get();
        double epsCR = this.sharedEpsCR.get();
        return FastMath.max((double)eps, (double)epsCR);
    }

    public double getSOR() {
        return this.polsor;
    }

    public void init(Atom[] atoms, double[] polarizability, double[][][] inducedDipole, double[][][] inducedDipoleCR, double[][] directDipole, double[][] directDipoleCR, double[][] cartesianDipolePhi, double[][] cartesianDipolePhiCR, AtomicDoubleArray3D field, AtomicDoubleArray3D fieldCR, boolean generalizedKirkwoodTerm, GeneralizedKirkwood generalizedKirkwood, EwaldParameters ewaldParameters) {
        this.atoms = atoms;
        this.polarizability = polarizability;
        this.inducedDipole = inducedDipole;
        this.inducedDipoleCR = inducedDipoleCR;
        this.directDipole = directDipole;
        this.directDipoleCR = directDipoleCR;
        this.cartesianDipolePhi = cartesianDipolePhi;
        this.cartesianDipolePhiCR = cartesianDipolePhiCR;
        this.field = field;
        this.fieldCR = fieldCR;
        this.generalizedKirkwoodTerm = generalizedKirkwoodTerm;
        this.generalizedKirkwood = generalizedKirkwood;
        this.aewald = ewaldParameters.aewald;
        this.aewald3 = ewaldParameters.aewald3;
    }

    public void run() throws Exception {
        try {
            int ti = this.getThreadIndex();
            if (this.sorLoop[ti] == null) {
                this.sorLoop[ti] = new SORLoop(this);
            }
            int nAtoms = this.atoms.length;
            this.execute(0, nAtoms - 1, this.sorLoop[ti]);
        }
        catch (RuntimeException ex) {
            logger.warning("Fatal exception computing the mutual induced dipoles in thread " + this.getThreadIndex());
            throw ex;
        }
        catch (Exception e) {
            String message = "Fatal exception computing the mutual induced dipoles in thread " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void start() {
        this.sharedEps.set(0.0);
        this.sharedEpsCR.set(0.0);
    }

    private class SORLoop
    extends IntegerForLoop {
        private double eps;
        private double epsCR;
        final /* synthetic */ SORRegion this$0;

        private SORLoop(SORRegion sORRegion) {
            SORRegion sORRegion2 = sORRegion;
            Objects.requireNonNull(sORRegion2);
            this.this$0 = sORRegion2;
        }

        public void finish() {
            this.this$0.sharedEps.addAndGet(this.eps);
            this.this$0.sharedEpsCR.addAndGet(this.epsCR);
        }

        public void run(int lb, int ub) throws Exception {
            int i;
            int threadID = this.getThreadIndex();
            double[][] induced0 = this.this$0.inducedDipole[0];
            double[][] inducedCR0 = this.this$0.inducedDipoleCR[0];
            if (this.this$0.aewald > 0.0) {
                for (i = lb; i <= ub; ++i) {
                    double[] dipolei = induced0[i];
                    double[] dipoleCRi = inducedCR0[i];
                    double[] phii = this.this$0.cartesianDipolePhi[i];
                    double[] phiCRi = this.this$0.cartesianDipolePhiCR[i];
                    double fx = this.this$0.aewald3 * dipolei[0] - phii[1];
                    double fy = this.this$0.aewald3 * dipolei[1] - phii[2];
                    double fz = this.this$0.aewald3 * dipolei[2] - phii[3];
                    double fxCR = this.this$0.aewald3 * dipoleCRi[0] - phiCRi[1];
                    double fyCR = this.this$0.aewald3 * dipoleCRi[1] - phiCRi[2];
                    double fzCR = this.this$0.aewald3 * dipoleCRi[2] - phiCRi[3];
                    this.this$0.field.add(threadID, i, fx, fy, fz);
                    this.this$0.fieldCR.add(threadID, i, fxCR, fyCR, fzCR);
                }
            }
            if (this.this$0.generalizedKirkwoodTerm) {
                AtomicDoubleArray3D fieldGK = this.this$0.generalizedKirkwood.getFieldGK();
                AtomicDoubleArray3D fieldGKCR = this.this$0.generalizedKirkwood.getFieldGKCR();
                for (int i2 = lb; i2 <= ub; ++i2) {
                    this.this$0.field.add(threadID, i2, fieldGK.getX(i2), fieldGK.getY(i2), fieldGK.getZ(i2));
                    this.this$0.fieldCR.add(threadID, i2, fieldGKCR.getX(i2), fieldGKCR.getY(i2), fieldGKCR.getZ(i2));
                }
            }
            this.this$0.field.reduce(lb, ub);
            this.this$0.fieldCR.reduce(lb, ub);
            for (i = lb; i <= ub; ++i) {
                double[] ind = induced0[i];
                double[] indCR = inducedCR0[i];
                double[] direct = this.this$0.directDipole[i];
                double[] directCR = this.this$0.directDipoleCR[i];
                double polar = this.this$0.polarizability[i];
                for (int j = 0; j < 3; ++j) {
                    double previous = ind[j];
                    double mutual = polar * this.this$0.field.get(j, i);
                    ind[j] = direct[j] + mutual;
                    double delta = this.this$0.polsor * (ind[j] - previous);
                    ind[j] = previous + delta;
                    this.eps += delta * delta;
                    previous = indCR[j];
                    mutual = polar * this.this$0.fieldCR.get(j, i);
                    indCR[j] = directCR[j] + mutual;
                    delta = this.this$0.polsor * (indCR[j] - previous);
                    indCR[j] = previous + delta;
                    this.epsCR += delta * delta;
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }

        public void start() {
            this.eps = 0.0;
            this.epsCR = 0.0;
        }
    }
}

