/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedDouble;
import edu.rit.pj.reduction.SharedInteger;
import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.special.Erf;
import ffx.potential.bonded.Atom;
import ffx.potential.extended.ExtendedSystem;
import ffx.potential.nonbonded.MaskingInterface;
import ffx.potential.nonbonded.pme.AlchemicalParameters;
import ffx.potential.nonbonded.pme.EwaldParameters;
import ffx.potential.nonbonded.pme.LambdaMode;
import ffx.potential.nonbonded.pme.Polarization;
import ffx.potential.nonbonded.pme.RealSpaceNeighborParameters;
import ffx.potential.nonbonded.pme.ScaleParameters;
import ffx.potential.nonbonded.pme.Torque;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.MultipoleType;
import ffx.potential.utils.EnergyException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class RealSpaceEnergyRegion
extends ParallelRegion
implements MaskingInterface {
    private static final Logger logger = Logger.getLogger(RealSpaceEnergyRegion.class.getName());
    private static final double oneThird = 0.3333333333333333;
    private final int maxThreads;
    private final double electric;
    private final SharedInteger sharedInteractions;
    private final ForceField.ELEC_FORM elecForm;
    private final RealSpaceEnergyLoop[] realSpaceEnergyLoop;
    private final FixedChargeEnergyLoop[] fixedChargeEnergyLoop;
    private final boolean intermolecularSoftcore;
    private final boolean intramolecularSoftcore;
    public double[][][] inducedDipole;
    public double[][][] inducedDipoleCR;
    protected int[][] ip11;
    private Atom[] atoms;
    private Crystal crystal;
    private double[][][] coordinates;
    private MultipoleType.MultipoleFrameDefinition[] frame;
    private int[][] axisAtom;
    private double[][][] globalMultipole;
    private double[][][] titrationMultipole;
    private double[][][] tautomerMultipole;
    private ExtendedSystem extendedSystem = null;
    private boolean esvTerm = false;
    private boolean[] use;
    private int[] molecule;
    private boolean[] isSoft;
    private double[] ipdamp;
    private double[] thole;
    private int[][] mask12;
    private int[][] mask13;
    private int[][] mask14;
    private int[][] mask15;
    private int[][][] realSpaceLists;
    private int[][] realSpaceCounts;
    private IntegerSchedule realSpaceSchedule;
    private long[] realSpaceEnergyTime;
    private AtomicDoubleArray3D grad;
    private AtomicDoubleArray3D torque;
    private AtomicDoubleArray3D lambdaGrad;
    private AtomicDoubleArray3D lambdaTorque;
    private SharedDouble shareddEdLambda;
    private SharedDouble sharedd2EdLambda2;
    private boolean gradient;
    private boolean lambdaTerm;
    private boolean nnTerm;
    private LambdaMode lambdaMode = LambdaMode.OFF;
    private Polarization polarization;
    private double lAlpha = 0.0;
    private double dlAlpha = 0.0;
    private double d2lAlpha = 0.0;
    private double dEdLSign = 1.0;
    private double dlPowPerm = 0.0;
    private double d2lPowPerm = 0.0;
    private boolean doPermanentRealSpace;
    private double permanentScale = 1.0;
    private double lPowPol = 1.0;
    private double dlPowPol = 0.0;
    private double d2lPowPol = 0.0;
    private boolean doPolarization;
    private double polarizationScale = 1.0;
    private double aewald;
    private double an0;
    private double an1;
    private double an2;
    private double an3;
    private double an4;
    private double an5;
    private double permanentEnergy;
    private double polarizationEnergy;
    private ScaleParameters scaleParameters;

    public RealSpaceEnergyRegion(ForceField.ELEC_FORM elecForm, int nt, ForceField forceField, boolean lambdaTerm, double electric) {
        this.maxThreads = nt;
        this.electric = electric;
        this.elecForm = elecForm;
        this.sharedInteractions = new SharedInteger();
        if (elecForm == ForceField.ELEC_FORM.FIXED_CHARGE) {
            this.fixedChargeEnergyLoop = new FixedChargeEnergyLoop[nt];
            this.realSpaceEnergyLoop = null;
        } else {
            this.fixedChargeEnergyLoop = null;
            this.realSpaceEnergyLoop = new RealSpaceEnergyLoop[nt];
        }
        if (lambdaTerm) {
            this.intermolecularSoftcore = forceField.getBoolean("INTERMOLECULAR_SOFTCORE", false);
            this.intramolecularSoftcore = forceField.getBoolean("INTRAMOLECULAR_SOFTCORE", false);
        } else {
            this.intermolecularSoftcore = false;
            this.intramolecularSoftcore = false;
        }
    }

    @Override
    public void applyMask(int i, boolean[] is14, double[] ... masks) {
        if (this.ip11[i] != null) {
            double[] permanentEnergyMask = masks[0];
            double[] permanentFieldMask = masks[1];
            for (int value : this.mask12[i]) {
                permanentFieldMask[value] = this.scaleParameters.p12scale;
                permanentEnergyMask[value] = this.scaleParameters.m12scale;
            }
            for (int value : this.mask13[i]) {
                permanentFieldMask[value] = this.scaleParameters.p13scale;
                permanentEnergyMask[value] = this.scaleParameters.m13scale;
            }
            block2: for (int value : this.mask14[i]) {
                permanentFieldMask[value] = this.scaleParameters.p14scale;
                permanentEnergyMask[value] = this.scaleParameters.m14scale;
                for (int k : this.ip11[i]) {
                    if (k != value) continue;
                    permanentFieldMask[value] = this.scaleParameters.intra14Scale * this.scaleParameters.p14scale;
                    continue block2;
                }
            }
            for (int value : this.mask15[i]) {
                permanentEnergyMask[value] = this.scaleParameters.m15scale;
            }
            double[] polarizationGroupMask = masks[2];
            for (int j : this.ip11[i]) {
                polarizationGroupMask[j] = this.scaleParameters.d11scale;
            }
        } else {
            double[] permanentEnergyMask = masks[0];
            for (int value : this.mask12[i]) {
                permanentEnergyMask[value] = this.scaleParameters.m12scale;
            }
            for (int value : this.mask13[i]) {
                permanentEnergyMask[value] = this.scaleParameters.m13scale;
            }
            for (int value : this.mask14[i]) {
                permanentEnergyMask[value] = this.scaleParameters.m14scale;
            }
        }
    }

    public void executeWith(ParallelTeam parallelTeam) {
        try {
            parallelTeam.execute((ParallelRegion)this);
        }
        catch (Exception e) {
            String message = " Exception computing the electrostatic energy.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void finish() {
        this.permanentEnergy = 0.0;
        this.polarizationEnergy = 0.0;
        if (this.elecForm == ForceField.ELEC_FORM.FIXED_CHARGE) {
            for (int i = 0; i < this.maxThreads; ++i) {
                this.permanentEnergy += this.fixedChargeEnergyLoop[i].permanentEnergy;
            }
        } else {
            for (int i = 0; i < this.maxThreads; ++i) {
                this.permanentEnergy += this.realSpaceEnergyLoop[i].permanentEnergy;
                this.polarizationEnergy += this.realSpaceEnergyLoop[i].inducedEnergy;
            }
        }
        this.permanentEnergy *= this.electric;
        this.polarizationEnergy *= this.electric;
        if (Double.isNaN(this.permanentEnergy)) {
            throw new EnergyException(String.format(" The permanent multipole energy is %16.8f", this.permanentEnergy));
        }
        if (Double.isNaN(this.polarizationEnergy)) {
            throw new EnergyException(String.format(" The polarization energy is %16.8f", this.polarizationEnergy));
        }
    }

    public int getCount(int i) {
        if (this.elecForm == ForceField.ELEC_FORM.FIXED_CHARGE) {
            return this.fixedChargeEnergyLoop[i].getCount();
        }
        return this.realSpaceEnergyLoop[i].getCount();
    }

    public int getInteractions() {
        return this.sharedInteractions.get();
    }

    public double getPermanentEnergy() {
        return this.permanentEnergy;
    }

    public double getPolarizationEnergy() {
        return this.polarizationEnergy;
    }

    public void init(Atom[] atoms, Crystal crystal, ExtendedSystem extendedSystem, boolean esvTerm, double[][][] coordinates, MultipoleType.MultipoleFrameDefinition[] frame, int[][] axisAtom, double[][][] globalMultipole, double[][][] titrationMultipole, double[][][] tautomerMultipole, double[][][] inducedDipole, double[][][] inducedDipoleCR, boolean[] use, int[] molecule, int[][] ip11, int[][] mask12, int[][] mask13, int[][] mask14, int[][] mask15, boolean[] isSoft, double[] ipdamp, double[] thole, RealSpaceNeighborParameters realSpaceNeighborParameters, boolean gradient, boolean lambdaTerm, boolean nnTerm, LambdaMode lambdaMode, Polarization polarization, EwaldParameters ewaldParameters, ScaleParameters scaleParameters, AlchemicalParameters alchemicalParameters, long[] realSpaceEnergyTime, AtomicDoubleArray3D grad, AtomicDoubleArray3D torque, AtomicDoubleArray3D lambdaGrad, AtomicDoubleArray3D lambdaTorque, SharedDouble shareddEdLambda, SharedDouble sharedd2EdLambda2) {
        this.atoms = atoms;
        this.crystal = crystal;
        this.extendedSystem = extendedSystem;
        this.esvTerm = esvTerm;
        this.coordinates = coordinates;
        this.frame = frame;
        this.axisAtom = axisAtom;
        this.globalMultipole = globalMultipole;
        this.titrationMultipole = titrationMultipole;
        this.tautomerMultipole = tautomerMultipole;
        this.inducedDipole = inducedDipole;
        this.inducedDipoleCR = inducedDipoleCR;
        this.use = use;
        this.molecule = molecule;
        this.ip11 = ip11;
        this.mask12 = mask12;
        this.mask13 = mask13;
        this.mask14 = mask14;
        this.mask15 = mask15;
        this.isSoft = isSoft;
        this.ipdamp = ipdamp;
        this.thole = thole;
        this.realSpaceLists = realSpaceNeighborParameters.realSpaceLists;
        this.realSpaceCounts = realSpaceNeighborParameters.realSpaceCounts;
        this.realSpaceSchedule = realSpaceNeighborParameters.realSpaceSchedule;
        this.gradient = gradient;
        this.lambdaTerm = lambdaTerm;
        this.nnTerm = nnTerm;
        this.lambdaMode = lambdaMode;
        this.polarization = polarization;
        this.lAlpha = alchemicalParameters.lAlpha;
        this.dlAlpha = alchemicalParameters.dlAlpha;
        this.d2lAlpha = alchemicalParameters.d2lAlpha;
        this.dEdLSign = alchemicalParameters.dEdLSign;
        this.dlPowPerm = alchemicalParameters.dlPowPerm;
        this.d2lPowPerm = alchemicalParameters.d2lPowPerm;
        this.doPermanentRealSpace = alchemicalParameters.doPermanentRealSpace;
        this.permanentScale = alchemicalParameters.permanentScale;
        this.lPowPol = alchemicalParameters.lPowPol;
        this.dlPowPol = alchemicalParameters.dlPowPol;
        this.d2lPowPol = alchemicalParameters.d2lPowPol;
        this.doPolarization = alchemicalParameters.doPolarization;
        this.polarizationScale = alchemicalParameters.polarizationScale;
        this.aewald = ewaldParameters.aewald;
        this.an0 = ewaldParameters.an0;
        this.an1 = ewaldParameters.an1;
        this.an2 = ewaldParameters.an2;
        this.an3 = ewaldParameters.an3;
        this.an4 = ewaldParameters.an4;
        this.an5 = ewaldParameters.an5;
        this.scaleParameters = scaleParameters;
        this.realSpaceEnergyTime = realSpaceEnergyTime;
        this.grad = grad;
        this.torque = torque;
        this.lambdaGrad = lambdaGrad;
        this.lambdaTorque = lambdaTorque;
        this.shareddEdLambda = shareddEdLambda;
        this.sharedd2EdLambda2 = sharedd2EdLambda2;
    }

    @Override
    public void removeMask(int i, boolean[] is14, double[] ... masks) {
        if (this.ip11[i] != null) {
            double[] permanentEnergyMask = masks[0];
            double[] permanentFieldMask = masks[1];
            for (int value : this.mask12[i]) {
                permanentFieldMask[value] = 1.0;
                permanentEnergyMask[value] = 1.0;
            }
            for (int value : this.mask13[i]) {
                permanentFieldMask[value] = 1.0;
                permanentEnergyMask[value] = 1.0;
            }
            block2: for (int value : this.mask14[i]) {
                permanentFieldMask[value] = 1.0;
                permanentEnergyMask[value] = 1.0;
                for (int k : this.ip11[i]) {
                    if (k != value) continue;
                    permanentFieldMask[value] = 1.0;
                    continue block2;
                }
            }
            for (int value : this.mask15[i]) {
                permanentEnergyMask[value] = 1.0;
            }
            double[] polarizationGroupMask = masks[2];
            for (int j : this.ip11[i]) {
                polarizationGroupMask[j] = 1.0;
            }
        } else {
            double[] permanentEnergyMask = masks[0];
            for (int value : this.mask12[i]) {
                permanentEnergyMask[value] = 1.0;
            }
            for (int value : this.mask13[i]) {
                permanentEnergyMask[value] = 1.0;
            }
            for (int value : this.mask14[i]) {
                permanentEnergyMask[value] = 1.0;
            }
        }
    }

    public void run() {
        int threadIndex = this.getThreadIndex();
        if (this.elecForm == ForceField.ELEC_FORM.FIXED_CHARGE) {
            if (this.fixedChargeEnergyLoop[threadIndex] == null) {
                this.fixedChargeEnergyLoop[threadIndex] = new FixedChargeEnergyLoop(this);
            }
            try {
                int nAtoms = this.atoms.length;
                this.execute(0, nAtoms - 1, this.fixedChargeEnergyLoop[threadIndex]);
            }
            catch (Exception e) {
                String message = "Fatal exception computing the real space energy in thread " + this.getThreadIndex() + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        } else {
            if (this.realSpaceEnergyLoop[threadIndex] == null) {
                this.realSpaceEnergyLoop[threadIndex] = new RealSpaceEnergyLoop(this);
            }
            try {
                int nAtoms = this.atoms.length;
                this.execute(0, nAtoms - 1, this.realSpaceEnergyLoop[threadIndex]);
            }
            catch (Exception e) {
                String message = "Fatal exception computing the real space energy in thread " + this.getThreadIndex() + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
    }

    public void start() {
        this.sharedInteractions.set(0);
    }

    private void log(int i, int k, double r, double eij, int count, double total) {
        logger.info(String.format("%s  %6d  %6d  %12.10f  %12.10f %8d %16.10f", "ELEC", this.atoms[i].getIndex(), this.atoms[k].getIndex(), r, eij, count, total));
    }

    private class FixedChargeEnergyLoop
    extends IntegerForLoop {
        private final double[] dx_local;
        private final double[][] rot_local;
        private double ci;
        private double ck;
        private double xr;
        private double yr;
        private double zr;
        private double bn0;
        private double bn1;
        private double bn2;
        private double rr1;
        private double rr3;
        private double rr5;
        private double scale;
        private double l2;
        private boolean soft;
        private double selfScale;
        private double permanentEnergy;
        private double inducedEnergy;
        private double dUdL;
        private double d2UdL2;
        private int i;
        private int k;
        private int iSymm;
        private int count;
        private double[] gxk_local;
        private double[] gyk_local;
        private double[] gzk_local;
        private double[] lxk_local;
        private double[] lyk_local;
        private double[] lzk_local;
        private double[] masking_local;
        private int threadID;
        final /* synthetic */ RealSpaceEnergyRegion this$0;

        FixedChargeEnergyLoop(RealSpaceEnergyRegion realSpaceEnergyRegion) {
            RealSpaceEnergyRegion realSpaceEnergyRegion2 = realSpaceEnergyRegion;
            Objects.requireNonNull(realSpaceEnergyRegion2);
            this.this$0 = realSpaceEnergyRegion2;
            this.dx_local = new double[3];
            this.rot_local = new double[3][3];
        }

        public void finish() {
            this.this$0.sharedInteractions.addAndGet(this.count);
            if (this.this$0.lambdaTerm) {
                this.this$0.shareddEdLambda.addAndGet(this.dUdL * this.this$0.electric);
                this.this$0.sharedd2EdLambda2.addAndGet(this.d2UdL2 * this.this$0.electric);
            }
            int n = this.getThreadIndex();
            this.this$0.realSpaceEnergyTime[n] = this.this$0.realSpaceEnergyTime[n] + System.nanoTime();
        }

        public int getCount() {
            return this.count;
        }

        public void run(int lb, int ub) {
            List symOps = this.this$0.crystal.spaceGroup.symOps;
            int nSymm = symOps.size();
            int nAtoms = this.this$0.atoms.length;
            this.iSymm = 0;
            while (this.iSymm < nSymm) {
                int j;
                SymOp symOp = (SymOp)symOps.get(this.iSymm);
                if (this.this$0.gradient) {
                    Arrays.fill(this.gxk_local, 0.0);
                    Arrays.fill(this.gyk_local, 0.0);
                    Arrays.fill(this.gzk_local, 0.0);
                }
                if (this.this$0.lambdaTerm) {
                    Arrays.fill(this.lxk_local, 0.0);
                    Arrays.fill(this.lyk_local, 0.0);
                    Arrays.fill(this.lzk_local, 0.0);
                }
                this.realSpaceChunk(lb, ub);
                if (this.this$0.gradient) {
                    if (this.iSymm != 0) {
                        this.this$0.crystal.applyTransSymRot(nAtoms, this.gxk_local, this.gyk_local, this.gzk_local, this.gxk_local, this.gyk_local, this.gzk_local, symOp, this.rot_local);
                    }
                    for (j = 0; j < nAtoms; ++j) {
                        this.this$0.grad.add(this.threadID, j, this.gxk_local[j], this.gyk_local[j], this.gzk_local[j]);
                    }
                }
                if (this.this$0.lambdaTerm) {
                    if (this.iSymm != 0) {
                        this.this$0.crystal.applyTransSymRot(nAtoms, this.lxk_local, this.lyk_local, this.lzk_local, this.lxk_local, this.lyk_local, this.lzk_local, symOp, this.rot_local);
                    }
                    for (j = 0; j < nAtoms; ++j) {
                        this.this$0.lambdaGrad.add(this.threadID, j, this.lxk_local[j], this.lyk_local[j], this.lzk_local[j]);
                    }
                }
                ++this.iSymm;
            }
        }

        public IntegerSchedule schedule() {
            return this.this$0.realSpaceSchedule;
        }

        public void start() {
            this.init();
            int n = this.threadID = this.getThreadIndex();
            this.this$0.realSpaceEnergyTime[n] = this.this$0.realSpaceEnergyTime[n] - System.nanoTime();
            this.permanentEnergy = 0.0;
            this.inducedEnergy = 0.0;
            this.count = 0;
            if (this.this$0.lambdaTerm) {
                this.dUdL = 0.0;
                this.d2UdL2 = 0.0;
            }
        }

        private void init() {
            int nAtoms = this.this$0.atoms.length;
            if (this.masking_local == null || this.masking_local.length < nAtoms) {
                this.gxk_local = new double[nAtoms];
                this.gyk_local = new double[nAtoms];
                this.gzk_local = new double[nAtoms];
                this.lxk_local = new double[nAtoms];
                this.lyk_local = new double[nAtoms];
                this.lzk_local = new double[nAtoms];
                this.masking_local = new double[nAtoms];
                Arrays.fill(this.masking_local, 1.0);
            }
        }

        private void realSpaceChunk(int lb, int ub) {
            double[] x = this.this$0.coordinates[0][0];
            double[] y = this.this$0.coordinates[0][1];
            double[] z = this.this$0.coordinates[0][2];
            double[][] mpole = this.this$0.globalMultipole[0];
            int[][] lists = this.this$0.realSpaceLists[this.iSymm];
            double[] neighborX = this.this$0.coordinates[this.iSymm][0];
            double[] neighborY = this.this$0.coordinates[this.iSymm][1];
            double[] neighborZ = this.this$0.coordinates[this.iSymm][2];
            double[][] neighborMultipole = this.this$0.globalMultipole[this.iSymm];
            this.i = lb;
            while (this.i <= ub) {
                if (this.this$0.use[this.i]) {
                    int moleculei = this.this$0.molecule[this.i];
                    if (this.iSymm == 0) {
                        this.this$0.applyMask(this.i, null, new double[][]{this.masking_local});
                    }
                    double xi = x[this.i];
                    double yi = y[this.i];
                    double zi = z[this.i];
                    double[] globalMultipolei = mpole[this.i];
                    this.setMultipoleI(globalMultipolei);
                    boolean softi = this.this$0.isSoft[this.i];
                    int[] list = lists[this.i];
                    int npair = this.this$0.realSpaceCounts[this.iSymm][this.i];
                    for (int j = 0; j < npair; ++j) {
                        double tautdUdL;
                        double titrdUdL;
                        boolean sameMolecule;
                        this.k = list[j];
                        if (!this.this$0.use[this.k]) continue;
                        boolean bl = sameMolecule = moleculei == this.this$0.molecule[this.k];
                        if (this.this$0.lambdaMode == LambdaMode.VAPOR && (this.this$0.intermolecularSoftcore && !sameMolecule || this.this$0.intramolecularSoftcore && sameMolecule)) continue;
                        this.selfScale = 1.0;
                        if (this.i == this.k) {
                            this.selfScale = 0.5;
                        }
                        double beta = 0.0;
                        this.l2 = 1.0;
                        boolean bl2 = this.soft = softi || this.this$0.isSoft[this.k];
                        if (this.soft && this.this$0.doPermanentRealSpace) {
                            beta = this.this$0.lAlpha;
                            this.l2 = this.this$0.permanentScale;
                        } else if (this.this$0.nnTerm) {
                            this.l2 = this.this$0.permanentScale;
                        }
                        double xk = neighborX[this.k];
                        double yk = neighborY[this.k];
                        double zk = neighborZ[this.k];
                        this.dx_local[0] = xk - xi;
                        this.dx_local[1] = yk - yi;
                        this.dx_local[2] = zk - zi;
                        double r2 = this.this$0.crystal.image(this.dx_local);
                        this.xr = this.dx_local[0];
                        this.yr = this.dx_local[1];
                        this.zr = this.dx_local[2];
                        double[] globalMultipolek = neighborMultipole[this.k];
                        this.setMultipoleK(globalMultipolek);
                        this.scale = this.masking_local[this.k];
                        double r = FastMath.sqrt((double)(r2 + beta));
                        double ralpha = this.this$0.aewald * r;
                        double exp2a = FastMath.exp((double)(-ralpha * ralpha));
                        this.rr1 = 1.0 / r;
                        double rr2 = this.rr1 * this.rr1;
                        this.bn0 = Erf.erfc((double)ralpha) * this.rr1;
                        this.bn1 = (this.bn0 + this.this$0.an0 * exp2a) * rr2;
                        this.bn2 = (3.0 * this.bn1 + this.this$0.an1 * exp2a) * rr2;
                        this.rr3 = this.rr1 * rr2;
                        this.rr5 = 3.0 * this.rr3 * rr2;
                        if (!this.this$0.doPermanentRealSpace) continue;
                        double ei = this.permanentPair(this.this$0.gradient, this.this$0.lambdaTerm);
                        if (Double.isNaN(ei) || Double.isInfinite(ei)) {
                            String message = String.format(" %s\n %s\n %s\n The permanent multipole energy between atoms %d and %d (%d) is %16.8f at %16.8f A.", this.this$0.crystal.getUnitCell().toString(), this.this$0.atoms[this.i].toString(), this.this$0.atoms[this.k].toString(), this.i, this.k, this.iSymm, ei, r);
                            throw new EnergyException(message);
                        }
                        if (ei != 0.0) {
                            this.permanentEnergy += ei;
                            ++this.count;
                        }
                        if (!this.this$0.esvTerm) continue;
                        if (this.this$0.extendedSystem.isTitrating(this.i)) {
                            titrdUdL = 0.0;
                            tautdUdL = 0.0;
                            double[][] titrMpole = this.this$0.titrationMultipole[0];
                            double[] titrMultipolei = titrMpole[this.i];
                            this.setMultipoleI(titrMultipolei);
                            titrdUdL = this.this$0.electric * this.permanentPair(false, false);
                            if (this.this$0.extendedSystem.isTautomerizing(this.i)) {
                                double[][] tautMpole = this.this$0.tautomerMultipole[0];
                                double[] tautMultipolei = tautMpole[this.i];
                                this.setMultipoleI(tautMultipolei);
                                tautdUdL = this.this$0.electric * this.permanentPair(false, false);
                            }
                            this.this$0.extendedSystem.addPermElecDeriv(this.i, titrdUdL, tautdUdL);
                            this.setMultipoleI(globalMultipolei);
                        }
                        if (!this.this$0.extendedSystem.isTitrating(this.k)) continue;
                        titrdUdL = 0.0;
                        tautdUdL = 0.0;
                        double[][] titrNeighborMpole = this.this$0.titrationMultipole[this.iSymm];
                        double[] titrMultipolek = titrNeighborMpole[this.k];
                        this.setMultipoleK(titrMultipolek);
                        titrdUdL = this.this$0.electric * this.permanentPair(false, false);
                        if (this.this$0.extendedSystem.isTautomerizing(this.k)) {
                            double[][] tautNeighborMpole = this.this$0.tautomerMultipole[this.iSymm];
                            double[] tautMultipolek = tautNeighborMpole[this.k];
                            this.setMultipoleK(tautMultipolek);
                            tautdUdL = this.this$0.electric * this.permanentPair(false, false);
                        }
                        this.this$0.extendedSystem.addPermElecDeriv(this.k, titrdUdL, tautdUdL);
                        this.setMultipoleK(globalMultipolek);
                    }
                    if (this.iSymm == 0) {
                        this.this$0.removeMask(this.i, null, new double[][]{this.masking_local});
                    }
                }
                ++this.i;
            }
        }

        private double permanentPair(boolean gradientLocal, boolean lambdaTermLocal) {
            double gl0 = this.ci * this.ck;
            double scale1 = 1.0 - this.scale;
            double ereal = gl0 * this.bn0;
            double efix = scale1 * (gl0 * this.rr1);
            double e = this.selfScale * this.l2 * (ereal - efix);
            if (gradientLocal) {
                double gf1 = this.bn1 * gl0;
                double ftm2x = gf1 * this.xr;
                double ftm2y = gf1 * this.yr;
                double ftm2z = gf1 * this.zr;
                if (scale1 != 0.0) {
                    double gfr1 = this.rr3 * gl0;
                    double ftm2rx = gfr1 * this.xr;
                    double ftm2ry = gfr1 * this.yr;
                    double ftm2rz = gfr1 * this.zr;
                    ftm2x -= scale1 * ftm2rx;
                    ftm2y -= scale1 * ftm2ry;
                    ftm2z -= scale1 * ftm2rz;
                }
                double prefactor = this.this$0.electric * this.selfScale * this.l2;
                this.this$0.grad.add(this.threadID, this.i, prefactor * ftm2x, prefactor * ftm2y, prefactor * ftm2z);
                int n = this.k;
                this.gxk_local[n] = this.gxk_local[n] - prefactor * ftm2x;
                int n2 = this.k;
                this.gyk_local[n2] = this.gyk_local[n2] - prefactor * ftm2y;
                int n3 = this.k;
                this.gzk_local[n3] = this.gzk_local[n3] - prefactor * ftm2z;
                if (this.this$0.lambdaTerm && this.soft) {
                    prefactor = this.this$0.electric * this.selfScale * this.this$0.dEdLSign * this.this$0.dlPowPerm;
                    this.this$0.lambdaGrad.add(this.threadID, this.i, prefactor * ftm2x, prefactor * ftm2y, prefactor * ftm2z);
                    int n4 = this.k;
                    this.lxk_local[n4] = this.lxk_local[n4] - prefactor * ftm2x;
                    int n5 = this.k;
                    this.lyk_local[n5] = this.lyk_local[n5] - prefactor * ftm2y;
                    int n6 = this.k;
                    this.lzk_local[n6] = this.lzk_local[n6] - prefactor * ftm2z;
                }
            }
            if (lambdaTermLocal && this.soft) {
                double dRealdL = gl0 * this.bn1;
                double d2RealdL2 = gl0 * this.bn2;
                this.dUdL += this.selfScale * (this.this$0.dEdLSign * this.this$0.dlPowPerm * ereal + this.l2 * this.this$0.dlAlpha * dRealdL);
                this.d2UdL2 += this.selfScale * (this.this$0.dEdLSign * (this.this$0.d2lPowPerm * ereal + this.this$0.dlPowPerm * this.this$0.dlAlpha * dRealdL + this.this$0.dlPowPerm * this.this$0.dlAlpha * dRealdL) + this.l2 * this.this$0.d2lAlpha * dRealdL + this.l2 * this.this$0.dlAlpha * this.this$0.dlAlpha * d2RealdL2);
                double dFixdL = gl0 * this.rr3;
                double d2FixdL2 = gl0 * this.rr5;
                this.dUdL -= this.selfScale * (this.this$0.dEdLSign * this.this$0.dlPowPerm * efix + this.l2 * this.this$0.dlAlpha * (dFixdL *= scale1));
                this.d2UdL2 -= this.selfScale * (this.this$0.dEdLSign * (this.this$0.d2lPowPerm * efix + this.this$0.dlPowPerm * this.this$0.dlAlpha * dFixdL + this.this$0.dlPowPerm * this.this$0.dlAlpha * dFixdL) + this.l2 * this.this$0.d2lAlpha * dFixdL + this.l2 * this.this$0.dlAlpha * this.this$0.dlAlpha * (d2FixdL2 *= scale1));
                double gf1 = this.bn2 * gl0;
                double ftm2x = gf1 * this.xr;
                double ftm2y = gf1 * this.yr;
                double ftm2z = gf1 * this.zr;
                if (scale1 != 0.0) {
                    double gfr1 = this.rr5 * gl0;
                    double ftm2rx = gfr1 * this.xr;
                    double ftm2ry = gfr1 * this.yr;
                    double ftm2rz = gfr1 * this.zr;
                    ftm2x -= scale1 * ftm2rx;
                    ftm2y -= scale1 * ftm2ry;
                    ftm2z -= scale1 * ftm2rz;
                }
                double prefactor = this.this$0.electric * this.selfScale * this.l2 * this.this$0.dlAlpha;
                this.this$0.lambdaGrad.add(this.threadID, this.i, prefactor * ftm2x, prefactor * ftm2y, prefactor * ftm2z);
                int n = this.k;
                this.lxk_local[n] = this.lxk_local[n] - prefactor * ftm2x;
                int n7 = this.k;
                this.lyk_local[n7] = this.lyk_local[n7] - prefactor * ftm2y;
                int n8 = this.k;
                this.lzk_local[n8] = this.lzk_local[n8] - prefactor * ftm2z;
            }
            return e;
        }

        private void setMultipoleI(double[] globalMultipolei) {
            this.ci = globalMultipolei[0];
        }

        private void setMultipoleK(double[] globalMultipolek) {
            this.ck = globalMultipolek[0];
        }
    }

    private class RealSpaceEnergyLoop
    extends IntegerForLoop {
        private final double[] dx_local;
        private final double[][] rot_local;
        private final Torque torques;
        private double ci;
        private double dix;
        private double diy;
        private double diz;
        private double qixx;
        private double qiyy;
        private double qizz;
        private double qixy;
        private double qixz;
        private double qiyz;
        private double ck;
        private double dkx;
        private double dky;
        private double dkz;
        private double qkxx;
        private double qkyy;
        private double qkzz;
        private double qkxy;
        private double qkxz;
        private double qkyz;
        private double uix;
        private double uiy;
        private double uiz;
        private double pix;
        private double piy;
        private double piz;
        private double xr;
        private double yr;
        private double zr;
        private double ukx;
        private double uky;
        private double ukz;
        private double pkx;
        private double pky;
        private double pkz;
        private double bn0;
        private double bn1;
        private double bn2;
        private double bn3;
        private double bn4;
        private double bn5;
        private double bn6;
        private double rr1;
        private double rr3;
        private double rr5;
        private double rr7;
        private double rr9;
        private double rr11;
        private double rr13;
        private double scale;
        private double scale3;
        private double scale5;
        private double scale7;
        private double scalep;
        private double scaled;
        private double ddsc3x;
        private double ddsc3y;
        private double ddsc3z;
        private double ddsc5x;
        private double ddsc5y;
        private double ddsc5z;
        private double ddsc7x;
        private double ddsc7y;
        private double ddsc7z;
        private double l2;
        private boolean soft;
        private double selfScale;
        private double permanentEnergy;
        private double inducedEnergy;
        private double dUdL;
        private double d2UdL2;
        private int i;
        private int k;
        private int iSymm;
        private int count;
        private double[] gxk_local;
        private double[] gyk_local;
        private double[] gzk_local;
        private double[] txk_local;
        private double[] tyk_local;
        private double[] tzk_local;
        private double[] lxk_local;
        private double[] lyk_local;
        private double[] lzk_local;
        private double[] ltxk_local;
        private double[] ltyk_local;
        private double[] ltzk_local;
        private double[] masking_local;
        private double[] maskingp_local;
        private double[] maskingd_local;
        private int threadID;
        final /* synthetic */ RealSpaceEnergyRegion this$0;

        RealSpaceEnergyLoop(RealSpaceEnergyRegion realSpaceEnergyRegion) {
            RealSpaceEnergyRegion realSpaceEnergyRegion2 = realSpaceEnergyRegion;
            Objects.requireNonNull(realSpaceEnergyRegion2);
            this.this$0 = realSpaceEnergyRegion2;
            this.dx_local = new double[3];
            this.rot_local = new double[3][3];
            this.torques = new Torque();
        }

        public void finish() {
            this.this$0.sharedInteractions.addAndGet(this.count);
            if (this.this$0.lambdaTerm) {
                this.this$0.shareddEdLambda.addAndGet(this.dUdL * this.this$0.electric);
                this.this$0.sharedd2EdLambda2.addAndGet(this.d2UdL2 * this.this$0.electric);
            }
            int n = this.getThreadIndex();
            this.this$0.realSpaceEnergyTime[n] = this.this$0.realSpaceEnergyTime[n] + System.nanoTime();
        }

        public int getCount() {
            return this.count;
        }

        public void run(int lb, int ub) {
            List symOps = this.this$0.crystal.spaceGroup.symOps;
            int nSymm = symOps.size();
            int nAtoms = this.this$0.atoms.length;
            this.iSymm = 0;
            while (this.iSymm < nSymm) {
                int j;
                double[] gj;
                int index;
                int j2;
                int i;
                double[] trq;
                double[][] g;
                int[] frameIndex;
                SymOp symOp = (SymOp)symOps.get(this.iSymm);
                if (this.this$0.gradient) {
                    Arrays.fill(this.gxk_local, 0.0);
                    Arrays.fill(this.gyk_local, 0.0);
                    Arrays.fill(this.gzk_local, 0.0);
                    Arrays.fill(this.txk_local, 0.0);
                    Arrays.fill(this.tyk_local, 0.0);
                    Arrays.fill(this.tzk_local, 0.0);
                }
                if (this.this$0.lambdaTerm) {
                    Arrays.fill(this.lxk_local, 0.0);
                    Arrays.fill(this.lyk_local, 0.0);
                    Arrays.fill(this.lzk_local, 0.0);
                    Arrays.fill(this.ltxk_local, 0.0);
                    Arrays.fill(this.ltyk_local, 0.0);
                    Arrays.fill(this.ltzk_local, 0.0);
                }
                this.realSpaceChunk(lb, ub);
                if (this.this$0.gradient) {
                    frameIndex = new int[]{-1, -1, -1, -1};
                    g = new double[4][3];
                    trq = new double[3];
                    for (i = 0; i < nAtoms; ++i) {
                        Arrays.fill(frameIndex, -1);
                        for (j2 = 0; j2 < 4; ++j2) {
                            Arrays.fill(g[j2], 0.0);
                        }
                        trq[0] = this.txk_local[i];
                        trq[1] = this.tyk_local[i];
                        trq[2] = this.tzk_local[i];
                        this.torques.torque(i, this.iSymm, trq, frameIndex, g);
                        for (j2 = 0; j2 < 4; ++j2) {
                            index = frameIndex[j2];
                            if (index < 0) continue;
                            gj = g[j2];
                            int n = index;
                            this.gxk_local[n] = this.gxk_local[n] + gj[0];
                            int n2 = index;
                            this.gyk_local[n2] = this.gyk_local[n2] + gj[1];
                            int n3 = index;
                            this.gzk_local[n3] = this.gzk_local[n3] + gj[2];
                        }
                    }
                    if (this.iSymm != 0) {
                        this.this$0.crystal.applyTransSymRot(nAtoms, this.gxk_local, this.gyk_local, this.gzk_local, this.gxk_local, this.gyk_local, this.gzk_local, symOp, this.rot_local);
                    }
                    for (j = 0; j < nAtoms; ++j) {
                        this.this$0.grad.add(this.threadID, j, this.gxk_local[j], this.gyk_local[j], this.gzk_local[j]);
                    }
                }
                if (this.this$0.lambdaTerm) {
                    frameIndex = new int[]{-1, -1, -1, -1};
                    g = new double[4][3];
                    trq = new double[3];
                    for (i = 0; i < nAtoms; ++i) {
                        Arrays.fill(frameIndex, -1);
                        for (j2 = 0; j2 < 4; ++j2) {
                            Arrays.fill(g[j2], 0.0);
                        }
                        trq[0] = this.ltxk_local[i];
                        trq[1] = this.ltyk_local[i];
                        trq[2] = this.ltzk_local[i];
                        this.torques.torque(i, this.iSymm, trq, frameIndex, g);
                        for (j2 = 0; j2 < 4; ++j2) {
                            index = frameIndex[j2];
                            if (index < 0) continue;
                            gj = g[j2];
                            int n = index;
                            this.lxk_local[n] = this.lxk_local[n] + gj[0];
                            int n4 = index;
                            this.lyk_local[n4] = this.lyk_local[n4] + gj[1];
                            int n5 = index;
                            this.lzk_local[n5] = this.lzk_local[n5] + gj[2];
                        }
                    }
                    if (this.iSymm != 0) {
                        this.this$0.crystal.applyTransSymRot(nAtoms, this.lxk_local, this.lyk_local, this.lzk_local, this.lxk_local, this.lyk_local, this.lzk_local, symOp, this.rot_local);
                    }
                    for (j = 0; j < nAtoms; ++j) {
                        this.this$0.lambdaGrad.add(this.threadID, j, this.lxk_local[j], this.lyk_local[j], this.lzk_local[j]);
                    }
                }
                ++this.iSymm;
            }
        }

        public IntegerSchedule schedule() {
            return this.this$0.realSpaceSchedule;
        }

        public void start() {
            this.init();
            int n = this.threadID = this.getThreadIndex();
            this.this$0.realSpaceEnergyTime[n] = this.this$0.realSpaceEnergyTime[n] - System.nanoTime();
            this.permanentEnergy = 0.0;
            this.inducedEnergy = 0.0;
            this.count = 0;
            if (this.this$0.lambdaTerm) {
                this.dUdL = 0.0;
                this.d2UdL2 = 0.0;
            }
            this.torques.init(this.this$0.axisAtom, this.this$0.frame, this.this$0.coordinates);
        }

        private void init() {
            int nAtoms = this.this$0.atoms.length;
            if (this.masking_local == null || this.masking_local.length < nAtoms) {
                this.txk_local = new double[nAtoms];
                this.tyk_local = new double[nAtoms];
                this.tzk_local = new double[nAtoms];
                this.gxk_local = new double[nAtoms];
                this.gyk_local = new double[nAtoms];
                this.gzk_local = new double[nAtoms];
                this.lxk_local = new double[nAtoms];
                this.lyk_local = new double[nAtoms];
                this.lzk_local = new double[nAtoms];
                this.ltxk_local = new double[nAtoms];
                this.ltyk_local = new double[nAtoms];
                this.ltzk_local = new double[nAtoms];
                this.masking_local = new double[nAtoms];
                this.maskingp_local = new double[nAtoms];
                this.maskingd_local = new double[nAtoms];
                Arrays.fill(this.masking_local, 1.0);
                Arrays.fill(this.maskingp_local, 1.0);
                Arrays.fill(this.maskingd_local, 1.0);
            }
        }

        private void realSpaceChunk(int lb, int ub) {
            double[] x = this.this$0.coordinates[0][0];
            double[] y = this.this$0.coordinates[0][1];
            double[] z = this.this$0.coordinates[0][2];
            double[][] mpole = this.this$0.globalMultipole[0];
            double[] zeropole = new double[10];
            double[][] ind = this.this$0.inducedDipole[0];
            double[][] indp = this.this$0.inducedDipoleCR[0];
            int[][] lists = this.this$0.realSpaceLists[this.iSymm];
            double[] neighborX = this.this$0.coordinates[this.iSymm][0];
            double[] neighborY = this.this$0.coordinates[this.iSymm][1];
            double[] neighborZ = this.this$0.coordinates[this.iSymm][2];
            double[][] neighborMultipole = this.this$0.globalMultipole[this.iSymm];
            double[][] neighborInducedDipole = this.this$0.inducedDipole[this.iSymm];
            double[][] neighborInducedDipolep = this.this$0.inducedDipoleCR[this.iSymm];
            this.i = lb;
            while (this.i <= ub) {
                if (this.this$0.use[this.i]) {
                    int moleculei = this.this$0.molecule[this.i];
                    if (this.iSymm == 0) {
                        this.this$0.applyMask(this.i, null, this.masking_local, this.maskingp_local, this.maskingd_local);
                    }
                    double xi = x[this.i];
                    double yi = y[this.i];
                    double zi = z[this.i];
                    double[] globalMultipolei = mpole[this.i];
                    double[] inducedDipolei = ind[this.i];
                    double[] inducedDipolepi = indp[this.i];
                    this.setMultipoleI(globalMultipolei);
                    this.setInducedI(inducedDipolei);
                    this.setInducedpI(inducedDipolepi);
                    boolean softi = this.this$0.isSoft[this.i];
                    double pdi = this.this$0.ipdamp[this.i];
                    double pti = this.this$0.thole[this.i];
                    int[] list = lists[this.i];
                    int npair = this.this$0.realSpaceCounts[this.iSymm][this.i];
                    for (int j = 0; j < npair; ++j) {
                        double tautdUdL;
                        double titrdUdL;
                        double ei;
                        double temp7;
                        double temp5;
                        double temp3;
                        double expdamp;
                        boolean sameMolecule;
                        this.k = list[j];
                        if (!this.this$0.use[this.k]) continue;
                        boolean bl = sameMolecule = moleculei == this.this$0.molecule[this.k];
                        if (this.this$0.lambdaMode == LambdaMode.VAPOR && (this.this$0.intermolecularSoftcore && !sameMolecule || this.this$0.intramolecularSoftcore && sameMolecule)) continue;
                        this.selfScale = 1.0;
                        if (this.i == this.k) {
                            this.selfScale = 0.5;
                        }
                        double beta = 0.0;
                        this.l2 = 1.0;
                        boolean bl2 = this.soft = softi || this.this$0.isSoft[this.k];
                        if (this.soft && this.this$0.doPermanentRealSpace) {
                            beta = this.this$0.lAlpha;
                            this.l2 = this.this$0.permanentScale;
                        } else if (this.this$0.nnTerm) {
                            this.l2 = this.this$0.permanentScale;
                        }
                        double xk = neighborX[this.k];
                        double yk = neighborY[this.k];
                        double zk = neighborZ[this.k];
                        this.dx_local[0] = xk - xi;
                        this.dx_local[1] = yk - yi;
                        this.dx_local[2] = zk - zi;
                        double r2 = this.this$0.crystal.image(this.dx_local);
                        this.xr = this.dx_local[0];
                        this.yr = this.dx_local[1];
                        this.zr = this.dx_local[2];
                        double[] globalMultipolek = neighborMultipole[this.k];
                        double[] inducedDipolek = neighborInducedDipole[this.k];
                        double[] inducedDipolepk = neighborInducedDipolep[this.k];
                        this.setMultipoleK(globalMultipolek);
                        this.setInducedK(inducedDipolek);
                        this.setInducedpK(inducedDipolepk);
                        double pdk = this.this$0.ipdamp[this.k];
                        double ptk = this.this$0.thole[this.k];
                        this.scale = this.masking_local[this.k];
                        this.scalep = this.maskingp_local[this.k];
                        this.scaled = this.maskingd_local[this.k];
                        this.scale3 = 1.0;
                        this.scale5 = 1.0;
                        this.scale7 = 1.0;
                        double r = FastMath.sqrt((double)(r2 + beta));
                        double ralpha = this.this$0.aewald * r;
                        double exp2a = FastMath.exp((double)(-ralpha * ralpha));
                        this.rr1 = 1.0 / r;
                        double rr2 = this.rr1 * this.rr1;
                        this.bn0 = Erf.erfc((double)ralpha) * this.rr1;
                        this.bn1 = (this.bn0 + this.this$0.an0 * exp2a) * rr2;
                        this.bn2 = (3.0 * this.bn1 + this.this$0.an1 * exp2a) * rr2;
                        this.bn3 = (5.0 * this.bn2 + this.this$0.an2 * exp2a) * rr2;
                        this.bn4 = (7.0 * this.bn3 + this.this$0.an3 * exp2a) * rr2;
                        this.bn5 = (9.0 * this.bn4 + this.this$0.an4 * exp2a) * rr2;
                        this.bn6 = (11.0 * this.bn5 + this.this$0.an5 * exp2a) * rr2;
                        this.rr3 = this.rr1 * rr2;
                        this.rr5 = 3.0 * this.rr3 * rr2;
                        this.rr7 = 5.0 * this.rr5 * rr2;
                        this.rr9 = 7.0 * this.rr7 * rr2;
                        this.rr11 = 9.0 * this.rr9 * rr2;
                        this.rr13 = 11.0 * this.rr11 * rr2;
                        this.ddsc3x = 0.0;
                        this.ddsc3y = 0.0;
                        this.ddsc3z = 0.0;
                        this.ddsc5x = 0.0;
                        this.ddsc5y = 0.0;
                        this.ddsc5z = 0.0;
                        this.ddsc7x = 0.0;
                        this.ddsc7y = 0.0;
                        this.ddsc7z = 0.0;
                        double damp = pdi * pdk;
                        double thole = FastMath.min((double)pti, (double)ptk);
                        double rdamp = r * damp;
                        damp = -thole * rdamp * rdamp * rdamp;
                        if (damp > -50.0) {
                            expdamp = FastMath.exp((double)damp);
                            this.scale3 = 1.0 - expdamp;
                            this.scale5 = 1.0 - expdamp * (1.0 - damp);
                            this.scale7 = 1.0 - expdamp * (1.0 - damp + 0.6 * damp * damp);
                            temp3 = -3.0 * damp * expdamp * rr2;
                            temp5 = -damp;
                            temp7 = -0.2 - 0.6 * damp;
                            this.ddsc3x = temp3 * this.xr;
                            this.ddsc3y = temp3 * this.yr;
                            this.ddsc3z = temp3 * this.zr;
                            this.ddsc5x = temp5 * this.ddsc3x;
                            this.ddsc5y = temp5 * this.ddsc3y;
                            this.ddsc5z = temp5 * this.ddsc3z;
                            this.ddsc7x = temp7 * this.ddsc5x;
                            this.ddsc7y = temp7 * this.ddsc5y;
                            this.ddsc7z = temp7 * this.ddsc5z;
                        }
                        if (this.this$0.doPermanentRealSpace) {
                            ei = this.permanentPair(this.this$0.gradient, this.this$0.lambdaTerm);
                            if (Double.isNaN(ei) || Double.isInfinite(ei)) {
                                String message = String.format(" %s\n %s\n %s\n The permanent multipole energy between atoms %d and %d (%d) is %16.8f at %16.8f A.", this.this$0.crystal.getUnitCell().toString(), this.this$0.atoms[this.i].toString(), this.this$0.atoms[this.k].toString(), this.i, this.k, this.iSymm, ei, r);
                                throw new EnergyException(message);
                            }
                            if (ei != 0.0) {
                                this.permanentEnergy += ei;
                                ++this.count;
                            }
                            if (this.this$0.esvTerm) {
                                double tautdUdL2;
                                double titrdUdL2;
                                if (this.this$0.extendedSystem.isTitrating(this.i)) {
                                    titrdUdL2 = 0.0;
                                    tautdUdL2 = 0.0;
                                    double[][] titrMpole = this.this$0.titrationMultipole[0];
                                    double[] titrMultipolei = titrMpole[this.i];
                                    this.setMultipoleI(titrMultipolei);
                                    titrdUdL2 = this.this$0.electric * this.permanentPair(false, false);
                                    if (this.this$0.extendedSystem.isTautomerizing(this.i)) {
                                        double[][] tautMpole = this.this$0.tautomerMultipole[0];
                                        double[] tautMultipolei = tautMpole[this.i];
                                        this.setMultipoleI(tautMultipolei);
                                        tautdUdL2 = this.this$0.electric * this.permanentPair(false, false);
                                    }
                                    this.this$0.extendedSystem.addPermElecDeriv(this.i, titrdUdL2, tautdUdL2);
                                    this.setMultipoleI(globalMultipolei);
                                }
                                if (this.this$0.extendedSystem.isTitrating(this.k)) {
                                    titrdUdL2 = 0.0;
                                    tautdUdL2 = 0.0;
                                    double[][] titrNeighborMpole = this.this$0.titrationMultipole[this.iSymm];
                                    double[] titrMultipolek = titrNeighborMpole[this.k];
                                    this.setMultipoleK(titrMultipolek);
                                    titrdUdL2 = this.this$0.electric * this.permanentPair(false, false);
                                    if (this.this$0.extendedSystem.isTautomerizing(this.k)) {
                                        double[][] tautNeighborMpole = this.this$0.tautomerMultipole[this.iSymm];
                                        double[] tautMultipolek = tautNeighborMpole[this.k];
                                        this.setMultipoleK(tautMultipolek);
                                        tautdUdL2 = this.this$0.electric * this.permanentPair(false, false);
                                    }
                                    this.this$0.extendedSystem.addPermElecDeriv(this.k, titrdUdL2, tautdUdL2);
                                    this.setMultipoleK(globalMultipolek);
                                }
                            }
                        }
                        if (this.this$0.polarization == Polarization.NONE || !this.this$0.doPolarization) continue;
                        if (this.soft && this.this$0.doPermanentRealSpace) {
                            this.scale3 = 1.0;
                            this.scale5 = 1.0;
                            this.scale7 = 1.0;
                            r = FastMath.sqrt((double)r2);
                            ralpha = this.this$0.aewald * r;
                            exp2a = FastMath.exp((double)(-ralpha * ralpha));
                            this.rr1 = 1.0 / r;
                            rr2 = this.rr1 * this.rr1;
                            this.bn0 = Erf.erfc((double)ralpha) * this.rr1;
                            this.bn1 = (this.bn0 + this.this$0.an0 * exp2a) * rr2;
                            this.bn2 = (3.0 * this.bn1 + this.this$0.an1 * exp2a) * rr2;
                            this.bn3 = (5.0 * this.bn2 + this.this$0.an2 * exp2a) * rr2;
                            this.bn4 = (7.0 * this.bn3 + this.this$0.an3 * exp2a) * rr2;
                            this.bn5 = (9.0 * this.bn4 + this.this$0.an4 * exp2a) * rr2;
                            this.bn6 = (11.0 * this.bn5 + this.this$0.an5 * exp2a) * rr2;
                            this.rr3 = this.rr1 * rr2;
                            this.rr5 = 3.0 * this.rr3 * rr2;
                            this.rr7 = 5.0 * this.rr5 * rr2;
                            this.rr9 = 7.0 * this.rr7 * rr2;
                            this.rr11 = 9.0 * this.rr9 * rr2;
                            this.ddsc3x = 0.0;
                            this.ddsc3y = 0.0;
                            this.ddsc3z = 0.0;
                            this.ddsc5x = 0.0;
                            this.ddsc5y = 0.0;
                            this.ddsc5z = 0.0;
                            this.ddsc7x = 0.0;
                            this.ddsc7y = 0.0;
                            this.ddsc7z = 0.0;
                            damp = pdi * pdk;
                            thole = FastMath.min((double)pti, (double)ptk);
                            damp = -thole * (rdamp = r * damp) * rdamp * rdamp;
                            if (damp > -50.0) {
                                expdamp = FastMath.exp((double)damp);
                                this.scale3 = 1.0 - expdamp;
                                this.scale5 = 1.0 - expdamp * (1.0 - damp);
                                this.scale7 = 1.0 - expdamp * (1.0 - damp + 0.6 * damp * damp);
                                temp3 = -3.0 * damp * expdamp * rr2;
                                temp5 = -damp;
                                temp7 = -0.2 - 0.6 * damp;
                                this.ddsc3x = temp3 * this.xr;
                                this.ddsc3y = temp3 * this.yr;
                                this.ddsc3z = temp3 * this.zr;
                                this.ddsc5x = temp5 * this.ddsc3x;
                                this.ddsc5y = temp5 * this.ddsc3y;
                                this.ddsc5z = temp5 * this.ddsc3z;
                                this.ddsc7x = temp7 * this.ddsc5x;
                                this.ddsc7y = temp7 * this.ddsc5y;
                                this.ddsc7z = temp7 * this.ddsc5z;
                            }
                        }
                        if (Double.isNaN(ei = this.polarizationPair(this.this$0.gradient, this.this$0.lambdaTerm)) || Double.isInfinite(ei)) {
                            String message = String.format(" %s\n %s\n with induced dipole: %8.3f %8.3f %8.3f\n %s\n with induced dipole: %8.3f %8.3f %8.3f\n The polarization energy due to atoms %d and %d (%d) is %10.6f at %10.6f A.", this.this$0.crystal.getUnitCell(), this.this$0.atoms[this.i], this.uix, this.uiy, this.uiz, this.this$0.atoms[this.k], this.ukx, this.uky, this.ukz, this.i + 1, this.k + 1, this.iSymm, ei, r);
                            throw new EnergyException(message);
                        }
                        this.inducedEnergy += ei;
                        if (!this.this$0.esvTerm) continue;
                        int esvI = this.this$0.extendedSystem.getTitrationESVIndex(this.i);
                        int esvK = this.this$0.extendedSystem.getTitrationESVIndex(this.k);
                        if (this.this$0.extendedSystem.isTitrating(this.i)) {
                            titrdUdL = 0.0;
                            tautdUdL = 0.0;
                            double[][] titrMpole = this.this$0.titrationMultipole[0];
                            double[] titrMultipolei = titrMpole[this.i];
                            this.setMultipoleI(titrMultipolei);
                            if (this.this$0.extendedSystem.isTitrating(this.k) && esvI == esvK) {
                                double[][] titrNeighborMpole = this.this$0.titrationMultipole[this.iSymm];
                                double[] titrMultipolek = titrNeighborMpole[this.k];
                                this.setMultipoleK(titrMultipolek);
                            } else {
                                this.setMultipoleK(zeropole);
                            }
                            titrdUdL = this.polarizationPair(false, false);
                            this.setInducedI(inducedDipolepi);
                            this.setInducedK(inducedDipolepk);
                            this.scaled = this.maskingp_local[this.k];
                            this.scalep = this.maskingd_local[this.k];
                            titrdUdL += this.polarizationPair(false, false);
                            this.setInducedI(inducedDipolei);
                            this.setInducedK(inducedDipolek);
                            this.scalep = this.maskingp_local[this.k];
                            this.scaled = this.maskingd_local[this.k];
                            if (this.this$0.extendedSystem.isTautomerizing(this.i)) {
                                double[][] tautMpole = this.this$0.tautomerMultipole[0];
                                double[] tautMultipolei = tautMpole[this.i];
                                this.setMultipoleI(tautMultipolei);
                                if (this.this$0.extendedSystem.isTautomerizing(this.k) && esvI == esvK) {
                                    double[][] tautNeighborMpole = this.this$0.tautomerMultipole[this.iSymm];
                                    double[] tautMultipolek = tautNeighborMpole[this.k];
                                    this.setMultipoleK(tautMultipolek);
                                } else {
                                    this.setMultipoleK(zeropole);
                                }
                                tautdUdL = this.polarizationPair(false, false);
                                this.setInducedI(inducedDipolepi);
                                this.setInducedK(inducedDipolepk);
                                this.scaled = this.maskingp_local[this.k];
                                this.scalep = this.maskingd_local[this.k];
                                tautdUdL += this.polarizationPair(false, false);
                                this.setInducedI(inducedDipolei);
                                this.setInducedK(inducedDipolek);
                                this.scalep = this.maskingp_local[this.k];
                                this.scaled = this.maskingd_local[this.k];
                            }
                            this.this$0.extendedSystem.addIndElecDeriv(this.i, titrdUdL * this.this$0.electric, tautdUdL * this.this$0.electric);
                            this.setMultipoleI(globalMultipolei);
                            this.setMultipoleK(globalMultipolek);
                        }
                        if (!this.this$0.extendedSystem.isTitrating(this.k) || esvI == esvK) continue;
                        titrdUdL = 0.0;
                        tautdUdL = 0.0;
                        double[][] titrNeighborMpole = this.this$0.titrationMultipole[this.iSymm];
                        double[] titrMultipolek = titrNeighborMpole[this.k];
                        this.setMultipoleK(titrMultipolek);
                        this.setMultipoleI(zeropole);
                        titrdUdL = this.polarizationPair(false, false);
                        this.setInducedI(inducedDipolepi);
                        this.setInducedK(inducedDipolepk);
                        this.scaled = this.maskingp_local[this.k];
                        this.scalep = this.maskingd_local[this.k];
                        titrdUdL += this.polarizationPair(false, false);
                        this.setInducedI(inducedDipolei);
                        this.setInducedK(inducedDipolek);
                        this.scalep = this.maskingp_local[this.k];
                        this.scaled = this.maskingd_local[this.k];
                        if (this.this$0.extendedSystem.isTautomerizing(this.k)) {
                            double[][] tautNeighborMpole = this.this$0.tautomerMultipole[this.iSymm];
                            double[] tautMultipolek = tautNeighborMpole[this.k];
                            this.setMultipoleK(tautMultipolek);
                            tautdUdL = this.polarizationPair(false, false);
                            this.setInducedI(inducedDipolepi);
                            this.setInducedK(inducedDipolepk);
                            this.scaled = this.maskingp_local[this.k];
                            this.scalep = this.maskingd_local[this.k];
                            tautdUdL += this.polarizationPair(false, false);
                            this.setInducedI(inducedDipolei);
                            this.setInducedK(inducedDipolek);
                            this.scalep = this.maskingp_local[this.k];
                            this.scaled = this.maskingd_local[this.k];
                        }
                        this.this$0.extendedSystem.addIndElecDeriv(this.k, titrdUdL * this.this$0.electric, tautdUdL * this.this$0.electric);
                        this.setMultipoleI(globalMultipolei);
                        this.setMultipoleK(globalMultipolek);
                    }
                    if (this.iSymm == 0) {
                        this.this$0.removeMask(this.i, null, this.masking_local, this.maskingp_local, this.maskingd_local);
                    }
                }
                ++this.i;
            }
        }

        private double permanentPair(boolean gradientLocal, boolean lambdaTermLocal) {
            double dixdkx = this.diy * this.dkz - this.diz * this.dky;
            double dixdky = this.diz * this.dkx - this.dix * this.dkz;
            double dixdkz = this.dix * this.dky - this.diy * this.dkx;
            double dixrx = this.diy * this.zr - this.diz * this.yr;
            double dixry = this.diz * this.xr - this.dix * this.zr;
            double dixrz = this.dix * this.yr - this.diy * this.xr;
            double dkxrx = this.dky * this.zr - this.dkz * this.yr;
            double dkxry = this.dkz * this.xr - this.dkx * this.zr;
            double dkxrz = this.dkx * this.yr - this.dky * this.xr;
            double qirx = this.qixx * this.xr + this.qixy * this.yr + this.qixz * this.zr;
            double qiry = this.qixy * this.xr + this.qiyy * this.yr + this.qiyz * this.zr;
            double qirz = this.qixz * this.xr + this.qiyz * this.yr + this.qizz * this.zr;
            double qkrx = this.qkxx * this.xr + this.qkxy * this.yr + this.qkxz * this.zr;
            double qkry = this.qkxy * this.xr + this.qkyy * this.yr + this.qkyz * this.zr;
            double qkrz = this.qkxz * this.xr + this.qkyz * this.yr + this.qkzz * this.zr;
            double qiqkrx = this.qixx * qkrx + this.qixy * qkry + this.qixz * qkrz;
            double qiqkry = this.qixy * qkrx + this.qiyy * qkry + this.qiyz * qkrz;
            double qiqkrz = this.qixz * qkrx + this.qiyz * qkry + this.qizz * qkrz;
            double qkqirx = this.qkxx * qirx + this.qkxy * qiry + this.qkxz * qirz;
            double qkqiry = this.qkxy * qirx + this.qkyy * qiry + this.qkyz * qirz;
            double qkqirz = this.qkxz * qirx + this.qkyz * qiry + this.qkzz * qirz;
            double qixqkx = this.qixy * this.qkxz + this.qiyy * this.qkyz + this.qiyz * this.qkzz - this.qixz * this.qkxy - this.qiyz * this.qkyy - this.qizz * this.qkyz;
            double qixqky = this.qixz * this.qkxx + this.qiyz * this.qkxy + this.qizz * this.qkxz - this.qixx * this.qkxz - this.qixy * this.qkyz - this.qixz * this.qkzz;
            double qixqkz = this.qixx * this.qkxy + this.qixy * this.qkyy + this.qixz * this.qkyz - this.qixy * this.qkxx - this.qiyy * this.qkxy - this.qiyz * this.qkxz;
            double rxqirx = this.yr * qirz - this.zr * qiry;
            double rxqiry = this.zr * qirx - this.xr * qirz;
            double rxqirz = this.xr * qiry - this.yr * qirx;
            double rxqkrx = this.yr * qkrz - this.zr * qkry;
            double rxqkry = this.zr * qkrx - this.xr * qkrz;
            double rxqkrz = this.xr * qkry - this.yr * qkrx;
            double rxqikrx = this.yr * qiqkrz - this.zr * qiqkry;
            double rxqikry = this.zr * qiqkrx - this.xr * qiqkrz;
            double rxqikrz = this.xr * qiqkry - this.yr * qiqkrx;
            double rxqkirx = this.yr * qkqirz - this.zr * qkqiry;
            double rxqkiry = this.zr * qkqirx - this.xr * qkqirz;
            double rxqkirz = this.xr * qkqiry - this.yr * qkqirx;
            double qkrxqirx = qkry * qirz - qkrz * qiry;
            double qkrxqiry = qkrz * qirx - qkrx * qirz;
            double qkrxqirz = qkrx * qiry - qkry * qirx;
            double qidkx = this.qixx * this.dkx + this.qixy * this.dky + this.qixz * this.dkz;
            double qidky = this.qixy * this.dkx + this.qiyy * this.dky + this.qiyz * this.dkz;
            double qidkz = this.qixz * this.dkx + this.qiyz * this.dky + this.qizz * this.dkz;
            double qkdix = this.qkxx * this.dix + this.qkxy * this.diy + this.qkxz * this.diz;
            double qkdiy = this.qkxy * this.dix + this.qkyy * this.diy + this.qkyz * this.diz;
            double qkdiz = this.qkxz * this.dix + this.qkyz * this.diy + this.qkzz * this.diz;
            double dixqkrx = this.diy * qkrz - this.diz * qkry;
            double dixqkry = this.diz * qkrx - this.dix * qkrz;
            double dixqkrz = this.dix * qkry - this.diy * qkrx;
            double dkxqirx = this.dky * qirz - this.dkz * qiry;
            double dkxqiry = this.dkz * qirx - this.dkx * qirz;
            double dkxqirz = this.dkx * qiry - this.dky * qirx;
            double rxqidkx = this.yr * qidkz - this.zr * qidky;
            double rxqidky = this.zr * qidkx - this.xr * qidkz;
            double rxqidkz = this.xr * qidky - this.yr * qidkx;
            double rxqkdix = this.yr * qkdiz - this.zr * qkdiy;
            double rxqkdiy = this.zr * qkdix - this.xr * qkdiz;
            double rxqkdiz = this.xr * qkdiy - this.yr * qkdix;
            double sc2 = this.dix * this.dkx + this.diy * this.dky + this.diz * this.dkz;
            double sc3 = this.dix * this.xr + this.diy * this.yr + this.diz * this.zr;
            double sc4 = this.dkx * this.xr + this.dky * this.yr + this.dkz * this.zr;
            double sc5 = qirx * this.xr + qiry * this.yr + qirz * this.zr;
            double sc6 = qkrx * this.xr + qkry * this.yr + qkrz * this.zr;
            double sc7 = qirx * this.dkx + qiry * this.dky + qirz * this.dkz;
            double sc8 = qkrx * this.dix + qkry * this.diy + qkrz * this.diz;
            double sc9 = qirx * qkrx + qiry * qkry + qirz * qkrz;
            double sc10 = 2.0 * (this.qixy * this.qkxy + this.qixz * this.qkxz + this.qiyz * this.qkyz) + this.qixx * this.qkxx + this.qiyy * this.qkyy + this.qizz * this.qkzz;
            double gl0 = this.ci * this.ck;
            double gl1 = this.ck * sc3 - this.ci * sc4;
            double gl2 = this.ci * sc6 + this.ck * sc5 - sc3 * sc4;
            double gl3 = sc3 * sc6 - sc4 * sc5;
            double gl4 = sc5 * sc6;
            double gl5 = -4.0 * sc9;
            double gl6 = sc2;
            double gl7 = 2.0 * (sc7 - sc8);
            double gl8 = 2.0 * sc10;
            double scale1 = 1.0 - this.scale;
            double ereal = gl0 * this.bn0 + (gl1 + gl6) * this.bn1 + (gl2 + gl7 + gl8) * this.bn2 + (gl3 + gl5) * this.bn3 + gl4 * this.bn4;
            double efix = scale1 * (gl0 * this.rr1 + (gl1 + gl6) * this.rr3 + (gl2 + gl7 + gl8) * this.rr5 + (gl3 + gl5) * this.rr7 + gl4 * this.rr9);
            double e = this.selfScale * this.l2 * (ereal - efix);
            if (gradientLocal) {
                double gf1 = this.bn1 * gl0 + this.bn2 * (gl1 + gl6) + this.bn3 * (gl2 + gl7 + gl8) + this.bn4 * (gl3 + gl5) + this.bn5 * gl4;
                double gf2 = -this.ck * this.bn1 + sc4 * this.bn2 - sc6 * this.bn3;
                double gf3 = this.ci * this.bn1 + sc3 * this.bn2 + sc5 * this.bn3;
                double gf4 = 2.0 * this.bn2;
                double gf5 = 2.0 * (-this.ck * this.bn2 + sc4 * this.bn3 - sc6 * this.bn4);
                double gf6 = 2.0 * (-this.ci * this.bn2 - sc3 * this.bn3 - sc5 * this.bn4);
                double gf7 = 4.0 * this.bn3;
                double ftm2x = gf1 * this.xr + gf2 * this.dix + gf3 * this.dkx + gf4 * (qkdix - qidkx) + gf5 * qirx + gf6 * qkrx + gf7 * (qiqkrx + qkqirx);
                double ftm2y = gf1 * this.yr + gf2 * this.diy + gf3 * this.dky + gf4 * (qkdiy - qidky) + gf5 * qiry + gf6 * qkry + gf7 * (qiqkry + qkqiry);
                double ftm2z = gf1 * this.zr + gf2 * this.diz + gf3 * this.dkz + gf4 * (qkdiz - qidkz) + gf5 * qirz + gf6 * qkrz + gf7 * (qiqkrz + qkqirz);
                double ttm2x = -this.bn1 * dixdkx + gf2 * dixrx + gf4 * (dixqkrx + dkxqirx + rxqidkx - 2.0 * qixqkx) - gf5 * rxqirx - gf7 * (rxqikrx + qkrxqirx);
                double ttm2y = -this.bn1 * dixdky + gf2 * dixry + gf4 * (dixqkry + dkxqiry + rxqidky - 2.0 * qixqky) - gf5 * rxqiry - gf7 * (rxqikry + qkrxqiry);
                double ttm2z = -this.bn1 * dixdkz + gf2 * dixrz + gf4 * (dixqkrz + dkxqirz + rxqidkz - 2.0 * qixqkz) - gf5 * rxqirz - gf7 * (rxqikrz + qkrxqirz);
                double ttm3x = this.bn1 * dixdkx + gf3 * dkxrx - gf4 * (dixqkrx + dkxqirx + rxqkdix - 2.0 * qixqkx) - gf6 * rxqkrx - gf7 * (rxqkirx - qkrxqirx);
                double ttm3y = this.bn1 * dixdky + gf3 * dkxry - gf4 * (dixqkry + dkxqiry + rxqkdiy - 2.0 * qixqky) - gf6 * rxqkry - gf7 * (rxqkiry - qkrxqiry);
                double ttm3z = this.bn1 * dixdkz + gf3 * dkxrz - gf4 * (dixqkrz + dkxqirz + rxqkdiz - 2.0 * qixqkz) - gf6 * rxqkrz - gf7 * (rxqkirz - qkrxqirz);
                if (scale1 != 0.0) {
                    double gfr1 = this.rr3 * gl0 + this.rr5 * (gl1 + gl6) + this.rr7 * (gl2 + gl7 + gl8) + this.rr9 * (gl3 + gl5) + this.rr11 * gl4;
                    double gfr2 = -this.ck * this.rr3 + sc4 * this.rr5 - sc6 * this.rr7;
                    double gfr3 = this.ci * this.rr3 + sc3 * this.rr5 + sc5 * this.rr7;
                    double gfr4 = 2.0 * this.rr5;
                    double gfr5 = 2.0 * (-this.ck * this.rr5 + sc4 * this.rr7 - sc6 * this.rr9);
                    double gfr6 = 2.0 * (-this.ci * this.rr5 - sc3 * this.rr7 - sc5 * this.rr9);
                    double gfr7 = 4.0 * this.rr7;
                    double ftm2rx = gfr1 * this.xr + gfr2 * this.dix + gfr3 * this.dkx + gfr4 * (qkdix - qidkx) + gfr5 * qirx + gfr6 * qkrx + gfr7 * (qiqkrx + qkqirx);
                    double ftm2ry = gfr1 * this.yr + gfr2 * this.diy + gfr3 * this.dky + gfr4 * (qkdiy - qidky) + gfr5 * qiry + gfr6 * qkry + gfr7 * (qiqkry + qkqiry);
                    double ftm2rz = gfr1 * this.zr + gfr2 * this.diz + gfr3 * this.dkz + gfr4 * (qkdiz - qidkz) + gfr5 * qirz + gfr6 * qkrz + gfr7 * (qiqkrz + qkqirz);
                    double ttm2rx = -this.rr3 * dixdkx + gfr2 * dixrx + gfr4 * (dixqkrx + dkxqirx + rxqidkx - 2.0 * qixqkx) - gfr5 * rxqirx - gfr7 * (rxqikrx + qkrxqirx);
                    double ttm2ry = -this.rr3 * dixdky + gfr2 * dixry + gfr4 * (dixqkry + dkxqiry + rxqidky - 2.0 * qixqky) - gfr5 * rxqiry - gfr7 * (rxqikry + qkrxqiry);
                    double ttm2rz = -this.rr3 * dixdkz + gfr2 * dixrz + gfr4 * (dixqkrz + dkxqirz + rxqidkz - 2.0 * qixqkz) - gfr5 * rxqirz - gfr7 * (rxqikrz + qkrxqirz);
                    double ttm3rx = this.rr3 * dixdkx + gfr3 * dkxrx - gfr4 * (dixqkrx + dkxqirx + rxqkdix - 2.0 * qixqkx) - gfr6 * rxqkrx - gfr7 * (rxqkirx - qkrxqirx);
                    double ttm3ry = this.rr3 * dixdky + gfr3 * dkxry - gfr4 * (dixqkry + dkxqiry + rxqkdiy - 2.0 * qixqky) - gfr6 * rxqkry - gfr7 * (rxqkiry - qkrxqiry);
                    double ttm3rz = this.rr3 * dixdkz + gfr3 * dkxrz - gfr4 * (dixqkrz + dkxqirz + rxqkdiz - 2.0 * qixqkz) - gfr6 * rxqkrz - gfr7 * (rxqkirz - qkrxqirz);
                    ftm2x -= scale1 * ftm2rx;
                    ftm2y -= scale1 * ftm2ry;
                    ftm2z -= scale1 * ftm2rz;
                    ttm2x -= scale1 * ttm2rx;
                    ttm2y -= scale1 * ttm2ry;
                    ttm2z -= scale1 * ttm2rz;
                    ttm3x -= scale1 * ttm3rx;
                    ttm3y -= scale1 * ttm3ry;
                    ttm3z -= scale1 * ttm3rz;
                }
                double prefactor = this.this$0.electric * this.selfScale * this.l2;
                this.this$0.grad.add(this.threadID, this.i, prefactor * ftm2x, prefactor * ftm2y, prefactor * ftm2z);
                this.this$0.torque.add(this.threadID, this.i, prefactor * ttm2x, prefactor * ttm2y, prefactor * ttm2z);
                int n = this.k;
                this.gxk_local[n] = this.gxk_local[n] - prefactor * ftm2x;
                int n2 = this.k;
                this.gyk_local[n2] = this.gyk_local[n2] - prefactor * ftm2y;
                int n3 = this.k;
                this.gzk_local[n3] = this.gzk_local[n3] - prefactor * ftm2z;
                int n4 = this.k;
                this.txk_local[n4] = this.txk_local[n4] + prefactor * ttm3x;
                int n5 = this.k;
                this.tyk_local[n5] = this.tyk_local[n5] + prefactor * ttm3y;
                int n6 = this.k;
                this.tzk_local[n6] = this.tzk_local[n6] + prefactor * ttm3z;
                if (this.this$0.lambdaTerm && this.soft) {
                    prefactor = this.this$0.electric * this.selfScale * this.this$0.dEdLSign * this.this$0.dlPowPerm;
                    this.this$0.lambdaGrad.add(this.threadID, this.i, prefactor * ftm2x, prefactor * ftm2y, prefactor * ftm2z);
                    this.this$0.lambdaTorque.add(this.threadID, this.i, prefactor * ttm2x, prefactor * ttm2y, prefactor * ttm2z);
                    int n7 = this.k;
                    this.lxk_local[n7] = this.lxk_local[n7] - prefactor * ftm2x;
                    int n8 = this.k;
                    this.lyk_local[n8] = this.lyk_local[n8] - prefactor * ftm2y;
                    int n9 = this.k;
                    this.lzk_local[n9] = this.lzk_local[n9] - prefactor * ftm2z;
                    int n10 = this.k;
                    this.ltxk_local[n10] = this.ltxk_local[n10] + prefactor * ttm3x;
                    int n11 = this.k;
                    this.ltyk_local[n11] = this.ltyk_local[n11] + prefactor * ttm3y;
                    int n12 = this.k;
                    this.ltzk_local[n12] = this.ltzk_local[n12] + prefactor * ttm3z;
                }
            }
            if (lambdaTermLocal && this.soft) {
                double dRealdL = gl0 * this.bn1 + (gl1 + gl6) * this.bn2 + (gl2 + gl7 + gl8) * this.bn3 + (gl3 + gl5) * this.bn4 + gl4 * this.bn5;
                double d2RealdL2 = gl0 * this.bn2 + (gl1 + gl6) * this.bn3 + (gl2 + gl7 + gl8) * this.bn4 + (gl3 + gl5) * this.bn5 + gl4 * this.bn6;
                this.dUdL += this.selfScale * (this.this$0.dEdLSign * this.this$0.dlPowPerm * ereal + this.l2 * this.this$0.dlAlpha * dRealdL);
                this.d2UdL2 += this.selfScale * (this.this$0.dEdLSign * (this.this$0.d2lPowPerm * ereal + this.this$0.dlPowPerm * this.this$0.dlAlpha * dRealdL + this.this$0.dlPowPerm * this.this$0.dlAlpha * dRealdL) + this.l2 * this.this$0.d2lAlpha * dRealdL + this.l2 * this.this$0.dlAlpha * this.this$0.dlAlpha * d2RealdL2);
                double dFixdL = gl0 * this.rr3 + (gl1 + gl6) * this.rr5 + (gl2 + gl7 + gl8) * this.rr7 + (gl3 + gl5) * this.rr9 + gl4 * this.rr11;
                double d2FixdL2 = gl0 * this.rr5 + (gl1 + gl6) * this.rr7 + (gl2 + gl7 + gl8) * this.rr9 + (gl3 + gl5) * this.rr11 + gl4 * this.rr13;
                this.dUdL -= this.selfScale * (this.this$0.dEdLSign * this.this$0.dlPowPerm * efix + this.l2 * this.this$0.dlAlpha * (dFixdL *= scale1));
                this.d2UdL2 -= this.selfScale * (this.this$0.dEdLSign * (this.this$0.d2lPowPerm * efix + this.this$0.dlPowPerm * this.this$0.dlAlpha * dFixdL + this.this$0.dlPowPerm * this.this$0.dlAlpha * dFixdL) + this.l2 * this.this$0.d2lAlpha * dFixdL + this.l2 * this.this$0.dlAlpha * this.this$0.dlAlpha * (d2FixdL2 *= scale1));
                double gf1 = this.bn2 * gl0 + this.bn3 * (gl1 + gl6) + this.bn4 * (gl2 + gl7 + gl8) + this.bn5 * (gl3 + gl5) + this.bn6 * gl4;
                double gf2 = -this.ck * this.bn2 + sc4 * this.bn3 - sc6 * this.bn4;
                double gf3 = this.ci * this.bn2 + sc3 * this.bn3 + sc5 * this.bn4;
                double gf4 = 2.0 * this.bn3;
                double gf5 = 2.0 * (-this.ck * this.bn3 + sc4 * this.bn4 - sc6 * this.bn5);
                double gf6 = 2.0 * (-this.ci * this.bn3 - sc3 * this.bn4 - sc5 * this.bn5);
                double gf7 = 4.0 * this.bn4;
                double ftm2x = gf1 * this.xr + gf2 * this.dix + gf3 * this.dkx + gf4 * (qkdix - qidkx) + gf5 * qirx + gf6 * qkrx + gf7 * (qiqkrx + qkqirx);
                double ftm2y = gf1 * this.yr + gf2 * this.diy + gf3 * this.dky + gf4 * (qkdiy - qidky) + gf5 * qiry + gf6 * qkry + gf7 * (qiqkry + qkqiry);
                double ftm2z = gf1 * this.zr + gf2 * this.diz + gf3 * this.dkz + gf4 * (qkdiz - qidkz) + gf5 * qirz + gf6 * qkrz + gf7 * (qiqkrz + qkqirz);
                double ttm2x = -this.bn2 * dixdkx + gf2 * dixrx + gf4 * (dixqkrx + dkxqirx + rxqidkx - 2.0 * qixqkx) - gf5 * rxqirx - gf7 * (rxqikrx + qkrxqirx);
                double ttm2y = -this.bn2 * dixdky + gf2 * dixry + gf4 * (dixqkry + dkxqiry + rxqidky - 2.0 * qixqky) - gf5 * rxqiry - gf7 * (rxqikry + qkrxqiry);
                double ttm2z = -this.bn2 * dixdkz + gf2 * dixrz + gf4 * (dixqkrz + dkxqirz + rxqidkz - 2.0 * qixqkz) - gf5 * rxqirz - gf7 * (rxqikrz + qkrxqirz);
                double ttm3x = this.bn2 * dixdkx + gf3 * dkxrx - gf4 * (dixqkrx + dkxqirx + rxqkdix - 2.0 * qixqkx) - gf6 * rxqkrx - gf7 * (rxqkirx - qkrxqirx);
                double ttm3y = this.bn2 * dixdky + gf3 * dkxry - gf4 * (dixqkry + dkxqiry + rxqkdiy - 2.0 * qixqky) - gf6 * rxqkry - gf7 * (rxqkiry - qkrxqiry);
                double ttm3z = this.bn2 * dixdkz + gf3 * dkxrz - gf4 * (dixqkrz + dkxqirz + rxqkdiz - 2.0 * qixqkz) - gf6 * rxqkrz - gf7 * (rxqkirz - qkrxqirz);
                if (scale1 != 0.0) {
                    double gfr1 = this.rr5 * gl0 + this.rr7 * (gl1 + gl6) + this.rr9 * (gl2 + gl7 + gl8) + this.rr11 * (gl3 + gl5) + this.rr13 * gl4;
                    double gfr2 = -this.ck * this.rr5 + sc4 * this.rr7 - sc6 * this.rr9;
                    double gfr3 = this.ci * this.rr5 + sc3 * this.rr7 + sc5 * this.rr9;
                    double gfr4 = 2.0 * this.rr7;
                    double gfr5 = 2.0 * (-this.ck * this.rr7 + sc4 * this.rr9 - sc6 * this.rr11);
                    double gfr6 = 2.0 * (-this.ci * this.rr7 - sc3 * this.rr9 - sc5 * this.rr11);
                    double gfr7 = 4.0 * this.rr9;
                    double ftm2rx = gfr1 * this.xr + gfr2 * this.dix + gfr3 * this.dkx + gfr4 * (qkdix - qidkx) + gfr5 * qirx + gfr6 * qkrx + gfr7 * (qiqkrx + qkqirx);
                    double ftm2ry = gfr1 * this.yr + gfr2 * this.diy + gfr3 * this.dky + gfr4 * (qkdiy - qidky) + gfr5 * qiry + gfr6 * qkry + gfr7 * (qiqkry + qkqiry);
                    double ftm2rz = gfr1 * this.zr + gfr2 * this.diz + gfr3 * this.dkz + gfr4 * (qkdiz - qidkz) + gfr5 * qirz + gfr6 * qkrz + gfr7 * (qiqkrz + qkqirz);
                    double ttm2rx = -this.rr5 * dixdkx + gfr2 * dixrx + gfr4 * (dixqkrx + dkxqirx + rxqidkx - 2.0 * qixqkx) - gfr5 * rxqirx - gfr7 * (rxqikrx + qkrxqirx);
                    double ttm2ry = -this.rr5 * dixdky + gfr2 * dixry + gfr4 * (dixqkry + dkxqiry + rxqidky - 2.0 * qixqky) - gfr5 * rxqiry - gfr7 * (rxqikry + qkrxqiry);
                    double ttm2rz = -this.rr5 * dixdkz + gfr2 * dixrz + gfr4 * (dixqkrz + dkxqirz + rxqidkz - 2.0 * qixqkz) - gfr5 * rxqirz - gfr7 * (rxqikrz + qkrxqirz);
                    double ttm3rx = this.rr5 * dixdkx + gfr3 * dkxrx - gfr4 * (dixqkrx + dkxqirx + rxqkdix - 2.0 * qixqkx) - gfr6 * rxqkrx - gfr7 * (rxqkirx - qkrxqirx);
                    double ttm3ry = this.rr5 * dixdky + gfr3 * dkxry - gfr4 * (dixqkry + dkxqiry + rxqkdiy - 2.0 * qixqky) - gfr6 * rxqkry - gfr7 * (rxqkiry - qkrxqiry);
                    double ttm3rz = this.rr5 * dixdkz + gfr3 * dkxrz - gfr4 * (dixqkrz + dkxqirz + rxqkdiz - 2.0 * qixqkz) - gfr6 * rxqkrz - gfr7 * (rxqkirz - qkrxqirz);
                    ftm2x -= scale1 * ftm2rx;
                    ftm2y -= scale1 * ftm2ry;
                    ftm2z -= scale1 * ftm2rz;
                    ttm2x -= scale1 * ttm2rx;
                    ttm2y -= scale1 * ttm2ry;
                    ttm2z -= scale1 * ttm2rz;
                    ttm3x -= scale1 * ttm3rx;
                    ttm3y -= scale1 * ttm3ry;
                    ttm3z -= scale1 * ttm3rz;
                }
                double prefactor = this.this$0.electric * this.selfScale * this.l2 * this.this$0.dlAlpha;
                this.this$0.lambdaGrad.add(this.threadID, this.i, prefactor * ftm2x, prefactor * ftm2y, prefactor * ftm2z);
                this.this$0.lambdaTorque.add(this.threadID, this.i, prefactor * ttm2x, prefactor * ttm2y, prefactor * ttm2z);
                int n = this.k;
                this.lxk_local[n] = this.lxk_local[n] - prefactor * ftm2x;
                int n13 = this.k;
                this.lyk_local[n13] = this.lyk_local[n13] - prefactor * ftm2y;
                int n14 = this.k;
                this.lzk_local[n14] = this.lzk_local[n14] - prefactor * ftm2z;
                int n15 = this.k;
                this.ltxk_local[n15] = this.ltxk_local[n15] + prefactor * ttm3x;
                int n16 = this.k;
                this.ltyk_local[n16] = this.ltyk_local[n16] + prefactor * ttm3y;
                int n17 = this.k;
                this.ltzk_local[n17] = this.ltzk_local[n17] + prefactor * ttm3z;
            }
            return e;
        }

        /*
         * WARNING - void declaration
         */
        private double polarizationPair(boolean gradientLocal, boolean lambdaTermLocal) {
            double scalar;
            double gfd;
            void findmpz;
            void fridmpz;
            void findmpy;
            void fridmpy;
            void findmpx;
            void fridmpx;
            void temp7;
            double temp5;
            double temp3;
            double ttm3riz;
            double ttm3riy;
            double ttm3rix;
            double gtri6;
            void gtri3;
            double ttm2riz;
            double ttm2riy;
            double gtri4;
            double gtri5;
            void gtri2;
            void gfri6;
            double gfri5;
            double gfri4;
            double gfri1;
            double dsc3 = 1.0 - this.scale3 * this.scaled;
            double dsc5 = 1.0 - this.scale5 * this.scaled;
            double dsc7 = 1.0 - this.scale7 * this.scaled;
            double psc3 = 1.0 - this.scale3 * this.scalep;
            double psc5 = 1.0 - this.scale5 * this.scalep;
            double psc7 = 1.0 - this.scale7 * this.scalep;
            double usc3 = 1.0 - this.scale3;
            double usc5 = 1.0 - this.scale5;
            double dixukx = this.diy * this.ukz - this.diz * this.uky;
            double dixuky = this.diz * this.ukx - this.dix * this.ukz;
            double dixukz = this.dix * this.uky - this.diy * this.ukx;
            double dkxuix = this.dky * this.uiz - this.dkz * this.uiy;
            double dkxuiy = this.dkz * this.uix - this.dkx * this.uiz;
            double dkxuiz = this.dkx * this.uiy - this.dky * this.uix;
            double dixukpx = this.diy * this.pkz - this.diz * this.pky;
            double dixukpy = this.diz * this.pkx - this.dix * this.pkz;
            double dixukpz = this.dix * this.pky - this.diy * this.pkx;
            double dkxuipx = this.dky * this.piz - this.dkz * this.piy;
            double dkxuipy = this.dkz * this.pix - this.dkx * this.piz;
            double dkxuipz = this.dkx * this.piy - this.dky * this.pix;
            double dixrx = this.diy * this.zr - this.diz * this.yr;
            double dixry = this.diz * this.xr - this.dix * this.zr;
            double dixrz = this.dix * this.yr - this.diy * this.xr;
            double dkxrx = this.dky * this.zr - this.dkz * this.yr;
            double dkxry = this.dkz * this.xr - this.dkx * this.zr;
            double dkxrz = this.dkx * this.yr - this.dky * this.xr;
            double qirx = this.qixx * this.xr + this.qixy * this.yr + this.qixz * this.zr;
            double qiry = this.qixy * this.xr + this.qiyy * this.yr + this.qiyz * this.zr;
            double qirz = this.qixz * this.xr + this.qiyz * this.yr + this.qizz * this.zr;
            double qkrx = this.qkxx * this.xr + this.qkxy * this.yr + this.qkxz * this.zr;
            double qkry = this.qkxy * this.xr + this.qkyy * this.yr + this.qkyz * this.zr;
            double qkrz = this.qkxz * this.xr + this.qkyz * this.yr + this.qkzz * this.zr;
            double rxqirx = this.yr * qirz - this.zr * qiry;
            double rxqiry = this.zr * qirx - this.xr * qirz;
            double rxqirz = this.xr * qiry - this.yr * qirx;
            double rxqkrx = this.yr * qkrz - this.zr * qkry;
            double rxqkry = this.zr * qkrx - this.xr * qkrz;
            double rxqkrz = this.xr * qkry - this.yr * qkrx;
            double qiukx = this.qixx * this.ukx + this.qixy * this.uky + this.qixz * this.ukz;
            double qiuky = this.qixy * this.ukx + this.qiyy * this.uky + this.qiyz * this.ukz;
            double qiukz = this.qixz * this.ukx + this.qiyz * this.uky + this.qizz * this.ukz;
            double qkuix = this.qkxx * this.uix + this.qkxy * this.uiy + this.qkxz * this.uiz;
            double qkuiy = this.qkxy * this.uix + this.qkyy * this.uiy + this.qkyz * this.uiz;
            double qkuiz = this.qkxz * this.uix + this.qkyz * this.uiy + this.qkzz * this.uiz;
            double qiukpx = this.qixx * this.pkx + this.qixy * this.pky + this.qixz * this.pkz;
            double qiukpy = this.qixy * this.pkx + this.qiyy * this.pky + this.qiyz * this.pkz;
            double qiukpz = this.qixz * this.pkx + this.qiyz * this.pky + this.qizz * this.pkz;
            double qkuipx = this.qkxx * this.pix + this.qkxy * this.piy + this.qkxz * this.piz;
            double qkuipy = this.qkxy * this.pix + this.qkyy * this.piy + this.qkyz * this.piz;
            double qkuipz = this.qkxz * this.pix + this.qkyz * this.piy + this.qkzz * this.piz;
            double uixqkrx = this.uiy * qkrz - this.uiz * qkry;
            double uixqkry = this.uiz * qkrx - this.uix * qkrz;
            double uixqkrz = this.uix * qkry - this.uiy * qkrx;
            double ukxqirx = this.uky * qirz - this.ukz * qiry;
            double ukxqiry = this.ukz * qirx - this.ukx * qirz;
            double ukxqirz = this.ukx * qiry - this.uky * qirx;
            double uixqkrpx = this.piy * qkrz - this.piz * qkry;
            double uixqkrpy = this.piz * qkrx - this.pix * qkrz;
            double uixqkrpz = this.pix * qkry - this.piy * qkrx;
            double ukxqirpx = this.pky * qirz - this.pkz * qiry;
            double ukxqirpy = this.pkz * qirx - this.pkx * qirz;
            double ukxqirpz = this.pkx * qiry - this.pky * qirx;
            double rxqiukx = this.yr * qiukz - this.zr * qiuky;
            double rxqiuky = this.zr * qiukx - this.xr * qiukz;
            double rxqiukz = this.xr * qiuky - this.yr * qiukx;
            double rxqkuix = this.yr * qkuiz - this.zr * qkuiy;
            double rxqkuiy = this.zr * qkuix - this.xr * qkuiz;
            double rxqkuiz = this.xr * qkuiy - this.yr * qkuix;
            double rxqiukpx = this.yr * qiukpz - this.zr * qiukpy;
            double rxqiukpy = this.zr * qiukpx - this.xr * qiukpz;
            double rxqiukpz = this.xr * qiukpy - this.yr * qiukpx;
            double rxqkuipx = this.yr * qkuipz - this.zr * qkuipy;
            double rxqkuipy = this.zr * qkuipx - this.xr * qkuipz;
            double rxqkuipz = this.xr * qkuipy - this.yr * qkuipx;
            double sc3 = this.dix * this.xr + this.diy * this.yr + this.diz * this.zr;
            double sc4 = this.dkx * this.xr + this.dky * this.yr + this.dkz * this.zr;
            double sc5 = qirx * this.xr + qiry * this.yr + qirz * this.zr;
            double sc6 = qkrx * this.xr + qkry * this.yr + qkrz * this.zr;
            double sci1 = this.uix * this.dkx + this.uiy * this.dky + this.uiz * this.dkz + this.dix * this.ukx + this.diy * this.uky + this.diz * this.ukz;
            double sci3 = this.uix * this.xr + this.uiy * this.yr + this.uiz * this.zr;
            double sci4 = this.ukx * this.xr + this.uky * this.yr + this.ukz * this.zr;
            double sci7 = qirx * this.ukx + qiry * this.uky + qirz * this.ukz;
            double sci8 = qkrx * this.uix + qkry * this.uiy + qkrz * this.uiz;
            double scip1 = this.pix * this.dkx + this.piy * this.dky + this.piz * this.dkz + this.dix * this.pkx + this.diy * this.pky + this.diz * this.pkz;
            double scip2 = this.uix * this.pkx + this.uiy * this.pky + this.uiz * this.pkz + this.pix * this.ukx + this.piy * this.uky + this.piz * this.ukz;
            double scip3 = this.pix * this.xr + this.piy * this.yr + this.piz * this.zr;
            double scip4 = this.pkx * this.xr + this.pky * this.yr + this.pkz * this.zr;
            double scip7 = qirx * this.pkx + qiry * this.pky + qirz * this.pkz;
            double scip8 = qkrx * this.pix + qkry * this.piy + qkrz * this.piz;
            double gli1 = this.ck * sci3 - this.ci * sci4;
            double gli2 = -sc3 * sci4 - sci3 * sc4;
            double gli3 = sci3 * sc6 - sci4 * sc5;
            double gli6 = sci1;
            double gli7 = 2.0 * (sci7 - sci8);
            double glip1 = this.ck * scip3 - this.ci * scip4;
            double glip2 = -sc3 * scip4 - scip3 * sc4;
            double glip3 = scip3 * sc6 - scip4 * sc5;
            double glip6 = scip1;
            double glip7 = 2.0 * (scip7 - scip8);
            double ereal = (gli1 + gli6) * this.bn1 + (gli2 + gli7) * this.bn2 + gli3 * this.bn3;
            double efix = (gli1 + gli6) * this.rr3 * psc3 + (gli2 + gli7) * this.rr5 * psc5 + gli3 * this.rr7 * psc7;
            double e = this.selfScale * 0.5 * (ereal - efix);
            if (!gradientLocal && !lambdaTermLocal) {
                return this.this$0.polarizationScale * e;
            }
            boolean dorli = false;
            if (psc3 != 0.0 || dsc3 != 0.0 || usc3 != 0.0) {
                dorli = true;
            }
            double gfi1 = 0.5 * this.bn2 * (gli1 + glip1 + gli6 + glip6) + 0.5 * this.bn2 * scip2 + 0.5 * this.bn3 * (gli2 + glip2 + gli7 + glip7) - 0.5 * this.bn3 * (sci3 * scip4 + scip3 * sci4) + 0.5 * this.bn4 * (gli3 + glip3);
            double gfi2 = -this.ck * this.bn1 + sc4 * this.bn2 - sc6 * this.bn3;
            double gfi3 = this.ci * this.bn1 + sc3 * this.bn2 + sc5 * this.bn3;
            double gfi4 = 2.0 * this.bn2;
            double gfi5 = this.bn3 * (sci4 + scip4);
            double gfi6 = -this.bn3 * (sci3 + scip3);
            double ftm2ix = gfi1 * this.xr + 0.5 * (gfi2 * (this.uix + this.pix) + this.bn2 * (sci4 * this.pix + scip4 * this.uix) + gfi3 * (this.ukx + this.pkx) + this.bn2 * (sci3 * this.pkx + scip3 * this.ukx) + (sci4 + scip4) * this.bn2 * this.dix + (sci3 + scip3) * this.bn2 * this.dkx + gfi4 * (qkuix + qkuipx - qiukx - qiukpx)) + gfi5 * qirx + gfi6 * qkrx;
            double ftm2iy = gfi1 * this.yr + 0.5 * (gfi2 * (this.uiy + this.piy) + this.bn2 * (sci4 * this.piy + scip4 * this.uiy) + gfi3 * (this.uky + this.pky) + this.bn2 * (sci3 * this.pky + scip3 * this.uky) + (sci4 + scip4) * this.bn2 * this.diy + (sci3 + scip3) * this.bn2 * this.dky + gfi4 * (qkuiy + qkuipy - qiuky - qiukpy)) + gfi5 * qiry + gfi6 * qkry;
            double ftm2iz = gfi1 * this.zr + 0.5 * (gfi2 * (this.uiz + this.piz) + this.bn2 * (sci4 * this.piz + scip4 * this.uiz) + gfi3 * (this.ukz + this.pkz) + this.bn2 * (sci3 * this.pkz + scip3 * this.ukz) + (sci4 + scip4) * this.bn2 * this.diz + (sci3 + scip3) * this.bn2 * this.dkz + gfi4 * (qkuiz + qkuipz - qiukz - qiukpz)) + gfi5 * qirz + gfi6 * qkrz;
            double gti2 = 0.5 * this.bn2 * (sci4 + scip4);
            double gti3 = 0.5 * this.bn2 * (sci3 + scip3);
            double gti4 = gfi4;
            double gti5 = gfi5;
            double gti6 = gfi6;
            double ttm2ix = -0.5 * this.bn1 * (dixukx + dixukpx) + gti2 * dixrx - gti5 * rxqirx + 0.5 * gti4 * (ukxqirx + rxqiukx + ukxqirpx + rxqiukpx);
            double ttm2iy = -0.5 * this.bn1 * (dixuky + dixukpy) + gti2 * dixry - gti5 * rxqiry + 0.5 * gti4 * (ukxqiry + rxqiuky + ukxqirpy + rxqiukpy);
            double ttm2iz = -0.5 * this.bn1 * (dixukz + dixukpz) + gti2 * dixrz - gti5 * rxqirz + 0.5 * gti4 * (ukxqirz + rxqiukz + ukxqirpz + rxqiukpz);
            double ttm3ix = -0.5 * this.bn1 * (dkxuix + dkxuipx) + gti3 * dkxrx - gti6 * rxqkrx - 0.5 * gti4 * (uixqkrx + rxqkuix + uixqkrpx + rxqkuipx);
            double ttm3iy = -0.5 * this.bn1 * (dkxuiy + dkxuipy) + gti3 * dkxry - gti6 * rxqkry - 0.5 * gti4 * (uixqkry + rxqkuiy + uixqkrpy + rxqkuipy);
            double ttm3iz = -0.5 * this.bn1 * (dkxuiz + dkxuipz) + gti3 * dkxrz - gti6 * rxqkrz - 0.5 * gti4 * (uixqkrz + rxqkuiz + uixqkrpz + rxqkuipz);
            double ftm2rix = 0.0;
            double ftm2riy = 0.0;
            double ftm2riz = 0.0;
            double ttm2rix = 0.0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            if (dorli) {
                double d6 = 0.5 * this.rr5 * ((gli1 + gli6) * psc3 + (glip1 + glip6) * dsc3 + scip2 * usc3) + 0.5 * this.rr7 * ((gli7 + gli2) * psc5 + (glip7 + glip2) * dsc5 - (sci3 * scip4 + scip3 * sci4) * usc5) + 0.5 * this.rr9 * (gli3 * psc7 + glip3 * dsc7);
                double d7 = 2.0 * this.rr5;
                double d8 = this.rr7 * (sci4 * psc7 + scip4 * dsc7);
                double d9 = -this.rr7 * (sci3 * psc7 + scip3 * dsc7);
                ftm2rix = gfri1 * this.xr + 0.5 * (-this.rr3 * this.ck * (this.uix * psc3 + this.pix * dsc3) + this.rr5 * sc4 * (this.uix * psc5 + this.pix * dsc5) - this.rr7 * sc6 * (this.uix * psc7 + this.pix * dsc7)) + (this.rr3 * this.ci * (this.ukx * psc3 + this.pkx * dsc3) + this.rr5 * sc3 * (this.ukx * psc5 + this.pkx * dsc5) + this.rr7 * sc5 * (this.ukx * psc7 + this.pkx * dsc7)) * 0.5 + this.rr5 * usc5 * (sci4 * this.pix + scip4 * this.uix + sci3 * this.pkx + scip3 * this.ukx) * 0.5 + 0.5 * (sci4 * psc5 + scip4 * dsc5) * this.rr5 * this.dix + 0.5 * (sci3 * psc5 + scip3 * dsc5) * this.rr5 * this.dkx + 0.5 * gfri4 * ((qkuix - qiukx) * psc5 + (qkuipx - qiukpx) * dsc5) + gfri5 * qirx + gfri6 * qkrx;
                ftm2riy = gfri1 * this.yr + 0.5 * (-this.rr3 * this.ck * (this.uiy * psc3 + this.piy * dsc3) + this.rr5 * sc4 * (this.uiy * psc5 + this.piy * dsc5) - this.rr7 * sc6 * (this.uiy * psc7 + this.piy * dsc7)) + (this.rr3 * this.ci * (this.uky * psc3 + this.pky * dsc3) + this.rr5 * sc3 * (this.uky * psc5 + this.pky * dsc5) + this.rr7 * sc5 * (this.uky * psc7 + this.pky * dsc7)) * 0.5 + this.rr5 * usc5 * (sci4 * this.piy + scip4 * this.uiy + sci3 * this.pky + scip3 * this.uky) * 0.5 + 0.5 * (sci4 * psc5 + scip4 * dsc5) * this.rr5 * this.diy + 0.5 * (sci3 * psc5 + scip3 * dsc5) * this.rr5 * this.dky + 0.5 * gfri4 * ((qkuiy - qiuky) * psc5 + (qkuipy - qiukpy) * dsc5) + gfri5 * qiry + gfri6 * qkry;
                ftm2riz = gfri1 * this.zr + 0.5 * (-this.rr3 * this.ck * (this.uiz * psc3 + this.piz * dsc3) + this.rr5 * sc4 * (this.uiz * psc5 + this.piz * dsc5) - this.rr7 * sc6 * (this.uiz * psc7 + this.piz * dsc7)) + (this.rr3 * this.ci * (this.ukz * psc3 + this.pkz * dsc3) + this.rr5 * sc3 * (this.ukz * psc5 + this.pkz * dsc5) + this.rr7 * sc5 * (this.ukz * psc7 + this.pkz * dsc7)) * 0.5 + this.rr5 * usc5 * (sci4 * this.piz + scip4 * this.uiz + sci3 * this.pkz + scip3 * this.ukz) * 0.5 + 0.5 * (sci4 * psc5 + scip4 * dsc5) * this.rr5 * this.diz + 0.5 * (sci3 * psc5 + scip3 * dsc5) * this.rr5 * this.dkz + 0.5 * gfri4 * ((qkuiz - qiukz) * psc5 + (qkuipz - qiukpz) * dsc5) + gfri5 * qirz + gfri6 * qkrz;
                double d10 = 0.5 * this.rr5 * (sci4 * psc5 + scip4 * dsc5);
                double d11 = 0.5 * this.rr5 * (sci3 * psc5 + scip3 * dsc5);
                double d12 = gfri4;
                double d13 = gfri5;
                void var282_143 = gfri6;
                ttm2rix = -this.rr3 * (dixukx * psc3 + dixukpx * dsc3) * 0.5 + gtri2 * dixrx - gtri5 * rxqirx + gtri4 * ((ukxqirx + rxqiukx) * psc5 + (ukxqirpx + rxqiukpx) * dsc5) * 0.5;
                ttm2riy = -this.rr3 * (dixuky * psc3 + dixukpy * dsc3) * 0.5 + gtri2 * dixry - gtri5 * rxqiry + gtri4 * ((ukxqiry + rxqiuky) * psc5 + (ukxqirpy + rxqiukpy) * dsc5) * 0.5;
                ttm2riz = -this.rr3 * (dixukz * psc3 + dixukpz * dsc3) * 0.5 + gtri2 * dixrz - gtri5 * rxqirz + gtri4 * ((ukxqirz + rxqiukz) * psc5 + (ukxqirpz + rxqiukpz) * dsc5) * 0.5;
                ttm3rix = -this.rr3 * (dkxuix * psc3 + dkxuipx * dsc3) * 0.5 + gtri3 * dkxrx - gtri6 * rxqkrx - gtri4 * ((uixqkrx + rxqkuix) * psc5 + (uixqkrpx + rxqkuipx) * dsc5) * 0.5;
                ttm3riy = -this.rr3 * (dkxuiy * psc3 + dkxuipy * dsc3) * 0.5 + gtri3 * dkxry - gtri6 * rxqkry - gtri4 * ((uixqkry + rxqkuiy) * psc5 + (uixqkrpy + rxqkuipy) * dsc5) * 0.5;
                ttm3riz = -this.rr3 * (dkxuiz * psc3 + dkxuipz * dsc3) * 0.5 + gtri3 * dkxrz - gtri6 * rxqkrz - gtri4 * ((uixqkrz + rxqkuiz) * psc5 + (uixqkrpz + rxqkuipz) * dsc5) * 0.5;
            }
            gfri1 = 0.5 * this.rr3 * ((gli1 + gli6) * this.scalep + (glip1 + glip6) * this.scaled);
            gfri4 = 0.5 * this.rr5 * ((gli2 + gli7) * this.scalep + (glip2 + glip7) * this.scaled);
            gfri5 = 0.5 * this.rr7 * (gli3 * this.scalep + glip3 * this.scaled);
            gfri6 = temp3 * this.ddsc3x + temp5 * this.ddsc5x + temp7 * this.ddsc7x;
            gtri2 = temp3 * this.ddsc3y + temp5 * this.ddsc5y + temp7 * this.ddsc7y;
            gtri3 = temp3 * this.ddsc3z + temp5 * this.ddsc5z + temp7 * this.ddsc7z;
            temp3 = 0.5 * this.rr3 * scip2;
            temp5 = -0.5 * this.rr5 * (sci3 * scip4 + scip3 * sci4);
            gtri4 = temp3 * this.ddsc3x + temp5 * this.ddsc5x;
            gtri5 = temp3 * this.ddsc3y + temp5 * this.ddsc5y;
            gtri6 = temp3 * this.ddsc3z + temp5 * this.ddsc5z;
            ftm2ix = ftm2ix - fridmpx - findmpx;
            ftm2iy = ftm2iy - fridmpy - findmpy;
            ftm2iz = ftm2iz - fridmpz - findmpz;
            if (this.this$0.polarization == Polarization.DIRECT) {
                void fdirz;
                void fdiry;
                void fdirx;
                void gfdr;
                double d14 = 0.5 * (this.bn2 * scip2 - this.bn3 * (scip3 * sci4 + sci3 * scip4));
                double d15 = 0.5 * (this.rr5 * scip2 * usc3 - this.rr7 * (scip3 * sci4 + sci3 * scip4) * usc5);
                ftm2ix = ftm2ix - gfd * this.xr - 0.5 * this.bn2 * (sci4 * this.pix + scip4 * this.uix + sci3 * this.pkx + scip3 * this.ukx);
                ftm2iy = ftm2iy - gfd * this.yr - 0.5 * this.bn2 * (sci4 * this.piy + scip4 * this.uiy + sci3 * this.pky + scip3 * this.uky);
                ftm2iz = ftm2iz - gfd * this.zr - 0.5 * this.bn2 * (sci4 * this.piz + scip4 * this.uiz + sci3 * this.pkz + scip3 * this.ukz);
                void var288_146 = gfdr * this.xr + 0.5 * usc5 * this.rr5 * (sci4 * this.pix + scip4 * this.uix + sci3 * this.pkx + scip3 * this.ukx);
                void var290_147 = gfdr * this.yr + 0.5 * usc5 * this.rr5 * (sci4 * this.piy + scip4 * this.uiy + sci3 * this.pky + scip3 * this.uky);
                void var292_148 = gfdr * this.zr + 0.5 * usc5 * this.rr5 * (sci4 * this.piz + scip4 * this.uiz + sci3 * this.pkz + scip3 * this.ukz);
                ftm2ix = ftm2ix + fdirx + findmpx;
                ftm2iy = ftm2iy + fdiry + findmpy;
                ftm2iz = ftm2iz + fdirz + findmpz;
            }
            ftm2ix -= ftm2rix;
            ftm2iy -= ftm2riy;
            ftm2iz -= ftm2riz;
            ttm2ix -= ttm2rix;
            ttm2iy -= ttm2riy;
            ttm2iz -= ttm2riz;
            ttm3ix -= ttm3rix;
            ttm3iy -= ttm3riy;
            ttm3iz -= ttm3riz;
            gfd = this.this$0.electric * this.this$0.polarizationScale * this.selfScale;
            this.this$0.grad.add(this.threadID, this.i, (double)(scalar * ftm2ix), (double)(scalar * ftm2iy), (double)(scalar * ftm2iz));
            this.this$0.torque.add(this.threadID, this.i, (double)(scalar * ttm2ix), (double)(scalar * ttm2iy), (double)(scalar * ttm2iz));
            int n = this.k;
            this.gxk_local[n] = this.gxk_local[n] - scalar * ftm2ix;
            int n2 = this.k;
            this.gyk_local[n2] = this.gyk_local[n2] - scalar * ftm2iy;
            int n3 = this.k;
            this.gzk_local[n3] = this.gzk_local[n3] - scalar * ftm2iz;
            int n4 = this.k;
            this.txk_local[n4] = this.txk_local[n4] + scalar * ttm3ix;
            int n5 = this.k;
            this.tyk_local[n5] = this.tyk_local[n5] + scalar * ttm3iy;
            int n6 = this.k;
            this.tzk_local[n6] = this.tzk_local[n6] + scalar * ttm3iz;
            if (lambdaTermLocal) {
                this.dUdL += this.this$0.dEdLSign * this.this$0.dlPowPol * e;
                this.d2UdL2 += this.this$0.dEdLSign * this.this$0.d2lPowPol * e;
                scalar = this.this$0.electric * this.this$0.dEdLSign * this.this$0.dlPowPol * this.selfScale;
                this.this$0.lambdaGrad.add(this.threadID, this.i, scalar * ftm2ix, scalar * ftm2iy, scalar * ftm2iz);
                this.this$0.lambdaTorque.add(this.threadID, this.i, scalar * ttm2ix, scalar * ttm2iy, scalar * ttm2iz);
                int n7 = this.k;
                this.lxk_local[n7] = this.lxk_local[n7] - scalar * ftm2ix;
                int n8 = this.k;
                this.lyk_local[n8] = this.lyk_local[n8] - scalar * ftm2iy;
                int n9 = this.k;
                this.lzk_local[n9] = this.lzk_local[n9] - scalar * ftm2iz;
                int n10 = this.k;
                this.ltxk_local[n10] = this.ltxk_local[n10] + scalar * ttm3ix;
                int n11 = this.k;
                this.ltyk_local[n11] = this.ltyk_local[n11] + scalar * ttm3iy;
                int n12 = this.k;
                this.ltzk_local[n12] = this.ltzk_local[n12] + scalar * ttm3iz;
            }
            return this.this$0.polarizationScale * e;
        }

        private void setMultipoleI(double[] globalMultipolei) {
            this.ci = globalMultipolei[0];
            this.dix = globalMultipolei[1];
            this.diy = globalMultipolei[2];
            this.diz = globalMultipolei[3];
            this.qixx = globalMultipolei[4] * 0.3333333333333333;
            this.qiyy = globalMultipolei[5] * 0.3333333333333333;
            this.qizz = globalMultipolei[6] * 0.3333333333333333;
            this.qixy = globalMultipolei[7] * 0.3333333333333333;
            this.qixz = globalMultipolei[8] * 0.3333333333333333;
            this.qiyz = globalMultipolei[9] * 0.3333333333333333;
        }

        private void setMultipoleK(double[] globalMultipolek) {
            this.ck = globalMultipolek[0];
            this.dkx = globalMultipolek[1];
            this.dky = globalMultipolek[2];
            this.dkz = globalMultipolek[3];
            this.qkxx = globalMultipolek[4] * 0.3333333333333333;
            this.qkyy = globalMultipolek[5] * 0.3333333333333333;
            this.qkzz = globalMultipolek[6] * 0.3333333333333333;
            this.qkxy = globalMultipolek[7] * 0.3333333333333333;
            this.qkxz = globalMultipolek[8] * 0.3333333333333333;
            this.qkyz = globalMultipolek[9] * 0.3333333333333333;
        }

        private void setInducedI(double[] inducedDipolei) {
            this.uix = inducedDipolei[0];
            this.uiy = inducedDipolei[1];
            this.uiz = inducedDipolei[2];
        }

        private void setInducedK(double[] inducedDipolek) {
            this.ukx = inducedDipolek[0];
            this.uky = inducedDipolek[1];
            this.ukz = inducedDipolek[2];
        }

        private void setInducedpI(double[] inducedDipolepi) {
            this.pix = inducedDipolepi[0];
            this.piy = inducedDipolepi[1];
            this.piz = inducedDipolepi[2];
        }

        private void setInducedpK(double[] inducedDipolepk) {
            this.pkx = inducedDipolepk[0];
            this.pky = inducedDipolepk[1];
            this.pkz = inducedDipolepk[2];
        }
    }
}

