/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import ffx.potential.nonbonded.pme.PermanentFieldRegion;
import ffx.potential.nonbonded.pme.RealSpaceEnergyRegion;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class PMETimings {
    private static final Logger logger = Logger.getLogger(PMETimings.class.getName());
    public final long[] realSpaceEnergyTime;
    public final long[] realSpaceSCFTime;
    private final int numThreads;
    public long realSpaceEnergyTotal;
    public long realSpaceSCFTotalTime;
    public long bornRadiiTotal;
    public long gkEnergyTotal;

    public PMETimings(int numThreads) {
        this.numThreads = numThreads;
        this.realSpaceEnergyTime = new long[numThreads];
        this.realSpaceSCFTime = new long[numThreads];
    }

    public void init() {
        for (int i = 0; i < this.numThreads; ++i) {
            this.realSpaceEnergyTime[i] = 0L;
            this.realSpaceSCFTime[i] = 0L;
        }
        this.realSpaceEnergyTotal = 0L;
        this.realSpaceSCFTotalTime = 0L;
        this.bornRadiiTotal = 0L;
        this.gkEnergyTotal = 0L;
    }

    public void printRealSpaceTimings(int maxThreads, PermanentFieldRegion permanentFieldRegion, RealSpaceEnergyRegion realSpaceEnergyRegion) {
        long realSpacePermTotal = permanentFieldRegion.getRealSpacePermTime();
        double total = (double)(realSpacePermTotal + this.realSpaceSCFTotalTime + this.realSpaceEnergyTotal) * 1.0E-9;
        logger.info(String.format("\n Real Space: %7.4f (sec)", total));
        logger.info("           Electric Field");
        logger.info(" Thread    Direct  SCF     Energy     Counts");
        long minPerm = Long.MAX_VALUE;
        long maxPerm = 0L;
        long minSCF = Long.MAX_VALUE;
        long maxSCF = 0L;
        long minEnergy = Long.MAX_VALUE;
        long maxEnergy = 0L;
        int minCount = Integer.MAX_VALUE;
        int maxCount = Integer.MIN_VALUE;
        for (int i = 0; i < maxThreads; ++i) {
            int count = realSpaceEnergyRegion.getCount(i);
            long realSpacePermTime = permanentFieldRegion.getInitTime(i) + permanentFieldRegion.getPermTime(i);
            logger.info(String.format("    %3d   %7.4f %7.4f %7.4f %10d", i, (double)realSpacePermTime * 1.0E-9, (double)this.realSpaceSCFTime[i] * 1.0E-9, (double)this.realSpaceEnergyTime[i] * 1.0E-9, count));
            minPerm = FastMath.min((long)realSpacePermTime, (long)minPerm);
            maxPerm = FastMath.max((long)realSpacePermTime, (long)maxPerm);
            minSCF = FastMath.min((long)this.realSpaceSCFTime[i], (long)minSCF);
            maxSCF = FastMath.max((long)this.realSpaceSCFTime[i], (long)maxSCF);
            minEnergy = FastMath.min((long)this.realSpaceEnergyTime[i], (long)minEnergy);
            maxEnergy = FastMath.max((long)this.realSpaceEnergyTime[i], (long)maxEnergy);
            minCount = FastMath.min((int)count, (int)minCount);
            maxCount = FastMath.max((int)count, (int)maxCount);
        }
        logger.info(String.format(" Min      %7.4f %7.4f %7.4f %10d", (double)minPerm * 1.0E-9, (double)minSCF * 1.0E-9, (double)minEnergy * 1.0E-9, minCount));
        logger.info(String.format(" Max      %7.4f %7.4f %7.4f %10d", (double)maxPerm * 1.0E-9, (double)maxSCF * 1.0E-9, (double)maxEnergy * 1.0E-9, maxCount));
        logger.info(String.format(" Delta    %7.4f %7.4f %7.4f %10d", (double)(maxPerm - minPerm) * 1.0E-9, (double)(maxSCF - minSCF) * 1.0E-9, (double)(maxEnergy - minEnergy) * 1.0E-9, maxCount - minCount));
        logger.info(String.format(" Actual   %7.4f %7.4f %7.4f %10d", (double)realSpacePermTotal * 1.0E-9, (double)this.realSpaceSCFTotalTime * 1.0E-9, (double)this.realSpaceEnergyTotal * 1.0E-9, realSpaceEnergyRegion.getInteractions()));
    }
}

