/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.GeneralizedKirkwood;
import ffx.potential.nonbonded.pme.EwaldParameters;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OPTRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(OPTRegion.class.getName());
    public final double[] optCoefficients;
    public final int optOrder = 2;
    private final OPTLoop[] optLoop;
    private final double[] optCoefficientsSum;
    public double[][][] inducedDipole;
    public double[][][] inducedDipoleCR;
    public double[][][] optDipole;
    public double[][][] optDipoleCR;
    private Atom[] atoms;
    private double[] polarizability;
    private double[][] cartesianDipolePhi;
    private double[][] cartesianDipolePhiCR;
    private AtomicDoubleArray3D field;
    private AtomicDoubleArray3D fieldCR;
    private boolean generalizedKirkwoodTerm;
    private GeneralizedKirkwood generalizedKirkwood;
    private double aewald;
    private double aewald3;
    private double dielectric;
    private int currentOptOrder;

    public OPTRegion(int nt) {
        this.optLoop = new OPTLoop[nt];
        this.optCoefficients = new double[3];
        this.optCoefficientsSum = new double[3];
        switch (2) {
            case 1: {
                this.optCoefficients[0] = 0.53;
                this.optCoefficients[1] = 0.604;
                break;
            }
            case 2: {
                this.optCoefficients[0] = 0.042;
                this.optCoefficients[1] = 0.635;
                this.optCoefficients[2] = 0.414;
                break;
            }
            case 3: {
                this.optCoefficients[0] = -0.132;
                this.optCoefficients[1] = 0.218;
                this.optCoefficients[2] = 0.637;
                this.optCoefficients[3] = 0.293;
                break;
            }
            case 4: {
                this.optCoefficients[0] = -0.071;
                this.optCoefficients[1] = -0.096;
                this.optCoefficients[2] = 0.358;
                this.optCoefficients[3] = 0.587;
                this.optCoefficients[4] = 0.216;
                break;
            }
            case 5: {
                this.optCoefficients[0] = -0.005;
                this.optCoefficients[1] = -0.129;
                this.optCoefficients[2] = -0.026;
                this.optCoefficients[3] = 0.465;
                this.optCoefficients[4] = 0.528;
                this.optCoefficients[5] = 0.161;
                break;
            }
            case 6: {
                this.optCoefficients[0] = 0.014;
                this.optCoefficients[1] = -0.041;
                this.optCoefficients[2] = -0.172;
                this.optCoefficients[3] = 0.073;
                this.optCoefficients[4] = 0.535;
                this.optCoefficients[5] = 0.467;
                this.optCoefficients[6] = 0.122;
                break;
            }
            default: {
                logger.severe(" Unsupported OPT order.");
            }
        }
        for (int i = 0; i <= 2; ++i) {
            for (int j = 2; j >= i; --j) {
                int n = i;
                this.optCoefficientsSum[n] = this.optCoefficientsSum[n] + this.optCoefficients[j];
            }
        }
    }

    public void init(int currentOptOrder, Atom[] atoms, double[] polarizability, double[][][] inducedDipole, double[][][] inducedDipoleCR, double[][] cartesianDipolePhi, double[][] cartesianDipolePhiCR, AtomicDoubleArray3D field, AtomicDoubleArray3D fieldCR, boolean generalizedKirkwoodTerm, GeneralizedKirkwood generalizedKirkwood, EwaldParameters ewaldParameters, double dielectric) {
        this.currentOptOrder = currentOptOrder;
        this.atoms = atoms;
        this.polarizability = polarizability;
        this.inducedDipole = inducedDipole;
        this.inducedDipoleCR = inducedDipoleCR;
        this.cartesianDipolePhi = cartesianDipolePhi;
        this.cartesianDipolePhiCR = cartesianDipolePhiCR;
        this.field = field;
        this.fieldCR = fieldCR;
        this.generalizedKirkwoodTerm = generalizedKirkwoodTerm;
        this.generalizedKirkwood = generalizedKirkwood;
        this.aewald = ewaldParameters.aewald;
        this.aewald3 = ewaldParameters.aewald3;
        this.dielectric = dielectric;
    }

    public void run() throws Exception {
        try {
            int ti = this.getThreadIndex();
            if (this.optLoop[ti] == null) {
                this.optLoop[ti] = new OPTLoop(this);
            }
            int nAtoms = this.atoms.length;
            this.execute(0, nAtoms - 1, this.optLoop[ti]);
        }
        catch (RuntimeException ex) {
            logger.warning("Fatal exception computing the opt induced dipoles in thread " + this.getThreadIndex());
            throw ex;
        }
        catch (Exception e) {
            String message = "Fatal exception computing the opt induced dipoles in thread " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private class OPTLoop
    extends IntegerForLoop {
        final /* synthetic */ OPTRegion this$0;

        private OPTLoop(OPTRegion oPTRegion) {
            OPTRegion oPTRegion2 = oPTRegion;
            Objects.requireNonNull(oPTRegion2);
            this.this$0 = oPTRegion2;
        }

        public void run(int lb, int ub) throws Exception {
            int i;
            int threadID = this.getThreadIndex();
            double[][] induced0 = this.this$0.inducedDipole[0];
            double[][] inducedCR0 = this.this$0.inducedDipoleCR[0];
            if (this.this$0.aewald > 0.0) {
                for (i = lb; i <= ub; ++i) {
                    double[] dipolei = induced0[i];
                    double[] dipoleCRi = inducedCR0[i];
                    double[] phii = this.this$0.cartesianDipolePhi[i];
                    double[] phiCRi = this.this$0.cartesianDipolePhiCR[i];
                    double fx = this.this$0.aewald3 * dipolei[0] - phii[1];
                    double fy = this.this$0.aewald3 * dipolei[1] - phii[2];
                    double fz = this.this$0.aewald3 * dipolei[2] - phii[3];
                    double fxCR = this.this$0.aewald3 * dipoleCRi[0] - phiCRi[1];
                    double fyCR = this.this$0.aewald3 * dipoleCRi[1] - phiCRi[2];
                    double fzCR = this.this$0.aewald3 * dipoleCRi[2] - phiCRi[3];
                    this.this$0.field.add(threadID, i, fx, fy, fz);
                    this.this$0.fieldCR.add(threadID, i, fxCR, fyCR, fzCR);
                }
            }
            this.this$0.field.reduce(lb, ub);
            this.this$0.fieldCR.reduce(lb, ub);
            if (this.this$0.dielectric > 1.0) {
                double inverseDielectric = 1.0 / this.this$0.dielectric;
                for (int i2 = lb; i2 <= ub; ++i2) {
                    this.this$0.field.scale(0, i2, inverseDielectric);
                    this.this$0.fieldCR.scale(0, i2, inverseDielectric);
                }
            }
            if (this.this$0.generalizedKirkwoodTerm) {
                AtomicDoubleArray3D fieldGK = this.this$0.generalizedKirkwood.getFieldGK();
                AtomicDoubleArray3D fieldGKCR = this.this$0.generalizedKirkwood.getFieldGKCR();
                for (int i3 = lb; i3 <= ub; ++i3) {
                    this.this$0.field.add(0, i3, fieldGK.getX(i3), fieldGK.getY(i3), fieldGK.getZ(i3));
                    this.this$0.fieldCR.add(0, i3, fieldGKCR.getX(i3), fieldGKCR.getY(i3), fieldGKCR.getZ(i3));
                }
            }
            for (i = lb; i <= ub; ++i) {
                double[] ind = induced0[i];
                double[] indCR = inducedCR0[i];
                double polar = this.this$0.polarizability[i];
                for (int j = 0; j < 3; ++j) {
                    this.this$0.optDipole[this.this$0.currentOptOrder][i][j] = polar * this.this$0.field.get(j, i);
                    this.this$0.optDipoleCR[this.this$0.currentOptOrder][i][j] = polar * this.this$0.fieldCR.get(j, i);
                    ind[j] = this.this$0.optDipole[this.this$0.currentOptOrder][i][j];
                    indCR[j] = this.this$0.optDipoleCR[this.this$0.currentOptOrder][i][j];
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }
    }
}

