/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.potential.bonded.Atom;
import ffx.potential.extended.ExtendedSystem;
import ffx.potential.nonbonded.ParticleMeshEwald;
import ffx.potential.nonbonded.pme.AlchemicalParameters;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.MultipoleType;
import ffx.potential.parameters.PolarizeType;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class InitializationRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(InitializationRegion.class.getName());
    private final ParticleMeshEwald particleMeshEwald;
    private final boolean rotateMultipoles;
    private final boolean useCharges;
    private final boolean useDipoles;
    private final boolean useQuadrupoles;
    private final InitializationLoop[] initializationLoop;
    private final RotateMultipolesLoop[] rotateMultipolesLoop;
    private boolean lambdaTerm;
    private AlchemicalParameters alchemicalParameters;
    private boolean esvTerm;
    private ExtendedSystem esvSystem;
    private Atom[] atoms;
    private double[][][] coordinates;
    private Crystal crystal;
    private MultipoleType.MultipoleFrameDefinition[] frame;
    private int[][] axisAtom;
    private double[][][] globalMultipole;
    private double[][][] titrationMultipole;
    private double[][][] tautomerMultipole;
    private double[] polarizability;
    private double[] titrationPolarizability;
    private double[] tautomerPolarizability;
    private double[] thole;
    private double[] ipdamp;
    private boolean[] use;
    private int[][][] neighborLists;
    private int[][][] realSpaceLists;
    private int[][][] vaporLists;
    private AtomicDoubleArray3D grad;
    private AtomicDoubleArray3D torque;
    private AtomicDoubleArray3D lambdaGrad;
    private AtomicDoubleArray3D lambdaTorque;

    public InitializationRegion(ParticleMeshEwald particleMeshEwald, int maxThreads, ForceField forceField) {
        this.initializationLoop = new InitializationLoop[maxThreads];
        this.rotateMultipolesLoop = new RotateMultipolesLoop[maxThreads];
        this.useCharges = forceField.getBoolean("USE_CHARGES", true);
        this.useDipoles = forceField.getBoolean("USE_DIPOLES", true);
        this.useQuadrupoles = forceField.getBoolean("USE_QUADRUPOLES", true);
        this.rotateMultipoles = forceField.getBoolean("ROTATE_MULTIPOLES", true);
        this.particleMeshEwald = particleMeshEwald;
    }

    public void executeWith(ParallelTeam parallelTeam) {
        try {
            parallelTeam.execute((ParallelRegion)this);
        }
        catch (RuntimeException e) {
            String message = "RuntimeException expanding coordinates and rotating multipoles.\n";
            logger.log(Level.WARNING, message, e);
            throw e;
        }
        catch (Exception e) {
            String message = "Fatal exception expanding coordinates and rotating multipoles.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void init(boolean lambdaTerm, AlchemicalParameters alchemicalParameters, ExtendedSystem esvSystem, Atom[] atoms, double[][][] coordinates, Crystal crystal, MultipoleType.MultipoleFrameDefinition[] frame, int[][] axisAtom, double[][][] globalMultipole, double[][][] titrationMultipole, double[][][] tautomerMultipole, double[] polarizability, double[] titrationPolarizability, double[] tautomerPolarizability, double[] thole, double[] ipdamp, boolean[] use, int[][][] neighborLists, int[][][] realSpaceLists, AtomicDoubleArray3D grad, AtomicDoubleArray3D torque, AtomicDoubleArray3D lambdaGrad, AtomicDoubleArray3D lambdaTorque) {
        this.lambdaTerm = lambdaTerm;
        this.alchemicalParameters = alchemicalParameters;
        this.esvSystem = esvSystem;
        if (esvSystem != null) {
            this.esvTerm = true;
        }
        this.atoms = atoms;
        this.coordinates = coordinates;
        this.crystal = crystal;
        this.frame = frame;
        this.axisAtom = axisAtom;
        this.globalMultipole = globalMultipole;
        this.titrationMultipole = titrationMultipole;
        this.tautomerMultipole = tautomerMultipole;
        this.polarizability = polarizability;
        this.titrationPolarizability = titrationPolarizability;
        this.tautomerPolarizability = tautomerPolarizability;
        this.thole = thole;
        this.ipdamp = ipdamp;
        this.use = use;
        this.neighborLists = neighborLists;
        this.realSpaceLists = realSpaceLists;
        this.vaporLists = alchemicalParameters.vaporLists;
        this.grad = grad;
        this.torque = torque;
        this.lambdaGrad = lambdaGrad;
        this.lambdaTorque = lambdaTorque;
    }

    public void run() {
        int nAtoms = this.atoms.length;
        int threadIndex = this.getThreadIndex();
        if (this.initializationLoop[threadIndex] == null) {
            this.initializationLoop[threadIndex] = new InitializationLoop(this);
            this.rotateMultipolesLoop[threadIndex] = new RotateMultipolesLoop(this);
        }
        try {
            this.execute(0, nAtoms - 1, this.initializationLoop[threadIndex]);
            this.execute(0, nAtoms - 1, this.rotateMultipolesLoop[threadIndex]);
        }
        catch (Exception e) {
            String message = "Fatal exception initializing coordinates in thread: " + threadIndex + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private class InitializationLoop
    extends IntegerForLoop {
        private final double[] in;
        private final double[] out;
        private double[] x;
        private double[] y;
        private double[] z;
        private int threadID;
        final /* synthetic */ InitializationRegion this$0;

        private InitializationLoop(InitializationRegion initializationRegion) {
            InitializationRegion initializationRegion2 = initializationRegion;
            Objects.requireNonNull(initializationRegion2);
            this.this$0 = initializationRegion2;
            this.in = new double[3];
            this.out = new double[3];
        }

        public void run(int lb, int ub) {
            this.this$0.grad.reset(this.threadID, lb, ub);
            this.this$0.torque.reset(this.threadID, lb, ub);
            if (this.this$0.lambdaTerm) {
                this.this$0.lambdaGrad.reset(this.threadID, lb, ub);
                this.this$0.lambdaTorque.reset(this.threadID, lb, ub);
            }
            for (int i = lb; i <= ub; ++i) {
                Atom atom = this.this$0.atoms[i];
                this.x[i] = atom.getX();
                this.y[i] = atom.getY();
                this.z[i] = atom.getZ();
                this.this$0.use[i] = atom.getUse();
                int size = this.this$0.neighborLists[0][i].length;
                if (this.this$0.vaporLists != null) {
                    size = FastMath.max((int)size, (int)this.this$0.vaporLists[0][i].length);
                }
                if (this.this$0.realSpaceLists[0][i] != null && this.this$0.realSpaceLists[0][i].length >= size) continue;
                this.this$0.realSpaceLists[0][i] = new int[size];
            }
            List symOps = this.this$0.crystal.spaceGroup.symOps;
            int nSymm = symOps.size();
            for (int iSymm = 1; iSymm < nSymm; ++iSymm) {
                SymOp symOp = (SymOp)symOps.get(iSymm);
                double[] xs = this.this$0.coordinates[iSymm][0];
                double[] ys = this.this$0.coordinates[iSymm][1];
                double[] zs = this.this$0.coordinates[iSymm][2];
                for (int i = lb; i <= ub; ++i) {
                    this.in[0] = this.x[i];
                    this.in[1] = this.y[i];
                    this.in[2] = this.z[i];
                    this.this$0.crystal.applySymOp(this.in, this.out, symOp);
                    xs[i] = this.out[0];
                    ys[i] = this.out[1];
                    zs[i] = this.out[2];
                    int size = this.this$0.neighborLists[iSymm][i].length;
                    if (this.this$0.realSpaceLists[iSymm][i] != null && this.this$0.realSpaceLists[iSymm][i].length >= size) continue;
                    this.this$0.realSpaceLists[iSymm][i] = new int[size];
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }

        public void start() {
            this.x = this.this$0.coordinates[0][0];
            this.y = this.this$0.coordinates[0][1];
            this.z = this.this$0.coordinates[0][2];
            this.threadID = this.getThreadIndex();
        }
    }

    private class RotateMultipolesLoop
    extends IntegerForLoop {
        private final double[] localOrigin;
        private final double[][] frameCoords;
        private final double[][] rotmat;
        private final double[] tempDipole;
        private final double[][] tempQuadrupole;
        private final double[] dipole;
        private final double[][] quadrupole;
        final /* synthetic */ InitializationRegion this$0;

        private RotateMultipolesLoop(InitializationRegion initializationRegion) {
            InitializationRegion initializationRegion2 = initializationRegion;
            Objects.requireNonNull(initializationRegion2);
            this.this$0 = initializationRegion2;
            this.localOrigin = new double[3];
            this.frameCoords = new double[4][3];
            this.rotmat = new double[3][3];
            this.tempDipole = new double[3];
            this.tempQuadrupole = new double[3][3];
            this.dipole = new double[3];
            this.quadrupole = new double[3][3];
        }

        public void run(int lb, int ub) {
            List symOps = this.this$0.crystal.spaceGroup.symOps;
            int nSymm = symOps.size();
            for (int iSymm = 0; iSymm < nSymm; ++iSymm) {
                double[] x = this.this$0.coordinates[iSymm][0];
                double[] y = this.this$0.coordinates[iSymm][1];
                double[] z = this.this$0.coordinates[iSymm][2];
                for (int ii = lb; ii <= ub; ++ii) {
                    Atom atom = this.this$0.atoms[ii];
                    double chargeScale = 1.0;
                    double dipoleScale = 1.0;
                    double quadrupoleScale = 1.0;
                    double polarizabilityScale = 1.0;
                    if (!this.this$0.useCharges) {
                        chargeScale = 0.0;
                    }
                    if (!this.this$0.useDipoles) {
                        dipoleScale = 0.0;
                    }
                    if (!this.this$0.useQuadrupoles) {
                        quadrupoleScale = 0.0;
                    }
                    if (!atom.getElectrostatics()) {
                        chargeScale = 0.0;
                        dipoleScale = 0.0;
                        quadrupoleScale = 0.0;
                        polarizabilityScale = 0.0;
                    }
                    if (this.this$0.alchemicalParameters.mode == AlchemicalParameters.AlchemicalMode.SCALE && atom.applyLambda()) {
                        chargeScale *= this.this$0.alchemicalParameters.permLambda;
                        dipoleScale *= this.this$0.alchemicalParameters.permLambda;
                        quadrupoleScale *= this.this$0.alchemicalParameters.permLambda;
                        polarizabilityScale *= this.this$0.alchemicalParameters.polLambda;
                    }
                    MultipoleType multipoleType = this.this$0.particleMeshEwald.getMultipoleType(ii);
                    double[] in = multipoleType.getMultipole();
                    this.this$0.frame[ii] = multipoleType.frameDefinition;
                    this.this$0.axisAtom[ii] = atom.getAxisAtomIndices();
                    if (this.this$0.rotateMultipoles) {
                        this.localOrigin[0] = x[ii];
                        this.localOrigin[1] = y[ii];
                        this.localOrigin[2] = z[ii];
                        int[] referenceSites = this.this$0.axisAtom[ii];
                        int nSites = 0;
                        if (referenceSites != null) {
                            nSites = referenceSites.length;
                        }
                        for (int i = 0; i < nSites; ++i) {
                            int index = referenceSites[i];
                            this.frameCoords[i][0] = x[index];
                            this.frameCoords[i][1] = y[index];
                            this.frameCoords[i][2] = z[index];
                        }
                        this.tempDipole[0] = in[1];
                        this.tempDipole[1] = in[2];
                        this.tempDipole[2] = in[3];
                        this.tempQuadrupole[0][0] = in[4];
                        this.tempQuadrupole[1][1] = in[5];
                        this.tempQuadrupole[2][2] = in[6];
                        this.tempQuadrupole[0][1] = in[7];
                        this.tempQuadrupole[0][2] = in[8];
                        this.tempQuadrupole[1][2] = in[9];
                        this.tempQuadrupole[1][0] = in[7];
                        this.tempQuadrupole[2][0] = in[8];
                        this.tempQuadrupole[2][1] = in[9];
                        boolean needsChiralInversion = false;
                        MultipoleType.getRotationMatrix(this.this$0.frame[ii], this.localOrigin, this.frameCoords, this.rotmat);
                        MultipoleType.rotateMultipole(this.rotmat, this.tempDipole, this.tempQuadrupole, this.dipole, this.quadrupole);
                        double[] out = this.this$0.globalMultipole[iSymm][ii];
                        out[0] = in[0] * chargeScale;
                        out[1] = this.dipole[0] * dipoleScale;
                        out[2] = this.dipole[1] * dipoleScale;
                        out[3] = this.dipole[2] * dipoleScale;
                        out[4] = this.quadrupole[0][0] * quadrupoleScale;
                        out[5] = this.quadrupole[1][1] * quadrupoleScale;
                        out[6] = this.quadrupole[2][2] * quadrupoleScale;
                        out[7] = this.quadrupole[0][1] * quadrupoleScale;
                        out[8] = this.quadrupole[0][2] * quadrupoleScale;
                        out[9] = this.quadrupole[1][2] * quadrupoleScale;
                        if (this.this$0.esvTerm && this.this$0.esvSystem.isTitrating(ii)) {
                            double[] esvMultipoleTitrDot = new double[10];
                            double[] esvMultipoleTautDot = new double[10];
                            double titrationLambda = this.this$0.esvSystem.getTitrationLambda(ii);
                            double tautomerLambda = this.this$0.esvSystem.getTautomerLambda(ii);
                            esvMultipoleTitrDot = this.this$0.esvSystem.getTitrationUtils().getMultipoleTitrationDeriv(atom, titrationLambda, tautomerLambda, esvMultipoleTitrDot);
                            esvMultipoleTautDot = this.this$0.esvSystem.getTitrationUtils().getMultipoleTautomerDeriv(atom, titrationLambda, tautomerLambda, esvMultipoleTautDot);
                            double tempCharge = esvMultipoleTitrDot[0];
                            this.tempDipole[0] = esvMultipoleTitrDot[1];
                            this.tempDipole[1] = esvMultipoleTitrDot[2];
                            this.tempDipole[2] = esvMultipoleTitrDot[3];
                            this.tempQuadrupole[0][0] = esvMultipoleTitrDot[4];
                            this.tempQuadrupole[1][1] = esvMultipoleTitrDot[5];
                            this.tempQuadrupole[2][2] = esvMultipoleTitrDot[6];
                            this.tempQuadrupole[0][1] = esvMultipoleTitrDot[7];
                            this.tempQuadrupole[0][2] = esvMultipoleTitrDot[8];
                            this.tempQuadrupole[1][2] = esvMultipoleTitrDot[9];
                            this.tempQuadrupole[1][0] = esvMultipoleTitrDot[7];
                            this.tempQuadrupole[2][0] = esvMultipoleTitrDot[8];
                            this.tempQuadrupole[2][1] = esvMultipoleTitrDot[9];
                            if (needsChiralInversion) {
                                this.tempDipole[1] = -this.tempDipole[1];
                                this.tempQuadrupole[0][1] = -this.tempQuadrupole[0][1];
                                this.tempQuadrupole[1][0] = -this.tempQuadrupole[1][0];
                                this.tempQuadrupole[1][2] = -this.tempQuadrupole[1][2];
                                this.tempQuadrupole[2][1] = -this.tempQuadrupole[2][1];
                            }
                            MultipoleType.rotateMultipole(this.rotmat, this.tempDipole, this.tempQuadrupole, this.dipole, this.quadrupole);
                            out = this.this$0.titrationMultipole[iSymm][ii];
                            out[0] = tempCharge * chargeScale;
                            out[1] = this.dipole[0] * dipoleScale;
                            out[2] = this.dipole[1] * dipoleScale;
                            out[3] = this.dipole[2] * dipoleScale;
                            out[4] = this.quadrupole[0][0] * quadrupoleScale;
                            out[5] = this.quadrupole[1][1] * quadrupoleScale;
                            out[6] = this.quadrupole[2][2] * quadrupoleScale;
                            out[7] = this.quadrupole[0][1] * quadrupoleScale;
                            out[8] = this.quadrupole[0][2] * quadrupoleScale;
                            out[9] = this.quadrupole[1][2] * quadrupoleScale;
                            tempCharge = esvMultipoleTautDot[0];
                            this.tempDipole[0] = esvMultipoleTautDot[1];
                            this.tempDipole[1] = esvMultipoleTautDot[2];
                            this.tempDipole[2] = esvMultipoleTautDot[3];
                            this.tempQuadrupole[0][0] = esvMultipoleTautDot[4];
                            this.tempQuadrupole[1][1] = esvMultipoleTautDot[5];
                            this.tempQuadrupole[2][2] = esvMultipoleTautDot[6];
                            this.tempQuadrupole[0][1] = esvMultipoleTautDot[7];
                            this.tempQuadrupole[0][2] = esvMultipoleTautDot[8];
                            this.tempQuadrupole[1][2] = esvMultipoleTautDot[9];
                            this.tempQuadrupole[1][0] = esvMultipoleTautDot[7];
                            this.tempQuadrupole[2][0] = esvMultipoleTautDot[8];
                            this.tempQuadrupole[2][1] = esvMultipoleTautDot[9];
                            if (needsChiralInversion) {
                                this.tempDipole[1] = -this.tempDipole[1];
                                this.tempQuadrupole[0][1] = -this.tempQuadrupole[0][1];
                                this.tempQuadrupole[1][0] = -this.tempQuadrupole[1][0];
                                this.tempQuadrupole[1][2] = -this.tempQuadrupole[1][2];
                                this.tempQuadrupole[2][1] = -this.tempQuadrupole[2][1];
                            }
                            MultipoleType.rotateMultipole(this.rotmat, this.tempDipole, this.tempQuadrupole, this.dipole, this.quadrupole);
                            out = this.this$0.tautomerMultipole[iSymm][ii];
                            out[0] = tempCharge * chargeScale;
                            out[1] = this.dipole[0] * dipoleScale;
                            out[2] = this.dipole[1] * dipoleScale;
                            out[3] = this.dipole[2] * dipoleScale;
                            out[4] = this.quadrupole[0][0] * quadrupoleScale;
                            out[5] = this.quadrupole[1][1] * quadrupoleScale;
                            out[6] = this.quadrupole[2][2] * quadrupoleScale;
                            out[7] = this.quadrupole[0][1] * quadrupoleScale;
                            out[8] = this.quadrupole[0][2] * quadrupoleScale;
                            out[9] = this.quadrupole[1][2] * quadrupoleScale;
                        }
                    } else {
                        double[] out = this.this$0.globalMultipole[iSymm][ii];
                        out[0] = in[0] * chargeScale;
                        out[1] = in[1] * dipoleScale;
                        out[2] = in[2] * dipoleScale;
                        out[3] = in[3] * dipoleScale;
                        out[4] = in[4] * quadrupoleScale;
                        out[5] = in[5] * quadrupoleScale;
                        out[6] = in[6] * quadrupoleScale;
                        out[7] = in[7] * quadrupoleScale;
                        out[8] = in[8] * quadrupoleScale;
                        out[9] = in[9] * quadrupoleScale;
                        if (this.this$0.esvTerm && this.this$0.esvSystem.isTitrating(ii)) {
                            double[] esvMultipoleTitrDot = new double[10];
                            double titrationLambda = this.this$0.esvSystem.getTitrationLambda(ii);
                            double tautomerLambda = this.this$0.esvSystem.getTautomerLambda(ii);
                            esvMultipoleTitrDot = this.this$0.esvSystem.getTitrationUtils().getMultipoleTitrationDeriv(atom, titrationLambda, tautomerLambda, esvMultipoleTitrDot);
                            in = esvMultipoleTitrDot;
                            out = this.this$0.titrationMultipole[iSymm][ii];
                            out[0] = in[0] * chargeScale;
                            out[1] = in[1] * dipoleScale;
                            out[2] = in[2] * dipoleScale;
                            out[3] = in[3] * dipoleScale;
                            out[4] = in[4] * quadrupoleScale;
                            out[5] = in[5] * quadrupoleScale;
                            out[6] = in[6] * quadrupoleScale;
                            out[7] = in[7] * quadrupoleScale;
                            out[8] = in[8] * quadrupoleScale;
                            out[9] = in[9] * quadrupoleScale;
                            double[] esvMultipoleTautDot = new double[10];
                            esvMultipoleTautDot = this.this$0.esvSystem.getTitrationUtils().getMultipoleTautomerDeriv(atom, titrationLambda, tautomerLambda, esvMultipoleTautDot);
                            in = esvMultipoleTautDot;
                            out = this.this$0.tautomerMultipole[iSymm][ii];
                            out[0] = in[0] * chargeScale;
                            out[1] = in[1] * dipoleScale;
                            out[2] = in[2] * dipoleScale;
                            out[3] = in[3] * dipoleScale;
                            out[4] = in[4] * quadrupoleScale;
                            out[5] = in[5] * quadrupoleScale;
                            out[6] = in[6] * quadrupoleScale;
                            out[7] = in[7] * quadrupoleScale;
                            out[8] = in[8] * quadrupoleScale;
                            out[9] = in[9] * quadrupoleScale;
                        }
                    }
                    PolarizeType polarizeType = this.this$0.particleMeshEwald.getPolarizeType(ii);
                    if (polarizeType != null) {
                        this.this$0.polarizability[ii] = polarizeType.polarizability * polarizabilityScale;
                        if (this.this$0.esvTerm && this.this$0.esvSystem.isTitrating(ii) && (this.this$0.esvSystem.isTitratingHydrogen(ii) || this.this$0.esvSystem.isTitratingHeavy(ii))) {
                            this.this$0.titrationPolarizability[ii] = 0.0;
                            this.this$0.tautomerPolarizability[ii] = 0.0;
                            double titrationLambda = this.this$0.esvSystem.getTitrationLambda(ii);
                            double tautomerLambda = this.this$0.esvSystem.getTautomerLambda(ii);
                            this.this$0.titrationPolarizability[ii] = this.this$0.esvSystem.getTitrationUtils().getPolarizabilityTitrationDeriv(atom, titrationLambda, tautomerLambda);
                            this.this$0.tautomerPolarizability[ii] = this.this$0.esvSystem.getTitrationUtils().getPolarizabilityTautomerDeriv(atom, titrationLambda, tautomerLambda);
                        }
                        this.this$0.thole[ii] = polarizeType.thole;
                        this.this$0.ipdamp[ii] = polarizeType.pdamp;
                        if (!(this.this$0.ipdamp[ii] > 0.0)) {
                            this.this$0.ipdamp[ii] = Double.POSITIVE_INFINITY;
                            continue;
                        }
                        this.this$0.ipdamp[ii] = 1.0 / this.this$0.ipdamp[ii];
                        continue;
                    }
                    this.this$0.polarizability[ii] = 0.0;
                    this.this$0.thole[ii] = 0.0;
                    this.this$0.ipdamp[ii] = Double.POSITIVE_INFINITY;
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }
    }
}

