/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;
import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.special.Erf;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.ReciprocalSpace;
import ffx.potential.nonbonded.pme.EwaldParameters;
import ffx.potential.nonbonded.pme.LambdaMode;
import ffx.potential.nonbonded.pme.PMETimings;
import ffx.potential.nonbonded.pme.RealSpaceNeighborParameters;
import ffx.potential.parameters.ForceField;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class InducedDipoleFieldRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(InducedDipoleFieldRegion.class.getName());
    private final boolean intermolecularSoftcore;
    private final boolean intramolecularSoftcore;
    public double[][][] inducedDipole;
    public double[][][] inducedDipoleCR;
    private Atom[] atoms;
    private Crystal crystal;
    private boolean[] use;
    private int[] molecule;
    private double[] ipdamp;
    private double[] thole;
    private double[][][] coordinates;
    private int[][][] realSpaceLists;
    private int[][] realSpaceCounts;
    private IntegerSchedule realSpaceSchedule;
    private ReciprocalSpace reciprocalSpace;
    private boolean reciprocalSpaceTerm;
    private LambdaMode lambdaMode = LambdaMode.OFF;
    private double aewald;
    private double an0;
    private double an1;
    private AtomicDoubleArray3D field;
    private AtomicDoubleArray3D fieldCR;
    private PMETimings pmeTimings;
    private final InducedDipoleRealSpaceFieldSection inducedRealSpaceFieldSection;
    private final InducedDipoleReciprocalFieldSection inducedReciprocalFieldSection;

    public InducedDipoleFieldRegion(ParallelTeam parallelTeam, ForceField forceField, boolean lambdaTerm) {
        this.inducedRealSpaceFieldSection = new InducedDipoleRealSpaceFieldSection(this, parallelTeam);
        this.inducedReciprocalFieldSection = new InducedDipoleReciprocalFieldSection(this);
        if (lambdaTerm) {
            this.intermolecularSoftcore = forceField.getBoolean("INTERMOLECULAR_SOFTCORE", false);
            this.intramolecularSoftcore = forceField.getBoolean("INTRAMOLECULAR_SOFTCORE", false);
        } else {
            this.intermolecularSoftcore = false;
            this.intramolecularSoftcore = false;
        }
    }

    public void executeWith(ParallelTeam sectionTeam) {
        try {
            sectionTeam.execute((ParallelRegion)this);
        }
        catch (RuntimeException e) {
            String message = "Runtime exception computing the induced reciprocal space field.\n";
            logger.log(Level.WARNING, message, e);
            throw e;
        }
        catch (Exception ex) {
            String message = "Fatal exception computing the induced reciprocal space field.\n";
            logger.log(Level.SEVERE, message, ex);
        }
    }

    public void init(Atom[] atoms, Crystal crystal, boolean[] use, int[] molecule, double[] ipdamp, double[] thole, double[][][] coordinates, RealSpaceNeighborParameters realSpaceNeighborParameters, double[][][] inducedDipole, double[][][] inducedDipoleCR, boolean reciprocalSpaceTerm, ReciprocalSpace reciprocalSpace, LambdaMode lambdaMode, EwaldParameters ewaldParameters, AtomicDoubleArray3D field, AtomicDoubleArray3D fieldCR, PMETimings pmeTimings) {
        this.atoms = atoms;
        this.crystal = crystal;
        this.use = use;
        this.molecule = molecule;
        this.ipdamp = ipdamp;
        this.thole = thole;
        this.coordinates = coordinates;
        this.realSpaceLists = realSpaceNeighborParameters.realSpaceLists;
        this.realSpaceCounts = realSpaceNeighborParameters.realSpaceCounts;
        this.realSpaceSchedule = realSpaceNeighborParameters.realSpaceSchedule;
        this.inducedDipole = inducedDipole;
        this.inducedDipoleCR = inducedDipoleCR;
        this.reciprocalSpaceTerm = reciprocalSpaceTerm;
        this.reciprocalSpace = reciprocalSpace;
        this.lambdaMode = lambdaMode;
        this.aewald = ewaldParameters.aewald;
        this.an0 = ewaldParameters.an0;
        this.an1 = ewaldParameters.an1;
        this.field = field;
        this.fieldCR = fieldCR;
        this.pmeTimings = pmeTimings;
    }

    public void run() {
        try {
            if (this.reciprocalSpaceTerm && this.aewald > 0.0) {
                this.execute(this.inducedRealSpaceFieldSection, this.inducedReciprocalFieldSection);
            } else {
                this.execute(this.inducedRealSpaceFieldSection);
            }
        }
        catch (Exception e) {
            String message = "Fatal exception computing the induced dipole field.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private class InducedDipoleRealSpaceFieldSection
    extends ParallelSection {
        private final InducedDipoleRealSpaceFieldRegion inducedDipoleRealSpaceFieldRegion;
        private final ParallelTeam parallelTeam;
        final /* synthetic */ InducedDipoleFieldRegion this$0;

        InducedDipoleRealSpaceFieldSection(InducedDipoleFieldRegion inducedDipoleFieldRegion, ParallelTeam parallelTeam) {
            InducedDipoleFieldRegion inducedDipoleFieldRegion2 = inducedDipoleFieldRegion;
            Objects.requireNonNull(inducedDipoleFieldRegion2);
            this.this$0 = inducedDipoleFieldRegion2;
            this.parallelTeam = parallelTeam;
            int nThreads = parallelTeam.getThreadCount();
            this.inducedDipoleRealSpaceFieldRegion = new InducedDipoleRealSpaceFieldRegion(inducedDipoleFieldRegion, nThreads);
        }

        public void run() {
            this.this$0.pmeTimings.realSpaceSCFTotalTime -= System.nanoTime();
            try {
                this.parallelTeam.execute((ParallelRegion)this.inducedDipoleRealSpaceFieldRegion);
            }
            catch (Exception e) {
                String message = "Fatal exception computing the real space field.\n";
                logger.log(Level.SEVERE, message, e);
            }
            this.this$0.pmeTimings.realSpaceSCFTotalTime += System.nanoTime();
        }
    }

    private class InducedDipoleReciprocalFieldSection
    extends ParallelSection {
        final /* synthetic */ InducedDipoleFieldRegion this$0;

        private InducedDipoleReciprocalFieldSection(InducedDipoleFieldRegion inducedDipoleFieldRegion) {
            InducedDipoleFieldRegion inducedDipoleFieldRegion2 = inducedDipoleFieldRegion;
            Objects.requireNonNull(inducedDipoleFieldRegion2);
            this.this$0 = inducedDipoleFieldRegion2;
        }

        public void run() {
            this.this$0.reciprocalSpace.performConvolution();
        }
    }

    private class InducedDipoleRealSpaceFieldRegion
    extends ParallelRegion {
        private final InducedRealSpaceFieldLoop[] inducedRealSpaceFieldLoop;
        final /* synthetic */ InducedDipoleFieldRegion this$0;

        InducedDipoleRealSpaceFieldRegion(InducedDipoleFieldRegion inducedDipoleFieldRegion, int threadCount) {
            InducedDipoleFieldRegion inducedDipoleFieldRegion2 = inducedDipoleFieldRegion;
            Objects.requireNonNull(inducedDipoleFieldRegion2);
            this.this$0 = inducedDipoleFieldRegion2;
            this.inducedRealSpaceFieldLoop = new InducedRealSpaceFieldLoop[threadCount];
        }

        public void run() {
            int threadIndex;
            int n = threadIndex = this.getThreadIndex();
            this.this$0.pmeTimings.realSpaceSCFTime[n] = this.this$0.pmeTimings.realSpaceSCFTime[n] - System.nanoTime();
            if (this.inducedRealSpaceFieldLoop[threadIndex] == null) {
                this.inducedRealSpaceFieldLoop[threadIndex] = new InducedRealSpaceFieldLoop(this);
            }
            try {
                int nAtoms = this.this$0.atoms.length;
                this.execute(0, nAtoms - 1, this.inducedRealSpaceFieldLoop[threadIndex]);
            }
            catch (Exception e) {
                String message = "Fatal exception computing the induced real space field in thread " + this.getThreadIndex() + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }

        private class InducedRealSpaceFieldLoop
        extends IntegerForLoop {
            private int threadID;
            private double[][] ind;
            private double[][] indCR;
            private double[] x;
            private double[] y;
            private double[] z;
            final /* synthetic */ InducedDipoleRealSpaceFieldRegion this$1;

            InducedRealSpaceFieldLoop(InducedDipoleRealSpaceFieldRegion inducedDipoleRealSpaceFieldRegion) {
                InducedDipoleRealSpaceFieldRegion inducedDipoleRealSpaceFieldRegion2 = inducedDipoleRealSpaceFieldRegion;
                Objects.requireNonNull(inducedDipoleRealSpaceFieldRegion2);
                this.this$1 = inducedDipoleRealSpaceFieldRegion2;
            }

            public void run(int lb, int ub) {
                double[] dx = new double[3];
                double[][] transOp = new double[3][3];
                int[][] lists = this.this$1.this$0.realSpaceLists[0];
                int[] counts = this.this$1.this$0.realSpaceCounts[0];
                for (int i = lb; i <= ub; ++i) {
                    if (!this.this$1.this$0.use[i]) continue;
                    int moleculei = this.this$1.this$0.molecule[i];
                    double fx = 0.0;
                    double fy = 0.0;
                    double fz = 0.0;
                    double px = 0.0;
                    double py = 0.0;
                    double pz = 0.0;
                    double xi = this.x[i];
                    double yi = this.y[i];
                    double zi = this.z[i];
                    double[] dipolei = this.ind[i];
                    double uix = dipolei[0];
                    double uiy = dipolei[1];
                    double uiz = dipolei[2];
                    double[] dipoleCRi = this.indCR[i];
                    double pix = dipoleCRi[0];
                    double piy = dipoleCRi[1];
                    double piz = dipoleCRi[2];
                    double pdi = this.this$1.this$0.ipdamp[i];
                    double pti = this.this$1.this$0.thole[i];
                    int[] list = lists[i];
                    int npair = counts[i];
                    for (int j = 0; j < npair; ++j) {
                        double rdamp;
                        boolean sameMolecule;
                        int k = list[j];
                        if (!this.this$1.this$0.use[k]) continue;
                        boolean bl = sameMolecule = moleculei == this.this$1.this$0.molecule[k];
                        if (this.this$1.this$0.lambdaMode == LambdaMode.VAPOR && (this.this$1.this$0.intermolecularSoftcore && !sameMolecule || this.this$1.this$0.intramolecularSoftcore && sameMolecule)) continue;
                        double pdk = this.this$1.this$0.ipdamp[k];
                        double ptk = this.this$1.this$0.thole[k];
                        dx[0] = this.x[k] - xi;
                        dx[1] = this.y[k] - yi;
                        dx[2] = this.z[k] - zi;
                        double r2 = this.this$1.this$0.crystal.image(dx);
                        double r = FastMath.sqrt((double)r2);
                        double rr1 = 1.0 / r;
                        double rr2 = rr1 * rr1;
                        double ralpha = this.this$1.this$0.aewald * r;
                        double exp2a = FastMath.exp((double)(-ralpha * ralpha));
                        double bn0 = Erf.erfc((double)ralpha) * rr1;
                        double bn1 = (bn0 + this.this$1.this$0.an0 * exp2a) * rr2;
                        double bn2 = (3.0 * bn1 + this.this$1.this$0.an1 * exp2a) * rr2;
                        double scale3 = 1.0;
                        double scale5 = 1.0;
                        double damp = pdi * pdk;
                        double pgamma = FastMath.min((double)pti, (double)ptk);
                        damp = -pgamma * (rdamp = r * damp) * rdamp * rdamp;
                        if (damp > -50.0) {
                            double expdamp = FastMath.exp((double)damp);
                            scale3 = 1.0 - expdamp;
                            scale5 = 1.0 - expdamp * (1.0 - damp);
                        }
                        double rr3 = rr1 * rr2;
                        double rr5 = 3.0 * rr3 * rr2;
                        rr3 *= 1.0 - scale3;
                        rr5 *= 1.0 - scale5;
                        double xr = dx[0];
                        double yr = dx[1];
                        double zr = dx[2];
                        double[] dipolek = this.ind[k];
                        double ukx = dipolek[0];
                        double uky = dipolek[1];
                        double ukz = dipolek[2];
                        double ukr = ukx * xr + uky * yr + ukz * zr;
                        double bn2ukr = bn2 * ukr;
                        double fimx = -bn1 * ukx + bn2ukr * xr;
                        double fimy = -bn1 * uky + bn2ukr * yr;
                        double fimz = -bn1 * ukz + bn2ukr * zr;
                        double rr5ukr = rr5 * ukr;
                        double fidx = -rr3 * ukx + rr5ukr * xr;
                        double fidy = -rr3 * uky + rr5ukr * yr;
                        double fidz = -rr3 * ukz + rr5ukr * zr;
                        fx += fimx - fidx;
                        fy += fimy - fidy;
                        fz += fimz - fidz;
                        double[] dipolepk = this.indCR[k];
                        double pkx = dipolepk[0];
                        double pky = dipolepk[1];
                        double pkz = dipolepk[2];
                        double pkr = pkx * xr + pky * yr + pkz * zr;
                        double bn2pkr = bn2 * pkr;
                        double pimx = -bn1 * pkx + bn2pkr * xr;
                        double pimy = -bn1 * pky + bn2pkr * yr;
                        double pimz = -bn1 * pkz + bn2pkr * zr;
                        double rr5pkr = rr5 * pkr;
                        double pidx = -rr3 * pkx + rr5pkr * xr;
                        double pidy = -rr3 * pky + rr5pkr * yr;
                        double pidz = -rr3 * pkz + rr5pkr * zr;
                        px += pimx - pidx;
                        py += pimy - pidy;
                        pz += pimz - pidz;
                        double uir = uix * xr + uiy * yr + uiz * zr;
                        double bn2uir = bn2 * uir;
                        double fkmx = -bn1 * uix + bn2uir * xr;
                        double fkmy = -bn1 * uiy + bn2uir * yr;
                        double fkmz = -bn1 * uiz + bn2uir * zr;
                        double rr5uir = rr5 * uir;
                        double fkdx = -rr3 * uix + rr5uir * xr;
                        double fkdy = -rr3 * uiy + rr5uir * yr;
                        double fkdz = -rr3 * uiz + rr5uir * zr;
                        this.this$1.this$0.field.add(this.threadID, k, fkmx - fkdx, fkmy - fkdy, fkmz - fkdz);
                        double pir = pix * xr + piy * yr + piz * zr;
                        double bn2pir = bn2 * pir;
                        double pkmx = -bn1 * pix + bn2pir * xr;
                        double pkmy = -bn1 * piy + bn2pir * yr;
                        double pkmz = -bn1 * piz + bn2pir * zr;
                        double rr5pir = rr5 * pir;
                        double pkdx = -rr3 * pix + rr5pir * xr;
                        double pkdy = -rr3 * piy + rr5pir * yr;
                        double pkdz = -rr3 * piz + rr5pir * zr;
                        this.this$1.this$0.fieldCR.add(this.threadID, k, pkmx - pkdx, pkmy - pkdy, pkmz - pkdz);
                    }
                    this.this$1.this$0.field.add(this.threadID, i, fx, fy, fz);
                    this.this$1.this$0.fieldCR.add(this.threadID, i, px, py, pz);
                }
                List symOps = this.this$1.this$0.crystal.spaceGroup.symOps;
                int nSymm = symOps.size();
                for (int iSymm = 1; iSymm < nSymm; ++iSymm) {
                    SymOp symOp = this.this$1.this$0.crystal.spaceGroup.getSymOp(iSymm);
                    this.this$1.this$0.crystal.getTransformationOperator(symOp, transOp);
                    lists = this.this$1.this$0.realSpaceLists[iSymm];
                    counts = this.this$1.this$0.realSpaceCounts[iSymm];
                    double[] xs = this.this$1.this$0.coordinates[iSymm][0];
                    double[] ys = this.this$1.this$0.coordinates[iSymm][1];
                    double[] zs = this.this$1.this$0.coordinates[iSymm][2];
                    double[][] inds = this.this$1.this$0.inducedDipole[iSymm];
                    double[][] indCRs = this.this$1.this$0.inducedDipoleCR[iSymm];
                    for (int i = lb; i <= ub; ++i) {
                        if (!this.this$1.this$0.use[i]) continue;
                        double fx = 0.0;
                        double fy = 0.0;
                        double fz = 0.0;
                        double px = 0.0;
                        double py = 0.0;
                        double pz = 0.0;
                        double xi = this.x[i];
                        double yi = this.y[i];
                        double zi = this.z[i];
                        double[] dipolei = this.ind[i];
                        double uix = dipolei[0];
                        double uiy = dipolei[1];
                        double uiz = dipolei[2];
                        double[] dipoleCRi = this.indCR[i];
                        double pix = dipoleCRi[0];
                        double piy = dipoleCRi[1];
                        double piz = dipoleCRi[2];
                        double pdi = this.this$1.this$0.ipdamp[i];
                        double pti = this.this$1.this$0.thole[i];
                        int[] list = lists[i];
                        int npair = counts[i];
                        for (int j = 0; j < npair; ++j) {
                            double rdamp;
                            int k = list[j];
                            if (!this.this$1.this$0.use[k]) continue;
                            double selfScale = 1.0;
                            if (i == k) {
                                selfScale = 0.5;
                            }
                            double pdk = this.this$1.this$0.ipdamp[k];
                            double ptk = this.this$1.this$0.thole[k];
                            dx[0] = xs[k] - xi;
                            dx[1] = ys[k] - yi;
                            dx[2] = zs[k] - zi;
                            double r2 = this.this$1.this$0.crystal.image(dx);
                            double r = FastMath.sqrt((double)r2);
                            double rr1 = 1.0 / r;
                            double rr2 = rr1 * rr1;
                            double ralpha = this.this$1.this$0.aewald * r;
                            double exp2a = FastMath.exp((double)(-ralpha * ralpha));
                            double bn0 = Erf.erfc((double)ralpha) * rr1;
                            double bn1 = (bn0 + this.this$1.this$0.an0 * exp2a) * rr2;
                            double bn2 = (3.0 * bn1 + this.this$1.this$0.an1 * exp2a) * rr2;
                            double scale3 = 1.0;
                            double scale5 = 1.0;
                            double damp = pdi * pdk;
                            double pgamma = FastMath.min((double)pti, (double)ptk);
                            damp = -pgamma * (rdamp = r * damp) * rdamp * rdamp;
                            if (damp > -50.0) {
                                double expdamp = FastMath.exp((double)damp);
                                scale3 = 1.0 - expdamp;
                                scale5 = 1.0 - expdamp * (1.0 - damp);
                            }
                            double rr3 = rr1 * rr2;
                            double rr5 = 3.0 * rr3 * rr2;
                            rr3 *= 1.0 - scale3;
                            rr5 *= 1.0 - scale5;
                            double xr = dx[0];
                            double yr = dx[1];
                            double zr = dx[2];
                            double[] dipolek = inds[k];
                            double ukx = dipolek[0];
                            double uky = dipolek[1];
                            double ukz = dipolek[2];
                            double[] dipolepk = indCRs[k];
                            double pkx = dipolepk[0];
                            double pky = dipolepk[1];
                            double pkz = dipolepk[2];
                            double ukr = ukx * xr + uky * yr + ukz * zr;
                            double bn2ukr = bn2 * ukr;
                            double fimx = -bn1 * ukx + bn2ukr * xr;
                            double fimy = -bn1 * uky + bn2ukr * yr;
                            double fimz = -bn1 * ukz + bn2ukr * zr;
                            double rr5ukr = rr5 * ukr;
                            double fidx = -rr3 * ukx + rr5ukr * xr;
                            double fidy = -rr3 * uky + rr5ukr * yr;
                            double fidz = -rr3 * ukz + rr5ukr * zr;
                            fx += selfScale * (fimx - fidx);
                            fy += selfScale * (fimy - fidy);
                            fz += selfScale * (fimz - fidz);
                            double pkr = pkx * xr + pky * yr + pkz * zr;
                            double bn2pkr = bn2 * pkr;
                            double pimx = -bn1 * pkx + bn2pkr * xr;
                            double pimy = -bn1 * pky + bn2pkr * yr;
                            double pimz = -bn1 * pkz + bn2pkr * zr;
                            double rr5pkr = rr5 * pkr;
                            double pidx = -rr3 * pkx + rr5pkr * xr;
                            double pidy = -rr3 * pky + rr5pkr * yr;
                            double pidz = -rr3 * pkz + rr5pkr * zr;
                            px += selfScale * (pimx - pidx);
                            py += selfScale * (pimy - pidy);
                            pz += selfScale * (pimz - pidz);
                            double uir = uix * xr + uiy * yr + uiz * zr;
                            double bn2uir = bn2 * uir;
                            double fkmx = -bn1 * uix + bn2uir * xr;
                            double fkmy = -bn1 * uiy + bn2uir * yr;
                            double fkmz = -bn1 * uiz + bn2uir * zr;
                            double rr5uir = rr5 * uir;
                            double fkdx = -rr3 * uix + rr5uir * xr;
                            double fkdy = -rr3 * uiy + rr5uir * yr;
                            double fkdz = -rr3 * uiz + rr5uir * zr;
                            double xc = selfScale * (fkmx - fkdx);
                            double yc = selfScale * (fkmy - fkdy);
                            double zc = selfScale * (fkmz - fkdz);
                            double kx = xc * transOp[0][0] + yc * transOp[1][0] + zc * transOp[2][0];
                            double ky = xc * transOp[0][1] + yc * transOp[1][1] + zc * transOp[2][1];
                            double kz = xc * transOp[0][2] + yc * transOp[1][2] + zc * transOp[2][2];
                            this.this$1.this$0.field.add(this.threadID, k, kx, ky, kz);
                            double pir = pix * xr + piy * yr + piz * zr;
                            double bn2pir = bn2 * pir;
                            double pkmx = -bn1 * pix + bn2pir * xr;
                            double pkmy = -bn1 * piy + bn2pir * yr;
                            double pkmz = -bn1 * piz + bn2pir * zr;
                            double rr5pir = rr5 * pir;
                            double pkdx = -rr3 * pix + rr5pir * xr;
                            double pkdy = -rr3 * piy + rr5pir * yr;
                            double pkdz = -rr3 * piz + rr5pir * zr;
                            xc = selfScale * (pkmx - pkdx);
                            yc = selfScale * (pkmy - pkdy);
                            zc = selfScale * (pkmz - pkdz);
                            kx = xc * transOp[0][0] + yc * transOp[1][0] + zc * transOp[2][0];
                            ky = xc * transOp[0][1] + yc * transOp[1][1] + zc * transOp[2][1];
                            kz = xc * transOp[0][2] + yc * transOp[1][2] + zc * transOp[2][2];
                            this.this$1.this$0.fieldCR.add(this.threadID, k, kx, ky, kz);
                        }
                        this.this$1.this$0.field.add(this.threadID, i, fx, fy, fz);
                        this.this$1.this$0.fieldCR.add(this.threadID, i, px, py, pz);
                    }
                }
            }

            public IntegerSchedule schedule() {
                return this.this$1.this$0.realSpaceSchedule;
            }

            public void start() {
                this.threadID = this.getThreadIndex();
                this.x = this.this$1.this$0.coordinates[0][0];
                this.y = this.this$1.this$0.coordinates[0][1];
                this.z = this.this$1.this$0.coordinates[0][2];
                this.ind = this.this$1.this$0.inducedDipole[0];
                this.indCR = this.this$1.this$0.inducedDipoleCR[0];
            }

            public void finish() {
                int n = this.threadID;
                this.this$1.this$0.pmeTimings.realSpaceSCFTime[n] = this.this$1.this$0.pmeTimings.realSpaceSCFTime[n] + System.nanoTime();
            }
        }
    }
}

