/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.potential.bonded.Atom;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExpandInducedDipolesRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(ExpandInducedDipolesRegion.class.getName());
    private final ExpandInducedDipoleLoop[] expandInducedDipoleLoop;
    public double[][][] inducedDipole;
    public double[][][] inducedDipoleCR;
    private Atom[] atoms;
    private Crystal crystal;

    public ExpandInducedDipolesRegion(int maxThreads) {
        this.expandInducedDipoleLoop = new ExpandInducedDipoleLoop[maxThreads];
        for (int i = 0; i < maxThreads; ++i) {
            this.expandInducedDipoleLoop[i] = new ExpandInducedDipoleLoop(this);
        }
    }

    public void executeWith(ParallelTeam parallelTeam) {
        try {
            parallelTeam.execute((ParallelRegion)this);
        }
        catch (Exception e) {
            String message = " Exception expanding induced dipoles.\n";
            logger.log(Level.WARNING, message, e);
        }
    }

    public void init(Atom[] atoms, Crystal crystal, double[][][] inducedDipole, double[][][] inducedDipoleCR) {
        this.atoms = atoms;
        this.crystal = crystal;
        this.inducedDipole = inducedDipole;
        this.inducedDipoleCR = inducedDipoleCR;
    }

    public void run() {
        try {
            int nAtoms = this.atoms.length;
            this.execute(0, nAtoms - 1, this.expandInducedDipoleLoop[this.getThreadIndex()]);
        }
        catch (Exception e) {
            String message = "Fatal exception expanding coordinates in thread: " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private class ExpandInducedDipoleLoop
    extends IntegerForLoop {
        final /* synthetic */ ExpandInducedDipolesRegion this$0;

        private ExpandInducedDipoleLoop(ExpandInducedDipolesRegion expandInducedDipolesRegion) {
            ExpandInducedDipolesRegion expandInducedDipolesRegion2 = expandInducedDipolesRegion;
            Objects.requireNonNull(expandInducedDipolesRegion2);
            this.this$0 = expandInducedDipolesRegion2;
        }

        public void run(int lb, int ub) {
            List symOps = this.this$0.crystal.spaceGroup.symOps;
            int nSymm = symOps.size();
            for (int s = 1; s < nSymm; ++s) {
                SymOp symOp = (SymOp)symOps.get(s);
                for (int ii = lb; ii <= ub; ++ii) {
                    this.this$0.crystal.applySymRot(this.this$0.inducedDipole[0][ii], this.this$0.inducedDipole[s][ii], symOp);
                    this.this$0.crystal.applySymRot(this.this$0.inducedDipoleCR[0][ii], this.this$0.inducedDipoleCR[s][ii], symOp);
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }
    }
}

