/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import ffx.numerics.special.Erf;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import org.apache.commons.math3.util.FastMath;

public class EwaldParameters {
    public static final double DEFAULT_EWALD_CUTOFF = 7.0;
    private static final double SQRT_PI = FastMath.sqrt((double)Math.PI);
    public static final double DEFAULT_EWALD_COEFFICIENT = 0.545;
    @FFXProperty(name="ewald-alpha", propertyGroup=PropertyGroup.ParticleMeshEwald, defaultValue="0.545", description="Sets the value of the Ewald coefficient, which controls the width of the Gaussian screening charges during\nparticle mesh Ewald summation for multipole electrostatics. In the absence of the ewald-alpha keyword,\nthe default value is 0.545, which is appropriate for most applications.\n")
    public double aewald;
    public double aewald3;
    public double an0;
    public double an1;
    public double an2;
    public double an3;
    public double an4;
    public double an5;
    public double off;
    public double off2;

    public EwaldParameters(double cutoff, double aewald) {
        this.setEwaldParameters(cutoff, aewald);
    }

    public void setEwaldParameters(double off, double aewald) {
        this.off = off;
        this.aewald = aewald;
        this.off2 = off * off;
        double alsq2 = 2.0 * aewald * aewald;
        double piEwald = Double.POSITIVE_INFINITY;
        if (aewald > 0.0) {
            piEwald = 1.0 / (SQRT_PI * aewald);
        }
        this.aewald3 = 1.3333333333333333 * FastMath.pow((double)aewald, (double)3.0) / SQRT_PI;
        if (aewald > 0.0) {
            this.an0 = alsq2 * piEwald;
            this.an1 = alsq2 * this.an0;
            this.an2 = alsq2 * this.an1;
            this.an3 = alsq2 * this.an2;
            this.an4 = alsq2 * this.an3;
            this.an5 = alsq2 * this.an4;
        } else {
            this.an0 = 0.0;
            this.an1 = 0.0;
            this.an2 = 0.0;
            this.an3 = 0.0;
            this.an4 = 0.0;
            this.an5 = 0.0;
        }
    }

    private double ewaldCoefficient(double cutoff, double precision) {
        double eps = 1.0E-8;
        if (precision < 0.1) {
            eps = precision;
        }
        double ratio = eps + 1.0;
        double x = 0.5;
        int i = 0;
        while (ratio >= eps) {
            ++i;
            ratio = Erf.erfc((double)((x *= 2.0) * cutoff)) / cutoff;
        }
        int k = i + 60;
        double xlo = 0.0;
        double xhi = x;
        for (int j = 0; j < k; ++j) {
            x = (xlo + xhi) / 2.0;
            ratio = Erf.erfc((double)(x * cutoff)) / cutoff;
            if (ratio >= eps) {
                xlo = x;
                continue;
            }
            xhi = x;
        }
        return x;
    }

    public static double ewaldCutoff(double coeff, double maxCutoff, double eps) {
        double ratio = Erf.erfc((double)(coeff * maxCutoff)) / maxCutoff;
        if (ratio > eps) {
            return maxCutoff;
        }
        double xlo = 0.0;
        double xhi = maxCutoff;
        double cutoff = 0.0;
        for (int j = 0; j < 100; ++j) {
            cutoff = (xlo + xhi) / 2.0;
            ratio = Erf.erfc((double)(coeff * cutoff)) / cutoff;
            if (ratio >= eps) {
                xlo = cutoff;
                continue;
            }
            xhi = cutoff;
        }
        return cutoff;
    }
}

