/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.pme;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.GeneralizedKirkwood;
import ffx.potential.nonbonded.pme.EwaldParameters;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(DirectRegion.class.getName());
    private final DirectLoop[] directLoop;
    public double[][][] inducedDipole;
    public double[][][] inducedDipoleCR;
    public double[][] directDipole;
    public double[][] directDipoleCR;
    public double[][] directField;
    public double[][] directFieldCR;
    private Atom[] atoms;
    private double[] polarizability;
    private double[][][] globalMultipole;
    private double[][] cartMultipolePhi;
    private AtomicDoubleArray3D field;
    private AtomicDoubleArray3D fieldCR;
    private boolean generalizedKirkwoodTerm;
    private GeneralizedKirkwood generalizedKirkwood;
    private double aewald;
    private double aewald3;
    private double soluteDielectric;

    public DirectRegion(int nt) {
        this.directLoop = new DirectLoop[nt];
    }

    public void executeWith(ParallelTeam parallelTeam) {
        try {
            parallelTeam.execute((ParallelRegion)this);
        }
        catch (Exception e) {
            String message = " Exception computing direct induced dipoles.\n";
            logger.log(Level.WARNING, message, e);
        }
    }

    public void init(Atom[] atoms, double[] polarizability, double[][][] globalMultipole, double[][] cartMultipolePhi, AtomicDoubleArray3D field, AtomicDoubleArray3D fieldCR, boolean generalizedKirkwoodTerm, GeneralizedKirkwood generalizedKirkwood, EwaldParameters ewaldParameters, double soluteDielectric, double[][][] inducedDipole, double[][][] inducedDipoleCR, double[][] directDipole, double[][] directDipoleCR, double[][] directField, double[][] directFieldCR) {
        this.atoms = atoms;
        this.polarizability = polarizability;
        this.globalMultipole = globalMultipole;
        this.cartMultipolePhi = cartMultipolePhi;
        this.field = field;
        this.fieldCR = fieldCR;
        this.generalizedKirkwoodTerm = generalizedKirkwoodTerm;
        this.generalizedKirkwood = generalizedKirkwood;
        this.aewald = ewaldParameters.aewald;
        this.aewald3 = ewaldParameters.aewald3;
        this.soluteDielectric = soluteDielectric;
        this.inducedDipole = inducedDipole;
        this.inducedDipoleCR = inducedDipoleCR;
        this.directDipole = directDipole;
        this.directDipoleCR = directDipoleCR;
        this.directField = directField;
        this.directFieldCR = directFieldCR;
    }

    public void run() throws Exception {
        int ti = this.getThreadIndex();
        if (this.directLoop[ti] == null) {
            this.directLoop[ti] = new DirectLoop(this);
        }
        try {
            int nAtoms = this.atoms.length;
            this.execute(0, nAtoms - 1, this.directLoop[ti]);
        }
        catch (Exception e) {
            String message = "Fatal exception computing the direct induced dipoles in thread " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private class DirectLoop
    extends IntegerForLoop {
        final /* synthetic */ DirectRegion this$0;

        private DirectLoop(DirectRegion directRegion) {
            DirectRegion directRegion2 = directRegion;
            Objects.requireNonNull(directRegion2);
            this.this$0 = directRegion2;
        }

        public void run(int lb, int ub) throws Exception {
            int threadID = this.getThreadIndex();
            if (this.this$0.aewald > 0.0) {
                for (int i = lb; i <= ub; ++i) {
                    double[] mpolei = this.this$0.globalMultipole[0][i];
                    double[] phii = this.this$0.cartMultipolePhi[i];
                    double fx = this.this$0.aewald3 * mpolei[1] - phii[1];
                    double fy = this.this$0.aewald3 * mpolei[2] - phii[2];
                    double fz = this.this$0.aewald3 * mpolei[3] - phii[3];
                    this.this$0.field.add(threadID, i, fx, fy, fz);
                    this.this$0.fieldCR.add(threadID, i, fx, fy, fz);
                }
            }
            this.this$0.field.reduce(lb, ub);
            this.this$0.fieldCR.reduce(lb, ub);
            if (this.this$0.soluteDielectric > 1.0) {
                double inverseDielectric = 1.0 / this.this$0.soluteDielectric;
                for (int i = lb; i <= ub; ++i) {
                    this.this$0.field.scale(0, i, inverseDielectric);
                    this.this$0.fieldCR.scale(0, i, inverseDielectric);
                }
            }
            if (this.this$0.generalizedKirkwoodTerm) {
                AtomicDoubleArray3D fieldGK = this.this$0.generalizedKirkwood.getFieldGK();
                for (int i = lb; i <= ub; ++i) {
                    double fx = fieldGK.getX(i);
                    double fy = fieldGK.getY(i);
                    double fz = fieldGK.getZ(i);
                    this.this$0.field.add(0, i, fx, fy, fz);
                    this.this$0.fieldCR.add(0, i, fx, fy, fz);
                }
            }
            double[][] induced0 = this.this$0.inducedDipole[0];
            double[][] inducedCR0 = this.this$0.inducedDipoleCR[0];
            for (int i = lb; i <= ub; ++i) {
                double polar = this.this$0.polarizability[i];
                double[] ind = induced0[i];
                double[] directi = this.this$0.directDipole[i];
                this.this$0.directField[i][0] = this.this$0.field.getX(i);
                this.this$0.directField[i][1] = this.this$0.field.getY(i);
                this.this$0.directField[i][2] = this.this$0.field.getZ(i);
                ind[0] = polar * this.this$0.directField[i][0];
                ind[1] = polar * this.this$0.directField[i][1];
                ind[2] = polar * this.this$0.directField[i][2];
                directi[0] = ind[0];
                directi[1] = ind[1];
                directi[2] = ind[2];
                double[] indCR = inducedCR0[i];
                double[] directCRi = this.this$0.directDipoleCR[i];
                this.this$0.directFieldCR[i][0] = this.this$0.fieldCR.getX(i);
                this.this$0.directFieldCR[i][1] = this.this$0.fieldCR.getY(i);
                this.this$0.directFieldCR[i][2] = this.this$0.fieldCR.getZ(i);
                indCR[0] = polar * this.this$0.directFieldCR[i][0];
                indCR[1] = polar * this.this$0.directFieldCR[i][1];
                indCR[2] = polar * this.this$0.directFieldCR[i][2];
                directCRi[0] = indCR[0];
                directCRi[1] = indCR[1];
                directCRi[2] = indCR[2];
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }
    }
}

