/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.octree;

import java.util.ArrayList;

public class OctreeCell {
    private int nCritical;
    private int numLeaves = 0;
    private ArrayList<Integer> leaves = new ArrayList();
    private int nChild = 0;
    private int[] children = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int parentIndex = 0;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private double r = 0.0;
    private double[] multipole = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

    public OctreeCell(int nCritical) {
        this.setnCritical(nCritical);
    }

    public void addToMultipole(double[] calculatedMultipole) {
        for (int i = 0; i < 10; ++i) {
            int n = i;
            this.multipole[n] = this.multipole[n] + calculatedMultipole[i];
        }
    }

    public int getChildAtIndex(int octant) {
        return this.children[octant];
    }

    public int getLeavesValueAtIndex(int index) {
        return this.leaves.get(index);
    }

    public double[] getMultipole() {
        return this.multipole;
    }

    public int getNumLeaves() {
        return this.numLeaves;
    }

    public void setNumLeaves(int num) {
        this.numLeaves = num;
    }

    public int getParentIndex() {
        return this.parentIndex;
    }

    public void setParentIndex(int p) {
        this.parentIndex = p;
    }

    public double getR() {
        return this.r;
    }

    public void setR(double r) {
        this.r = r;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public int getnChild() {
        return this.nChild;
    }

    public void setnChild(int num) {
        this.nChild = num;
    }

    public void setChildren(int octant, int c) {
        this.children[octant] = c;
    }

    public void setLeaf(int index, int leaf) {
        this.leaves.set(index, leaf);
    }

    public void setnCritical(int nCrit) {
        this.nCritical = nCrit;
    }
}

