/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.octree;

import ffx.potential.nonbonded.octree.OctreeCell;
import ffx.potential.nonbonded.octree.OctreeParticle;
import ffx.potential.nonbonded.octree.OctreePoint;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.commons.lang3.BooleanUtils;

public class Octree {
    private static final Logger logger = Logger.getLogger(Octree.class.getName());
    private final ArrayList<OctreeCell> leaves = new ArrayList();
    private final int nCritical;
    private final ArrayList<OctreeParticle> particles;
    private final double theta;
    private ArrayList<OctreeCell> cells = new ArrayList();

    public Octree(ArrayList<OctreeParticle> particles) {
        this.particles = particles;
        this.nCritical = 10;
        this.theta = 0.5;
    }

    public Octree(int nCritical, ArrayList<OctreeParticle> particles) {
        this.nCritical = nCritical;
        this.particles = particles;
        this.theta = 0.5;
    }

    public Octree(int nCritical, ArrayList<OctreeParticle> particles, double theta) {
        this.nCritical = nCritical;
        this.particles = particles;
        this.theta = theta;
    }

    public void addChild(int octant, int p) {
        OctreeCell tempCell = new OctreeCell(this.nCritical);
        this.cells.add(tempCell);
        int c = this.cells.size() - 1;
        this.cells.get(c).setR(this.cells.get(p).getR() * 0.5);
        this.cells.get(c).setX(this.cells.get(p).getX() * (double)((octant & 1) * 2 - 1));
        this.cells.get(c).setY(this.cells.get(p).getY() * (double)((octant & 2) - 1));
        this.cells.get(c).setZ(this.cells.get(p).getZ() * ((double)(octant & 4) * 0.5 - 1.0));
        this.cells.get(c).setParentIndex(p);
        this.cells.get(c).setChildren(octant, c);
        this.cells.get(c).setnChild(this.cells.get(p).getnChild() | 1 << octant);
    }

    public void buildTree(OctreeCell root) {
        this.cells = new ArrayList();
        this.cells.add(root);
        int n = this.particles.size();
        for (int i = 0; i < n; ++i) {
            int current = 0;
            while (this.cells.get(current).getNumLeaves() >= this.nCritical) {
                this.cells.get(current).setNumLeaves(this.cells.get(current).getNumLeaves() + 1);
                int octX = 0;
                int octY = 0;
                int octZ = 0;
                if (this.particles.get(i).getX() > this.cells.get(current).getX()) {
                    octX = 1;
                }
                if (this.particles.get(i).getY() > this.cells.get(current).getY()) {
                    octY = 1;
                }
                if (this.particles.get(i).getZ() > this.cells.get(current).getZ()) {
                    octZ = 1;
                }
                int octant = octX + (octY << 1) + (octZ << 2);
                boolean noChildInOctant = BooleanUtils.toBoolean((int)(this.cells.get(current).getnChild() & 1 << octant));
                if (noChildInOctant) {
                    this.addChild(octant, current);
                }
                current = this.cells.get(current).getChildAtIndex(octant);
            }
            this.cells.get(current).setLeaf(this.cells.get(current).getNumLeaves(), i);
            this.cells.get(current).setNumLeaves(this.cells.get(current).getNumLeaves() + 1);
            if (this.cells.get(current).getNumLeaves() < this.nCritical) continue;
            this.splitCell(current);
        }
    }

    public void directSum() {
        for (int i = 0; i < this.particles.size(); ++i) {
            for (int j = 0; j < this.particles.size(); ++j) {
                if (j == i) continue;
                double r = this.particles.get(i).distance(this.particles.get(j));
                this.particles.get(j).addToPhi(this.particles.get(j).getCharge() / r);
            }
        }
        for (OctreeParticle particle : this.particles) {
            particle.addToPhi(0.0);
        }
    }

    public double distance(double[] array, OctreePoint point) {
        return Math.sqrt(Math.pow(array[0] - point.getX(), 2.0) + Math.pow(array[1] - point.getY(), 2.0) + Math.pow(array[2] - point.getZ(), 2.0));
    }

    public void evalPotnetial() {
        for (int i = 0; i < this.particles.size(); ++i) {
            this.evalAtTarget(0, i);
        }
    }

    public void l2Error(double[] phiDirect, double[] phiTree) {
        double errorSumNum = 0.0;
        double errorSumDenom = 0.0;
        for (int i = 0; i < phiDirect.length; ++i) {
            errorSumNum += Math.pow(phiDirect[i] - phiTree[i], 2.0);
            errorSumDenom += Math.pow(phiDirect[i], 2.0);
        }
        double error = Math.sqrt(errorSumNum / errorSumDenom);
        logger.info("L2 Norm Error: " + error);
    }

    public void upwardSweep() {
        for (int c = this.cells.size() - 1; c > 0; --c) {
            int p = this.cells.get(c).getParentIndex();
            this.M2M(p, c);
        }
    }

    private void splitCell(int p) {
        for (int i = 0; i < this.nCritical; ++i) {
            int octX = 0;
            int octY = 0;
            int octZ = 0;
            if (this.particles.get(i).getX() > this.cells.get(p).getX()) {
                octX = 1;
            }
            if (this.particles.get(i).getY() > this.cells.get(p).getY()) {
                octY = 1;
            }
            if (this.particles.get(i).getZ() > this.cells.get(p).getZ()) {
                octZ = 1;
            }
            int octant = octX + (octY << 1) + (octZ << 2);
            boolean noChildInOctant = BooleanUtils.toBoolean((int)(this.cells.get(p).getnChild() & 1 << octant));
            if (noChildInOctant) {
                this.addChild(octant, p);
            }
            int c = this.cells.get(p).getChildAtIndex(octant);
            this.cells.get(c).setLeaf(this.cells.get(c).getNumLeaves(), 1);
            this.cells.get(c).setNumLeaves(this.cells.get(c).getNumLeaves() + 1);
            if (this.cells.get(c).getNumLeaves() < this.nCritical) continue;
            this.splitCell(c);
        }
    }

    private void getMultipole(int p, ArrayList<Integer> leaves) {
        if (this.cells.get(p).getNumLeaves() >= this.nCritical) {
            for (int c = 0; c < 8; ++c) {
                if (!BooleanUtils.toBoolean((int)(this.cells.get(p).getnChild() & 1 << c))) continue;
                this.getMultipole(this.cells.get(p).getChildAtIndex(c), leaves);
            }
        } else {
            for (int i = 0; i < this.cells.get(p).getNumLeaves(); ++i) {
                int l = this.cells.get(p).getLeavesValueAtIndex(i);
                double dx = this.cells.get(p).getX() - this.particles.get(l).getX();
                double dy = this.cells.get(p).getY() - this.particles.get(l).getY();
                double dz = this.cells.get(p).getZ() - this.particles.get(l).getZ();
                double charge = this.particles.get(l).getCharge();
                double[] calculatedMultipole = new double[]{charge, dx * charge, dy * charge, dz * charge, Math.pow(dx, 2.0) * 0.5 * charge, Math.pow(dy, 2.0) * 0.5 * charge, Math.pow(dz, 2.0) * 0.5 * charge, dx * dy * 0.5 * charge, dy * dz * 0.5 * charge, dz * dx * 0.5 * charge};
                this.cells.get(p).addToMultipole(calculatedMultipole);
                leaves.add(p);
            }
        }
    }

    private void M2M(int p, int c) {
        double dx = this.cells.get(p).getX() - this.cells.get(c).getX();
        double dy = this.cells.get(p).getY() - this.cells.get(c).getY();
        double dz = this.cells.get(p).getZ() - this.cells.get(c).getZ();
        double[] Dxyz = new double[]{dx, dy, dz};
        double[] Dyzx = new double[]{dy, dz, dx};
        this.cells.get(p).addToMultipole(this.cells.get(c).getMultipole());
        double[] currentChildMultipole = this.cells.get(c).getMultipole();
        double[] additionalMultipoleTerms = new double[]{0.0, currentChildMultipole[0] * Dxyz[0], currentChildMultipole[0] * Dxyz[1], currentChildMultipole[0] * Dxyz[2], currentChildMultipole[1] * Dxyz[0] + 0.5 * currentChildMultipole[0] * Math.pow(Dxyz[0], 2.0), currentChildMultipole[2] * Dxyz[1] + 0.5 * currentChildMultipole[0] * Math.pow(Dxyz[1], 2.0), currentChildMultipole[3] * Dxyz[2] + 0.5 * currentChildMultipole[0] * Math.pow(Dxyz[2], 2.0), 0.5 * currentChildMultipole[2] * Dyzx[0] + 0.5 * currentChildMultipole[1] * Dxyz[0] + 0.5 * currentChildMultipole[0] * Dxyz[0] * Dyzx[0], 0.5 * currentChildMultipole[3] * Dyzx[1] + 0.5 * currentChildMultipole[2] * Dxyz[1] + 0.5 * currentChildMultipole[0] * Dxyz[1] * Dyzx[1], 0.5 * currentChildMultipole[1] * Dyzx[2] + 0.5 * currentChildMultipole[3] * Dxyz[2] + 0.5 * currentChildMultipole[0] * Dxyz[2] * Dyzx[2]};
        this.cells.get(p).addToMultipole(additionalMultipoleTerms);
    }

    private void evalAtTarget(int p, int i) {
        if (this.cells.get(p).getNumLeaves() >= this.nCritical) {
            for (int oct = 0; oct < 8; ++oct) {
                if (BooleanUtils.toBoolean((int)(this.cells.get(p).getnChild() & 1 << oct))) {
                    int c = this.cells.get(p).getChildAtIndex(oct);
                    double r = this.particles.get(i).distance(this.cells.get(c));
                    if (this.cells.get(c).getR() > this.theta * r) {
                        this.evalAtTarget(c, i);
                        continue;
                    }
                    double dx = this.particles.get(i).getX() - this.cells.get(c).getX();
                    double dy = this.particles.get(i).getY() - this.cells.get(c).getY();
                    double dz = this.particles.get(i).getZ() - this.cells.get(c).getZ();
                    double r3 = Math.pow(r, 3.0);
                    double r5 = r3 * Math.pow(r, 2.0);
                    double[] weight = new double[]{1.0 / r, -dx / r3, -dy / r3, -dz / r3, 3.0 * Math.pow(dx, 2.0) / r5 - 1.0 / r3, 3.0 * Math.pow(dy, 2.0) / r5 - 1.0 / r3, 3.0 * Math.pow(dz, 2.0) / r5 - 1.0 / r3, 3.0 * dx * dy / r5, 3.0 * dy * dz / r5, 3.0 * dz * dx / r5};
                    double dotProduct = 0.0;
                    for (int d = 0; d < weight.length; ++d) {
                        double[] multipoleArray = this.cells.get(c).getMultipole();
                        dotProduct += multipoleArray[d] * weight[d];
                    }
                    this.particles.get(i).addToPhi(dotProduct);
                    continue;
                }
                for (int j = 0; j < this.cells.get(p).getNumLeaves(); ++j) {
                    OctreeParticle source = this.particles.get(this.cells.get(p).getLeavesValueAtIndex(j));
                    double r = this.particles.get(i).distance(source);
                    if (r == 0.0) continue;
                    this.particles.get(i).addToPhi(source.getCharge() / r);
                }
            }
        }
    }
}

