/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.implicit;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.reduction.SharedBooleanArray;
import edu.rit.pj.reduction.SharedDouble;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Residue;
import ffx.potential.parameters.VDWType;
import ffx.potential.utils.EnergyException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class SurfaceAreaRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(SurfaceAreaRegion.class.getName());
    private static final double delta = 1.0E-8;
    private static final double delta2 = 1.0000000000000001E-16;
    private final Atom[] atoms;
    private final int nAtoms;
    private final int[][][] neighborLists;
    private final double[] x;
    private final double[] y;
    private final double[] z;
    private final boolean[] use;
    private final InitLoop[] initLoop;
    private final AtomOverlapLoop[] atomOverlapLoop;
    private final SurfaceAreaLoop[] surfaceAreaLoop;
    private final SharedDouble sharedSurfaceArea;
    private final double probe;
    private final int MAXARC = 1000;
    private SharedBooleanArray skip;
    private AtomicDoubleArray3D grad;
    private int[][] overlaps;
    private Integer[] overlapCounts;
    private double[][] overlapDX;
    private double[][] overlapDY;
    private double[][] overlapDZ;
    private double[][] overlapXY2;
    private double[][] overlapR2;
    private double[][] overlapR;
    private IndexedDouble[][] gr;
    private boolean[] buried;
    private double[] area;
    private double[] r;
    private double surfaceTension;

    public SurfaceAreaRegion(Atom[] atoms, double[] x, double[] y, double[] z, boolean[] use, int[][][] neighborLists, AtomicDoubleArray3D grad, int nt, double probe, double surfaceTension) {
        this.atoms = atoms;
        this.nAtoms = atoms.length;
        this.x = x;
        this.y = y;
        this.z = z;
        this.use = use;
        this.neighborLists = neighborLists;
        this.probe = probe;
        this.grad = grad;
        this.surfaceTension = surfaceTension;
        this.atomOverlapLoop = new AtomOverlapLoop[nt];
        this.surfaceAreaLoop = new SurfaceAreaLoop[nt];
        this.initLoop = new InitLoop[nt];
        for (int i = 0; i < nt; ++i) {
            this.atomOverlapLoop[i] = new AtomOverlapLoop(this);
            this.surfaceAreaLoop[i] = new SurfaceAreaLoop(this);
            this.initLoop[i] = new InitLoop(this);
        }
        this.sharedSurfaceArea = new SharedDouble();
        this.init();
    }

    public void finish() {
        if (logger.isLoggable(Level.FINE)) {
            int n = this.initLoop.length;
            long initTime = 0L;
            long overlapTime = 0L;
            long cavTime = 0L;
            for (int i = 0; i < n; ++i) {
                initTime = FastMath.max((long)this.initLoop[i].time, (long)initTime);
                overlapTime = FastMath.max((long)this.atomOverlapLoop[i].time, (long)overlapTime);
                cavTime = FastMath.max((long)this.surfaceAreaLoop[i].time, (long)cavTime);
            }
            logger.fine(String.format(" Cavitation Init: %10.3f Overlap: %10.3f Cav:  %10.3f", (double)initTime * 1.0E-9, (double)overlapTime * 1.0E-9, (double)cavTime * 1.0E-9));
        }
    }

    public double getEnergy() {
        return this.sharedSurfaceArea.get();
    }

    public double[] getArea() {
        return this.area;
    }

    public double getResidueSurfaceArea(Residue residue) {
        List<Atom> atoms = residue.getAtomList();
        double residueArea = 0.0;
        for (Atom atom : atoms) {
            int i = atom.getXyzIndex() - 1;
            residueArea += this.area[i];
        }
        return residueArea;
    }

    public final void init() {
        if (this.overlapCounts == null || this.overlapCounts.length < this.nAtoms) {
            this.overlapCounts = new Integer[this.nAtoms];
            this.overlapDX = new double[this.nAtoms][1000];
            this.overlapDY = new double[this.nAtoms][1000];
            this.overlapDZ = new double[this.nAtoms][1000];
            this.overlapXY2 = new double[this.nAtoms][1000];
            this.overlapR2 = new double[this.nAtoms][1000];
            this.overlapR = new double[this.nAtoms][1000];
            this.gr = new IndexedDouble[this.nAtoms][1000];
            this.overlaps = new int[this.nAtoms][1000];
            this.buried = new boolean[this.nAtoms];
            this.skip = new SharedBooleanArray(this.nAtoms);
            this.area = new double[this.nAtoms];
            this.r = new double[this.nAtoms];
        }
        for (int i = 0; i < this.nAtoms; ++i) {
            VDWType type = this.atoms[i].getVDWType();
            double rmini = type.radius;
            this.r[i] = rmini / 2.0;
            if (this.r[i] != 0.0) {
                this.r[i] = this.r[i] + this.probe;
            }
            this.skip.set(i, true);
        }
    }

    public void run() {
        try {
            this.execute(0, this.nAtoms - 1, this.initLoop[this.getThreadIndex()]);
            this.execute(0, this.nAtoms - 1, this.atomOverlapLoop[this.getThreadIndex()]);
            this.execute(0, this.nAtoms - 1, this.surfaceAreaLoop[this.getThreadIndex()]);
        }
        catch (Exception e) {
            String message = "Fatal exception computing Cavitation energy in thread " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void setSurfaceTension(double surfaceTension) {
        this.surfaceTension = surfaceTension;
    }

    public void start() {
        this.sharedSurfaceArea.set(0.0);
    }

    private class AtomOverlapLoop
    extends IntegerForLoop {
        public long time;
        final /* synthetic */ SurfaceAreaRegion this$0;

        private AtomOverlapLoop(SurfaceAreaRegion surfaceAreaRegion) {
            SurfaceAreaRegion surfaceAreaRegion2 = surfaceAreaRegion;
            Objects.requireNonNull(surfaceAreaRegion2);
            this.this$0 = surfaceAreaRegion2;
        }

        public void finish() {
            this.time += System.nanoTime();
        }

        public void run(int lb, int ub) {
            for (int i = lb; i <= ub; ++i) {
                int[] list;
                if (this.this$0.skip.get(i) || !this.this$0.use[i]) continue;
                for (int k : list = this.this$0.neighborLists[0][i]) {
                    if (k == i) continue;
                    this.pair(i, k);
                    if (this.this$0.skip.get(k) && this.this$0.use[k]) continue;
                    this.pair(k, i);
                }
            }
        }

        public void start() {
            this.time = -System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pair(int i, int k) {
            double r2;
            double dr;
            double xi = this.this$0.x[i];
            double yi = this.this$0.y[i];
            double zi = this.this$0.z[i];
            double rri = this.this$0.r[i];
            double rplus = rri + this.this$0.r[k];
            double dx = this.this$0.x[k] - xi;
            double dy = this.this$0.y[k] - yi;
            double dz = this.this$0.z[k] - zi;
            if (FastMath.abs((double)dx) >= rplus || FastMath.abs((double)dy) >= rplus || FastMath.abs((double)dz) >= rplus) {
                return;
            }
            double xysq = dx * dx + dy * dy;
            if (xysq < 1.0000000000000001E-16) {
                dx = 1.0E-8;
                dy = 0.0;
                xysq = 1.0000000000000001E-16;
            }
            if (rplus - (dr = FastMath.sqrt((double)(r2 = xysq + dz * dz))) <= 1.0E-8) {
                return;
            }
            double rminus = rri - this.this$0.r[k];
            int[] nArray = this.this$0.overlaps[i];
            synchronized (nArray) {
                if (dr - FastMath.abs((double)rminus) <= 1.0E-8) {
                    if (rminus <= 0.0) {
                        this.this$0.buried[i] = true;
                    }
                    return;
                }
                int n = this.this$0.overlapCounts[i];
                this.this$0.overlaps[i][n] = k;
                this.this$0.overlapDX[i][n] = dx;
                this.this$0.overlapDY[i][n] = dy;
                this.this$0.overlapDZ[i][n] = dz;
                this.this$0.overlapXY2[i][n] = xysq;
                this.this$0.overlapR2[i][n] = r2;
                this.this$0.overlapR[i][n] = dr;
                double rri2 = 2.0 * rri;
                this.this$0.gr[i][n] = new IndexedDouble((r2 + rplus * rminus) / (rri2 * this.this$0.overlapR[i][n]), n);
                Integer[] integerArray = this.this$0.overlapCounts;
                int n2 = i;
                Integer n3 = integerArray[n2];
                integerArray[n2] = integerArray[n2] + 1;
                if (this.this$0.overlapCounts[i] >= 1000) {
                    throw new EnergyException(String.format(" Increase the value of MAXARC to (%d).", this.this$0.overlapCounts[i]));
                }
            }
        }
    }

    private class SurfaceAreaLoop
    extends IntegerForLoop {
        private static final double pix2 = Math.PI * 2;
        private static final double pix4 = Math.PI * 4;
        private static final double pid2 = 1.5707963267948966;
        private static final double eps = 1.0E-8;
        public long time;
        private double localSurfaceEnergy;
        private IndexedDouble[] arci;
        private boolean[] omit;
        private double[] xc;
        private double[] yc;
        private double[] zc;
        private double[] dsq;
        private double[] b;
        private double[] bsq;
        private double[] bg;
        private double[] risq;
        private double[] ri;
        private double[] ther;
        private double[] ider;
        private double[] sign_yder;
        private double[] arcf;
        private double[] ex;
        private double[] ux;
        private double[] uy;
        private double[] uz;
        private int[] kent;
        private int[] kout;
        private int[] intag;
        private int[] lt;
        private int i;
        private int j;
        private int ib;
        private int threadID;
        final /* synthetic */ SurfaceAreaRegion this$0;

        SurfaceAreaLoop(SurfaceAreaRegion surfaceAreaRegion) {
            SurfaceAreaRegion surfaceAreaRegion2 = surfaceAreaRegion;
            Objects.requireNonNull(surfaceAreaRegion2);
            this.this$0 = surfaceAreaRegion2;
            this.allocateMemory(1000);
        }

        public void finish() {
            this.this$0.sharedSurfaceArea.addAndGet(this.localSurfaceEnergy);
            this.time += System.nanoTime();
        }

        public void run(int lb, int ub) {
            for (int ir = lb; ir <= ub; ++ir) {
                if (this.this$0.skip.get(ir) || !this.this$0.use[ir] || this.this$0.buried[this.i]) continue;
                double rri = this.this$0.r[ir];
                double rri2 = 2.0 * rri;
                double rrisq = rri * rri;
                this.surface(rri, rri2, rrisq, this.this$0.surfaceTension, false, ir);
                if (this.this$0.area[ir] < 0.0) {
                    logger.log(Level.WARNING, String.format(" Negative surface area set to 0 for atom %d.", ir));
                    this.this$0.area[ir] = 0.0;
                }
                int n = ir;
                this.this$0.area[n] = this.this$0.area[n] * (rrisq * this.this$0.surfaceTension);
                this.localSurfaceEnergy += this.this$0.area[ir];
            }
        }

        public void start() {
            this.time = -System.nanoTime();
            this.threadID = this.getThreadIndex();
            this.localSurfaceEnergy = 0.0;
            Arrays.fill(this.ider, 0.0);
            Arrays.fill(this.sign_yder, 0.0);
        }

        public void surface(double rri, double rri2, double rrisq, double wght, boolean moved, int ir) {
            int k;
            this.ib = 0;
            int jb = 0;
            double arcLength = 0.0;
            double exang = 0.0;
            if (this.this$0.overlapCounts[ir] == 0) {
                this.this$0.area[ir] = Math.PI * 4;
                return;
            }
            if (this.this$0.overlapCounts[ir] == 1) {
                double dx = this.this$0.overlapDX[ir][0];
                double dy = this.this$0.overlapDY[ir][0];
                double dz = this.this$0.overlapDZ[ir][0];
                double r2 = this.this$0.overlapR2[ir][0];
                double rr = this.this$0.overlapR[ir][0];
                double arcsum = Math.PI * 2;
                ++this.ib;
                arcLength += this.this$0.gr[ir][0].value * arcsum;
                if (!moved) {
                    int k2 = this.this$0.overlaps[ir][0];
                    double t1 = arcsum * rrisq * (r2 - rrisq + this.this$0.r[k2] * this.this$0.r[k2]) / (rri2 * r2 * rr);
                    double gx = dx * t1 * wght;
                    double gy = dy * t1 * wght;
                    double gz = dz * t1 * wght;
                    this.this$0.grad.sub(this.threadID, ir, gx, gy, gz);
                    this.this$0.grad.add(this.threadID, k2, gx, gy, gz);
                }
                this.this$0.area[ir] = (double)this.ib * (Math.PI * 2) + exang + arcLength;
                this.this$0.area[ir] = this.this$0.area[ir] % (Math.PI * 4);
                return;
            }
            Arrays.sort(this.this$0.gr[ir], 0, (int)this.this$0.overlapCounts[ir]);
            for (int j = 0; j < this.this$0.overlapCounts[ir]; ++j) {
                int k3 = this.this$0.gr[ir][j].key;
                this.intag[j] = this.this$0.overlaps[ir][k3];
                this.xc[j] = this.this$0.overlapDX[ir][k3];
                this.yc[j] = this.this$0.overlapDY[ir][k3];
                this.zc[j] = this.this$0.overlapDZ[ir][k3];
                this.dsq[j] = this.this$0.overlapXY2[ir][k3];
                this.b[j] = this.this$0.overlapR[ir][k3];
                this.bsq[j] = this.this$0.overlapR2[ir][k3];
                this.omit[j] = false;
            }
            for (int i = 0; i < this.this$0.overlapCounts[ir]; ++i) {
                double gi = this.this$0.gr[ir][i].value * rri;
                this.bg[i] = this.b[i] * gi;
                this.risq[i] = rrisq - gi * gi;
                this.ri[i] = FastMath.sqrt((double)this.risq[i]);
                this.ther[i] = 1.5707963267948966 - FastMath.asin((double)FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)this.this$0.gr[ir][i].value)));
            }
            for (k = 0; k < this.this$0.overlapCounts[ir] - 1; ++k) {
                if (this.omit[k]) continue;
                double txk = this.xc[k];
                double tyk = this.yc[k];
                double tzk = this.zc[k];
                double bk = this.b[k];
                double therk = this.ther[k];
                this.j = k + 1;
                while (this.j < this.this$0.overlapCounts[ir]) {
                    if (!this.omit[this.j]) {
                        double td;
                        double cc = (txk * this.xc[this.j] + tyk * this.yc[this.j] + tzk * this.zc[this.j]) / (bk * this.b[this.j]);
                        if (!((cc = FastMath.acos((double)FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)cc)))) >= (td = therk + this.ther[this.j]))) {
                            if (cc + this.ther[this.j] < therk) {
                                this.omit[this.j] = true;
                            } else if (cc > 1.0E-8 && Math.PI * 2 - cc <= td) {
                                this.this$0.area[ir] = 0.0;
                                return;
                            }
                        }
                    }
                    ++this.j;
                }
            }
            for (k = 0; k < this.this$0.overlapCounts[ir]; ++k) {
                int l;
                double arcsum;
                if (this.omit[k]) continue;
                boolean komit = this.omit[k];
                this.omit[k] = true;
                int narc = 0;
                boolean top = false;
                double txk = this.xc[k];
                double tyk = this.yc[k];
                double tzk = this.zc[k];
                double dk = FastMath.sqrt((double)this.dsq[k]);
                double bsqk = this.bsq[k];
                double bk = this.b[k];
                double gk = this.this$0.gr[ir][k].value * rri;
                double risqk = this.risq[k];
                double rik = this.ri[k];
                double therk = this.ther[k];
                double t1 = tzk / (bk * dk);
                double axx = txk * t1;
                double axy = tyk * t1;
                double axz = dk / bk;
                double ayx = tyk / dk;
                double ayy = txk / dk;
                double azx = txk / bk;
                double azy = tyk / bk;
                double azz = tzk / bk;
                for (int l2 = 0; l2 < this.this$0.overlapCounts[ir]; ++l2) {
                    double tf;
                    double ti;
                    if (this.omit[l2]) continue;
                    double txl = this.xc[l2];
                    double tyl = this.yc[l2];
                    double tzl = this.zc[l2];
                    double uxl = txl * axx + tyl * axy - tzl * axz;
                    double uyl = tyl * ayy - txl * ayx;
                    double uzl = txl * azx + tyl * azy + tzl * azz;
                    double cosine = FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)(uzl / this.b[l2])));
                    if (!(FastMath.acos((double)cosine) < therk + this.ther[l2])) continue;
                    double dsql = uxl * uxl + uyl * uyl;
                    double tb = uzl * gk - this.bg[l2];
                    double txb = uxl * tb;
                    double tyb = uyl * tb;
                    double td = rik * dsql;
                    double tr2 = risqk * dsql - tb * tb;
                    tr2 = FastMath.max((double)1.0E-8, (double)tr2);
                    double tr = FastMath.sqrt((double)tr2);
                    double txr = uxl * tr;
                    double tyr = uyl * tr;
                    tb = (txb + tyr) / td;
                    tb = FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)tb));
                    double tk1 = FastMath.acos((double)tb);
                    if (tyb - txr < 0.0) {
                        tk1 = Math.PI * 2 - tk1;
                    }
                    tb = (txb - tyr) / td;
                    tb = FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)tb));
                    double tk2 = FastMath.acos((double)tb);
                    if (tyb + txr < 0.0) {
                        tk2 = Math.PI * 2 - tk2;
                    }
                    double thec = (rrisq * uzl - gk * this.bg[l2]) / (rik * this.ri[l2] * this.b[l2]);
                    double the = 0.0;
                    if (FastMath.abs((double)thec) < 1.0) {
                        the = -FastMath.acos((double)thec);
                    } else if (thec >= 1.0) {
                        the = 0.0;
                    } else if (thec <= -1.0) {
                        the = -Math.PI;
                    }
                    cosine = FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)((uzl * gk - uxl * rik) / (this.b[l2] * rri))));
                    if ((FastMath.acos((double)cosine) - this.ther[l2]) * (tk2 - tk1) <= 0.0) {
                        ti = tk2;
                        tf = tk1;
                    } else {
                        ti = tk1;
                        tf = tk2;
                    }
                    if (++narc > 1000) {
                        throw new EnergyException(String.format(" Increase value of MAXARC %d.", narc));
                    }
                    int narc1 = narc - 1;
                    if (tf <= ti) {
                        this.arcf[narc1] = tf;
                        this.arci[narc1] = new IndexedDouble(0.0, narc1);
                        tf = Math.PI * 2;
                        this.lt[narc1] = l2;
                        this.ex[narc1] = the;
                        top = true;
                        narc1 = ++narc - 1;
                    }
                    this.arcf[narc1] = tf;
                    this.arci[narc1] = new IndexedDouble(ti, narc1);
                    this.lt[narc1] = l2;
                    this.ex[narc1] = the;
                    this.ux[l2] = uxl;
                    this.uy[l2] = uyl;
                    this.uz[l2] = uzl;
                }
                this.omit[k] = komit;
                if (narc <= 0) {
                    arcsum = Math.PI * 2;
                    ++this.ib;
                    arcLength += this.this$0.gr[ir][k].value * arcsum;
                    if (moved) continue;
                    int in = this.intag[k];
                    t1 = arcsum * rrisq * (bsqk - rrisq + this.this$0.r[in] * this.this$0.r[in]) / (rri2 * bsqk * bk);
                    this.this$0.grad.sub(this.threadID, ir, txk * t1 * wght, tyk * t1 * wght, tzk * t1 * wght);
                    this.this$0.grad.add(this.threadID, in, txk * t1 * wght, tyk * t1 * wght, tzk * t1 * wght);
                    continue;
                }
                Arrays.sort(this.arci, 0, narc);
                arcsum = this.arci[0].value;
                int mi = this.arci[0].key;
                double t = this.arcf[mi];
                int ni = mi;
                this.j = 1;
                while (this.j < narc) {
                    double tt;
                    int m = this.arci[this.j].key;
                    if (t < this.arci[this.j].value) {
                        int l3;
                        arcsum += this.arci[this.j].value - t;
                        exang += this.ex[ni];
                        if (++jb >= 1000) {
                            throw new EnergyException(String.format("Increase the value of MAXARC (%d).", jb));
                        }
                        int n = l3 = this.lt[ni];
                        this.ider[n] = this.ider[n] + 1.0;
                        int n2 = l3;
                        this.sign_yder[n2] = this.sign_yder[n2] + 1.0;
                        this.kent[jb] = 1000 * (l3 + 1) + (k + 1);
                        int n3 = l3 = this.lt[m];
                        this.ider[n3] = this.ider[n3] + 1.0;
                        int n4 = l3;
                        this.sign_yder[n4] = this.sign_yder[n4] - 1.0;
                        this.kout[jb] = 1000 * (k + 1) + (l3 + 1);
                    }
                    if ((tt = this.arcf[m]) >= t) {
                        t = tt;
                        ni = m;
                    }
                    ++this.j;
                }
                arcsum += Math.PI * 2 - t;
                if (!top) {
                    exang += this.ex[ni];
                    int n = l = this.lt[ni];
                    this.ider[n] = this.ider[n] + 1.0;
                    int n5 = l;
                    this.sign_yder[n5] = this.sign_yder[n5] + 1.0;
                    this.kent[++jb] = 1000 * (l + 1) + (k + 1);
                    int n6 = l = this.lt[mi];
                    this.ider[n6] = this.ider[n6] + 1.0;
                    int n7 = l;
                    this.sign_yder[n7] = this.sign_yder[n7] - 1.0;
                    this.kout[jb] = 1000 * (k + 1) + (l + 1);
                }
                for (l = 0; l <= this.this$0.overlapCounts[ir]; ++l) {
                    if (this.ider[l] == 0.0) continue;
                    double rcn = this.ider[l] * rrisq;
                    this.ider[l] = 0.0;
                    double uzl = this.uz[l];
                    double gl = this.this$0.gr[ir][l].value * rri;
                    double bgl = this.bg[l];
                    double bsql = this.bsq[l];
                    double risql = this.risq[l];
                    double wxlsq = bsql - uzl * uzl;
                    double wxl = FastMath.sqrt((double)wxlsq);
                    double p = bgl - gk * uzl;
                    double v = risqk * wxlsq - p * p;
                    v = FastMath.max((double)1.0E-8, (double)v);
                    v = FastMath.sqrt((double)v);
                    t1 = rri * (gk * (bgl - bsql) + uzl * (bgl - rrisq)) / (v * risql * bsql);
                    double deal = -wxl * t1;
                    double decl = -uzl * t1 - rri / v;
                    double dtkal = (wxlsq - p) / (wxl * v);
                    double dtkcl = (uzl - gk) / v;
                    double s = gk * this.b[l] - gl * uzl;
                    t1 = 2.0 * gk - uzl;
                    double t2 = rrisq - bgl;
                    double dtlal = -(risql * wxlsq * this.b[l] * t1 - s * (wxlsq * t2 + risql * bsql)) / (risql * wxl * bsql * v);
                    double dtlcl = -(risql * this.b[l] * (uzl * t1 - bgl) - uzl * t2 * s) / (risql * bsql * v);
                    double gaca = rcn * (deal - (gk * dtkal - gl * dtlal) / rri) / wxl;
                    double gacb = (gk - uzl * gl / this.b[l]) * this.sign_yder[l] * rri / wxlsq;
                    this.sign_yder[l] = 0.0;
                    if (moved) continue;
                    double faca = this.ux[l] * gaca - this.uy[l] * gacb;
                    double facb = this.uy[l] * gaca + this.ux[l] * gacb;
                    double facc = rcn * (decl - (gk * dtkcl - gl * dtlcl) / rri);
                    double dax = axx * faca - ayx * facb + azx * facc;
                    double day = axy * faca + ayy * facb + azy * facc;
                    double daz = azz * facc - axz * faca;
                    int in = this.intag[l];
                    this.this$0.grad.add(this.threadID, ir, dax * wght, day * wght, daz * wght);
                    this.this$0.grad.sub(this.threadID, in, dax * wght, day * wght, daz * wght);
                }
                arcLength += this.this$0.gr[ir][k].value * arcsum;
                if (moved) continue;
                int in = this.intag[k];
                t1 = arcsum * rrisq * (bsqk - rrisq + this.this$0.r[in] * this.this$0.r[in]) / (rri2 * bsqk * bk);
                this.this$0.grad.sub(this.threadID, ir, txk * t1 * wght, tyk * t1 * wght, tzk * t1 * wght);
                this.this$0.grad.add(this.threadID, in, txk * t1 * wght, tyk * t1 * wght, tzk * t1 * wght);
            }
            if (arcLength == 0.0) {
                this.this$0.area[ir] = 0.0;
                return;
            }
            if (jb == 0) {
                this.this$0.area[ir] = (double)this.ib * (Math.PI * 2) + exang + arcLength;
                this.this$0.area[ir] = this.this$0.area[ir] % (Math.PI * 4);
                return;
            }
            this.j = 0;
            for (k = 1; k <= jb; ++k) {
                if (this.kout[k] == -1) continue;
                this.i = k;
                boolean success = this.independentBoundaries(k, exang, jb, ir, arcLength);
                if (!success) continue;
                return;
            }
            ++this.ib;
            logger.log(Level.WARNING, String.format(" Connectivity error at atom %d", ir));
            this.this$0.area[ir] = 0.0;
        }

        private void allocateMemory(int maxarc) {
            this.arci = new IndexedDouble[maxarc];
            this.arcf = new double[maxarc];
            this.risq = new double[maxarc];
            this.ri = new double[maxarc];
            this.dsq = new double[maxarc];
            this.bsq = new double[maxarc];
            this.intag = new int[maxarc];
            this.lt = new int[maxarc];
            this.kent = new int[maxarc];
            this.kout = new int[maxarc];
            this.ider = new double[maxarc];
            this.sign_yder = new double[maxarc];
            this.xc = new double[maxarc];
            this.yc = new double[maxarc];
            this.zc = new double[maxarc];
            this.b = new double[maxarc];
            this.omit = new boolean[maxarc];
            this.bg = new double[maxarc];
            this.ther = new double[maxarc];
            this.ex = new double[maxarc];
            this.ux = new double[maxarc];
            this.uy = new double[maxarc];
            this.uz = new double[maxarc];
        }

        boolean independentBoundaries(int k, double exAngle, int jb, int ir, double arcLength) {
            int m = this.kout[this.i];
            this.kout[this.i] = -1;
            ++this.j;
            for (int ii = 1; ii <= jb; ++ii) {
                if (m != this.kent[ii]) continue;
                if (ii == k) {
                    ++this.ib;
                    if (this.j == jb) {
                        this.this$0.area[ir] = (double)this.ib * 2.0 * Math.PI + exAngle + arcLength;
                        this.this$0.area[ir] = this.this$0.area[ir] % (Math.PI * 4);
                        return true;
                    }
                    return false;
                }
                this.i = ii;
                return this.independentBoundaries(k, exAngle, jb, ir, arcLength);
            }
            return false;
        }
    }

    private class InitLoop
    extends IntegerForLoop {
        public long time;
        final /* synthetic */ SurfaceAreaRegion this$0;

        private InitLoop(SurfaceAreaRegion surfaceAreaRegion) {
            SurfaceAreaRegion surfaceAreaRegion2 = surfaceAreaRegion;
            Objects.requireNonNull(surfaceAreaRegion2);
            this.this$0 = surfaceAreaRegion2;
        }

        public void finish() {
            this.time += System.nanoTime();
        }

        public void run(int lb, int ub) throws Exception {
            for (int i = lb; i <= ub; ++i) {
                int[] list;
                this.this$0.buried[i] = false;
                this.this$0.area[i] = 0.0;
                this.this$0.overlapCounts[i] = 0;
                double xr = this.this$0.x[i];
                double yr = this.this$0.y[i];
                double zr = this.this$0.z[i];
                double rri = this.this$0.r[i];
                for (int k : list = this.this$0.neighborLists[0][i]) {
                    double dx = this.this$0.x[k] - xr;
                    double dy = this.this$0.y[k] - yr;
                    double dz = this.this$0.z[k] - zr;
                    double ccsq = dx * dx + dy * dy + dz * dz;
                    double rrik = rri + this.this$0.r[k];
                    if (!(ccsq <= rrik * rrik) || !this.this$0.use[i] && !this.this$0.use[k]) continue;
                    this.this$0.skip.set(k, false);
                    this.this$0.skip.set(i, false);
                }
            }
        }

        public void start() {
            this.time = -System.nanoTime();
        }
    }

    private static class IndexedDouble
    implements Comparable<IndexedDouble> {
        public double value;
        public int key;

        IndexedDouble(double value, int key) {
            this.value = value;
            this.key = key;
        }

        @Override
        public int compareTo(IndexedDouble d) {
            return Double.compare(this.value, d.value);
        }
    }
}

