/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.implicit;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.numerics.atomic.AtomicDoubleArray;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.GeneralizedKirkwood;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InitializationRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(InitializationRegion.class.getName());
    private GeneralizedKirkwood generalizedKirkwood;
    private final InitializationLoop[] initializationLoop;
    private Atom[] atoms;
    private boolean lambdaTerm;
    private AtomicDoubleArray3D grad;
    private AtomicDoubleArray3D torque;
    private AtomicDoubleArray sharedBornGrad;

    public InitializationRegion(int maxThreads) {
        this.initializationLoop = new InitializationLoop[maxThreads];
    }

    public void executeWith(ParallelTeam parallelTeam) {
        try {
            parallelTeam.execute((ParallelRegion)this);
        }
        catch (Exception e) {
            String message = " Exception expanding initializing GK.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void init(GeneralizedKirkwood generalizedKirkwood, Atom[] atoms, boolean lambdaTerm, AtomicDoubleArray3D grad, AtomicDoubleArray3D torque, AtomicDoubleArray sharedBornGrad) {
        this.generalizedKirkwood = generalizedKirkwood;
        this.atoms = atoms;
        this.lambdaTerm = lambdaTerm;
        this.grad = grad;
        this.torque = torque;
        this.sharedBornGrad = sharedBornGrad;
    }

    public void run() {
        int threadIndex = this.getThreadIndex();
        if (this.initializationLoop[threadIndex] == null) {
            this.initializationLoop[threadIndex] = new InitializationLoop(this);
        }
        try {
            int nAtoms = this.atoms.length;
            this.execute(0, nAtoms - 1, this.initializationLoop[threadIndex]);
        }
        catch (Exception e) {
            String message = "Fatal exception initializing coordinates in thread: " + threadIndex + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private class InitializationLoop
    extends IntegerForLoop {
        private int threadID;
        final /* synthetic */ InitializationRegion this$0;

        private InitializationLoop(InitializationRegion initializationRegion) {
            InitializationRegion initializationRegion2 = initializationRegion;
            Objects.requireNonNull(initializationRegion2);
            this.this$0 = initializationRegion2;
        }

        public void run(int lb, int ub) {
            this.this$0.grad.reset(this.threadID, lb, ub);
            this.this$0.torque.reset(this.threadID, lb, ub);
            this.this$0.sharedBornGrad.reset(this.threadID, lb, ub);
            if (this.this$0.lambdaTerm) {
                for (int i = lb; i <= ub; ++i) {
                    this.this$0.generalizedKirkwood.udpateSoluteParameters(i);
                    if (this.this$0.atoms[i].applyLambda()) continue;
                    logger.warning(String.format(" Atom %s is not alchemical.", this.this$0.atoms[i].toString()));
                    logger.warning(" Alchemical GK calculations require all atoms to be alchemical.");
                    break;
                }
            }
        }

        public IntegerSchedule schedule() {
            return IntegerSchedule.fixed();
        }

        public void start() {
            this.threadID = this.getThreadIndex();
        }
    }
}

