/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.implicit;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedDouble;
import ffx.numerics.atomic.AtomicDoubleArray;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Atom;
import ffx.potential.parameters.ForceField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class GaussVol {
    private static final Logger logger = Logger.getLogger(GaussVol.class.getName());
    private static final double offset = 0.005;
    private static final double KFC = 2.2269859253;
    private static final double PFC = 2.5;
    private static final double sphereConversion = 2.2269859253;
    private static final int MAX_ORDER = 16;
    private static final double ANG3 = 1.0;
    private static final double VOLMINA = 0.01;
    private static final double VOLMINB = 0.1;
    private static final double MIN_GVOL = Double.MIN_VALUE;
    public static final double DEFAULT_GAUSSVOL_RADII_OFFSET = 0.0;
    public static final double DEFAULT_GAUSSVOL_RADII_SCALE = 1.15;
    private static final double RMIN_TO_SIGMA = 1.0 / FastMath.pow((double)2.0, (double)0.16666666666666666);
    private final GaussVolRegion gaussVolRegion;
    private final AtomicDoubleArray3D grad;
    private final SharedDouble totalVolume;
    private final SharedDouble energy;
    private final AtomicDoubleArray gradV;
    private final AtomicDoubleArray freeVolume;
    private final AtomicDoubleArray selfVolume;
    private final ParallelTeam parallelTeam;
    private final double vdwRadiiOffset;
    private final double vdwRadiiScale;
    private final boolean includeHydrogen;
    private final boolean useSigma;
    private static final double FOUR_THIRDS_PI = 4.1887902047863905;
    private final Atom[] atoms;
    private final int nAtoms;
    private double[] radii;
    private double[] volumes;
    private final double[] radiiOffset;
    private final double[] volumeOffset;
    private final double[] gammas;
    private final boolean[] ishydrogen;
    private final double[] selfVolumeFraction;
    private final GaussianOverlapTree tree;
    private int maximumDepth = 0;
    private int totalNumberOfOverlaps = 0;
    private double surfaceArea;
    private double volume;
    private double[] volumeGradient;
    private double[] surfaceAreaGradient;

    public GaussVol(Atom[] atoms, ForceField forceField, ParallelTeam parallelTeam) {
        this.atoms = atoms;
        this.nAtoms = atoms.length;
        this.tree = new GaussianOverlapTree(this, this.nAtoms);
        this.radii = new double[this.nAtoms];
        this.volumes = new double[this.nAtoms];
        this.gammas = new double[this.nAtoms];
        this.ishydrogen = new boolean[this.nAtoms];
        this.radiiOffset = new double[this.nAtoms];
        this.volumeOffset = new double[this.nAtoms];
        this.selfVolumeFraction = new double[this.nAtoms];
        this.vdwRadiiOffset = forceField.getDouble("GAUSSVOL_RADII_OFFSET", 0.0);
        this.vdwRadiiScale = forceField.getDouble("GAUSSVOL_RADII_SCALE", 1.15);
        this.includeHydrogen = forceField.getBoolean("GAUSSVOL_HYDROGEN", false);
        this.useSigma = forceField.getBoolean("GAUSSVOL_USE_SIGMA", false);
        for (int i = 0; i < this.nAtoms; ++i) {
            this.updateAtom(i);
        }
        this.parallelTeam = parallelTeam;
        int nThreads = 1;
        if (parallelTeam != null) {
            nThreads = parallelTeam.getThreadCount();
            this.gaussVolRegion = new GaussVolRegion(this, nThreads);
        } else {
            this.gaussVolRegion = null;
        }
        this.totalVolume = new SharedDouble();
        this.energy = new SharedDouble();
        AtomicDoubleArray.AtomicDoubleArrayImpl atomicDoubleArrayImpl = AtomicDoubleArray.AtomicDoubleArrayImpl.MULTI;
        this.grad = new AtomicDoubleArray3D(atomicDoubleArrayImpl, this.nAtoms, nThreads);
        this.gradV = atomicDoubleArrayImpl.createInstance(nThreads, this.nAtoms);
        this.freeVolume = atomicDoubleArrayImpl.createInstance(nThreads, this.nAtoms);
        this.selfVolume = atomicDoubleArrayImpl.createInstance(nThreads, this.nAtoms);
    }

    public double[] getRadii() {
        return this.radii;
    }

    private static double overlapGaussianAlpha(GaussianVca g1, GaussianVca g2, GaussianVca g12, double[] dVdr, double[] dVdV, double[] sfp) {
        double dgvolv;
        double dgvol;
        double[] c1 = g1.c;
        double[] c2 = g2.c;
        double[] dist = new double[3];
        DoubleMath.sub((double[])c2, (double[])c1, (double[])dist);
        double d2 = DoubleMath.length2((double[])dist);
        double a12 = g1.a + g2.a;
        double deltai = 1.0 / a12;
        double df = g1.a * g2.a * deltai;
        double ef = FastMath.exp((double)(-df * d2));
        double gvol = g1.v * g2.v / FastMath.pow((double)(Math.PI / df), (double)1.5) * ef;
        dVdr[0] = dgvol = -2.0 * df * gvol;
        dVdV[0] = dgvolv = g1.v > 0.0 ? gvol / g1.v : 0.0;
        double[] c1a = new double[3];
        double[] c2a = new double[3];
        DoubleMath.scale((double[])c1, (double)(g1.a * deltai), (double[])c1a);
        DoubleMath.scale((double[])c2, (double)(g2.a * deltai), (double[])c2a);
        DoubleMath.add((double[])c1a, (double[])c2a, (double[])g12.c);
        g12.a = a12;
        g12.v = gvol;
        double[] sp = new double[1];
        double s = GaussVol.switchingFunction(gvol, 0.01, 0.1, sp);
        sfp[0] = sp[0] * gvol + s;
        return s * gvol;
    }

    private static double switchingFunction(double gvol, double volmina, double volminb, double[] sp) {
        if (gvol > volminb) {
            sp[0] = 0.0;
            return 1.0;
        }
        if (gvol < volmina) {
            sp[0] = 0.0;
            return 0.0;
        }
        double swd = 1.0 / (volminb - volmina);
        double swu = (gvol - volmina) * swd;
        double swu2 = swu * swu;
        double swu3 = swu * swu2;
        sp[0] = swd * 30.0 * swu2 * (1.0 - 2.0 * swu + swu2);
        return swu3 * (10.0 - 15.0 * swu + 6.0 * swu2);
    }

    public double[] getSelfVolumeFractions() {
        return this.selfVolumeFraction;
    }

    public double computeVolumeAndSA(double[][] positions) {
        if (this.parallelTeam == null || this.parallelTeam.getThreadCount() == 1) {
            for (int i = 0; i < this.nAtoms - 1; ++i) {
                this.updateAtom(i);
            }
            this.computeTree(positions);
            this.computeVolume(this.totalVolume, this.energy, this.grad, this.gradV, this.freeVolume, this.selfVolume);
        } else {
            try {
                this.gaussVolRegion.init(GAUSSVOL_MODE.COMPUTE_TREE, positions);
                this.parallelTeam.execute((ParallelRegion)this.gaussVolRegion);
            }
            catch (Exception e) {
                logger.severe(" Exception evaluating GaussVol " + String.valueOf(e));
            }
        }
        if (this.volumeGradient == null || this.volumeGradient.length != this.nAtoms * 3) {
            this.volumeGradient = new double[this.nAtoms * 3];
            this.surfaceAreaGradient = new double[this.nAtoms * 3];
        }
        double selfVolumeSum = 0.0;
        double noOverlapVolume = 0.0;
        for (int i = 0; i < this.nAtoms; ++i) {
            double si = this.selfVolume.get(i);
            selfVolumeSum += si;
            double x = this.grad.getX(i);
            double y = this.grad.getY(i);
            double z = this.grad.getZ(i);
            if (this.ishydrogen[i]) {
                x = 0.0;
                y = 0.0;
                z = 0.0;
                this.selfVolumeFraction[i] = 0.0;
            } else {
                double vi = this.volumes[i];
                noOverlapVolume += vi;
                this.selfVolumeFraction[i] = si / vi;
            }
            int index = i * 3;
            this.volumeGradient[index++] = x;
            this.volumeGradient[index++] = y;
            this.volumeGradient[index] = z;
            index = i * 3;
            this.surfaceAreaGradient[index++] = x;
            this.surfaceAreaGradient[index++] = y;
            this.surfaceAreaGradient[index] = z;
        }
        if (logger.isLoggable(Level.FINE)) {
            double meanHCT = selfVolumeSum / noOverlapVolume;
            logger.fine(String.format("\n Mean Self-Volume Fraction: %16.8f", meanHCT));
            logger.fine(String.format(" Cube Root of the Fraction: %16.8f", FastMath.cbrt((double)meanHCT)));
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(" Atomic Self-volume Fractions");
                for (int i = 0; i < this.nAtoms; ++i) {
                    logger.finest(String.format(" %6d %16.8f", i + 1, this.selfVolumeFraction[i]));
                }
            }
        }
        this.volume = this.totalVolume.get();
        double[] radiiBak = this.radii;
        double[] volumeBak = this.volumes;
        this.radii = this.radiiOffset;
        this.volumes = this.volumeOffset;
        if (this.parallelTeam == null || this.parallelTeam.getThreadCount() == 1) {
            this.rescanTreeVolumes(positions);
            this.computeVolume(this.totalVolume, this.energy, this.grad, this.gradV, this.freeVolume, this.selfVolume);
        } else {
            try {
                this.gaussVolRegion.init(GAUSSVOL_MODE.RESCAN_TREE, positions);
                this.parallelTeam.execute((ParallelRegion)this.gaussVolRegion);
            }
            catch (Exception e) {
                logger.severe(" Exception evaluating GaussVol " + String.valueOf(e));
            }
        }
        this.radii = radiiBak;
        this.volumes = volumeBak;
        double selfVolumeOffsetSum = 0.0;
        for (int i = 0; i < this.nAtoms; ++i) {
            int index;
            selfVolumeOffsetSum += this.selfVolume.get(i);
            double x = this.grad.getX(i);
            double y = this.grad.getY(i);
            double z = this.grad.getZ(i);
            if (this.ishydrogen[i]) {
                x = 0.0;
                y = 0.0;
                z = 0.0;
            }
            this.surfaceAreaGradient[index = i * 3] = (x - this.surfaceAreaGradient[index++]) / 0.005;
            this.surfaceAreaGradient[index] = (y - this.surfaceAreaGradient[index++]) / 0.005;
            this.surfaceAreaGradient[index] = (z - this.surfaceAreaGradient[index]) / 0.005;
        }
        this.surfaceArea = (selfVolumeOffsetSum - selfVolumeSum) / 0.005;
        return this.volume;
    }

    public int getMaximumDepth() {
        return this.maximumDepth;
    }

    public double getSurfaceArea() {
        return this.surfaceArea;
    }

    public double[] getSurfaceAreaGradient() {
        return this.surfaceAreaGradient;
    }

    public int getTotalNumberOfOverlaps() {
        return this.totalNumberOfOverlaps;
    }

    public double getVolume() {
        return this.volume;
    }

    public double[] getVolumeGradient() {
        return this.volumeGradient;
    }

    public void allocate(Atom[] atoms) throws Exception {
        if (atoms.length != this.atoms.length) {
            throw new Exception(" allocate: number of atoms does not match");
        }
    }

    private void computeTree(double[][] positions) {
        this.tree.computeOverlapTreeR(positions, this.radii, this.volumes, this.gammas, this.ishydrogen);
    }

    private void computeVolume(SharedDouble totalVolume, SharedDouble totalEnergy, AtomicDoubleArray3D grad, AtomicDoubleArray gradV, AtomicDoubleArray freeVolume, AtomicDoubleArray selfVolume) {
        totalVolume.set(0.0);
        totalEnergy.set(0.0);
        grad.reset(0, 0, this.nAtoms - 1);
        gradV.reset(0, 0, this.nAtoms - 1);
        freeVolume.reset(0, 0, this.nAtoms - 1);
        selfVolume.reset(0, 0, this.nAtoms - 1);
        this.tree.computeVolume2R(totalVolume, totalEnergy, grad, gradV, freeVolume, selfVolume);
        grad.reduce(0, this.nAtoms - 1);
        gradV.reduce(0, this.nAtoms - 1);
        freeVolume.reduce(0, this.nAtoms - 1);
        selfVolume.reduce(0, this.nAtoms - 1);
        for (int i = 0; i < this.nAtoms; ++i) {
            if (!(this.volumes[i] > 0.0)) continue;
            gradV.set(0, i, gradV.get(i) / this.volumes[i]);
        }
    }

    private void rescanTreeVolumes(double[][] positions) {
        this.tree.rescanTreeV(positions, this.radii, this.volumes, this.gammas, this.ishydrogen);
    }

    private void rescanTreeGammas() {
        this.tree.rescanTreeG(this.gammas);
    }

    private void getStats(int[] nov) {
        if (nov.length != this.nAtoms) {
            return;
        }
        for (int i = 0; i < this.nAtoms; ++i) {
            nov[i] = 0;
        }
        for (int atom = 0; atom < this.nAtoms; ++atom) {
            int slot = atom + 1;
            nov[atom] = this.tree.nChildrenUnderSlotR(slot);
        }
    }

    private void printTree() {
        this.tree.printTree();
    }

    public void updateAtom(int i) {
        Atom atom = this.atoms[i];
        this.ishydrogen[i] = atom.isHydrogen();
        if (this.includeHydrogen) {
            this.ishydrogen[i] = false;
        }
        this.radii[i] = atom.getVDWType().radius / 2.0;
        if (this.useSigma) {
            int n = i;
            this.radii[n] = this.radii[n] * RMIN_TO_SIGMA;
        }
        int n = i;
        this.radii[n] = this.radii[n] + this.vdwRadiiOffset;
        int n2 = i;
        this.radii[n2] = this.radii[n2] * this.vdwRadiiScale;
        this.volumes[i] = 4.1887902047863905 * FastMath.pow((double)this.radii[i], (int)3);
        this.gammas[i] = 1.0;
        this.radiiOffset[i] = this.radii[i] + 0.005;
        this.volumeOffset[i] = 4.1887902047863905 * FastMath.pow((double)this.radiiOffset[i], (int)3);
    }

    private class GaussianOverlapTree {
        int nAtoms;
        List<GaussianOverlap> overlaps;
        final /* synthetic */ GaussVol this$0;

        GaussianOverlapTree(GaussVol gaussVol, int nAtoms) {
            GaussVol gaussVol2 = gaussVol;
            Objects.requireNonNull(gaussVol2);
            this.this$0 = gaussVol2;
            this.nAtoms = nAtoms;
            this.overlaps = Collections.synchronizedList(new ArrayList(nAtoms + 1));
        }

        void initOverlapTree(double[][] pos, double[] radii, double[] volumes, double[] gammas, boolean[] ishydrogen) {
            this.overlaps = Collections.synchronizedList(new ArrayList(this.nAtoms + 1));
            GaussianOverlap overlap = new GaussianOverlap();
            overlap.level = 0;
            overlap.volume = 0.0;
            overlap.dvv1 = 0.0;
            overlap.selfVolume = 0.0;
            overlap.sfp = 1.0;
            overlap.gamma1i = 0.0;
            overlap.parentIndex = -1;
            overlap.atom = -1;
            overlap.childrenStartIndex = 1;
            overlap.childrenCount = this.nAtoms;
            this.overlaps.add(0, overlap);
            for (int iat = 0; iat < this.nAtoms; ++iat) {
                overlap = new GaussianOverlap();
                double a = 2.2269859253 / (radii[iat] * radii[iat]);
                double vol = ishydrogen[iat] ? 0.0 : volumes[iat];
                overlap.level = 1;
                overlap.g.v = vol;
                overlap.g.a = a;
                overlap.g.c = pos[iat];
                overlap.volume = vol;
                overlap.dvv1 = 1.0;
                overlap.selfVolume = 0.0;
                overlap.sfp = 1.0;
                overlap.gamma1i = gammas[iat];
                overlap.parentIndex = 0;
                overlap.atom = iat;
                overlap.childrenStartIndex = -1;
                overlap.childrenCount = -1;
                this.overlaps.add(iat + 1, overlap);
            }
        }

        int addChildren(int parentIndex, List<GaussianOverlap> childrenOverlaps) {
            int startIndex = this.overlaps.size();
            int noverlaps = childrenOverlaps.size();
            GaussianOverlap root = this.overlaps.get(parentIndex);
            root.childrenStartIndex = startIndex;
            root.childrenCount = noverlaps;
            Collections.sort(childrenOverlaps);
            int rootLevel = root.level;
            int nextLevel = rootLevel + 1;
            for (GaussianOverlap child : childrenOverlaps) {
                child.level = nextLevel;
                child.parentIndex = parentIndex;
                child.childrenStartIndex = -1;
                child.childrenCount = -1;
                this.overlaps.add(child);
            }
            return startIndex;
        }

        void computeChildren(int rootIndex, List<GaussianOverlap> childrenOverlaps) {
            childrenOverlaps.clear();
            GaussianOverlap root = this.overlaps.get(rootIndex);
            int parentIndex = root.parentIndex;
            if (parentIndex < 0) {
                throw new IllegalArgumentException(" Cannot compute children of master node!");
            }
            if (root.level >= 16) {
                return;
            }
            GaussianOverlap parent = this.overlaps.get(parentIndex);
            int siblingStart = parent.childrenStartIndex;
            int siblingCount = parent.childrenCount;
            if (siblingStart < 0 || siblingCount < 0) {
                throw new IllegalArgumentException(String.format(" Parent %s of overlap %s has no sibilings.", parent, root));
            }
            if (rootIndex < siblingStart && rootIndex > siblingStart + siblingCount - 1) {
                throw new IllegalArgumentException(String.format(" Node %s is somehow not the child of its parent %s", root, parent));
            }
            for (int slotj = rootIndex + 1; slotj < siblingStart + siblingCount; ++slotj) {
                GaussianVca g12 = new GaussianVca();
                GaussianOverlap sibling = this.overlaps.get(slotj);
                double[] dVdr = new double[1];
                double[] dVdV = new double[1];
                double[] sfp = new double[1];
                int atom2 = sibling.atom;
                GaussianVca g1 = root.g;
                GaussianVca g2 = this.overlaps.get((int)(atom2 + 1)).g;
                double gvol = GaussVol.overlapGaussianAlpha(g1, g2, g12, dVdr, dVdV, sfp);
                if (!(gvol > Double.MIN_VALUE)) continue;
                GaussianOverlap ov = new GaussianOverlap(g12, gvol, 0.0, atom2);
                DoubleMath.sub((double[])g2.c, (double[])g1.c, (double[])ov.dv1);
                DoubleMath.scale((double[])ov.dv1, (double)(-dVdr[0]), (double[])ov.dv1);
                ov.dvv1 = dVdV[0];
                ov.sfp = sfp[0];
                ov.gamma1i = root.gamma1i + this.overlaps.get((int)(atom2 + 1)).gamma1i;
                childrenOverlaps.add(ov);
            }
        }

        private void computeAndAddChildrenR(int root) {
            List<GaussianOverlap> childrenOverlaps = Collections.synchronizedList(new ArrayList());
            this.computeChildren(root, childrenOverlaps);
            int nOverlaps = childrenOverlaps.size();
            if (nOverlaps > 0) {
                int startSlot;
                for (int ichild = startSlot = this.addChildren(root, childrenOverlaps); ichild < startSlot + nOverlaps; ++ichild) {
                    this.computeAndAddChildrenR(ichild);
                    ++this.this$0.totalNumberOfOverlaps;
                }
            }
        }

        void computeOverlapTreeR(double[][] pos, double[] radii, double[] volumes, double[] gammas, boolean[] ishydrogen) {
            this.initOverlapTree(pos, radii, volumes, gammas, ishydrogen);
            for (int slot = 1; slot <= this.nAtoms; ++slot) {
                this.computeAndAddChildrenR(slot);
                ++this.this$0.totalNumberOfOverlaps;
            }
        }

        void computeVolumeUnderSlot2R(int slot, double[] psi1i, double[] f1i, double[] p1i, double[] psip1i, double[] fp1i, double[] pp1i, double[] energy1i, double[] fenergy1i, double[] penergy1i, int threadID, AtomicDoubleArray3D dr, AtomicDoubleArray dv, AtomicDoubleArray freeVolume, AtomicDoubleArray selfVolume) {
            GaussianOverlap ov = this.overlaps.get(slot);
            if (ov.level >= this.this$0.maximumDepth) {
                this.this$0.maximumDepth = ov.level;
            }
            double cf = ov.level % 2 == 0 ? -1.0 : 1.0;
            double volcoeff = ov.level > 0 ? cf : 0.0;
            double volcoeffp = ov.level > 0 ? volcoeff / (double)ov.level : 0.0;
            int atom = ov.atom;
            double ai = this.overlaps.get((int)(atom + 1)).g.a;
            double a1i = ov.g.a;
            double a1 = a1i - ai;
            psi1i[0] = volcoeff * ov.volume;
            f1i[0] = volcoeff * ov.sfp;
            psip1i[0] = volcoeffp * ov.volume;
            fp1i[0] = volcoeffp * ov.sfp;
            energy1i[0] = volcoeffp * ov.gamma1i * ov.volume;
            fenergy1i[0] = volcoeffp * ov.sfp * ov.gamma1i;
            if (ov.childrenStartIndex >= 0) {
                for (int sloti = ov.childrenStartIndex; sloti < ov.childrenStartIndex + ov.childrenCount; ++sloti) {
                    double[] psi1it = new double[1];
                    double[] f1it = new double[1];
                    double[] p1it = new double[3];
                    double[] psip1it = new double[1];
                    double[] fp1it = new double[1];
                    double[] pp1it = new double[3];
                    double[] energy1it = new double[1];
                    double[] fenergy1it = new double[1];
                    double[] penergy1it = new double[3];
                    this.computeVolumeUnderSlot2R(sloti, psi1it, f1it, p1it, psip1it, fp1it, pp1it, energy1it, fenergy1it, penergy1it, threadID, dr, dv, freeVolume, selfVolume);
                    psi1i[0] = psi1i[0] + psi1it[0];
                    f1i[0] = f1i[0] + f1it[0];
                    DoubleMath.add((double[])p1i, (double[])p1it, (double[])p1i);
                    psip1i[0] = psip1i[0] + psip1it[0];
                    fp1i[0] = fp1i[0] + fp1it[0];
                    DoubleMath.add((double[])pp1i, (double[])pp1it, (double[])pp1i);
                    energy1i[0] = energy1i[0] + energy1it[0];
                    fenergy1i[0] = fenergy1i[0] + fenergy1it[0];
                    DoubleMath.add((double[])penergy1i, (double[])penergy1it, (double[])penergy1i);
                }
            }
            if (ov.level > 0) {
                freeVolume.add(threadID, atom, psi1i[0]);
                selfVolume.add(threadID, atom, psip1i[0]);
                double c2 = ai / a1i;
                double[] work1 = new double[3];
                double[] work2 = new double[3];
                double[] work3 = new double[3];
                DoubleMath.scale((double[])penergy1i, (double)c2, (double[])work1);
                DoubleMath.scale((double[])ov.dv1, (double)(-fenergy1i[0]), (double[])work2);
                DoubleMath.add((double[])work1, (double[])work2, (double[])work3);
                dr.add(threadID, atom, work3[0], work3[1], work3[2]);
                dv.add(threadID, atom, ov.g.v * fenergy1i[0]);
                c2 = a1 / a1i;
                DoubleMath.scale((double[])ov.dv1, (double)f1i[0], (double[])work1);
                DoubleMath.scale((double[])pp1i, (double)c2, (double[])work2);
                DoubleMath.add((double[])work1, (double[])work2, (double[])p1i);
                DoubleMath.scale((double[])ov.dv1, (double)fp1i[0], (double[])work1);
                DoubleMath.scale((double[])pp1i, (double)c2, (double[])work2);
                DoubleMath.add((double[])work1, (double[])work2, (double[])pp1i);
                DoubleMath.scale((double[])ov.dv1, (double)fenergy1i[0], (double[])work1);
                DoubleMath.scale((double[])penergy1i, (double)c2, (double[])work2);
                DoubleMath.add((double[])work1, (double[])work2, (double[])penergy1i);
                f1i[0] = ov.dvv1 * f1i[0];
                fp1i[0] = ov.dvv1 * fp1i[0];
                fenergy1i[0] = ov.dvv1 * fenergy1i[0];
            }
        }

        void computeVolume2R(SharedDouble volume, SharedDouble energy, AtomicDoubleArray3D dr, AtomicDoubleArray dv, AtomicDoubleArray freeVolume, AtomicDoubleArray selfvolume) {
            double[] psi1i = new double[1];
            double[] f1i = new double[1];
            double[] p1i = new double[3];
            double[] psip1i = new double[1];
            double[] fp1i = new double[1];
            double[] pp1i = new double[3];
            double[] energy1i = new double[1];
            double[] fenergy1i = new double[1];
            double[] penergy1i = new double[3];
            int threadID = 0;
            this.computeVolumeUnderSlot2R(0, psi1i, f1i, p1i, psip1i, fp1i, pp1i, energy1i, fenergy1i, penergy1i, threadID, dr, dv, freeVolume, selfvolume);
            volume.addAndGet(psi1i[0]);
            energy.addAndGet(energy1i[0]);
        }

        void rescanTreeV(double[][] pos, double[] radii, double[] volumes, double[] gammas, boolean[] ishydrogen) {
            this.initRescanTreeV(pos, radii, volumes, gammas, ishydrogen);
            this.rescanR(0);
        }

        void rescanR(int slot) {
            GaussianOverlap ov = this.overlaps.get(slot);
            int parentIndex = ov.parentIndex;
            if (parentIndex > 0) {
                GaussianVca g12 = new GaussianVca();
                double[] dVdr = new double[1];
                double[] dVdV = new double[1];
                double[] sfp = new double[1];
                int atom = ov.atom;
                GaussianOverlap parent = this.overlaps.get(parentIndex);
                GaussianVca g1 = parent.g;
                GaussianVca g2 = this.overlaps.get((int)(atom + 1)).g;
                double gvol = GaussVol.overlapGaussianAlpha(g1, g2, g12, dVdr, dVdV, sfp);
                ov.g = g12;
                ov.volume = gvol;
                DoubleMath.sub((double[])g2.c, (double[])g1.c, (double[])ov.dv1);
                DoubleMath.scale((double[])ov.dv1, (double)(-dVdr[0]), (double[])ov.dv1);
                ov.dvv1 = dVdV[0];
                ov.sfp = sfp[0];
                ov.gamma1i = parent.gamma1i + this.overlaps.get((int)(atom + 1)).gamma1i;
            }
            for (int slotChild = ov.childrenStartIndex; slotChild < ov.childrenStartIndex + ov.childrenCount; ++slotChild) {
                this.rescanR(slotChild);
            }
        }

        void initRescanTreeV(double[][] pos, double[] radii, double[] volumes, double[] gammas, boolean[] ishydrogen) {
            int slot = 0;
            GaussianOverlap ov = this.overlaps.get(slot);
            ov.level = 0;
            ov.volume = 0.0;
            ov.dv1 = new double[3];
            ov.dvv1 = 0.0;
            ov.selfVolume = 0.0;
            ov.sfp = 1.0;
            ov.gamma1i = 0.0;
            slot = 1;
            int iat = 0;
            while (iat < this.nAtoms) {
                double a = 2.2269859253 / (radii[iat] * radii[iat]);
                double vol = ishydrogen[iat] ? 0.0 : volumes[iat];
                ov = this.overlaps.get(slot);
                ov.level = 1;
                ov.g.v = vol;
                ov.g.a = a;
                ov.g.c = pos[iat];
                ov.volume = vol;
                ov.dv1 = new double[3];
                ov.dvv1 = 1.0;
                ov.selfVolume = 0.0;
                ov.sfp = 1.0;
                ov.gamma1i = gammas[iat];
                ++iat;
                ++slot;
            }
        }

        void rescanGammaR(int slot) {
            GaussianOverlap go = this.overlaps.get(slot);
            int parentIndex = go.parentIndex;
            if (parentIndex > 0) {
                int atom = go.atom;
                GaussianOverlap parent = this.overlaps.get(parentIndex);
                go.gamma1i = parent.gamma1i + this.overlaps.get((int)(atom + 1)).gamma1i;
            }
            for (int slotChild = go.childrenStartIndex; slotChild < go.childrenStartIndex + go.childrenCount; ++slotChild) {
                this.rescanGammaR(slotChild);
            }
        }

        void rescanTreeG(double[] gammas) {
            int slot = 0;
            GaussianOverlap ov = this.overlaps.get(slot);
            ov.gamma1i = 0.0;
            slot = 1;
            int iat = 0;
            while (iat < this.nAtoms) {
                ov = this.overlaps.get(slot);
                ov.gamma1i = gammas[iat];
                ++iat;
                ++slot;
            }
            this.rescanGammaR(0);
        }

        void printTree() {
            for (int i = 1; i <= this.nAtoms; ++i) {
                this.printTreeR(i);
            }
        }

        void printTreeR(int slot) {
            GaussianOverlap ov = this.overlaps.get(slot);
            logger.info(String.format("tg:      %d ", slot));
            ov.printOverlap();
            for (int i = ov.childrenStartIndex; i < ov.childrenStartIndex + ov.childrenCount; ++i) {
                this.printTreeR(i);
            }
        }

        int nChildrenUnderSlotR(int slot) {
            int n = 0;
            if (this.overlaps.get((int)slot).childrenCount > 0) {
                n += this.overlaps.get((int)slot).childrenCount;
                for (int i = 0; i < this.overlaps.get((int)slot).childrenCount; ++i) {
                    n += this.nChildrenUnderSlotR(this.overlaps.get((int)slot).childrenStartIndex + i);
                }
            }
            return n;
        }
    }

    private class GaussVolRegion
    extends ParallelRegion {
        private final InitGaussVol[] initGaussVol;
        private final GaussianOverlapTree[] localTree;
        private final ComputeTreeLoop[] computeTreeLoops;
        private final ComputeVolumeLoop[] computeVolumeLoops;
        private final RescanTreeLoop[] rescanTreeLoops;
        private final ReductionLoop[] reductionLoops;
        private GAUSSVOL_MODE mode;
        private double[][] coordinates;
        final /* synthetic */ GaussVol this$0;

        public GaussVolRegion(GaussVol gaussVol, int nThreads) {
            GaussVol gaussVol2 = gaussVol;
            Objects.requireNonNull(gaussVol2);
            this.this$0 = gaussVol2;
            this.mode = GAUSSVOL_MODE.COMPUTE_TREE;
            this.coordinates = null;
            this.initGaussVol = new InitGaussVol[nThreads];
            this.localTree = new GaussianOverlapTree[nThreads];
            this.computeTreeLoops = new ComputeTreeLoop[nThreads];
            this.computeVolumeLoops = new ComputeVolumeLoop[nThreads];
            this.rescanTreeLoops = new RescanTreeLoop[nThreads];
            this.reductionLoops = new ReductionLoop[nThreads];
        }

        public void init(GAUSSVOL_MODE mode, double[][] coordinates) {
            this.mode = mode;
            this.coordinates = coordinates;
            this.this$0.totalVolume.set(0.0);
            this.this$0.energy.set(0.0);
            this.this$0.grad.reset(this.this$0.parallelTeam);
            this.this$0.gradV.reset(this.this$0.parallelTeam, 0, this.this$0.nAtoms - 1);
            this.this$0.freeVolume.reset(this.this$0.parallelTeam, 0, this.this$0.nAtoms - 1);
            this.this$0.selfVolume.reset(this.this$0.parallelTeam, 0, this.this$0.nAtoms - 1);
        }

        public void run() throws Exception {
            int threadIndex = this.getThreadIndex();
            if (this.computeTreeLoops[threadIndex] == null) {
                this.initGaussVol[threadIndex] = new InitGaussVol(this);
                this.localTree[threadIndex] = new GaussianOverlapTree(this.this$0, this.this$0.nAtoms);
                this.computeTreeLoops[threadIndex] = new ComputeTreeLoop(this);
                this.computeVolumeLoops[threadIndex] = new ComputeVolumeLoop(this);
                this.rescanTreeLoops[threadIndex] = new RescanTreeLoop(this);
                this.reductionLoops[threadIndex] = new ReductionLoop(this);
            }
            try {
                if (this.mode == GAUSSVOL_MODE.COMPUTE_TREE) {
                    this.execute(0, this.this$0.nAtoms - 1, this.initGaussVol[threadIndex]);
                    this.execute(1, this.this$0.nAtoms, this.computeTreeLoops[threadIndex]);
                    this.execute(1, this.this$0.nAtoms, this.computeVolumeLoops[threadIndex]);
                    this.execute(0, this.this$0.nAtoms - 1, this.reductionLoops[threadIndex]);
                } else {
                    this.execute(1, this.this$0.nAtoms, this.rescanTreeLoops[threadIndex]);
                    this.execute(1, this.this$0.nAtoms, this.computeVolumeLoops[threadIndex]);
                    this.execute(0, this.this$0.nAtoms - 1, this.reductionLoops[threadIndex]);
                }
            }
            catch (RuntimeException ex) {
                logger.warning("Runtime exception computing tree in thread: " + threadIndex);
                throw ex;
            }
            catch (Exception e) {
                String message = "Fatal exception computing tree in thread: " + threadIndex + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }

        private class InitGaussVol
        extends IntegerForLoop {
            final /* synthetic */ GaussVolRegion this$1;

            private InitGaussVol(GaussVolRegion gaussVolRegion) {
                GaussVolRegion gaussVolRegion2 = gaussVolRegion;
                Objects.requireNonNull(gaussVolRegion2);
                this.this$1 = gaussVolRegion2;
            }

            public void run(int first, int last) throws Exception {
                for (int i = first; i <= last; ++i) {
                    this.this$1.this$0.updateAtom(i);
                }
            }
        }

        private class ComputeTreeLoop
        extends IntegerForLoop {
            final /* synthetic */ GaussVolRegion this$1;

            private ComputeTreeLoop(GaussVolRegion gaussVolRegion) {
                GaussVolRegion gaussVolRegion2 = gaussVolRegion;
                Objects.requireNonNull(gaussVolRegion2);
                this.this$1 = gaussVolRegion2;
            }

            public void run(int first, int last) throws Exception {
                int threadIndex = this.getThreadIndex();
                for (int slot = first; slot <= last; ++slot) {
                    this.this$1.localTree[threadIndex].computeAndAddChildrenR(slot);
                }
            }

            public void start() {
                this.this$1.localTree[this.getThreadIndex()].initOverlapTree(this.this$1.coordinates, this.this$1.this$0.radii, this.this$1.this$0.volumes, this.this$1.this$0.gammas, this.this$1.this$0.ishydrogen);
            }
        }

        private class ComputeVolumeLoop
        extends IntegerForLoop {
            final /* synthetic */ GaussVolRegion this$1;

            private ComputeVolumeLoop(GaussVolRegion gaussVolRegion) {
                GaussVolRegion gaussVolRegion2 = gaussVolRegion;
                Objects.requireNonNull(gaussVolRegion2);
                this.this$1 = gaussVolRegion2;
            }

            public void run(int first, int last) throws Exception {
                int threadIndex = this.getThreadIndex();
                for (int slot = first; slot <= last; ++slot) {
                    double[] psi1i = new double[1];
                    double[] f1i = new double[1];
                    double[] p1i = new double[3];
                    double[] psip1i = new double[1];
                    double[] fp1i = new double[1];
                    double[] pp1i = new double[3];
                    double[] energy1i = new double[1];
                    double[] fenergy1i = new double[1];
                    double[] penergy1i = new double[3];
                    this.this$1.localTree[threadIndex].computeVolumeUnderSlot2R(slot, psi1i, f1i, p1i, psip1i, fp1i, pp1i, energy1i, fenergy1i, penergy1i, threadIndex, this.this$1.this$0.grad, this.this$1.this$0.gradV, this.this$1.this$0.freeVolume, this.this$1.this$0.selfVolume);
                    this.this$1.this$0.totalVolume.addAndGet(psi1i[0]);
                    this.this$1.this$0.energy.addAndGet(energy1i[0]);
                }
            }
        }

        private class RescanTreeLoop
        extends IntegerForLoop {
            final /* synthetic */ GaussVolRegion this$1;

            private RescanTreeLoop(GaussVolRegion gaussVolRegion) {
                GaussVolRegion gaussVolRegion2 = gaussVolRegion;
                Objects.requireNonNull(gaussVolRegion2);
                this.this$1 = gaussVolRegion2;
            }

            public void run(int first, int last) throws Exception {
                int threadIndex = this.getThreadIndex();
                for (int slot = first; slot <= last; ++slot) {
                    this.this$1.localTree[threadIndex].rescanR(slot);
                }
            }

            public void start() {
                this.this$1.localTree[this.getThreadIndex()].initRescanTreeV(this.this$1.coordinates, this.this$1.this$0.radii, this.this$1.this$0.volumes, this.this$1.this$0.gammas, this.this$1.this$0.ishydrogen);
            }
        }

        private class ReductionLoop
        extends IntegerForLoop {
            int threadID;
            final /* synthetic */ GaussVolRegion this$1;

            private ReductionLoop(GaussVolRegion gaussVolRegion) {
                GaussVolRegion gaussVolRegion2 = gaussVolRegion;
                Objects.requireNonNull(gaussVolRegion2);
                this.this$1 = gaussVolRegion2;
            }

            public void run(int lb, int ub) {
                this.this$1.this$0.grad.reduce(lb, ub);
                this.this$1.this$0.gradV.reduce(lb, ub);
                this.this$1.this$0.freeVolume.reduce(lb, ub);
                this.this$1.this$0.selfVolume.reduce(lb, ub);
                for (int i = lb; i <= ub; ++i) {
                    if (!(this.this$1.this$0.volumes[i] > 0.0)) continue;
                    this.this$1.this$0.gradV.set(0, i, this.this$1.this$0.gradV.get(i) / this.this$1.this$0.volumes[i]);
                }
            }

            public void start() {
                this.threadID = this.getThreadIndex();
            }
        }
    }

    private static class GaussianVca {
        public double v;
        public double a;
        public double[] c = new double[3];

        private GaussianVca() {
        }
    }

    private static enum GAUSSVOL_MODE {
        COMPUTE_TREE,
        RESCAN_TREE;

    }

    private static class GaussianOverlap
    implements Comparable<GaussianOverlap> {
        public int level;
        public GaussianVca g;
        public double volume;
        public int atom;
        double dvv1;
        double[] dv1;
        double gamma1i;
        double selfVolume;
        double sfp;
        int parentIndex;
        int childrenStartIndex;
        int childrenCount;

        public GaussianOverlap() {
            this.g = new GaussianVca();
            this.dv1 = new double[3];
        }

        public GaussianOverlap(GaussianVca g, double volume, double selfVolume, int atom) {
            this.g = g;
            this.volume = volume;
            this.selfVolume = selfVolume;
            this.atom = atom;
            this.dv1 = new double[3];
        }

        @Override
        public int compareTo(GaussianOverlap o) {
            return Double.compare(this.volume, o.volume);
        }

        public void printOverlap() {
            logger.info(String.format(" Gaussian Overlap %d: Atom: %d, Parent: %d, ChildrenStartIndex: %d, ChildrenCount: %d,Volume: %6.3f, Gamma: %6.3f, Gauss.a: %6.3f, Gauss.v: %6.3f, Gauss.center (%6.3f,%6.3f,%6.3f),dedx: %6.3f, dedy: %6.3f, dedz: %6.3f, sfp: %6.3f", this.level, this.atom, this.parentIndex, this.childrenStartIndex, this.childrenCount, this.volume, this.gamma1i, this.g.a, this.g.v, this.g.c[0], this.g.c[1], this.g.c[2], this.dv1[0], this.dv1[1], this.dv1[2], this.sfp));
        }
    }
}

