/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.implicit;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.reduction.SharedDouble;
import ffx.crystal.Crystal;
import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.VanDerWaalsForm;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.VDWType;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class DispersionRegion
extends ParallelRegion {
    public static final double DEFAULT_DISPERSION_OFFSET = 1.056;
    public static final double DEFAULT_SOLUTE_OFFSET = 0.0;
    private static final Logger logger = Logger.getLogger(DispersionRegion.class.getName());
    private static final double DEFAULT_DISP_OVERLAP_FACTOR = 0.75;
    private static final double SLEVY = 1.0;
    private static final double AWATER = 0.033428;
    private static final double EPSO = 0.11;
    private static final double EPSH = 0.0135;
    private static final double RMINO = 1.7025;
    private static final double RMINH = 1.3275;
    private static final VDWType.EPSILON_RULE epsilonRule = VDWType.EPSILON_RULE.HHG;
    private static final VDWType.RADIUS_RULE radiusRule = VDWType.RADIUS_RULE.CUBIC_MEAN;
    private final DispersionLoop[] dispersionLoop;
    private final SharedDouble sharedDispersion;
    protected Atom[] atoms;
    private Crystal crystal;
    private boolean[] use = null;
    private int[][][] neighborLists;
    private double[] x;
    private double[] y;
    private double[] z;
    private double cut2;
    private boolean gradient = false;
    private AtomicDoubleArray3D grad;
    private double dispersionOffest;
    private double soluteOffset;
    private double dispersionOverlapFactor;

    public DispersionRegion(int nt, Atom[] atoms, ForceField forceField) {
        this.dispersionLoop = new DispersionLoop[nt];
        for (int i = 0; i < nt; ++i) {
            this.dispersionLoop[i] = new DispersionLoop(this);
        }
        this.sharedDispersion = new SharedDouble();
        this.dispersionOffest = forceField.getDouble("DISPERSION_OFFSET", 1.056);
        this.soluteOffset = forceField.getDouble("SOLUTE_OFFSET", 0.0);
        this.dispersionOverlapFactor = forceField.getDouble("DISP_OVERLAP_FACTOR", 0.75);
        this.allocate(atoms);
    }

    private static double tailCorrection(double r0, double eps, double rmin) {
        if (r0 < rmin) {
            double r03 = r0 * r0 * r0;
            double rmin3 = rmin * rmin * rmin;
            return -eps * 4.0 * Math.PI * (rmin3 - r03) / 3.0 - eps * Math.PI * 18.0 * rmin3 / 11.0;
        }
        double ri2 = r0 * r0;
        double ri4 = ri2 * ri2;
        double ri7 = r0 * ri2 * ri4;
        double ri11 = ri7 * ri4;
        double rmin2 = rmin * rmin;
        double rmin4 = rmin2 * rmin2;
        double rmin7 = rmin * rmin2 * rmin4;
        return Math.PI * 2 * eps * rmin7 * (2.0 * rmin7 - 11.0 * ri7) / (11.0 * ri11);
    }

    public void allocate(Atom[] atoms) {
        this.atoms = atoms;
    }

    public void setDispersionOffest(double dispersionOffest) {
        this.dispersionOffest = dispersionOffest;
    }

    public double getDispersionOffset() {
        return this.dispersionOffest;
    }

    public double getDispersionOverlapFactor() {
        return this.dispersionOverlapFactor;
    }

    public void setDispersionOverlapFactor(double dispersionOverlapFactor) {
        this.dispersionOverlapFactor = dispersionOverlapFactor;
    }

    public double getEnergy() {
        return this.sharedDispersion.get();
    }

    public double getSoluteOffset() {
        return this.soluteOffset;
    }

    public void setSoluteOffset(double soluteOffset) {
        this.soluteOffset = soluteOffset;
    }

    public void init(Atom[] atoms, Crystal crystal, boolean[] use, int[][][] neighborLists, double[] x, double[] y, double[] z, double cut2, boolean gradient, AtomicDoubleArray3D grad) {
        this.atoms = atoms;
        this.crystal = crystal;
        this.use = use;
        this.neighborLists = neighborLists;
        this.x = x;
        this.y = y;
        this.z = z;
        this.cut2 = cut2;
        this.gradient = gradient;
        this.grad = grad;
    }

    public void run() {
        try {
            int nAtoms = this.atoms.length;
            this.execute(0, nAtoms - 1, this.dispersionLoop[this.getThreadIndex()]);
        }
        catch (Exception e) {
            String message = "Fatal exception computing Dispersion energy in thread " + this.getThreadIndex() + "\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void start() {
        this.sharedDispersion.set(0.0);
    }

    private class DispersionLoop
    extends IntegerForLoop {
        private final double[] dx_local;
        private double edisp;
        private double r;
        private double r2;
        private double r3;
        private double xr;
        private double yr;
        private double zr;
        private int threadID;
        final /* synthetic */ DispersionRegion this$0;

        DispersionLoop(DispersionRegion dispersionRegion) {
            DispersionRegion dispersionRegion2 = dispersionRegion;
            Objects.requireNonNull(dispersionRegion2);
            this.this$0 = dispersionRegion2;
            this.dx_local = new double[3];
        }

        public void finish() {
            this.this$0.sharedDispersion.addAndGet(this.edisp);
        }

        public void run(int lb, int ub) {
            for (int i = lb; i <= ub; ++i) {
                int[] list;
                if (!this.this$0.use[i]) continue;
                VDWType type = this.this$0.atoms[i].getVDWType();
                double epsi = type.wellDepth;
                double rmini = type.radius / 2.0;
                double cDisp = 0.0;
                if (rmini > 0.0 && epsi > 0.0) {
                    double emixo = VanDerWaalsForm.getCombinedEps(0.11, epsi, 1.7025, rmini, epsilonRule);
                    double rmixo = VanDerWaalsForm.getCombinedRadius(1.7025, rmini, radiusRule);
                    double riO = rmixo / 2.0 + this.this$0.dispersionOffest;
                    cDisp = DispersionRegion.tailCorrection(riO, emixo, rmixo);
                    double emixh = VanDerWaalsForm.getCombinedEps(0.0135, epsi, 1.3275, rmini, epsilonRule);
                    double rmixh = VanDerWaalsForm.getCombinedRadius(1.3275, rmini, radiusRule);
                    double riH = rmixh / 2.0 + this.this$0.dispersionOffest;
                    cDisp += 2.0 * DispersionRegion.tailCorrection(riH, emixh, rmixh);
                    cDisp = 0.033428 * cDisp;
                }
                this.edisp += cDisp;
                double sum = 0.0;
                double xi = this.this$0.x[i];
                double yi = this.this$0.y[i];
                double zi = this.this$0.z[i];
                for (int k : list = this.this$0.neighborLists[0][i]) {
                    if (!this.this$0.use[k] || i == k || !(this.this$0.atoms[k].getVDWType().radius > 0.0)) continue;
                    this.dx_local[0] = xi - this.this$0.x[k];
                    this.dx_local[1] = yi - this.this$0.y[k];
                    this.dx_local[2] = zi - this.this$0.z[k];
                    this.r2 = this.this$0.crystal.image(this.dx_local);
                    if (this.r2 > this.this$0.cut2) continue;
                    this.xr = this.dx_local[0];
                    this.yr = this.dx_local[1];
                    this.zr = this.dx_local[2];
                    this.r = FastMath.sqrt((double)this.r2);
                    this.r3 = this.r * this.r2;
                    sum += this.removeSoluteDispersion(i, k);
                    this.xr = -this.xr;
                    this.yr = -this.yr;
                    this.zr = -this.zr;
                    sum += this.removeSoluteDispersion(k, i);
                }
                this.edisp -= 0.033428 * sum;
            }
        }

        public void start() {
            this.threadID = this.getThreadIndex();
            this.edisp = 0.0;
        }

        private double removeSoluteDispersion(int i, int k) {
            VDWType type = this.this$0.atoms[i].getVDWType();
            double epsi = type.wellDepth;
            double rmini = type.radius / 2.0;
            double rmink = this.this$0.atoms[k].getVDWType().radius / 2.0;
            double emixo = VanDerWaalsForm.getCombinedEps(0.11, epsi, 1.7025, rmini, epsilonRule);
            double rmixo = VanDerWaalsForm.getCombinedRadius(1.7025, rmini, radiusRule);
            double riO = rmixo / 2.0 + this.this$0.dispersionOffest;
            double nO = 1.0;
            double emixh = VanDerWaalsForm.getCombinedEps(0.0135, epsi, 1.3275, rmini, epsilonRule);
            double rmixh = VanDerWaalsForm.getCombinedRadius(1.3275, rmini, radiusRule);
            double riH = rmixh / 2.0 + this.this$0.dispersionOffest;
            double nH = 2.0;
            double sk = (rmink + this.this$0.soluteOffset) * this.this$0.dispersionOverlapFactor;
            return this.interact(i, k, nO, riO, sk, rmixo, emixo) + this.interact(i, k, nH, riH, sk, rmixh, emixh);
        }

        private double interact(int i, int k, double factor, double ri, double sk, double rmix, double emix) {
            double sum = 0.0;
            if (ri < this.r + sk) {
                double uik;
                double de = 0.0;
                double sk2 = sk * sk;
                double iStart = FastMath.max((double)ri, (double)(this.r - sk));
                double lik = iStart;
                if (lik < rmix) {
                    double lik2 = lik * lik;
                    double lik3 = lik2 * lik;
                    double lik4 = lik3 * lik;
                    double uik2 = FastMath.min((double)(this.r + sk), (double)rmix);
                    double uik22 = uik2 * uik2;
                    double uik3 = uik22 * uik2;
                    double uik4 = uik3 * uik2;
                    sum = this.integralBeforeRMin(emix, this.r, this.r2, sk2, lik2, lik3, lik4, uik22, uik3, uik4);
                    if (this.this$0.gradient) {
                        de = this.integralBeforeRminDerivative(ri, emix, rmix, this.r, this.r2, this.r3, sk, sk2, lik, lik2, lik3, uik2, uik22, uik3);
                    }
                }
                if ((uik = this.r + sk) > rmix) {
                    lik = FastMath.max((double)iStart, (double)rmix);
                    double lik2 = lik * lik;
                    double lik3 = lik2 * lik;
                    double lik4 = lik3 * lik;
                    double lik5 = lik4 * lik;
                    double lik6 = lik5 * lik;
                    double lik10 = lik5 * lik5;
                    double lik11 = lik10 * lik;
                    double lik12 = lik11 * lik;
                    double uik2 = uik * uik;
                    double uik3 = uik2 * uik;
                    double uik4 = uik3 * uik;
                    double uik5 = uik4 * uik;
                    double uik10 = uik5 * uik5;
                    double uik11 = uik10 * uik;
                    double uik12 = uik11 * uik;
                    double rmix7 = FastMath.pow((double)rmix, (int)7);
                    sum += this.integratlAfterRmin(emix, rmix7, this.r, this.r2, sk2, lik, lik2, lik3, lik4, lik5, lik10, lik11, lik12, uik, uik2, uik3, uik4, uik5, uik10, uik11, uik12);
                    if (this.this$0.gradient) {
                        double lik13 = lik12 * lik;
                        double uik6 = uik5 * uik;
                        double uik13 = uik12 * uik;
                        de += this.integratlAfterRminDerivative(ri, emix, rmix, rmix7, iStart, this.r, this.r2, this.r3, sk, sk2, lik, lik2, lik3, lik5, lik6, lik12, lik13, uik, uik2, uik3, uik6, uik13);
                    }
                }
                if (this.this$0.gradient) {
                    de = -de / this.r * factor * 1.0 * 0.033428;
                    double dedx = de * this.xr;
                    double dedy = de * this.yr;
                    double dedz = de * this.zr;
                    this.this$0.grad.add(this.threadID, i, dedx, dedy, dedz);
                    this.this$0.grad.sub(this.threadID, k, dedx, dedy, dedz);
                }
            }
            return factor * sum;
        }

        private double integralBeforeRMin(double eps, double rij, double rij2, double rho2, double lik2, double lik3, double lik4, double uik2, double uik3, double uik4) {
            return -eps * (Math.PI * 4 * (3.0 * (lik4 - uik4) - 8.0 * rij * (lik3 - uik3) + 6.0 * (rij2 - rho2) * (lik2 - uik2)) / (48.0 * rij));
        }

        private double integralBeforeRminDerivative(double ri, double eps, double rmin, double rij, double rij2, double rij3, double rho, double rho2, double lik, double lik2, double lik3, double uik, double uik2, double uik3) {
            double dl = ri > rij - rho ? (-lik2 + 2.0 * rij2 + 2.0 * rho2) * lik2 : (-lik3 + 4.0 * lik2 * rij - 6.0 * lik * rij2 + 2.0 * lik * rho2 + 4.0 * rij3 - 4.0 * rij * rho2) * lik;
            double du = rij + rho > rmin ? -(-uik2 + 2.0 * rij2 + 2.0 * rho2) * uik2 : -(-uik3 + 4.0 * uik2 * rij - 6.0 * uik * rij2 + 2.0 * uik * rho2 + 4.0 * rij3 - 4.0 * rij * rho2) * uik;
            return -eps * Math.PI * (dl + du) / (4.0 * rij2);
        }

        private double integratlAfterRmin(double eps, double rmin7, double rij, double rij2, double rho2, double lik, double lik2, double lik3, double lik4, double lik5, double lik10, double lik11, double lik12, double uik, double uik2, double uik3, double uik4, double uik5, double uik10, double uik11, double uik12) {
            double er7 = eps * rmin7;
            double term = (15.0 * uik * lik * rij * (uik4 - lik4) - 10.0 * uik2 * lik2 * (uik3 - lik3) + 6.0 * (rho2 - rij2) * (uik5 - lik5)) / (120.0 * rij * lik5 * uik5);
            double term2 = (120.0 * uik * lik * rij * (uik11 - lik11) - 66.0 * uik2 * lik2 * (uik10 - lik10) + 55.0 * (rho2 - rij2) * (uik12 - lik12)) / (2640.0 * rij * lik12 * uik12);
            double idisp = -2.0 * er7 * term;
            double irep = er7 * rmin7 * term2;
            return Math.PI * 4 * (irep + idisp);
        }

        private double integratlAfterRminDerivative(double ri, double eps, double rmin, double rmin7, double rmax, double rij, double rij2, double rij3, double rho, double rho2, double lik, double lik2, double lik3, double lik5, double lik6, double lik12, double lik13, double uik, double uik2, double uik3, double uik6, double uik13) {
            double er7 = eps * rmin7;
            double lowerTerm = lik2 * rij + rij3 - rij * rho2;
            double upperTerm = uik2 * rij + rij3 - rij * rho2;
            double dl = ri > rij - rho || rmax < rmin ? -(-5.0 * lik2 + 3.0 * rij2 + 3.0 * rho2) / lik5 : (5.0 * lik3 - 33.0 * lik * rij2 - 3.0 * lik * rho2 + 15.0 * lowerTerm) / lik6;
            double du = -(5.0 * uik3 - 33.0 * uik * rij2 - 3.0 * uik * rho2 + 15.0 * upperTerm) / uik6;
            double de = Math.PI * -2 * er7 * (dl + du) / (15.0 * rij2);
            dl = ri > rij - rho || rmax < rmin ? -(-6.0 * lik2 + 5.0 * rij2 + 5.0 * rho2) / lik12 : (6.0 * lik3 - 125.0 * lik * rij2 - 5.0 * lik * rho2 + 60.0 * lowerTerm) / lik13;
            du = -(6.0 * uik3 - 125.0 * uik * rij2 - 5.0 * uik * rho2 + 60.0 * upperTerm) / uik13;
            return de += Math.PI * er7 * rmin7 * (dl + du) / (60.0 * rij2);
        }
    }
}

