/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.implicit;

import org.apache.commons.math3.util.FastMath;

public class BornTanhRescaling {
    public static final double MAX_BORN_RADIUS = 30.0;
    private static final double RECIP_MAX_BORN_RADIUS3 = FastMath.pow((double)30.0, (double)-3.0);
    private static final double PI4_3 = 4.1887902047863905;
    private static double beta0 = 0.9563;
    private static double beta1 = 0.2578;
    private static double beta2 = 0.081;

    public static double tanhRescaling(double Ii, double rhoi) {
        double rhoi3 = rhoi * rhoi * rhoi;
        double rhoi3Psi = rhoi3 * Ii;
        double rhoi6Psi2 = rhoi3Psi * rhoi3Psi;
        double rhoi9Psi3 = rhoi6Psi2 * rhoi3Psi;
        double tanh_constant = 4.1887902047863905 * (1.0 / rhoi3 - RECIP_MAX_BORN_RADIUS3);
        return tanh_constant * FastMath.tanh((double)(beta0 * rhoi3Psi - beta1 * rhoi6Psi2 + beta2 * rhoi9Psi3));
    }

    public static double tanhRescalingChainRule(double Ii, double rhoi) {
        double rhoi3 = rhoi * rhoi * rhoi;
        double rhoi3Psi = rhoi3 * Ii;
        double rhoi6Psi2 = rhoi3Psi * rhoi3Psi;
        double rhoi9Psi3 = rhoi6Psi2 * rhoi3Psi;
        double rhoi6Psi = rhoi3 * rhoi3 * Ii;
        double rhoi9Psi2 = rhoi6Psi2 * rhoi3;
        double tanhTerm = FastMath.tanh((double)(beta0 * rhoi3Psi - beta1 * rhoi6Psi2 + beta2 * rhoi9Psi3));
        double tanh2 = tanhTerm * tanhTerm;
        double chainRuleTerm = beta0 * rhoi3 - 2.0 * beta1 * rhoi6Psi + 3.0 * beta2 * rhoi9Psi2;
        double tanh_constant = 4.1887902047863905 * (1.0 / rhoi3 - RECIP_MAX_BORN_RADIUS3);
        return tanh_constant * chainRuleTerm * (1.0 - tanh2);
    }

    public static double getBeta0() {
        return beta0;
    }

    public static double getBeta1() {
        return beta1;
    }

    public static double getBeta2() {
        return beta2;
    }

    public static void setBeta0(double beta0) {
        BornTanhRescaling.beta0 = beta0;
    }

    public static void setBeta1(double beta1) {
        BornTanhRescaling.beta1 = beta1;
    }

    public static void setBeta2(double beta2) {
        BornTanhRescaling.beta2 = beta2;
    }
}

