/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded.implicit;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.reduction.DoubleOp;
import edu.rit.pj.reduction.SharedDoubleArray;
import ffx.crystal.Crystal;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.implicit.BornTanhRescaling;
import ffx.potential.nonbonded.implicit.NeckIntegral;
import ffx.potential.parameters.ForceField;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;

public class BornRadiiRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(BornRadiiRegion.class.getName());
    private static final double oneThird = 0.3333333333333333;
    private static final double PI4_3 = 4.1887902047863905;
    private static final double INVERSE_PI4_3 = 0.23873241463784303;
    private static final double PI_12 = 0.2617993877991494;
    private final BornRadiiLoop[] bornRadiiLoop;
    protected Atom[] atoms;
    private Crystal crystal;
    private double[][][] sXYZ;
    private int[][][] neighborLists;
    private double[] baseRadius;
    private double[] descreenRadius;
    private double[] overlapScale;
    private double[] neckScale;
    private final double[] perfectRadii;
    private final boolean usePerfectRadii;
    private double[] born;
    private boolean[] use;
    private double cut2;
    private boolean nativeEnvironmentApproximation;
    private final boolean perfectHCTScale;
    private double descreenOffset = 0.0;
    private SharedDoubleArray sharedBorn;
    private boolean verboseRadii;
    private final boolean neckCorrection;
    private final boolean tanhCorrection;
    private double[] unscaledBornIntegral;

    public BornRadiiRegion(int nt, int nAtoms, ForceField forceField, boolean neckCorrection, boolean tanhCorrection, boolean perfectHCTScale) {
        this.bornRadiiLoop = new BornRadiiLoop[nt];
        for (int i = 0; i < nt; ++i) {
            this.bornRadiiLoop[i] = new BornRadiiLoop(this);
        }
        this.verboseRadii = forceField.getBoolean("VERBOSE_BORN_RADII", false);
        this.perfectHCTScale = perfectHCTScale;
        this.neckCorrection = neckCorrection;
        this.tanhCorrection = tanhCorrection;
        if (this.verboseRadii && logger.isLoggable(Level.FINER)) {
            logger.finer(" Verbose Born radii.");
        }
        if (tanhCorrection) {
            this.unscaledBornIntegral = new double[nAtoms];
        }
        CompositeConfiguration compositeConfiguration = forceField.getProperties();
        this.usePerfectRadii = forceField.getBoolean("PERFECT_RADII", false);
        String[] radii = compositeConfiguration.getStringArray("perfect-radius");
        if (this.usePerfectRadii) {
            this.perfectRadii = new double[nAtoms];
            if (radii != null && radii.length > 0) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(String.format(" Reading %d perfect-radius records .", radii.length));
                }
                for (String radius : radii) {
                    String[] tokens = radius.trim().split(" +");
                    if (tokens.length == 2) {
                        int index = Integer.parseInt(tokens[0]) - 1;
                        double value = Double.parseDouble(tokens[1]);
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(String.format(" perfect-radius %d %16.8f", index, value));
                        }
                        if (index < 0 || index >= nAtoms || !(value > 0.0)) continue;
                        this.perfectRadii[index] = value;
                        continue;
                    }
                    logger.warning(String.format(" Could not parse perfect-radius line %s", radius));
                }
            }
        } else {
            this.perfectRadii = null;
        }
    }

    public double[] getPerfectRadii() {
        int nAtoms = this.atoms.length;
        double[] radii = new double[nAtoms];
        System.arraycopy(this.baseRadius, 0, radii, 0, nAtoms);
        if (this.usePerfectRadii) {
            for (int i = 0; i < nAtoms; ++i) {
                double perfectRadius = this.perfectRadii[i];
                if (!(perfectRadius > 0.0)) continue;
                radii[i] = perfectRadius;
            }
        }
        return radii;
    }

    public void finish() {
        int nAtoms = this.atoms.length;
        if (this.usePerfectRadii) {
            for (int i = 0; i < nAtoms; ++i) {
                double perfectRadius = this.perfectRadii[i];
                this.born[i] = !this.use[i] || perfectRadius <= 0.0 ? this.baseRadius[i] : perfectRadius;
            }
            return;
        }
        for (int i = 0; i < nAtoms; ++i) {
            double sum;
            double baseRi = this.baseRadius[i];
            if (!this.use[i]) {
                this.born[i] = baseRi;
                continue;
            }
            double soluteIntegral = -this.sharedBorn.get(i);
            if (this.tanhCorrection) {
                this.unscaledBornIntegral[i] = soluteIntegral;
                soluteIntegral = BornTanhRescaling.tanhRescaling(soluteIntegral, baseRi);
            }
            if ((sum = 4.1887902047863905 / (baseRi * baseRi * baseRi) - soluteIntegral) <= 0.0) {
                this.born[i] = 30.0;
                if (!this.verboseRadii) continue;
                logger.info(String.format(" Born Integral < 0 for atom %d; set Born radius to %12.6f (Base Radius: %12.6f)", i + 1, this.born[i], this.baseRadius[i]));
                continue;
            }
            this.born[i] = FastMath.pow((double)(0.23873241463784303 * sum), (double)-0.3333333333333333);
            if (this.born[i] < baseRi) {
                this.born[i] = baseRi;
                if (!this.verboseRadii) continue;
                logger.info(String.format(" Born radius < Base Radius for atom %d: set Born radius to %12.6f", i + 1, baseRi));
                continue;
            }
            if (this.born[i] > 30.0) {
                this.born[i] = 30.0;
                if (!this.verboseRadii) continue;
                logger.info(String.format(" Born radius > %12.6f Angstroms for atom %d: set Born radius to %12.6f", 30.0, i + 1, baseRi));
                continue;
            }
            if (Double.isInfinite(this.born[i]) || Double.isNaN(this.born[i])) {
                this.born[i] = baseRi;
                if (!this.verboseRadii) continue;
                logger.info(String.format(" Born radius NaN / Infinite for atom %d; set Born radius to %12.6f", i + 1, baseRi));
                continue;
            }
            if (!this.verboseRadii) continue;
            logger.info(String.format(" Born radius for atom %d: %12.6f (Base Radius: %2.6f)", i + 1, this.born[i], baseRi));
        }
        if (this.verboseRadii) {
            logger.info(" Disabling verbose radii printing.");
            this.verboseRadii = false;
        }
    }

    public void init(Atom[] atoms, Crystal crystal, double[][][] sXYZ, int[][][] neighborLists, double[] baseRadius, double[] descreenRadius, double[] overlapScale, double[] neckScale, double descreenOffset, boolean[] use, double cut2, boolean nativeEnvironmentApproximation, double[] born) {
        this.atoms = atoms;
        this.crystal = crystal;
        this.sXYZ = sXYZ;
        this.neighborLists = neighborLists;
        this.baseRadius = baseRadius;
        this.descreenRadius = descreenRadius;
        this.overlapScale = overlapScale;
        this.neckScale = neckScale;
        this.descreenOffset = descreenOffset;
        this.use = use;
        this.cut2 = cut2;
        this.nativeEnvironmentApproximation = nativeEnvironmentApproximation;
        this.born = born;
    }

    public void run() {
        if (!this.usePerfectRadii) {
            try {
                int nAtoms = this.atoms.length;
                this.execute(0, nAtoms - 1, this.bornRadiiLoop[this.getThreadIndex()]);
            }
            catch (Exception e) {
                String message = "Fatal exception computing Born radii in thread " + this.getThreadIndex() + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
    }

    public void start() {
        int nAtoms = this.atoms.length;
        if (this.sharedBorn == null || this.sharedBorn.length() < nAtoms) {
            this.sharedBorn = new SharedDoubleArray(nAtoms);
        }
        for (int i = 0; i < nAtoms; ++i) {
            this.sharedBorn.set(i, 0.0);
        }
    }

    public double[] getBorn() {
        return this.born;
    }

    public double[] getUnscaledBornIntegral() {
        return this.unscaledBornIntegral;
    }

    private class BornRadiiLoop
    extends IntegerForLoop {
        private double[] localBorn;
        final /* synthetic */ BornRadiiRegion this$0;

        private BornRadiiLoop(BornRadiiRegion bornRadiiRegion) {
            BornRadiiRegion bornRadiiRegion2 = bornRadiiRegion;
            Objects.requireNonNull(bornRadiiRegion2);
            this.this$0 = bornRadiiRegion2;
        }

        public void finish() {
            this.this$0.sharedBorn.reduce(this.localBorn, DoubleOp.SUM);
        }

        public void run(int lb, int ub) {
            int nSymm = this.this$0.crystal.spaceGroup.symOps.size();
            if (nSymm == 0) {
                nSymm = 1;
            }
            double[] x = this.this$0.sXYZ[0][0];
            double[] y = this.this$0.sXYZ[0][1];
            double[] z = this.this$0.sXYZ[0][2];
            for (int iSymOp = 0; iSymOp < nSymm; ++iSymOp) {
                double[][] xyz = this.this$0.sXYZ[iSymOp];
                for (int i = lb; i <= ub; ++i) {
                    int[] list;
                    if (!this.this$0.nativeEnvironmentApproximation && !this.this$0.use[i]) continue;
                    double integralStartI = FastMath.max((double)this.this$0.baseRadius[i], (double)this.this$0.descreenRadius[i]) + this.this$0.descreenOffset;
                    double descreenRi = this.this$0.descreenRadius[i];
                    double xi = x[i];
                    double yi = y[i];
                    double zi = z[i];
                    for (int k : list = this.this$0.neighborLists[iSymOp][i]) {
                        double sk;
                        double r;
                        double r2;
                        double zr;
                        double yr;
                        double xr;
                        double integralStartK = FastMath.max((double)this.this$0.baseRadius[k], (double)this.this$0.descreenRadius[k]) + this.this$0.descreenOffset;
                        double descreenRk = this.this$0.descreenRadius[k];
                        if (!this.this$0.nativeEnvironmentApproximation && !this.this$0.use[k]) continue;
                        double mixedNeckScale = 0.5 * (this.this$0.neckScale[i] + this.this$0.neckScale[k]);
                        if (i != k) {
                            double si;
                            xr = xyz[0][k] - xi;
                            yr = xyz[1][k] - yi;
                            zr = xyz[2][k] - zi;
                            r2 = this.this$0.crystal.image(xr, yr, zr);
                            if (r2 > this.this$0.cut2) continue;
                            r = FastMath.sqrt((double)r2);
                            sk = this.this$0.overlapScale[k];
                            if (sk > 0.0) {
                                double descreenIK = this.descreen(r, r2, integralStartI, descreenRk, sk);
                                int n = i;
                                this.localBorn[n] = this.localBorn[n] + descreenIK;
                                if (this.this$0.neckCorrection) {
                                    int n2 = i;
                                    this.localBorn[n2] = this.localBorn[n2] + this.neckDescreen(r, integralStartI, descreenRk, mixedNeckScale);
                                }
                            }
                            if (!((si = this.this$0.overlapScale[i]) > 0.0)) continue;
                            double descreenKI = this.descreen(r, r2, integralStartK, descreenRi, si);
                            int n = k;
                            this.localBorn[n] = this.localBorn[n] + descreenKI;
                            if (!this.this$0.neckCorrection) continue;
                            int n3 = k;
                            this.localBorn[n3] = this.localBorn[n3] + this.neckDescreen(r, integralStartK, descreenRi, mixedNeckScale);
                            continue;
                        }
                        if (iSymOp <= 0 || (r2 = this.this$0.crystal.image(xr = xyz[0][k] - xi, yr = xyz[1][k] - yi, zr = xyz[2][k] - zi)) > this.this$0.cut2) continue;
                        r = FastMath.sqrt((double)r2);
                        sk = this.this$0.overlapScale[k];
                        if (!(sk > 0.0)) continue;
                        int n = i;
                        this.localBorn[n] = this.localBorn[n] + this.descreen(r, r2, integralStartI, descreenRk, sk);
                        if (!this.this$0.neckCorrection) continue;
                        int n4 = i;
                        this.localBorn[n4] = this.localBorn[n4] + this.neckDescreen(r, integralStartI, descreenRk, mixedNeckScale);
                    }
                }
            }
        }

        public void start() {
            int nAtoms = this.this$0.atoms.length;
            if (this.localBorn == null || this.localBorn.length < nAtoms) {
                this.localBorn = new double[nAtoms];
            }
            Arrays.fill(this.localBorn, 0.0);
        }

        private double neckDescreen(double r, double radius, double radiusK, double sneck) {
            double radiusWater = 1.4;
            if (r > radius + radiusK + 2.0 * radiusWater) {
                return 0.0;
            }
            double[] constants = NeckIntegral.getNeckConstants(radius, radiusK);
            double Aij = constants[0];
            double Bij = constants[1];
            double rMinusBij = r - Bij;
            double radiiMinusr = radius + radiusK + 2.0 * radiusWater - r;
            double power1 = rMinusBij * rMinusBij * rMinusBij * rMinusBij;
            double power2 = radiiMinusr * radiiMinusr * radiiMinusr * radiiMinusr;
            double neckIntegral = 4.1887902047863905 * sneck * Aij * power1 * power2;
            return -neckIntegral;
        }

        private double descreen(double r, double r2, double radius, double radiusK, double hctScale) {
            if (this.this$0.perfectHCTScale) {
                return this.perfectHCTIntegral(r, r2, radius, radiusK, hctScale);
            }
            return this.integral(r, r2, radius, radiusK * hctScale);
        }

        private double integral(double r, double r2, double radius, double scaledRadius) {
            double integral = 0.0;
            if (scaledRadius > 0.0 && radius < r + scaledRadius) {
                double upper;
                if (radius + r < scaledRadius) {
                    upper = scaledRadius - r;
                    integral = 4.1887902047863905 * (1.0 / (upper * upper * upper) - 1.0 / (radius * radius * radius));
                }
                upper = r + scaledRadius;
                double lower = radius + r < scaledRadius ? scaledRadius - r : (r < radius + scaledRadius ? radius : r - scaledRadius);
                double l2 = lower * lower;
                double l4 = l2 * l2;
                double lr = lower * r;
                double l4r = l4 * r;
                double u2 = upper * upper;
                double u4 = u2 * u2;
                double ur = upper * r;
                double u4r = u4 * r;
                double scaledRk2 = scaledRadius * scaledRadius;
                double term = (3.0 * (r2 - scaledRk2) + 6.0 * u2 - 8.0 * ur) / u4r - (3.0 * (r2 - scaledRk2) + 6.0 * l2 - 8.0 * lr) / l4r;
                integral -= 0.2617993877991494 * term;
            }
            return integral;
        }

        private double perfectHCTIntegral(double r, double r2, double radius, double radiusK, double perfectHCT) {
            double integral = 0.0;
            if (radiusK > 0.0 && radius < r + radiusK) {
                double upper;
                if (radius + r < radiusK) {
                    upper = radiusK - r;
                    integral = 4.1887902047863905 * (1.0 / (upper * upper * upper) - 1.0 / (radius * radius * radius));
                }
                upper = r + radiusK;
                double lower = radius + r < radiusK ? radiusK - r : (r < radius + radiusK ? radius : r - radiusK);
                double l2 = lower * lower;
                double l4 = l2 * l2;
                double lr = lower * r;
                double l4r = l4 * r;
                double u2 = upper * upper;
                double u4 = u2 * u2;
                double ur = upper * r;
                double u4r = u4 * r;
                double scaledK2 = radiusK * radiusK;
                double term = (3.0 * (r2 - scaledK2) + 6.0 * u2 - 8.0 * ur) / u4r - (3.0 * (r2 - scaledK2) + 6.0 * l2 - 8.0 * lr) / l4r;
                integral -= 0.2617993877991494 * term;
            }
            return perfectHCT * integral;
        }
    }
}

