/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded;

import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.VDWPairType;
import ffx.potential.parameters.VDWType;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class VanDerWaalsForm {
    private static final Logger logger = Logger.getLogger(VanDerWaalsForm.class.getName());
    static final byte RADMIN = 0;
    static final byte EPS = 1;
    public static final double DEFAULT_VDW_TAPER = 0.9;
    public static final double DEFAULT_VDW_CUTOFF = 12.0;
    @FFXProperty(name="halgren-gamma", propertyGroup=PropertyGroup.VanDerWaalsFunctionalForm, defaultValue="0.12", description="Sets the value of the gamma parameter in Halgren\u2019s buffered 14-7 vdw potential energy functional form.\nIn the absence of the gamma-halgren property, a default value of 0.12 is used.\"\n")
    public final double gamma;
    @FFXProperty(name="halgren-delta", propertyGroup=PropertyGroup.VanDerWaalsFunctionalForm, defaultValue="0.07", description="Sets the value of the delta parameter in Halgren\u2019s buffered 14-7 vdw potential energy functional form.\nIn the absence of the delta-halgren property, a default value of 0.07 is used.\n")
    public final double delta;
    @FFXProperty(name="vdwtype", clazz=String.class, propertyGroup=PropertyGroup.VanDerWaalsFunctionalForm, defaultValue="LENNARD-JONES", description="[LENNARD-JONES / BUFFERED-14-7]\nSets the functional form for the van der Waals potential energy term.\nThe text modifier gives the name of the functional form to be used.\nThe default in the absence of the vdwtype keyword is to use the standard two parameter Lennard-Jones function.\n")
    public VDWType.VDW_TYPE vdwType = VDWType.DEFAULT_VDW_TYPE;
    @FFXProperty(name="epsilonrule", clazz=String.class, propertyGroup=PropertyGroup.VanDerWaalsFunctionalForm, defaultValue="GEOMETRIC", description="[GEOMETRIC / HHG / W-H]\nSelects the combining rule used to derive the epsilon value for van der Waals interactions.\nThe default in the absence of the epsilonrule keyword is to use the geometric mean of the\nindividual epsilon values of the two atoms involved in the van der Waals interaction.\n")
    public VDWType.EPSILON_RULE epsilonRule;
    @FFXProperty(name="radiusrule", clazz=String.class, propertyGroup=PropertyGroup.VanDerWaalsFunctionalForm, defaultValue="ARITHMETIC", description="[ARITHMETIC / GEOMETRIC / CUBIC-MEAN]\nSets the functional form of the radius combining rule for heteroatomic van der Waals potential energy interactions.\nThe default in the absence of the radiusrule keyword is to use the arithmetic mean combining rule to get radii for heteroatomic interactions.\n")
    public VDWType.RADIUS_RULE radiusRule;
    @FFXProperty(name="radiussize", clazz=String.class, propertyGroup=PropertyGroup.VanDerWaalsFunctionalForm, defaultValue="RADIUS", description="[RADIUS / DIAMETER]\nDetermines whether the atom size values given in van der Waals parameters read from\nVDW keyword statements are interpreted as atomic radius or diameter values.\nThe default in the absence of the radiussize keyword is to assume that vdw size parameters are given as radius values.\n")
    public VDWType.RADIUS_SIZE radiusSize;
    @FFXProperty(name="radiustype", clazz=String.class, propertyGroup=PropertyGroup.VanDerWaalsFunctionalForm, defaultValue="R-MIN", description="[R-MIN / SIGMA]\nDetermines whether atom size values given in van der Waals parameters read from VDW keyword\nstatements are interpreted as potential minimum (Rmin) or LJ-style sigma values.\nThe default in the absence of the radiustype keyword is to assume that vdw size parameters are given as Rmin values.\n")
    public VDWType.RADIUS_TYPE radiusType;
    @FFXProperty(name="vdw-12-scale", propertyGroup=PropertyGroup.VanDerWaalsFunctionalForm, defaultValue="0.0", description="Provides a multiplicative scale factor that is applied to van der Waals potential\ninteractions between 1-2 connected atoms, i.e., atoms that are directly bonded.\nThe default value of 0.0 is used to omit 1-2 interactions,\nif the vdw-12-scale property is not given in either the parameter file or the property file.\n")
    protected double scale12;
    @FFXProperty(name="vdw-13-scale", propertyGroup=PropertyGroup.VanDerWaalsFunctionalForm, defaultValue="0.0", description="Provides a multiplicative scale factor that is applied to van der Waals potential\ninteractions between 1-3 connected atoms, i.e., atoms separated by two covalent bonds.\nThe default value of 0.0 is used to omit 1-3 interactions, if the vdw-13-scale property\nis not given in either the parameter file or the property file.\n")
    protected double scale13;
    @FFXProperty(name="vdw-14-scale", propertyGroup=PropertyGroup.VanDerWaalsFunctionalForm, defaultValue="1.0", description="Provides a multiplicative scale factor that is applied to van der Waals potential\ninteractions between 1-4 connected atoms, i.e., atoms separated by three covalent bonds.\nThe default value of 1.0 is used, if the vdw-14-scale keyword is not given in either\nthe parameter file or the property file.\n")
    protected double scale14;
    int maxClass;
    double[] rMin;
    double[] eps;
    private final double[][] radEps;
    private final double[][] radEps14;
    private final VDWPowers vdwPowers;
    final int dispersivePower;
    private final int dispersivePower1;
    final double t1n;
    final int repDispPower;
    private final int repDispPower1;
    final double gamma1;

    public VanDerWaalsForm(ForceField forceField) {
        int i;
        int repulsivePower;
        String value = forceField.getString("VDWTYPE", VDWType.DEFAULT_VDW_TYPE.name());
        try {
            this.vdwType = VDWType.VDW_TYPE.valueOf(ForceField.toEnumForm(value));
        }
        catch (Exception e) {
            logger.info(String.format(" Unrecognized VDWTYPE %s; defaulting to %s.", new Object[]{value, this.vdwType}));
        }
        switch (this.vdwType) {
            case BUFFERED_14_7: {
                this.vdwPowers = new Buffered_14_7(this);
                break;
            }
            case LENNARD_JONES: {
                this.vdwPowers = new LJ_6_12(this);
                break;
            }
            default: {
                this.vdwPowers = new VDWPowers(this);
            }
        }
        this.epsilonRule = VDWType.DEFAULT_EPSILON_RULE;
        value = forceField.getString("EPSILONRULE", VDWType.DEFAULT_EPSILON_RULE.name());
        try {
            this.epsilonRule = VDWType.EPSILON_RULE.valueOf(ForceField.toEnumForm(value));
        }
        catch (Exception e) {
            logger.info(String.format(" Unrecognized EPSILONRULE %s; defaulting to %s.", new Object[]{value, this.epsilonRule}));
        }
        this.radiusRule = VDWType.DEFAULT_RADIUS_RULE;
        value = forceField.getString("RADIUSRULE", VDWType.DEFAULT_RADIUS_RULE.name());
        try {
            this.radiusRule = VDWType.RADIUS_RULE.valueOf(ForceField.toEnumForm(value));
        }
        catch (Exception e) {
            logger.info(String.format(" Unrecognized RADIUSRULE %s; defaulting to %s.", new Object[]{value, this.radiusRule}));
        }
        this.radiusSize = VDWType.DEFAULT_RADIUS_SIZE;
        value = forceField.getString("RADIUSSIZE", VDWType.DEFAULT_RADIUS_SIZE.name());
        try {
            this.radiusSize = VDWType.RADIUS_SIZE.valueOf(ForceField.toEnumForm(value));
        }
        catch (Exception e) {
            logger.info(String.format(" Unrecognized RADIUSSIZE %s; defaulting to %s.", new Object[]{value, this.radiusSize}));
        }
        this.radiusType = VDWType.DEFAULT_RADIUS_TYPE;
        value = forceField.getString("RADIUSTYPE", VDWType.DEFAULT_RADIUS_TYPE.name());
        try {
            this.radiusType = VDWType.RADIUS_TYPE.valueOf(ForceField.toEnumForm(value));
        }
        catch (Exception e) {
            logger.info(String.format(" Unrecognized RADIUSTYPE %s; defaulting to %s", new Object[]{value, this.radiusType}));
        }
        switch (this.vdwType) {
            case LENNARD_JONES: {
                repulsivePower = 12;
                this.dispersivePower = 6;
                this.delta = 0.0;
                this.gamma = 0.0;
                break;
            }
            default: {
                repulsivePower = 14;
                this.dispersivePower = 7;
                this.delta = forceField.getDouble("DELTA-HALGREN", 0.07);
                this.gamma = forceField.getDouble("GAMMA-HALGREN", 0.12);
            }
        }
        this.repDispPower = repulsivePower - this.dispersivePower;
        this.dispersivePower1 = this.dispersivePower - 1;
        this.repDispPower1 = this.repDispPower - 1;
        double delta1 = 1.0 + this.delta;
        this.t1n = FastMath.pow((double)delta1, (int)this.dispersivePower);
        this.gamma1 = 1.0 + this.gamma;
        this.scale12 = forceField.getDouble("VDW_12_SCALE", 0.0);
        this.scale13 = forceField.getDouble("VDW_13_SCALE", 0.0);
        this.scale14 = forceField.getDouble("VDW_14_SCALE", 1.0);
        double scale15 = forceField.getDouble("VDW_15_SCALE", 1.0);
        if (scale15 != 1.0) {
            logger.severe(" Van Der Waals 1-5 masking rules are not supported.");
        }
        if (this.scale12 > 1.0) {
            this.scale12 = 1.0 / this.scale12;
        }
        if (this.scale13 > 1.0) {
            this.scale13 = 1.0 / this.scale13;
        }
        if (this.scale14 > 1.0) {
            this.scale14 = 1.0 / this.scale14;
        }
        Map<String, VDWType> map = forceField.getVDWTypes();
        TreeMap<String, VDWType> vdwTypes = new TreeMap<String, VDWType>(map);
        this.maxClass = 0;
        for (VDWType currentType : vdwTypes.values()) {
            if (currentType.atomClass <= this.maxClass) continue;
            this.maxClass = currentType.atomClass;
        }
        this.radEps = new double[this.maxClass + 1][2 * (this.maxClass + 1)];
        this.radEps14 = new double[this.maxClass + 1][2 * (this.maxClass + 1)];
        double radScale = switch (this.radiusSize) {
            case VDWType.RADIUS_SIZE.DIAMETER -> 0.5;
            default -> 1.0;
        };
        switch (this.radiusType) {
            case SIGMA: {
                radScale *= 1.122462048309373;
                break;
            }
        }
        this.rMin = new double[this.maxClass + 1];
        this.eps = new double[this.maxClass + 1];
        for (VDWType vDWType : vdwTypes.values()) {
            int i2 = vDWType.atomClass;
            double ri = radScale * vDWType.radius;
            double e1 = vDWType.wellDepth;
            this.rMin[i2] = ri;
            this.eps[i2] = e1;
            for (VDWType vdwj : vdwTypes.tailMap(vDWType.getKey()).values()) {
                int j = vdwj.atomClass;
                double rj = radScale * vdwj.radius;
                double e2 = vdwj.wellDepth;
                double radmin = VanDerWaalsForm.getCombinedRadius(ri, rj, this.radiusRule);
                double eps = VanDerWaalsForm.getCombinedEps(e1, e2, ri, rj, this.epsilonRule);
                if (radmin > 0.0) {
                    this.radEps[i2][j * 2 + 0] = 1.0 / radmin;
                    this.radEps[j][i2 * 2 + 0] = 1.0 / radmin;
                    this.radEps14[i2][j * 2 + 0] = 1.0 / radmin;
                    this.radEps14[j][i2 * 2 + 0] = 1.0 / radmin;
                } else {
                    this.radEps[i2][j * 2 + 0] = 0.0;
                    this.radEps[j][i2 * 2 + 0] = 0.0;
                    this.radEps14[i2][j * 2 + 0] = 0.0;
                    this.radEps14[j][i2 * 2 + 0] = 0.0;
                }
                this.radEps[i2][j * 2 + 1] = eps;
                this.radEps[j][i2 * 2 + 1] = eps;
                this.radEps14[i2][j * 2 + 1] = eps;
                this.radEps14[j][i2 * 2 + 1] = eps;
            }
        }
        Map<String, VDWType> vdw14Types = forceField.getVDW14Types();
        for (VDWType vdwi : vdwTypes.values()) {
            VDWType vdw14 = forceField.getVDW14Type(vdwi.getKey());
            if (vdw14 != null) {
                vdwi = vdw14;
            }
            i = vdwi.atomClass;
            double ri = radScale * vdwi.radius;
            double e1 = vdwi.wellDepth;
            for (VDWType vdwj : vdw14Types.values()) {
                int j = vdwj.atomClass;
                double rj = radScale * vdwj.radius;
                double e2 = vdwj.wellDepth;
                double radmin = VanDerWaalsForm.getCombinedRadius(ri, rj, this.radiusRule);
                double eps = VanDerWaalsForm.getCombinedEps(e1, e2, ri, rj, this.epsilonRule);
                if (radmin > 0.0) {
                    this.radEps14[i][j * 2 + 0] = 1.0 / radmin;
                    this.radEps14[j][i * 2 + 0] = 1.0 / radmin;
                } else {
                    this.radEps14[i][j * 2 + 0] = 0.0;
                    this.radEps14[j][i * 2 + 0] = 0.0;
                }
                this.radEps14[i][j * 2 + 1] = eps;
                this.radEps14[j][i * 2 + 1] = eps;
            }
        }
        Map<String, VDWPairType> map2 = forceField.getVDWPairTypes();
        for (VDWPairType vdwPairType : map2.values()) {
            i = vdwPairType.atomClasses[0];
            int j = vdwPairType.atomClasses[1];
            double radmin = vdwPairType.radius;
            double eps = vdwPairType.wellDepth;
            if (radmin > 0.0) {
                this.radEps[i][j * 2 + 0] = 1.0 / radmin;
                this.radEps[j][i * 2 + 0] = 1.0 / radmin;
                this.radEps14[i][j * 2 + 0] = 1.0 / radmin;
                this.radEps14[j][i * 2 + 0] = 1.0 / radmin;
            } else {
                this.radEps[i][j * 2 + 0] = 0.0;
                this.radEps[j][i * 2 + 0] = 0.0;
                this.radEps14[i][j * 2 + 0] = 0.0;
                this.radEps14[j][i * 2 + 0] = 0.0;
            }
            this.radEps[i][j * 2 + 1] = eps;
            this.radEps[j][i * 2 + 1] = eps;
            this.radEps14[i][j * 2 + 1] = eps;
            this.radEps14[j][i * 2 + 1] = eps;
        }
    }

    public static double getCombinedEps(double ei, double ej, double ri, double rj, VDWType.EPSILON_RULE epsilonRule) {
        double sei = FastMath.sqrt((double)ei);
        double sej = FastMath.sqrt((double)ej);
        switch (epsilonRule) {
            case GEOMETRIC: {
                return sei * sej;
            }
            case W_H: {
                double rr = ri * rj;
                double rr3 = rr * rr * rr;
                double ri6 = FastMath.pow((double)ri, (int)6);
                double rj6 = FastMath.pow((double)rj, (int)6);
                return 2.0 * sei * sej * rr3 / (ri6 + rj6);
            }
        }
        if (ei * ej == 0.0) {
            return 0.0;
        }
        return 4.0 * (ei * ej) / ((sei + sej) * (sei + sej));
    }

    public static double getCombinedRadius(double ri, double rj, VDWType.RADIUS_RULE radiusRule) {
        switch (radiusRule) {
            case ARITHMETIC: {
                return ri + rj;
            }
            case GEOMETRIC: {
                return 2.0 * FastMath.sqrt((double)ri) * FastMath.sqrt((double)rj);
            }
        }
        double ri2 = ri * ri;
        double ri3 = ri * ri2;
        double rj2 = rj * rj;
        double rj3 = rj * rj2;
        return 2.0 * (ri3 + rj3) / (ri2 + rj2);
    }

    public double getCombinedEps(int class1, int class2) {
        return this.radEps[class1][class2 * 2 + 1];
    }

    public double getCombinedEps14(int class1, int class2) {
        return this.radEps14[class1][class2 * 2 + 1];
    }

    public double getCombinedInverseRmin(int class1, int class2) {
        return this.radEps[class1][class2 * 2 + 0];
    }

    public double getCombinedInverseRmin14(int class1, int class2) {
        return this.radEps14[class1][class2 * 2 + 0];
    }

    public double[] getEps() {
        return this.eps;
    }

    public double[] getRmin() {
        return this.rMin;
    }

    public double getScale14() {
        return this.scale14;
    }

    double rhoDisp1(double rho) {
        return this.vdwPowers.rhoDisp1(rho);
    }

    double rhoDelta1(double rhoDelta) {
        return this.vdwPowers.rhoDisp1(rhoDelta);
    }

    private class Buffered_14_7
    extends VDWPowers {
        private Buffered_14_7(VanDerWaalsForm vanDerWaalsForm) {
            Objects.requireNonNull(vanDerWaalsForm);
            super(vanDerWaalsForm);
        }

        @Override
        public double rhoDelta1(double rhoDelta) {
            double rhoDelta2 = rhoDelta * rhoDelta;
            return rhoDelta2 * rhoDelta2 * rhoDelta2;
        }

        @Override
        public double rhoDisp1(double rho) {
            double rho2 = rho * rho;
            return rho2 * rho2 * rho2;
        }
    }

    private class VDWPowers {
        final /* synthetic */ VanDerWaalsForm this$0;

        private VDWPowers(VanDerWaalsForm vanDerWaalsForm) {
            VanDerWaalsForm vanDerWaalsForm2 = vanDerWaalsForm;
            Objects.requireNonNull(vanDerWaalsForm2);
            this.this$0 = vanDerWaalsForm2;
        }

        public double rhoDelta1(double rhoDelta) {
            return FastMath.pow((double)rhoDelta, (int)this.this$0.repDispPower1);
        }

        public double rhoDisp1(double rho) {
            return FastMath.pow((double)rho, (int)this.this$0.dispersivePower1);
        }
    }

    private class LJ_6_12
    extends VDWPowers {
        private LJ_6_12(VanDerWaalsForm vanDerWaalsForm) {
            Objects.requireNonNull(vanDerWaalsForm);
            super(vanDerWaalsForm);
        }

        @Override
        public double rhoDelta1(double rhoDelta) {
            double rhoDelta2 = rhoDelta * rhoDelta;
            return rhoDelta2 * rhoDelta2 * rhoDelta;
        }

        @Override
        public double rhoDisp1(double rho) {
            double rho2 = rho * rho;
            return rho2 * rho2 * rho;
        }
    }
}

