/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import ffx.potential.nonbonded.SpatialDensityRegion;
import ffx.potential.nonbonded.SpatialDensitySchedule;
import java.util.logging.Logger;

public abstract class SpatialDensityLoop
extends IntegerForLoop {
    private static final Logger logger = Logger.getLogger(SpatialDensityLoop.class.getName());
    private int nSymm;
    private SpatialDensityRegion spatialDensityRegion;
    private SpatialDensitySchedule spatialDensitySchedule;
    private int octant = 0;

    public SpatialDensityLoop(SpatialDensityRegion region, int nSymm, int[] atomsPerChunk) {
        this.spatialDensityRegion = region;
        this.nSymm = nSymm;
        this.spatialDensitySchedule = new SpatialDensitySchedule(region.nThreads, region.nAtoms, atomsPerChunk, 0.97);
        assert (nSymm <= region.nSymm);
    }

    public abstract void gridDensity(int var1, int var2);

    public void run(int lb, int ub) {
        block10: for (int icell = lb; icell <= ub; ++icell) {
            int ia = this.spatialDensityRegion.actualA[icell];
            int ib = this.spatialDensityRegion.actualB[icell];
            int ic = this.spatialDensityRegion.actualC[icell];
            switch (this.octant) {
                case 0: {
                    this.gridCell(ia, ib, ic);
                    continue block10;
                }
                case 1: {
                    this.gridCell(ia, ib, ic + 1);
                    continue block10;
                }
                case 2: {
                    this.gridCell(ia, ib + 1, ic);
                    continue block10;
                }
                case 3: {
                    this.gridCell(ia, ib + 1, ic + 1);
                    continue block10;
                }
                case 4: {
                    this.gridCell(ia + 1, ib, ic);
                    continue block10;
                }
                case 5: {
                    this.gridCell(ia + 1, ib, ic + 1);
                    continue block10;
                }
                case 6: {
                    this.gridCell(ia + 1, ib + 1, ic);
                    continue block10;
                }
                case 7: {
                    this.gridCell(ia + 1, ib + 1, ic + 1);
                    continue block10;
                }
                default: {
                    String message = "Programming error in PermanentDensityLoop.\n";
                    logger.severe(message);
                }
            }
        }
    }

    public IntegerSchedule schedule() {
        return this.spatialDensitySchedule;
    }

    public void setNsymm(int nSymm) {
        this.nSymm = nSymm;
        assert (nSymm <= this.spatialDensityRegion.nSymm);
    }

    public SpatialDensityLoop setOctant(int octant) {
        this.octant = octant;
        return this;
    }

    public void setRegion(SpatialDensityRegion spatialDensityRegion) {
        this.spatialDensityRegion = spatialDensityRegion;
        this.spatialDensitySchedule = new SpatialDensitySchedule(spatialDensityRegion.nThreads, spatialDensityRegion.nAtoms, spatialDensityRegion.actualCount, 0.97);
    }

    private void gridCell(int ia, int ib, int ic) {
        for (int iSymm = 0; iSymm < this.nSymm; ++iSymm) {
            int[] pairList = this.spatialDensityRegion.cellList[iSymm];
            int index = this.spatialDensityRegion.index(ia, ib, ic);
            int start = this.spatialDensityRegion.cellStart[iSymm][index];
            int stop = start + this.spatialDensityRegion.cellCount[iSymm][index];
            for (int i = start; i < stop; ++i) {
                int n = pairList[i];
                this.gridDensity(iSymm, n);
            }
        }
    }
}

