/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import ffx.crystal.Crystal;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.SliceLoop;
import ffx.potential.nonbonded.SpatialDensityRegion;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;

public class SliceRegion
extends ParallelRegion {
    public int buff = 3;
    public boolean[][] select;
    protected SliceLoop[] sliceLoop;
    protected double[][][] coordinates;
    int nAtoms;
    int nSymm;
    private int gX;
    private int gY;
    private int gZ;
    private DoubleBuffer gridBuffer;
    private GridInitLoop[] gridInitLoop;
    private double initValue = 0.0;
    private int gridSize;
    private double[] grid;
    private boolean rebuildList;
    private int[][] zAtListBuild;

    public SliceRegion(int gX, int gY, int gZ, double[] grid, int nSymm, int threadCount, Atom[] atoms, double[][][] coordinates) {
        int i;
        this.nAtoms = atoms.length;
        this.gX = gX;
        this.gY = gY;
        this.gZ = gZ;
        this.gridSize = gX * gY * gZ * 2;
        this.nSymm = nSymm;
        this.coordinates = coordinates;
        this.grid = grid;
        if (grid != null) {
            this.gridBuffer = DoubleBuffer.wrap(grid);
        }
        this.sliceLoop = new SliceLoop[threadCount];
        this.gridInitLoop = new GridInitLoop[threadCount];
        for (i = 0; i < threadCount; ++i) {
            this.gridInitLoop[i] = new GridInitLoop(this);
        }
        this.select = new boolean[nSymm][this.nAtoms];
        for (i = 0; i < nSymm; ++i) {
            Arrays.fill(this.select[i], true);
        }
        this.zAtListBuild = new int[nSymm][this.nAtoms];
        this.rebuildList = true;
    }

    public void finish() {
        if (this.rebuildList) {
            this.sliceLoop[0].saveZValues(this.zAtListBuild);
        }
        this.rebuildList = false;
    }

    public double[] getGrid() {
        return this.grid;
    }

    public int getNatoms() {
        return this.nAtoms;
    }

    public int getNsymm() {
        return this.nSymm;
    }

    public void run() throws Exception {
        int threadIndex = this.getThreadIndex();
        SliceLoop loop = this.sliceLoop[threadIndex];
        loop.setNsymm(this.nSymm);
        loop.setRebuildList(this.rebuildList);
        try {
            this.execute(0, this.gridSize - 1, this.gridInitLoop[threadIndex]);
            this.execute(0, this.gZ - 1, loop);
        }
        catch (Exception e) {
            String message = " Exception in SliceRegion.";
            SpatialDensityRegion.logger.log(Level.SEVERE, message, e);
        }
    }

    public void selectAtoms() {
        for (int i = 0; i < this.nSymm; ++i) {
            Arrays.fill(this.select[i], true);
        }
    }

    public void setAtoms(Atom[] atoms) {
        this.nAtoms = atoms.length;
        this.select = new boolean[this.nSymm][this.nAtoms];
        this.zAtListBuild = new int[this.nSymm][this.nAtoms];
        for (int i = 0; i < this.nSymm; ++i) {
            Arrays.fill(this.select[i], true);
        }
        this.rebuildList = true;
    }

    public final void setCrystal(Crystal crystal, int gX, int gY, int gZ) {
        this.gX = gX;
        this.gY = gY;
        this.gZ = gZ;
        this.gridSize = gX * gY * gZ * 2;
    }

    public void setDensityLoop(SliceLoop[] loops) {
        this.sliceLoop = loops;
    }

    public void setInitValue(double initValue) {
        this.initValue = initValue;
    }

    public void start() {
        this.selectAtoms();
        this.rebuildList = this.rebuildList || this.sliceLoop[0].checkList(this.zAtListBuild, this.buff);
    }

    void setGridBuffer(DoubleBuffer grid) {
        this.gridBuffer = grid;
    }

    private class GridInitLoop
    extends IntegerForLoop {
        private final IntegerSchedule schedule;
        final /* synthetic */ SliceRegion this$0;

        private GridInitLoop(SliceRegion sliceRegion) {
            SliceRegion sliceRegion2 = sliceRegion;
            Objects.requireNonNull(sliceRegion2);
            this.this$0 = sliceRegion2;
            this.schedule = IntegerSchedule.fixed();
        }

        public void run(int lb, int ub) {
            if (this.this$0.gridBuffer != null) {
                for (int i = lb; i <= ub; ++i) {
                    this.this$0.gridBuffer.put(i, this.this$0.initValue);
                }
            }
        }

        public IntegerSchedule schedule() {
            return this.schedule;
        }
    }
}

