/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import ffx.crystal.Crystal;
import ffx.numerics.fft.Complex;
import ffx.numerics.fft.Complex3D;
import ffx.numerics.fft.Complex3DParallel;
import ffx.numerics.math.ScalarMath;
import ffx.numerics.spline.UniformBSpline;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.ParticleMeshEwald;
import ffx.potential.nonbonded.RowLoop;
import ffx.potential.nonbonded.RowRegion;
import ffx.potential.nonbonded.SliceLoop;
import ffx.potential.nonbonded.SliceRegion;
import ffx.potential.nonbonded.SpatialDensityLoop;
import ffx.potential.nonbonded.SpatialDensityRegion;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperties;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.nio.DoubleBuffer;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;

public class ReciprocalSpace {
    private static final Logger logger = Logger.getLogger(ReciprocalSpace.class.getName());
    private static final int[] qi1 = new int[]{0, 1, 2, 0, 0, 1};
    private static final int[] qi2 = new int[]{0, 1, 2, 1, 2, 2};
    private static final double toSeconds = 1.0E-9;
    private final ParticleMeshEwald particleMeshEwald;
    private final ForceField.ELEC_FORM elecForm;
    private final ForceField forceField;
    private final int nSymm;
    private final int threadCount;
    private static final int DEFAULT_PME_ORDER = 5;
    @FFXProperty(name="pme-order", clazz=Integer.class, propertyGroup=PropertyGroup.ParticleMeshEwald, defaultValue="5", description="Sets the order of the B-spline interpolation used during particle mesh Ewald summation for partial charge\nor atomic multipole electrostatics. A default value of 5 is used in the absence of the pme-order keyword.\n")
    private final int bSplineOrder;
    private final int derivOrder = 3;
    private final double aEwald;
    private final ParallelTeam parallelTeam;
    private final ParallelTeam fftTeam;
    private final BSplineRegion bSplineRegion;
    private final FractionalMultipoleRegion fractionalMultipoleRegion;
    private final FractionalInducedRegion fractionalInducedRegion;
    private final SpatialPermanentLoop[] spatialPermanentLoops;
    private final SpatialInducedLoop[] spatialInducedLoops;
    private final SlicePermanentLoop[] slicePermanentLoops;
    private final SliceInducedLoop[] sliceInducedLoops;
    private final RowPermanentLoop[] rowPermanentLoops;
    private final RowInducedLoop[] rowInducedLoops;
    private final int[][] gridAtomCount;
    private final int[][][] gridAtomList;
    private final PermanentPhiRegion permanentPhiRegion;
    private final InducedPhiRegion polarizationPhiRegion;
    private final IntegerSchedule recipSchedule;
    private final double[][] transformFieldMatrix = new double[10][10];
    private final double[][] transformMultipoleMatrix = new double[10][10];
    private final double[][] a = new double[3][3];
    private double[][][] inducedDipoleFrac;
    private double[][][] inducedDipoleFracCR;
    private Crystal crystal;
    private Atom[] atoms;
    private int nAtoms;
    private static final double DEFAULT_PME_MESH_DENSITY = 1.2;
    private static final double oneThird = 0.3333333333333333;
    @FFXProperty(name="pme-mesh-density", clazz=Integer.class, propertyGroup=PropertyGroup.ParticleMeshEwald, defaultValue="1.2", description="The default in the absence of the pme-grid keyword is to set the grid size along each\naxis to the smallest factor of 2, 3 and/or 5 that is at least as large as\npme-mesh-density times the axis length in Angstroms.\n")
    private double density;
    @FFXProperties(value={@FFXProperty(name="pme-grid-x", clazz=Integer.class, propertyGroup=PropertyGroup.ParticleMeshEwald, defaultValue="NONE", description="Specifies the PME grid dimension along the x-axis and takes precedence over the pme-grid keyword."), @FFXProperty(name="pme-grid", clazz=Integer.class, propertyGroup=PropertyGroup.ParticleMeshEwald, defaultValue="NONE", description="[3 integers]\nSets the dimensions of the reciprocal space grid used during particle mesh Ewald\nsummation for electrostatics. The three modifiers give the size along the X-, Y- and Z- axes,\nrespectively. If either the Y- or Z-axis dimensions are omitted, then they are set equal\nto the X-axis dimension. The default in the absence of the pme-grid keyword is to set the\ngrid size along each axis to the smallest value that can be factored by 2, 3, 4 and/or 5\nand is at least as large as 1.2 times the axis length in Angstroms.\nThe value 1.2 can be changed using the pme-mesh-density property.\n")})
    private int fftX;
    @FFXProperty(name="pme-grid-y", clazz=Integer.class, propertyGroup=PropertyGroup.ParticleMeshEwald, defaultValue="NONE", description="Specifies the PME grid dimension along the y-axis and takes precedence over the pme-grid keyword.")
    private int fftY;
    @FFXProperty(name="pme-grid-z", clazz=Integer.class, propertyGroup=PropertyGroup.ParticleMeshEwald, defaultValue="NONE", description="Specifies the PME grid dimension along the z-axis and takes precedence over the pme-grid keyword.")
    private int fftZ;
    private int fftSpace;
    private double[] splineGrid;
    private DoubleBuffer splineBuffer;
    private double[][][] coordinates;
    private SpatialDensityRegion spatialDensityRegion;
    private SliceRegion sliceRegion;
    private RowRegion rowRegion;
    private Complex3DParallel complex3DFFT;
    private GridMethod gridMethod;
    private long bSplineTotal;
    private long splinePermanentTotal;
    private long splineInducedTotal;
    private long permanentPhiTotal;
    private long inducedPhiTotal;
    private long convTotal;
    private final long[] bSplineTime;
    private final long[] splinePermanentTime;
    private final long[] permanentPhiTime;
    private final long[] splineInducedTime;
    private final int[] splineCount;
    private final long[] inducedPhiTime;

    public ReciprocalSpace(ParticleMeshEwald particleMeshEwald, Crystal crystal, ForceField forceField, Atom[] atoms, double aewald, ParallelTeam fftTeam, ParallelTeam parallelTeam) {
        boolean available;
        this.particleMeshEwald = particleMeshEwald;
        this.crystal = crystal.getUnitCell();
        this.forceField = forceField;
        this.atoms = atoms;
        this.nAtoms = atoms.length;
        this.aEwald = aewald;
        this.fftTeam = fftTeam;
        this.parallelTeam = parallelTeam;
        this.elecForm = particleMeshEwald.getElecForm();
        this.coordinates = particleMeshEwald.getCoordinates();
        this.threadCount = parallelTeam.getThreadCount();
        this.nSymm = this.crystal.spaceGroup.getNumberOfSymOps();
        String recipStrategy = null;
        try {
            recipStrategy = forceField.getString("RECIP_SCHEDULE");
            IntegerSchedule.parse((String)recipStrategy);
            available = true;
        }
        catch (Exception e) {
            available = false;
        }
        if (available) {
            this.recipSchedule = IntegerSchedule.parse((String)recipStrategy);
            logger.log(Level.INFO, "  Convolution schedule {0}", recipStrategy);
        } else {
            this.recipSchedule = IntegerSchedule.fixed();
        }
        CompositeConfiguration properties = forceField.getProperties();
        String gridString = properties.getString("grid-method", "SPATIAL").toUpperCase();
        try {
            this.gridMethod = GridMethod.valueOf(gridString);
        }
        catch (Exception e) {
            this.gridMethod = GridMethod.SPATIAL;
        }
        this.bSplineOrder = forceField.getInteger("PME_ORDER", 5);
        double density = this.initConvolution();
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("    B-Spline Order:                    %8d\n", this.bSplineOrder));
            sb.append(String.format("    Mesh Density:                      %8.3f\n", density));
            sb.append(String.format("    Mesh Dimensions:              (%3d,%3d,%3d)\n", this.fftX, this.fftY, this.fftZ));
            sb.append(String.format("    Grid Method:                       %8s\n", this.gridMethod.toString()));
            logger.info(sb.toString());
        }
        this.bSplineRegion = new BSplineRegion(this);
        this.fractionalMultipoleRegion = new FractionalMultipoleRegion(this);
        this.fractionalInducedRegion = new FractionalInducedRegion(this);
        switch (this.gridMethod.ordinal()) {
            default: {
                this.spatialPermanentLoops = new SpatialPermanentLoop[this.threadCount];
                this.spatialInducedLoops = new SpatialInducedLoop[this.threadCount];
                for (int i = 0; i < this.threadCount; ++i) {
                    this.spatialPermanentLoops[i] = new SpatialPermanentLoop(this, this.spatialDensityRegion, this.bSplineRegion);
                    this.spatialInducedLoops[i] = new SpatialInducedLoop(this, this.spatialDensityRegion, this.bSplineRegion);
                }
                this.slicePermanentLoops = null;
                this.sliceInducedLoops = null;
                this.rowPermanentLoops = null;
                this.rowInducedLoops = null;
                this.gridAtomCount = null;
                this.gridAtomList = null;
                break;
            }
            case 2: {
                this.rowPermanentLoops = new RowPermanentLoop[this.threadCount];
                this.rowInducedLoops = new RowInducedLoop[this.threadCount];
                for (int i = 0; i < this.threadCount; ++i) {
                    this.rowPermanentLoops[i] = new RowPermanentLoop(this, this.rowRegion, this.bSplineRegion);
                    this.rowInducedLoops[i] = new RowInducedLoop(this, this.rowRegion, this.bSplineRegion);
                }
                this.gridAtomCount = new int[this.nSymm][this.threadCount];
                this.gridAtomList = new int[this.nSymm][this.threadCount][this.nAtoms];
                this.spatialPermanentLoops = null;
                this.spatialInducedLoops = null;
                this.slicePermanentLoops = null;
                this.sliceInducedLoops = null;
                break;
            }
            case 1: {
                this.slicePermanentLoops = new SlicePermanentLoop[this.threadCount];
                this.sliceInducedLoops = new SliceInducedLoop[this.threadCount];
                for (int i = 0; i < this.threadCount; ++i) {
                    this.slicePermanentLoops[i] = new SlicePermanentLoop(this, this.sliceRegion, this.bSplineRegion);
                    this.sliceInducedLoops[i] = new SliceInducedLoop(this, this.sliceRegion, this.bSplineRegion);
                }
                this.gridAtomCount = new int[this.nSymm][this.threadCount];
                this.gridAtomList = new int[this.nSymm][this.threadCount][this.nAtoms];
                this.spatialPermanentLoops = null;
                this.spatialInducedLoops = null;
                this.rowPermanentLoops = null;
                this.rowInducedLoops = null;
            }
        }
        this.permanentPhiRegion = new PermanentPhiRegion(this, this.bSplineRegion);
        this.polarizationPhiRegion = new InducedPhiRegion(this, this.bSplineRegion);
        this.bSplineTime = new long[this.threadCount];
        this.splinePermanentTime = new long[this.threadCount];
        this.splineInducedTime = new long[this.threadCount];
        this.splineCount = new int[this.threadCount];
        this.permanentPhiTime = new long[this.threadCount];
        this.inducedPhiTime = new long[this.threadCount];
    }

    private static void discreteFTMod(double[] bsmod, double[] bsarray, int nfft, int order) {
        double factor = Math.PI * 2 / (double)nfft;
        for (int i = 0; i < nfft; ++i) {
            double sum1 = 0.0;
            double sum2 = 0.0;
            for (int j = 0; j < nfft; ++j) {
                double arg = factor * (double)(i * j);
                sum1 += bsarray[j] * FastMath.cos((double)arg);
                sum2 += bsarray[j] * FastMath.sin((double)arg);
            }
            bsmod[i] = sum1 * sum1 + sum2 * sum2;
        }
        double eps = 1.0E-7;
        if (bsmod[0] < eps) {
            bsmod[0] = 0.5 * bsmod[1];
        }
        for (int i = 1; i < nfft - 1; ++i) {
            if (!(bsmod[i] < eps)) continue;
            bsmod[i] = 0.5 * (bsmod[i - 1] + bsmod[i + 1]);
        }
        if (bsmod[nfft - 1] < eps) {
            bsmod[nfft - 1] = 0.5 * bsmod[nfft - 2];
        }
        int jcut = 50;
        int order2 = 2 * order;
        for (int i = 0; i < nfft; ++i) {
            double zeta;
            int k = i;
            if (i > nfft / 2) {
                k -= nfft;
            }
            if (k == 0) {
                zeta = 1.0;
            } else {
                double arg;
                int j;
                double sum1 = 1.0;
                double sum2 = 1.0;
                factor = Math.PI * (double)k / (double)nfft;
                for (j = 0; j < jcut; ++j) {
                    arg = factor / (factor + Math.PI * (double)(j + 1));
                    sum1 += FastMath.pow((double)arg, (int)order);
                    sum2 += FastMath.pow((double)arg, (int)order2);
                }
                for (j = 0; j < jcut; ++j) {
                    arg = factor / (factor - Math.PI * (double)(j + 1));
                    sum1 += FastMath.pow((double)arg, (int)order);
                    sum2 += FastMath.pow((double)arg, (int)order2);
                }
                zeta = sum2 / sum1;
            }
            bsmod[i] = bsmod[i] * zeta * zeta;
        }
    }

    public void cartToFracInducedDipole(double[] inducedDipole, double[] inducedDipoleCR, double[] fracInducedDipole, double[] fracInducedDipoleCR) {
        double[] in = inducedDipole;
        fracInducedDipole[0] = this.a[0][0] * in[0] + this.a[0][1] * in[1] + this.a[0][2] * in[2];
        fracInducedDipole[1] = this.a[1][0] * in[0] + this.a[1][1] * in[1] + this.a[1][2] * in[2];
        fracInducedDipole[2] = this.a[2][0] * in[0] + this.a[2][1] * in[1] + this.a[2][2] * in[2];
        in = inducedDipoleCR;
        fracInducedDipoleCR[0] = this.a[0][0] * in[0] + this.a[0][1] * in[1] + this.a[0][2] * in[2];
        fracInducedDipoleCR[1] = this.a[1][0] * in[0] + this.a[1][1] * in[1] + this.a[1][2] * in[2];
        fracInducedDipoleCR[2] = this.a[2][0] * in[0] + this.a[2][1] * in[1] + this.a[2][2] * in[2];
    }

    public void computeBSplines() {
        try {
            this.bSplineTotal -= System.nanoTime();
            this.parallelTeam.execute((ParallelRegion)this.bSplineRegion);
            this.bSplineTotal += System.nanoTime();
        }
        catch (Exception e) {
            String message = " Fatal exception evaluating b-Splines.";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void computeInducedPhi(double[][] cartInducedDipolePhi, double[][] cartInducedDipoleCRPhi, double[][] fracInducedDipolePhi, double[][] fracInducedDipoleCRPhi) {
        this.inducedPhiTotal -= System.nanoTime();
        try {
            this.polarizationPhiRegion.setInducedDipolePhi(cartInducedDipolePhi, cartInducedDipoleCRPhi, fracInducedDipolePhi, fracInducedDipoleCRPhi);
            this.parallelTeam.execute((ParallelRegion)this.polarizationPhiRegion);
        }
        catch (Exception e) {
            String message = "Fatal exception evaluating induced reciprocal space potential.";
            logger.log(Level.SEVERE, message, e);
        }
        this.inducedPhiTotal += System.nanoTime();
    }

    public void computePermanentPhi(double[][] cartPermanentPhi, double[][] fracPermanentPhi) {
        this.permanentPhiTotal -= System.nanoTime();
        try {
            this.permanentPhiRegion.setPermanentPhi(cartPermanentPhi, fracPermanentPhi);
            this.parallelTeam.execute((ParallelRegion)this.permanentPhiRegion);
        }
        catch (Exception e) {
            String message = " Fatal exception evaluating permanent reciprocal space potential.";
            logger.log(Level.SEVERE, message, e);
        }
        this.permanentPhiTotal += System.nanoTime();
    }

    public int getXDim() {
        return this.fftX;
    }

    public int getYDim() {
        return this.fftY;
    }

    public int getZDim() {
        return this.fftZ;
    }

    public void performConvolution() {
        this.convTotal -= System.nanoTime();
        try {
            this.complex3DFFT.convolution(this.splineGrid);
        }
        catch (Exception e) {
            String message = "Fatal exception evaluating the convolution.";
            logger.log(Level.SEVERE, message, e);
        }
        this.convTotal += System.nanoTime();
    }

    public void initTimings() {
        this.bSplineTotal = 0L;
        this.splinePermanentTotal = 0L;
        this.splineInducedTotal = 0L;
        this.permanentPhiTotal = 0L;
        this.inducedPhiTotal = 0L;
        this.convTotal = 0L;
        for (int i = 0; i < this.threadCount; ++i) {
            this.bSplineTime[i] = 0L;
            this.splinePermanentTime[i] = 0L;
            this.splineInducedTime[i] = 0L;
            this.permanentPhiTime[i] = 0L;
            this.inducedPhiTime[i] = 0L;
            this.splineCount[i] = 0;
        }
        if (this.complex3DFFT != null) {
            this.complex3DFFT.initTiming();
        }
    }

    public void printTimings() {
        if (logger.isLoggable(Level.FINE) && this.complex3DFFT != null) {
            double total = (double)(this.bSplineTotal + this.convTotal + this.splinePermanentTotal + this.permanentPhiTotal + this.splineInducedTotal + this.inducedPhiTotal) * 1.0E-9;
            logger.fine(String.format("\n Reciprocal Space: %7.4f (sec)", total));
            long[] convTime = this.complex3DFFT.getTiming();
            logger.fine("                           Direct Field    SCF Field");
            logger.fine(" Thread  B-Spline  3DConv  Spline  Phi     Spline  Phi      Count");
            long minBSpline = Long.MAX_VALUE;
            long maxBSpline = 0L;
            long minConv = Long.MAX_VALUE;
            long maxConv = 0L;
            long minBSPerm = Long.MAX_VALUE;
            long maxBSPerm = 0L;
            long minPhiPerm = Long.MAX_VALUE;
            long maxPhiPerm = 0L;
            long minBSInduced = Long.MAX_VALUE;
            long maxBSInduced = 0L;
            long minPhiInduced = Long.MAX_VALUE;
            long maxPhiInduced = 0L;
            int minCount = Integer.MAX_VALUE;
            int maxCount = 0;
            for (int i = 0; i < this.threadCount; ++i) {
                logger.fine(String.format("    %3d   %7.4f %7.4f %7.4f %7.4f %7.4f %7.4f  %6d", i, (double)this.bSplineTime[i] * 1.0E-9, (double)convTime[i] * 1.0E-9, (double)this.splinePermanentTime[i] * 1.0E-9, (double)this.permanentPhiTime[i] * 1.0E-9, (double)this.splineInducedTime[i] * 1.0E-9, (double)this.inducedPhiTime[i] * 1.0E-9, this.splineCount[i]));
                minBSpline = FastMath.min((long)this.bSplineTime[i], (long)minBSpline);
                maxBSpline = FastMath.max((long)this.bSplineTime[i], (long)maxBSpline);
                minConv = FastMath.min((long)convTime[i], (long)minConv);
                maxConv = FastMath.max((long)convTime[i], (long)maxConv);
                minBSPerm = FastMath.min((long)this.splinePermanentTime[i], (long)minBSPerm);
                maxBSPerm = FastMath.max((long)this.splinePermanentTime[i], (long)maxBSPerm);
                minPhiPerm = FastMath.min((long)this.permanentPhiTime[i], (long)minPhiPerm);
                maxPhiPerm = FastMath.max((long)this.permanentPhiTime[i], (long)maxPhiPerm);
                minBSInduced = FastMath.min((long)this.splineInducedTime[i], (long)minBSInduced);
                maxBSInduced = FastMath.max((long)this.splineInducedTime[i], (long)maxBSInduced);
                minPhiInduced = FastMath.min((long)this.inducedPhiTime[i], (long)minPhiInduced);
                maxPhiInduced = FastMath.max((long)this.inducedPhiTime[i], (long)maxPhiInduced);
                minCount = FastMath.min((int)this.splineCount[i], (int)minCount);
                maxCount = FastMath.max((int)this.splineCount[i], (int)maxCount);
            }
            logger.fine(String.format(" Min      %7.4f %7.4f %7.4f %7.4f %7.4f %7.4f  %6d", (double)minBSpline * 1.0E-9, (double)minConv * 1.0E-9, (double)minBSPerm * 1.0E-9, (double)minPhiPerm * 1.0E-9, (double)minBSInduced * 1.0E-9, (double)minPhiInduced * 1.0E-9, minCount));
            logger.fine(String.format(" Max      %7.4f %7.4f %7.4f %7.4f %7.4f %7.4f  %6d", (double)maxBSpline * 1.0E-9, (double)maxConv * 1.0E-9, (double)maxBSPerm * 1.0E-9, (double)maxPhiPerm * 1.0E-9, (double)maxBSInduced * 1.0E-9, (double)maxPhiInduced * 1.0E-9, maxCount));
            logger.fine(String.format(" Delta    %7.4f %7.4f %7.4f %7.4f %7.4f %7.4f  %6d", (double)(maxBSpline - minBSpline) * 1.0E-9, (double)(maxConv - minConv) * 1.0E-9, (double)(maxBSPerm - minBSPerm) * 1.0E-9, (double)(maxPhiPerm - minPhiPerm) * 1.0E-9, (double)(maxBSInduced - minBSInduced) * 1.0E-9, (double)(maxPhiInduced - minPhiInduced) * 1.0E-9, maxCount - minCount));
            logger.fine(String.format(" Actual   %7.4f %7.4f %7.4f %7.4f %7.4f %7.4f  %6d", (double)this.bSplineTotal * 1.0E-9, (double)this.convTotal * 1.0E-9, (double)this.splinePermanentTotal * 1.0E-9, (double)this.permanentPhiTotal * 1.0E-9, (double)this.splineInducedTotal * 1.0E-9, (double)this.inducedPhiTotal * 1.0E-9, this.nAtoms * this.nSymm));
        }
    }

    public void setAtoms(Atom[] atoms) {
        this.atoms = atoms;
        this.nAtoms = atoms.length;
        this.coordinates = this.particleMeshEwald.getCoordinates();
        switch (this.gridMethod.ordinal()) {
            case 0: {
                this.spatialDensityRegion.setAtoms(atoms);
                this.spatialDensityRegion.coordinates = this.coordinates;
                break;
            }
            case 2: {
                this.rowRegion.setAtoms(atoms);
                this.rowRegion.coordinates = this.coordinates;
                break;
            }
            case 1: {
                this.sliceRegion.setAtoms(atoms);
                this.sliceRegion.coordinates = this.coordinates;
            }
        }
    }

    public void setCrystal(Crystal crystal) {
        this.crystal = crystal.getUnitCell();
        if (this.nSymm != this.crystal.spaceGroup.getNumberOfSymOps()) {
            logger.info(this.crystal.toString());
            logger.info(crystal.toString());
            logger.severe(" The reciprocal space class does not currently allow changes in the number of symmetry operators unless it is mapped by a user supplied symmetry operator.");
        }
        this.coordinates = this.particleMeshEwald.getCoordinates();
        this.initConvolution();
    }

    public void splineInducedDipoles(double[][][] inducedDipole, double[][][] inducedDipoleCR, boolean[] use) {
        this.splineInducedTotal -= System.nanoTime();
        try {
            if (this.inducedDipoleFrac == null || this.inducedDipoleFrac.length != inducedDipole.length || this.inducedDipoleFrac[0].length != inducedDipole[0].length) {
                int nAtoms = inducedDipole.length;
                int nSymm = inducedDipole[0].length;
                this.inducedDipoleFrac = new double[nAtoms][nSymm][3];
                this.inducedDipoleFracCR = new double[nAtoms][nSymm][3];
            }
            this.fractionalInducedRegion.setUse(use);
            this.fractionalInducedRegion.setInducedDipoles(inducedDipole, inducedDipoleCR, this.inducedDipoleFrac, this.inducedDipoleFracCR);
            this.parallelTeam.execute((ParallelRegion)this.fractionalInducedRegion);
        }
        catch (Exception e) {
            String message = " Fatal exception evaluating fractional induced dipoles.";
            logger.log(Level.SEVERE, message, e);
        }
        switch (this.gridMethod.ordinal()) {
            case 0: {
                int i;
                this.spatialDensityRegion.setDensityLoop(this.spatialInducedLoops);
                for (i = 0; i < this.threadCount; ++i) {
                    this.spatialInducedLoops[i].setInducedDipoles(this.inducedDipoleFrac, this.inducedDipoleFracCR);
                    this.spatialInducedLoops[i].setUse(use);
                    this.spatialInducedLoops[i].setRegion(this.spatialDensityRegion);
                }
                try {
                    this.parallelTeam.execute((ParallelRegion)this.spatialDensityRegion);
                }
                catch (Exception e) {
                    String message = " Fatal exception evaluating induced density.\n";
                    logger.log(Level.SEVERE, message, e);
                }
                break;
            }
            case 2: {
                int i;
                this.rowRegion.setDensityLoop(this.rowInducedLoops);
                for (i = 0; i < this.threadCount; ++i) {
                    this.rowInducedLoops[i].setInducedDipoles(this.inducedDipoleFrac, this.inducedDipoleFracCR);
                    this.rowInducedLoops[i].setUse(use);
                }
                try {
                    this.parallelTeam.execute((ParallelRegion)this.rowRegion);
                }
                catch (Exception e) {
                    String message = " Fatal exception evaluating induced density.";
                    logger.log(Level.SEVERE, message, e);
                }
                break;
            }
            default: {
                int i;
                this.sliceRegion.setDensityLoop(this.sliceInducedLoops);
                for (i = 0; i < this.threadCount; ++i) {
                    this.sliceInducedLoops[i].setInducedDipoles(this.inducedDipoleFrac, this.inducedDipoleFracCR);
                    this.sliceInducedLoops[i].setUse(use);
                }
                try {
                    this.parallelTeam.execute((ParallelRegion)this.sliceRegion);
                    break;
                }
                catch (Exception e) {
                    String message = " Fatal exception evaluating induced density.";
                    logger.log(Level.SEVERE, message, e);
                }
            }
        }
        this.splineInducedTotal += System.nanoTime();
    }

    public void splinePermanentMultipoles(double[][][] globalMultipoles, double[][][] fracMultipoles, boolean[] use) {
        String message;
        this.splinePermanentTotal -= System.nanoTime();
        try {
            this.fractionalMultipoleRegion.setUse(use);
            this.fractionalMultipoleRegion.setPermanent(globalMultipoles, fracMultipoles);
            this.parallelTeam.execute((ParallelRegion)this.fractionalMultipoleRegion);
        }
        catch (Exception e) {
            message = " Fatal exception evaluating fractional multipoles.";
            logger.log(Level.SEVERE, message, e);
        }
        switch (this.gridMethod.ordinal()) {
            case 0: {
                this.spatialDensityRegion.setCrystal(this.crystal.getUnitCell(), this.fftX, this.fftY, this.fftZ);
                this.spatialDensityRegion.assignAtomsToCells();
                this.spatialDensityRegion.setDensityLoop(this.spatialPermanentLoops);
                for (int i = 0; i < this.threadCount; ++i) {
                    this.spatialPermanentLoops[i].setPermanent(fracMultipoles);
                    this.spatialPermanentLoops[i].setUse(use);
                    this.spatialPermanentLoops[i].setRegion(this.spatialDensityRegion);
                }
                try {
                    this.parallelTeam.execute((ParallelRegion)this.spatialDensityRegion);
                }
                catch (Exception e) {
                    message = " Fatal exception evaluating permanent multipole density.";
                    logger.log(Level.SEVERE, message, e);
                }
                break;
            }
            case 2: {
                this.rowRegion.setCrystal(this.crystal.getUnitCell(), this.fftX, this.fftY, this.fftZ);
                this.rowRegion.setDensityLoop(this.rowPermanentLoops);
                for (int i = 0; i < this.threadCount; ++i) {
                    this.rowPermanentLoops[i].setPermanent(fracMultipoles);
                    this.rowPermanentLoops[i].setUse(use);
                }
                try {
                    this.parallelTeam.execute((ParallelRegion)this.rowRegion);
                }
                catch (Exception e) {
                    message = " Fatal exception evaluating permanent multipole density.";
                    logger.log(Level.SEVERE, message, e);
                }
                break;
            }
            case 1: {
                this.sliceRegion.setCrystal(this.crystal.getUnitCell(), this.fftX, this.fftY, this.fftZ);
                this.sliceRegion.setDensityLoop(this.slicePermanentLoops);
                for (int i = 0; i < this.threadCount; ++i) {
                    this.slicePermanentLoops[i].setPermanent(fracMultipoles);
                    this.slicePermanentLoops[i].setUse(use);
                }
                try {
                    this.parallelTeam.execute((ParallelRegion)this.sliceRegion);
                    break;
                }
                catch (Exception e) {
                    message = " Fatal exception evaluating permanent multipole density.";
                    logger.log(Level.SEVERE, message, e);
                }
            }
        }
        this.splinePermanentTotal += System.nanoTime();
    }

    private double initConvolution() {
        boolean dimChanged;
        int nZ;
        int nY;
        String grid;
        String[] values;
        int fftXCurrent = this.fftX;
        int fftYCurrent = this.fftY;
        int fftZCurrent = this.fftZ;
        int defaultX = -1;
        int defaultY = -1;
        int defaultZ = -1;
        if (this.forceField.hasProperty("PME_GRID") && (values = (grid = this.forceField.getString("PME_GRID", "-1 -1 -1")).trim().split(" +")) != null) {
            defaultY = defaultX = Integer.parseInt(values[0]);
            defaultZ = defaultX;
            if (values.length > 1) {
                defaultY = Integer.parseInt(values[1]);
                if (values.length > 2) {
                    defaultZ = Integer.parseInt(values[2]);
                }
            }
        }
        this.density = this.forceField.getDouble("PME_MESH_DENSITY", 1.2);
        int nX = this.forceField.getInteger("PME_GRID_X", defaultX);
        if (nX < 2) {
            nX = (int)FastMath.floor((double)(this.crystal.a * this.density)) + 1;
            if (nX % 2 != 0) {
                ++nX;
            }
            while (!Complex.preferredDimension((int)nX)) {
                nX += 2;
            }
        }
        if ((nY = this.forceField.getInteger("PME_GRID_Y", defaultY)) < 2) {
            nY = (int)FastMath.floor((double)(this.crystal.b * this.density)) + 1;
            if (nY % 2 != 0) {
                ++nY;
            }
            while (!Complex.preferredDimension((int)nY)) {
                nY += 2;
            }
        }
        if ((nZ = this.forceField.getInteger("PME_GRID_Z", defaultZ)) < 2) {
            nZ = (int)FastMath.floor((double)(this.crystal.c * this.density)) + 1;
            if (nZ % 2 != 0) {
                ++nZ;
            }
            while (!Complex.preferredDimension((int)nZ)) {
                nZ += 2;
            }
        }
        int minGrid = this.forceField.getInteger("PME_GRID_MIN", 16);
        nX = FastMath.max((int)nX, (int)minGrid);
        nY = FastMath.max((int)nY, (int)minGrid);
        nZ = FastMath.max((int)nZ, (int)minGrid);
        this.fftX = nX;
        this.fftY = nY;
        this.fftZ = nZ;
        this.transformMultipoleMatrix();
        this.transformFieldMatrix();
        for (int i = 0; i < 3; ++i) {
            this.a[0][i] = (double)this.fftX * this.crystal.A[i][0];
            this.a[1][i] = (double)this.fftY * this.crystal.A[i][1];
            this.a[2][i] = (double)this.fftZ * this.crystal.A[i][2];
        }
        this.fftSpace = this.fftX * this.fftY * this.fftZ * 2;
        boolean bl = dimChanged = this.fftX != fftXCurrent || this.fftY != fftYCurrent || this.fftZ != fftZCurrent;
        if (this.complex3DFFT == null || dimChanged) {
            this.complex3DFFT = new Complex3DParallel(this.fftX, this.fftY, this.fftZ, this.fftTeam, this.recipSchedule);
            if (this.splineGrid == null || this.splineGrid.length < this.fftSpace) {
                this.splineGrid = new double[this.fftSpace];
            }
            this.splineBuffer = DoubleBuffer.wrap(this.splineGrid);
        }
        this.complex3DFFT.setRecip(this.generalizedInfluenceFunction());
        switch (this.gridMethod.ordinal()) {
            case 0: {
                if (this.spatialDensityRegion == null || dimChanged) {
                    this.spatialDensityRegion = new SpatialDensityRegion(this.fftX, this.fftY, this.fftZ, this.splineGrid, this.bSplineOrder, this.nSymm, 10, this.threadCount, this.crystal, this.atoms, this.coordinates);
                    break;
                }
                this.spatialDensityRegion.setCrystal(this.crystal, this.fftX, this.fftY, this.fftZ);
                this.spatialDensityRegion.coordinates = this.coordinates;
                break;
            }
            case 2: {
                if (this.rowRegion == null || dimChanged) {
                    this.rowRegion = new RowRegion(this.fftX, this.fftY, this.fftZ, this.splineGrid, this.nSymm, this.threadCount, this.atoms, this.coordinates);
                    break;
                }
                this.rowRegion.setCrystal(this.crystal, this.fftX, this.fftY, this.fftZ);
                this.rowRegion.coordinates = this.coordinates;
                break;
            }
            case 1: {
                if (this.sliceRegion == null || dimChanged) {
                    this.sliceRegion = new SliceRegion(this.fftX, this.fftY, this.fftZ, this.splineGrid, this.nSymm, this.threadCount, this.atoms, this.coordinates);
                    break;
                }
                this.sliceRegion.setCrystal(this.crystal, this.fftX, this.fftY, this.fftZ);
                this.sliceRegion.coordinates = this.coordinates;
            }
        }
        return this.density;
    }

    private int RowIndexZ(int i) {
        return i / this.fftY;
    }

    private int RowIndexY(int i) {
        return i % this.fftY;
    }

    private double[] generalizedInfluenceFunction() {
        double[] influenceFunction = new double[this.fftSpace / 2];
        double[] bsModX = new double[this.fftX];
        double[] bsModY = new double[this.fftY];
        double[] bsModZ = new double[this.fftZ];
        int maxfft = FastMath.max((int)FastMath.max((int)FastMath.max((int)this.fftX, (int)this.fftY), (int)this.fftZ), (int)(this.bSplineOrder + 1));
        double[] bsArray = new double[maxfft];
        double[] c = new double[this.bSplineOrder];
        UniformBSpline.bSpline((double)0.0, (int)this.bSplineOrder, (double[])c);
        System.arraycopy(c, 0, bsArray, 1, this.bSplineOrder);
        ReciprocalSpace.discreteFTMod(bsModX, bsArray, this.fftX, this.bSplineOrder);
        ReciprocalSpace.discreteFTMod(bsModY, bsArray, this.fftY, this.bSplineOrder);
        ReciprocalSpace.discreteFTMod(bsModZ, bsArray, this.fftZ, this.bSplineOrder);
        double r00 = this.crystal.A[0][0];
        double r01 = this.crystal.A[0][1];
        double r02 = this.crystal.A[0][2];
        double r10 = this.crystal.A[1][0];
        double r11 = this.crystal.A[1][1];
        double r12 = this.crystal.A[1][2];
        double r20 = this.crystal.A[2][0];
        double r21 = this.crystal.A[2][1];
        double r22 = this.crystal.A[2][2];
        int ntot = this.fftX * this.fftY * this.fftZ;
        double piTerm = Math.PI / this.aEwald * (Math.PI / this.aEwald);
        double volTerm = Math.PI * this.crystal.volume;
        int nfXY = this.fftX * this.fftY;
        int nX_2 = (this.fftX + 1) / 2;
        int nY_2 = (this.fftY + 1) / 2;
        int nZ_2 = (this.fftZ + 1) / 2;
        for (int i = 0; i < ntot - 1; ++i) {
            int kX;
            int kZ = (i + 1) / nfXY;
            int j = i - kZ * nfXY + 1;
            int kY = j / this.fftX;
            int h = kX = j - kY * this.fftX;
            int k = kY;
            int l = kZ;
            if (kX >= nX_2) {
                h -= this.fftX;
            }
            if (kY >= nY_2) {
                k -= this.fftY;
            }
            if (kZ >= nZ_2) {
                l -= this.fftZ;
            }
            double sX = r00 * (double)h + r01 * (double)k + r02 * (double)l;
            double sY = r10 * (double)h + r11 * (double)k + r12 * (double)l;
            double sZ = r20 * (double)h + r21 * (double)k + r22 * (double)l;
            double sSquared = sX * sX + sY * sY + sZ * sZ;
            double term = -piTerm * sSquared;
            double expterm = 0.0;
            if (term > -50.0) {
                double denom = sSquared * volTerm * bsModX[kX] * bsModY[kY] * bsModZ[kZ];
                expterm = FastMath.exp((double)term) / denom;
                if (this.crystal.aperiodic()) {
                    expterm *= 1.0 - FastMath.cos((double)(Math.PI * this.crystal.a * FastMath.sqrt((double)sSquared)));
                }
            }
            int ii = Complex3D.interleavedIndex((int)kX, (int)kY, (int)kZ, (int)this.fftX, (int)this.fftY) / 2;
            influenceFunction[ii] = expterm;
        }
        influenceFunction[0] = 0.0;
        if (this.crystal.aperiodic()) {
            influenceFunction[0] = 1.5707963267948966 / this.crystal.a;
        }
        return influenceFunction;
    }

    private void transformMultipoleMatrix() {
        int k;
        int i1;
        int i;
        double[][] a = new double[3][3];
        for (i = 0; i < 3; ++i) {
            a[0][i] = (double)this.fftX * this.crystal.A[i][0];
            a[1][i] = (double)this.fftY * this.crystal.A[i][1];
            a[2][i] = (double)this.fftZ * this.crystal.A[i][2];
        }
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                this.transformMultipoleMatrix[i][j] = 0.0;
            }
        }
        this.transformMultipoleMatrix[0][0] = 1.0;
        for (i = 1; i < 4; ++i) {
            System.arraycopy(a[i - 1], 0, this.transformMultipoleMatrix[i], 1, 3);
        }
        for (i1 = 0; i1 < 3; ++i1) {
            k = qi1[i1];
            for (int i2 = 0; i2 < 6; ++i2) {
                int i3 = qi1[i2];
                int j = qi2[i2];
                this.transformMultipoleMatrix[i1 + 4][i2 + 4] = a[k][i3] * a[k][j];
            }
        }
        for (i1 = 3; i1 < 6; ++i1) {
            k = qi1[i1];
            int l = qi2[i1];
            for (int i2 = 0; i2 < 6; ++i2) {
                int i4 = qi1[i2];
                int j = qi2[i2];
                this.transformMultipoleMatrix[i1 + 4][i2 + 4] = a[k][i4] * a[l][j] + a[k][j] * a[l][i4];
            }
        }
    }

    private void transformFieldMatrix() {
        int k;
        int i1;
        int i;
        double[][] a = new double[3][3];
        for (i = 0; i < 3; ++i) {
            a[i][0] = (double)this.fftX * this.crystal.A[i][0];
            a[i][1] = (double)this.fftY * this.crystal.A[i][1];
            a[i][2] = (double)this.fftZ * this.crystal.A[i][2];
        }
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                this.transformFieldMatrix[i][j] = 0.0;
            }
        }
        this.transformFieldMatrix[0][0] = 1.0;
        for (i = 1; i < 4; ++i) {
            System.arraycopy(a[i - 1], 0, this.transformFieldMatrix[i], 1, 3);
        }
        for (i1 = 0; i1 < 3; ++i1) {
            int i2;
            int i22;
            k = qi1[i1];
            for (i22 = 0; i22 < 3; ++i22) {
                i2 = qi1[i22];
                this.transformFieldMatrix[i1 + 4][i22 + 4] = a[k][i2] * a[k][i2];
            }
            for (i22 = 3; i22 < 6; ++i22) {
                i2 = qi1[i22];
                int j = qi2[i22];
                this.transformFieldMatrix[i1 + 4][i22 + 4] = 2.0 * a[k][i2] * a[k][j];
            }
        }
        for (i1 = 3; i1 < 6; ++i1) {
            int i3;
            int i2;
            k = qi1[i1];
            int n = qi2[i1];
            for (i2 = 0; i2 < 3; ++i2) {
                i3 = qi1[i2];
                this.transformFieldMatrix[i1 + 4][i2 + 4] = a[k][i3] * a[n][i3];
            }
            for (i2 = 3; i2 < 6; ++i2) {
                i3 = qi1[i2];
                int j = qi2[i2];
                this.transformFieldMatrix[i1 + 4][i2 + 4] = a[k][i3] * a[n][j] + a[n][i3] * a[k][j];
            }
        }
    }

    private void toFractionalMultipole(double[] gm, double[] fm) {
        int k;
        int j;
        fm[0] = gm[0];
        for (j = 1; j < 4; ++j) {
            fm[j] = 0.0;
            for (k = 1; k < 4; ++k) {
                fm[j] = Math.fma(this.transformMultipoleMatrix[j][k], gm[k], fm[j]);
            }
        }
        for (j = 4; j < 10; ++j) {
            fm[j] = 0.0;
            for (k = 4; k < 7; ++k) {
                fm[j] = Math.fma(this.transformMultipoleMatrix[j][k], gm[k], fm[j]);
            }
            for (k = 7; k < 10; ++k) {
                fm[j] = Math.fma(this.transformMultipoleMatrix[j][k] * 2.0, gm[k], fm[j]);
            }
            fm[j] = fm[j] * 0.3333333333333333;
        }
    }

    public void toFractionalDipole(double[] globalDipole, double[] fractionalDipole) {
        for (int j = 0; j < 3; ++j) {
            fractionalDipole[j] = 0.0;
            for (int k = 0; k < 3; ++k) {
                fractionalDipole[j] = Math.fma(this.transformMultipoleMatrix[j + 1][k + 1], globalDipole[k], fractionalDipole[j]);
            }
        }
    }

    public static enum GridMethod {
        SPATIAL,
        SLICE,
        ROW;

    }

    public class BSplineRegion
    extends ParallelRegion {
        final BSplineLoop[] bSplineLoop;
        double[][][][] splineX;
        double[][][][] splineY;
        double[][][][] splineZ;
        int[][][] initGrid;
        private double r00;
        private double r01;
        private double r02;
        private double r10;
        private double r11;
        private double r12;
        private double r20;
        private double r21;
        private double r22;
        final /* synthetic */ ReciprocalSpace this$0;

        BSplineRegion(ReciprocalSpace this$0) {
            ReciprocalSpace reciprocalSpace = this$0;
            Objects.requireNonNull(reciprocalSpace);
            this.this$0 = reciprocalSpace;
            this.bSplineLoop = new BSplineLoop[this$0.threadCount];
            for (int i = 0; i < this$0.threadCount; ++i) {
                this.bSplineLoop[i] = new BSplineLoop(this);
            }
        }

        public void run() {
            if (this.splineX.length < this.this$0.nSymm) {
                logger.severe(" Programming Error: the number of reciprocal space symmetry operators changed.");
            }
            try {
                int threadID = this.getThreadIndex();
                this.execute(0, this.this$0.nAtoms - 1, this.bSplineLoop[threadID]);
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
        }

        public void start() {
            this.r00 = this.this$0.crystal.A[0][0];
            this.r01 = this.this$0.crystal.A[0][1];
            this.r02 = this.this$0.crystal.A[0][2];
            this.r10 = this.this$0.crystal.A[1][0];
            this.r11 = this.this$0.crystal.A[1][1];
            this.r12 = this.this$0.crystal.A[1][2];
            this.r20 = this.this$0.crystal.A[2][0];
            this.r21 = this.this$0.crystal.A[2][1];
            this.r22 = this.this$0.crystal.A[2][2];
            if (this.splineX == null || this.splineX[0].length < this.this$0.nAtoms) {
                this.initGrid = new int[this.this$0.nSymm][this.this$0.nAtoms][];
                this.splineX = new double[this.this$0.nSymm][this.this$0.nAtoms][][];
                this.splineY = new double[this.this$0.nSymm][this.this$0.nAtoms][][];
                this.splineZ = new double[this.this$0.nSymm][this.this$0.nAtoms][][];
            }
        }

        public class BSplineLoop
        extends IntegerForLoop {
            private int threadID;
            private final double[][] bSplineWork;
            private final IntegerSchedule schedule;
            final /* synthetic */ BSplineRegion this$1;

            BSplineLoop(BSplineRegion this$1) {
                BSplineRegion bSplineRegion = this$1;
                Objects.requireNonNull(bSplineRegion);
                this.this$1 = bSplineRegion;
                this.schedule = IntegerSchedule.fixed();
                this.bSplineWork = new double[this$1.this$0.bSplineOrder][this$1.this$0.bSplineOrder];
            }

            public void finish() {
                int n = this.threadID;
                this.this$1.this$0.bSplineTime[n] = this.this$1.this$0.bSplineTime[n] + System.nanoTime();
            }

            public void run(int lb, int ub) {
                for (int iSymOp = 0; iSymOp < this.this$1.this$0.nSymm; ++iSymOp) {
                    double[] x = this.this$1.this$0.coordinates[iSymOp][0];
                    double[] y = this.this$1.this$0.coordinates[iSymOp][1];
                    double[] z = this.this$1.this$0.coordinates[iSymOp][2];
                    int[][] initgridi = this.this$1.initGrid[iSymOp];
                    double[][][] splineXi = this.this$1.splineX[iSymOp];
                    double[][][] splineYi = this.this$1.splineY[iSymOp];
                    double[][][] splineZi = this.this$1.splineZ[iSymOp];
                    for (int i = lb; i <= ub; ++i) {
                        if (initgridi[i] == null) {
                            initgridi[i] = new int[3];
                            splineXi[i] = new double[this.this$1.this$0.bSplineOrder][4];
                            splineYi[i] = new double[this.this$1.this$0.bSplineOrder][4];
                            splineZi[i] = new double[this.this$1.this$0.bSplineOrder][4];
                        }
                        double xi = x[i];
                        double yi = y[i];
                        double zi = z[i];
                        int[] grd = initgridi[i];
                        double wx = xi * this.this$1.r00 + yi * this.this$1.r10 + zi * this.this$1.r20;
                        double ux = wx - (double)FastMath.round((double)wx) + 0.5;
                        double frx = (double)this.this$1.this$0.fftX * ux;
                        int ifrx = (int)frx;
                        double bx = frx - (double)ifrx;
                        grd[0] = ifrx - this.this$1.this$0.bSplineOrder;
                        UniformBSpline.bSplineDerivatives((double)bx, (int)this.this$1.this$0.bSplineOrder, (int)3, (double[][])splineXi[i], (double[][])this.bSplineWork);
                        double wy = xi * this.this$1.r01 + yi * this.this$1.r11 + zi * this.this$1.r21;
                        double uy = wy - (double)FastMath.round((double)wy) + 0.5;
                        double fry = (double)this.this$1.this$0.fftY * uy;
                        int ifry = (int)fry;
                        double by = fry - (double)ifry;
                        grd[1] = ifry - this.this$1.this$0.bSplineOrder;
                        UniformBSpline.bSplineDerivatives((double)by, (int)this.this$1.this$0.bSplineOrder, (int)3, (double[][])splineYi[i], (double[][])this.bSplineWork);
                        double wz = xi * this.this$1.r02 + yi * this.this$1.r12 + zi * this.this$1.r22;
                        double uz = wz - (double)FastMath.round((double)wz) + 0.5;
                        double frz = (double)this.this$1.this$0.fftZ * uz;
                        int ifrz = (int)frz;
                        double bz = frz - (double)ifrz;
                        grd[2] = ifrz - this.this$1.this$0.bSplineOrder;
                        UniformBSpline.bSplineDerivatives((double)bz, (int)this.this$1.this$0.bSplineOrder, (int)3, (double[][])splineZi[i], (double[][])this.bSplineWork);
                    }
                }
            }

            public IntegerSchedule schedule() {
                return this.schedule;
            }

            public void start() {
                int n = this.threadID = this.getThreadIndex();
                this.this$1.this$0.bSplineTime[n] = this.this$1.this$0.bSplineTime[n] - System.nanoTime();
            }
        }
    }

    private class FractionalMultipoleRegion
    extends ParallelRegion {
        private double[][][] globalMultipoles;
        private double[][][] fracMultipoles;
        private boolean[] use;
        private FractionalMultipoleLoop[] fractionalMultipoleLoops;
        final /* synthetic */ ReciprocalSpace this$0;

        private FractionalMultipoleRegion(ReciprocalSpace reciprocalSpace) {
            ReciprocalSpace reciprocalSpace2 = reciprocalSpace;
            Objects.requireNonNull(reciprocalSpace2);
            this.this$0 = reciprocalSpace2;
            this.globalMultipoles = null;
            this.fracMultipoles = null;
            this.use = null;
        }

        public void start() {
            if (this.fractionalMultipoleLoops == null) {
                int nThreads = this.getThreadCount();
                this.fractionalMultipoleLoops = new FractionalMultipoleLoop[nThreads];
                for (int i = 0; i < nThreads; ++i) {
                    this.fractionalMultipoleLoops[i] = new FractionalMultipoleLoop(this);
                }
            }
        }

        void setPermanent(double[][][] globalMultipoles, double[][][] fracMultipoles) {
            this.globalMultipoles = globalMultipoles;
            this.fracMultipoles = fracMultipoles;
        }

        private void setUse(boolean[] use) {
            this.use = use;
        }

        public void run() {
            int threadIndex = this.getThreadIndex();
            try {
                this.execute(0, this.this$0.nAtoms - 1, this.fractionalMultipoleLoops[threadIndex]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private class FractionalMultipoleLoop
        extends IntegerForLoop {
            final /* synthetic */ FractionalMultipoleRegion this$1;

            private FractionalMultipoleLoop(FractionalMultipoleRegion fractionalMultipoleRegion) {
                FractionalMultipoleRegion fractionalMultipoleRegion2 = fractionalMultipoleRegion;
                Objects.requireNonNull(fractionalMultipoleRegion2);
                this.this$1 = fractionalMultipoleRegion2;
            }

            public void run(int lb, int ub) {
                for (int s = 0; s < this.this$1.this$0.nSymm; ++s) {
                    for (int i = lb; i <= ub; ++i) {
                        if (!this.this$1.use[i]) continue;
                        this.this$1.this$0.toFractionalMultipole(this.this$1.globalMultipoles[s][i], this.this$1.fracMultipoles[s][i]);
                    }
                }
            }

            public IntegerSchedule schedule() {
                return IntegerSchedule.fixed();
            }
        }
    }

    private class FractionalInducedRegion
    extends ParallelRegion {
        private double[][][] inducedDipole;
        private double[][][] inducedDipoleCR;
        private double[][][] inducedDipoleFrac;
        private double[][][] inducedDipoleFracCR;
        private boolean[] use;
        private FractionalInducedLoop[] fractionalInducedLoops;
        final /* synthetic */ ReciprocalSpace this$0;

        private FractionalInducedRegion(ReciprocalSpace reciprocalSpace) {
            ReciprocalSpace reciprocalSpace2 = reciprocalSpace;
            Objects.requireNonNull(reciprocalSpace2);
            this.this$0 = reciprocalSpace2;
            this.use = null;
        }

        public void start() {
            if (this.fractionalInducedLoops == null) {
                int nThreads = this.getThreadCount();
                this.fractionalInducedLoops = new FractionalInducedLoop[nThreads];
                for (int i = 0; i < nThreads; ++i) {
                    this.fractionalInducedLoops[i] = new FractionalInducedLoop(this);
                }
            }
        }

        void setInducedDipoles(double[][][] inducedDipole, double[][][] inducedDipoleCR, double[][][] inducedDipoleFrac, double[][][] inducedDipoleFracCR) {
            this.inducedDipole = inducedDipole;
            this.inducedDipoleCR = inducedDipoleCR;
            this.inducedDipoleFrac = inducedDipoleFrac;
            this.inducedDipoleFracCR = inducedDipoleFracCR;
        }

        private void setUse(boolean[] use) {
            this.use = use;
        }

        public void run() {
            int threadIndex = this.getThreadIndex();
            try {
                this.execute(0, this.this$0.nAtoms - 1, this.fractionalInducedLoops[threadIndex]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private class FractionalInducedLoop
        extends IntegerForLoop {
            final /* synthetic */ FractionalInducedRegion this$1;

            private FractionalInducedLoop(FractionalInducedRegion fractionalInducedRegion) {
                FractionalInducedRegion fractionalInducedRegion2 = fractionalInducedRegion;
                Objects.requireNonNull(fractionalInducedRegion2);
                this.this$1 = fractionalInducedRegion2;
            }

            public void run(int lb, int ub) {
                for (int s = 0; s < this.this$1.this$0.nSymm; ++s) {
                    for (int i = lb; i <= ub; ++i) {
                        if (!this.this$1.use[i]) continue;
                        this.this$1.this$0.toFractionalDipole(this.this$1.inducedDipole[s][i], this.this$1.inducedDipoleFrac[s][i]);
                        this.this$1.this$0.toFractionalDipole(this.this$1.inducedDipoleCR[s][i], this.this$1.inducedDipoleFracCR[s][i]);
                    }
                }
            }

            public IntegerSchedule schedule() {
                return IntegerSchedule.fixed();
            }
        }
    }

    private class SpatialPermanentLoop
    extends SpatialDensityLoop {
        private final BSplineRegion bSplines;
        private double[][][] fracMultipoles;
        private boolean[] use;
        private int threadIndex;
        final /* synthetic */ ReciprocalSpace this$0;

        SpatialPermanentLoop(ReciprocalSpace reciprocalSpace, SpatialDensityRegion region, BSplineRegion splines) {
            ReciprocalSpace reciprocalSpace2 = reciprocalSpace;
            Objects.requireNonNull(reciprocalSpace2);
            this.this$0 = reciprocalSpace2;
            super(region, region.nSymm, region.actualCount);
            this.fracMultipoles = null;
            this.use = null;
            this.bSplines = splines;
        }

        public void finish() {
            int n = this.threadIndex;
            this.this$0.splinePermanentTime[n] = this.this$0.splinePermanentTime[n] + System.nanoTime();
        }

        @Override
        public void gridDensity(int iSymm, int n) {
            if (this.use != null && !this.use[n]) {
                return;
            }
            int n2 = this.threadIndex;
            this.this$0.splineCount[n2] = this.this$0.splineCount[n2] + 1;
            switch (this.this$0.elecForm) {
                case PAM: {
                    this.gridMultipoleDensity(iSymm, n);
                    break;
                }
                case FIXED_CHARGE: {
                    this.gridFixedChargeDensity(iSymm, n);
                }
            }
        }

        private void gridMultipoleDensity(int iSymm, int n) {
            double[] fm = this.fracMultipoles[iSymm][n];
            double[][] splx = this.bSplines.splineX[iSymm][n];
            double[][] sply = this.bSplines.splineY[iSymm][n];
            double[][] splz = this.bSplines.splineZ[iSymm][n];
            int igrd0 = this.bSplines.initGrid[iSymm][n][0];
            int jgrd0 = this.bSplines.initGrid[iSymm][n][1];
            int k0 = this.bSplines.initGrid[iSymm][n][2];
            double c = fm[0];
            double dx = fm[1];
            double dy = fm[2];
            double dz = fm[3];
            double qxx = fm[4];
            double qyy = fm[5];
            double qzz = fm[6];
            double qxy = fm[7];
            double qxz = fm[8];
            double qyz = fm[9];
            for (int ith3 = 0; ith3 < this.this$0.bSplineOrder; ++ith3) {
                double[] splzi = splz[ith3];
                double v0 = splzi[0];
                double v1 = splzi[1];
                double v2 = splzi[2];
                double c0 = c * v0;
                double dx0 = dx * v0;
                double dy0 = dy * v0;
                double dz1 = dz * v1;
                double qxx0 = qxx * v0;
                double qyy0 = qyy * v0;
                double qzz2 = qzz * v2;
                double qxy0 = qxy * v0;
                double qxz1 = qxz * v1;
                double qyz1 = qyz * v1;
                double c0dz1qzz2 = c0 + dz1 + qzz2;
                double dy0qyz1 = dy0 + qyz1;
                double dx0qxz1 = dx0 + qxz1;
                int k = ScalarMath.mod((int)(++k0), (int)this.this$0.fftZ);
                int j0 = jgrd0;
                for (int ith2 = 0; ith2 < this.this$0.bSplineOrder; ++ith2) {
                    double[] splyi = sply[ith2];
                    double u0 = splyi[0];
                    double u1 = splyi[1];
                    double u2 = splyi[2];
                    double term0 = Math.fma(c0dz1qzz2, u0, Math.fma(dy0qyz1, u1, qyy0 * u2));
                    double term1 = Math.fma(dx0qxz1, u0, qxy0 * u1);
                    double term2 = qxx0 * u0;
                    int j = ScalarMath.mod((int)(++j0), (int)this.this$0.fftY);
                    int i0 = igrd0;
                    for (int ith1 = 0; ith1 < this.this$0.bSplineOrder; ++ith1) {
                        int i = ScalarMath.mod((int)(++i0), (int)this.this$0.fftX);
                        int ii = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        double[] splxi = splx[ith1];
                        double current = this.this$0.splineBuffer.get(ii);
                        double updated = Math.fma(splxi[0], term0, current);
                        updated = Math.fma(splxi[1], term1, updated);
                        updated = Math.fma(splxi[2], term2, updated);
                        this.this$0.splineBuffer.put(ii, updated);
                    }
                }
            }
        }

        private void gridFixedChargeDensity(int iSymm, int n) {
            double[] fm = this.fracMultipoles[iSymm][n];
            double[][] splx = this.bSplines.splineX[iSymm][n];
            double[][] sply = this.bSplines.splineY[iSymm][n];
            double[][] splz = this.bSplines.splineZ[iSymm][n];
            int igrd0 = this.bSplines.initGrid[iSymm][n][0];
            int jgrd0 = this.bSplines.initGrid[iSymm][n][1];
            int k0 = this.bSplines.initGrid[iSymm][n][2];
            double c = fm[0];
            for (int ith3 = 0; ith3 < this.this$0.bSplineOrder; ++ith3) {
                double[] splzi = splz[ith3];
                double v0 = splzi[0];
                double c0 = c * v0;
                int k = ScalarMath.mod((int)(++k0), (int)this.this$0.fftZ);
                int j0 = jgrd0;
                for (int ith2 = 0; ith2 < this.this$0.bSplineOrder; ++ith2) {
                    double[] splyi = sply[ith2];
                    double u0 = splyi[0];
                    double term0 = c0 * u0;
                    int j = ScalarMath.mod((int)(++j0), (int)this.this$0.fftY);
                    int i0 = igrd0;
                    for (int ith1 = 0; ith1 < this.this$0.bSplineOrder; ++ith1) {
                        int i = ScalarMath.mod((int)(++i0), (int)this.this$0.fftX);
                        int ii = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        double[] splxi = splx[ith1];
                        double current = this.this$0.splineBuffer.get(ii);
                        double updated = Math.fma(splxi[0], term0, current);
                        this.this$0.splineBuffer.put(ii, updated);
                    }
                }
            }
        }

        public void start() {
            int n = this.threadIndex = this.getThreadIndex();
            this.this$0.splinePermanentTime[n] = this.this$0.splinePermanentTime[n] - System.nanoTime();
        }

        void setPermanent(double[][][] fracMultipoles) {
            this.fracMultipoles = fracMultipoles;
        }

        private void setUse(boolean[] use) {
            this.use = use;
        }
    }

    private class SpatialInducedLoop
    extends SpatialDensityLoop {
        private final BSplineRegion bSplineRegion;
        private double[][][] inducedDipoleFrac;
        private double[][][] inducedDipoleFracCR;
        private boolean[] use;
        final /* synthetic */ ReciprocalSpace this$0;

        SpatialInducedLoop(ReciprocalSpace reciprocalSpace, SpatialDensityRegion region, BSplineRegion splines) {
            ReciprocalSpace reciprocalSpace2 = reciprocalSpace;
            Objects.requireNonNull(reciprocalSpace2);
            this.this$0 = reciprocalSpace2;
            super(region, region.nSymm, region.actualCount);
            this.inducedDipoleFrac = null;
            this.inducedDipoleFracCR = null;
            this.use = null;
            this.bSplineRegion = splines;
        }

        public void finish() {
            int n = this.getThreadIndex();
            this.this$0.splineInducedTime[n] = this.this$0.splineInducedTime[n] + System.nanoTime();
        }

        @Override
        public void gridDensity(int iSymm, int n) {
            if (this.use != null && !this.use[n]) {
                return;
            }
            double[] ind = this.inducedDipoleFrac[iSymm][n];
            double ux = ind[0];
            double uy = ind[1];
            double uz = ind[2];
            double[] indCR = this.inducedDipoleFracCR[iSymm][n];
            double px = indCR[0];
            double py = indCR[1];
            double pz = indCR[2];
            double[][] splx = this.bSplineRegion.splineX[iSymm][n];
            double[][] sply = this.bSplineRegion.splineY[iSymm][n];
            double[][] splz = this.bSplineRegion.splineZ[iSymm][n];
            int igrd0 = this.bSplineRegion.initGrid[iSymm][n][0];
            int jgrd0 = this.bSplineRegion.initGrid[iSymm][n][1];
            int k0 = this.bSplineRegion.initGrid[iSymm][n][2];
            for (int ith3 = 0; ith3 < this.this$0.bSplineOrder; ++ith3) {
                double[] splzi = splz[ith3];
                double v0 = splzi[0];
                double v1 = splzi[1];
                double dx0 = ux * v0;
                double dy0 = uy * v0;
                double dz1 = uz * v1;
                double px0 = px * v0;
                double py0 = py * v0;
                double pz1 = pz * v1;
                int k = ScalarMath.mod((int)(++k0), (int)this.this$0.fftZ);
                int j0 = jgrd0;
                for (int ith2 = 0; ith2 < this.this$0.bSplineOrder; ++ith2) {
                    double[] splyi = sply[ith2];
                    double u0 = splyi[0];
                    double u1 = splyi[1];
                    double term0 = Math.fma(dz1, u0, dy0 * u1);
                    double term1 = dx0 * u0;
                    double termp0 = Math.fma(pz1, u0, py0 * u1);
                    double termp1 = px0 * u0;
                    int j = ScalarMath.mod((int)(++j0), (int)this.this$0.fftY);
                    int i0 = igrd0;
                    for (int ith1 = 0; ith1 < this.this$0.bSplineOrder; ++ith1) {
                        int i = ScalarMath.mod((int)(++i0), (int)this.this$0.fftX);
                        int ii = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        double[] splxi = splx[ith1];
                        double current = this.this$0.splineBuffer.get(ii);
                        double currenti = this.this$0.splineBuffer.get(ii + 1);
                        double updated = Math.fma(splxi[0], term0, Math.fma(splxi[1], term1, current));
                        double udpatedi = Math.fma(splxi[0], termp0, Math.fma(splxi[1], termp1, currenti));
                        this.this$0.splineBuffer.put(ii, updated);
                        this.this$0.splineBuffer.put(ii + 1, udpatedi);
                    }
                }
            }
        }

        public void setUse(boolean[] use) {
            this.use = use;
        }

        public void start() {
            int n = this.getThreadIndex();
            this.this$0.splineInducedTime[n] = this.this$0.splineInducedTime[n] - System.nanoTime();
        }

        void setInducedDipoles(double[][][] inducedDipoleFrac, double[][][] inducedDipoleFracCR) {
            this.inducedDipoleFrac = inducedDipoleFrac;
            this.inducedDipoleFracCR = inducedDipoleFracCR;
        }
    }

    private class SlicePermanentLoop
    extends SliceLoop {
        private final BSplineRegion bSplines;
        private double[][][] fracMultipoles;
        private boolean[] use;
        private int threadIndex;
        final /* synthetic */ ReciprocalSpace this$0;

        SlicePermanentLoop(ReciprocalSpace reciprocalSpace, SliceRegion region, BSplineRegion splines) {
            ReciprocalSpace reciprocalSpace2 = reciprocalSpace;
            Objects.requireNonNull(reciprocalSpace2);
            this.this$0 = reciprocalSpace2;
            super(region.nAtoms, region.nSymm, region);
            this.fracMultipoles = null;
            this.use = null;
            this.bSplines = splines;
        }

        public void finish() {
            int n = this.threadIndex;
            this.this$0.splinePermanentTime[n] = this.this$0.splinePermanentTime[n] + System.nanoTime();
        }

        @Override
        public void gridDensity(int iSymm, int iAtom, int lb, int ub) {
            if (this.use != null && !this.use[iAtom]) {
                return;
            }
            switch (this.this$0.elecForm) {
                case PAM: {
                    this.gridMultipoleDensity(iSymm, iAtom, lb, ub);
                    break;
                }
                case FIXED_CHARGE: {
                    this.gridFixedChargeDensity(iSymm, iAtom, lb, ub);
                }
            }
        }

        private void gridMultipoleDensity(int iSymm, int iAtom, int lb, int ub) {
            boolean atomContributes = false;
            int k0 = this.bSplines.initGrid[iSymm][iAtom][2];
            for (int ith3 = 0; ith3 < this.this$0.bSplineOrder; ++ith3) {
                int k;
                if (lb > (k = ScalarMath.mod((int)(++k0), (int)this.this$0.fftZ)) || k > ub) continue;
                atomContributes = true;
                break;
            }
            if (!atomContributes) {
                return;
            }
            int n = this.threadIndex;
            this.this$0.splineCount[n] = this.this$0.splineCount[n] + 1;
            int index = this.this$0.gridAtomCount[iSymm][this.threadIndex];
            this.this$0.gridAtomList[iSymm][this.threadIndex][index] = iAtom;
            int[] nArray = this.this$0.gridAtomCount[iSymm];
            int n2 = this.threadIndex;
            nArray[n2] = nArray[n2] + 1;
            double[] fm = this.fracMultipoles[iSymm][iAtom];
            double[][] splx = this.bSplines.splineX[iSymm][iAtom];
            double[][] sply = this.bSplines.splineY[iSymm][iAtom];
            double[][] splz = this.bSplines.splineZ[iSymm][iAtom];
            int igrd0 = this.bSplines.initGrid[iSymm][iAtom][0];
            int jgrd0 = this.bSplines.initGrid[iSymm][iAtom][1];
            k0 = this.bSplines.initGrid[iSymm][iAtom][2];
            double c = fm[0];
            double dx = fm[1];
            double dy = fm[2];
            double dz = fm[3];
            double qxx = fm[4];
            double qyy = fm[5];
            double qzz = fm[6];
            double qxy = fm[7];
            double qxz = fm[8];
            double qyz = fm[9];
            for (int ith3 = 0; ith3 < this.this$0.bSplineOrder; ++ith3) {
                int k;
                if ((k = ScalarMath.mod((int)(++k0), (int)this.this$0.fftZ)) < lb || k > ub) continue;
                double[] splzi = splz[ith3];
                double v0 = splzi[0];
                double v1 = splzi[1];
                double v2 = splzi[2];
                double c0 = c * v0;
                double dx0 = dx * v0;
                double dy0 = dy * v0;
                double dz1 = dz * v1;
                double qxx0 = qxx * v0;
                double qyy0 = qyy * v0;
                double qzz2 = qzz * v2;
                double qxy0 = qxy * v0;
                double qxz1 = qxz * v1;
                double qyz1 = qyz * v1;
                double c0dz1qzz2 = c0 + dz1 + qzz2;
                double dy0qyz1 = dy0 + qyz1;
                double dx0qxz1 = dx0 + qxz1;
                int j0 = jgrd0;
                for (int ith2 = 0; ith2 < this.this$0.bSplineOrder; ++ith2) {
                    double[] splyi = sply[ith2];
                    double u0 = splyi[0];
                    double u1 = splyi[1];
                    double u2 = splyi[2];
                    double term0 = Math.fma(c0dz1qzz2, u0, Math.fma(dy0qyz1, u1, qyy0 * u2));
                    double term1 = Math.fma(dx0qxz1, u0, qxy0 * u1);
                    double term2 = qxx0 * u0;
                    int j = ScalarMath.mod((int)(++j0), (int)this.this$0.fftY);
                    int i0 = igrd0;
                    for (int ith1 = 0; ith1 < this.this$0.bSplineOrder; ++ith1) {
                        int i = ScalarMath.mod((int)(++i0), (int)this.this$0.fftX);
                        int ii = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        double[] splxi = splx[ith1];
                        double current = this.this$0.splineBuffer.get(ii);
                        double updated = Math.fma(splxi[0], term0, current);
                        updated = Math.fma(splxi[1], term1, updated);
                        updated = Math.fma(splxi[2], term2, updated);
                        this.this$0.splineBuffer.put(ii, updated);
                    }
                }
            }
        }

        private void gridFixedChargeDensity(int iSymm, int iAtom, int lb, int ub) {
            boolean atomContributes = false;
            int k0 = this.bSplines.initGrid[iSymm][iAtom][2];
            for (int ith3 = 0; ith3 < this.this$0.bSplineOrder; ++ith3) {
                int k;
                if (lb > (k = ScalarMath.mod((int)(++k0), (int)this.this$0.fftZ)) || k > ub) continue;
                atomContributes = true;
                break;
            }
            if (!atomContributes) {
                return;
            }
            int n = this.threadIndex;
            this.this$0.splineCount[n] = this.this$0.splineCount[n] + 1;
            int index = this.this$0.gridAtomCount[iSymm][this.threadIndex];
            this.this$0.gridAtomList[iSymm][this.threadIndex][index] = iAtom;
            int[] nArray = this.this$0.gridAtomCount[iSymm];
            int n2 = this.threadIndex;
            nArray[n2] = nArray[n2] + 1;
            double[] fm = this.fracMultipoles[iSymm][iAtom];
            double[][] splx = this.bSplines.splineX[iSymm][iAtom];
            double[][] sply = this.bSplines.splineY[iSymm][iAtom];
            double[][] splz = this.bSplines.splineZ[iSymm][iAtom];
            int igrd0 = this.bSplines.initGrid[iSymm][iAtom][0];
            int jgrd0 = this.bSplines.initGrid[iSymm][iAtom][1];
            k0 = this.bSplines.initGrid[iSymm][iAtom][2];
            double c = fm[0];
            for (int ith3 = 0; ith3 < this.this$0.bSplineOrder; ++ith3) {
                int k;
                if ((k = ScalarMath.mod((int)(++k0), (int)this.this$0.fftZ)) < lb || k > ub) continue;
                double[] splzi = splz[ith3];
                double v0 = splzi[0];
                double c0 = c * v0;
                int j0 = jgrd0;
                for (int ith2 = 0; ith2 < this.this$0.bSplineOrder; ++ith2) {
                    double[] splyi = sply[ith2];
                    double u0 = splyi[0];
                    double term0 = c0 * u0;
                    int j = ScalarMath.mod((int)(++j0), (int)this.this$0.fftY);
                    int i0 = igrd0;
                    for (int ith1 = 0; ith1 < this.this$0.bSplineOrder; ++ith1) {
                        int i = ScalarMath.mod((int)(++i0), (int)this.this$0.fftX);
                        int ii = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        double[] splxi = splx[ith1];
                        double current = this.this$0.splineBuffer.get(ii);
                        double updated = Math.fma(splxi[0], term0, current);
                        this.this$0.splineBuffer.put(ii, updated);
                    }
                }
            }
        }

        public void start() {
            int n = this.threadIndex = this.getThreadIndex();
            this.this$0.splinePermanentTime[n] = this.this$0.splinePermanentTime[n] - System.nanoTime();
            for (int i = 0; i < this.this$0.nSymm; ++i) {
                this.this$0.gridAtomCount[i][this.threadIndex] = 0;
            }
        }

        void setPermanent(double[][][] fracMultipoles) {
            this.fracMultipoles = fracMultipoles;
        }

        private void setUse(boolean[] use) {
            this.use = use;
        }
    }

    private class SliceInducedLoop
    extends SliceLoop {
        private final BSplineRegion bSplineRegion;
        private double[][][] inducedDipoleFrac;
        private double[][][] inducedDipoleFracCR;
        private boolean[] use;
        final /* synthetic */ ReciprocalSpace this$0;

        SliceInducedLoop(ReciprocalSpace reciprocalSpace, SliceRegion region, BSplineRegion splines) {
            ReciprocalSpace reciprocalSpace2 = reciprocalSpace;
            Objects.requireNonNull(reciprocalSpace2);
            this.this$0 = reciprocalSpace2;
            super(region.nAtoms, region.nSymm, region);
            this.inducedDipoleFrac = null;
            this.inducedDipoleFracCR = null;
            this.use = null;
            this.bSplineRegion = splines;
        }

        public void finish() {
            int threadIndex;
            int n = threadIndex = this.getThreadIndex();
            this.this$0.splineInducedTime[n] = this.this$0.splineInducedTime[n] + System.nanoTime();
        }

        @Override
        public void gridDensity(int iSymm, int iAtom, int lb, int ub) {
            if (this.use != null && !this.use[iAtom]) {
                return;
            }
            double[] ind = this.inducedDipoleFrac[iSymm][iAtom];
            double ux = ind[0];
            double uy = ind[1];
            double uz = ind[2];
            double[] indCR = this.inducedDipoleFracCR[iSymm][iAtom];
            double px = indCR[0];
            double py = indCR[1];
            double pz = indCR[2];
            double[][] splx = this.bSplineRegion.splineX[iSymm][iAtom];
            double[][] sply = this.bSplineRegion.splineY[iSymm][iAtom];
            double[][] splz = this.bSplineRegion.splineZ[iSymm][iAtom];
            int igrd0 = this.bSplineRegion.initGrid[iSymm][iAtom][0];
            int jgrd0 = this.bSplineRegion.initGrid[iSymm][iAtom][1];
            int k0 = this.bSplineRegion.initGrid[iSymm][iAtom][2];
            for (int ith3 = 0; ith3 < this.this$0.bSplineOrder; ++ith3) {
                int k;
                if ((k = ScalarMath.mod((int)(++k0), (int)this.this$0.fftZ)) < lb || k > ub) continue;
                double[] splzi = splz[ith3];
                double v0 = splzi[0];
                double v1 = splzi[1];
                double dx0 = ux * v0;
                double dy0 = uy * v0;
                double dz1 = uz * v1;
                double px0 = px * v0;
                double py0 = py * v0;
                double pz1 = pz * v1;
                int j0 = jgrd0;
                for (int ith2 = 0; ith2 < this.this$0.bSplineOrder; ++ith2) {
                    double[] splyi = sply[ith2];
                    double u0 = splyi[0];
                    double u1 = splyi[1];
                    double term0 = Math.fma(dz1, u0, dy0 * u1);
                    double term1 = dx0 * u0;
                    double termp0 = Math.fma(pz1, u0, py0 * u1);
                    double termp1 = px0 * u0;
                    int j = ScalarMath.mod((int)(++j0), (int)this.this$0.fftY);
                    int i0 = igrd0;
                    for (int ith1 = 0; ith1 < this.this$0.bSplineOrder; ++ith1) {
                        int i = ScalarMath.mod((int)(++i0), (int)this.this$0.fftX);
                        int ii = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        double[] splxi = splx[ith1];
                        double current = this.this$0.splineBuffer.get(ii);
                        double currenti = this.this$0.splineBuffer.get(ii + 1);
                        double updated = Math.fma(splxi[0], term0, Math.fma(splxi[1], term1, current));
                        double udpatedi = Math.fma(splxi[0], termp0, Math.fma(splxi[1], termp1, currenti));
                        this.this$0.splineBuffer.put(ii, updated);
                        this.this$0.splineBuffer.put(ii + 1, udpatedi);
                    }
                }
            }
        }

        @Override
        public void run(int lb, int ub) {
            int ti = this.getThreadIndex();
            for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                int[] list = this.this$0.gridAtomList[iSymm][ti];
                int n = this.this$0.gridAtomCount[iSymm][ti];
                for (int i = 0; i < n; ++i) {
                    int iAtom = list[i];
                    this.gridDensity(iSymm, iAtom, lb, ub);
                }
            }
        }

        public void setUse(boolean[] use) {
            this.use = use;
        }

        public void start() {
            int threadIndex;
            int n = threadIndex = this.getThreadIndex();
            this.this$0.splineInducedTime[n] = this.this$0.splineInducedTime[n] - System.nanoTime();
        }

        void setInducedDipoles(double[][][] inducedDipoleFrac, double[][][] inducedDipoleFracCR) {
            this.inducedDipoleFrac = inducedDipoleFrac;
            this.inducedDipoleFracCR = inducedDipoleFracCR;
        }
    }

    private class RowPermanentLoop
    extends RowLoop {
        private final BSplineRegion bSplines;
        private double[][][] fracMultipoles;
        private boolean[] use;
        private int threadIndex;
        final /* synthetic */ ReciprocalSpace this$0;

        RowPermanentLoop(ReciprocalSpace reciprocalSpace, RowRegion region, BSplineRegion splines) {
            ReciprocalSpace reciprocalSpace2 = reciprocalSpace;
            Objects.requireNonNull(reciprocalSpace2);
            this.this$0 = reciprocalSpace2;
            super(region.nAtoms, region.nSymm, region);
            this.fracMultipoles = null;
            this.use = null;
            this.bSplines = splines;
        }

        public void finish() {
            int n = this.threadIndex;
            this.this$0.splinePermanentTime[n] = this.this$0.splinePermanentTime[n] + System.nanoTime();
        }

        @Override
        public void gridDensity(int iSymm, int iAtom, int lb, int ub) {
            if (this.use != null && !this.use[iAtom]) {
                return;
            }
            switch (this.this$0.elecForm) {
                case PAM: {
                    this.gridMultipoleDensity(iSymm, iAtom, lb, ub);
                    break;
                }
                case FIXED_CHARGE: {
                    this.gridFixedChargeDensity(iSymm, iAtom, lb, ub);
                }
            }
        }

        private void gridMultipoleDensity(int iSymm, int iAtom, int lb, int ub) {
            boolean atomContributes = false;
            int k0 = this.bSplines.initGrid[iSymm][iAtom][2];
            int lbZ = this.this$0.RowIndexZ(lb);
            int ubZ = this.this$0.RowIndexZ(ub);
            for (int ith3 = 0; ith3 < this.this$0.bSplineOrder; ++ith3) {
                int k;
                if (lbZ > (k = ScalarMath.mod((int)(++k0), (int)this.this$0.fftZ)) || k > ubZ) continue;
                atomContributes = true;
                break;
            }
            if (!atomContributes) {
                return;
            }
            int n = this.threadIndex;
            this.this$0.splineCount[n] = this.this$0.splineCount[n] + 1;
            int index = this.this$0.gridAtomCount[iSymm][this.threadIndex];
            this.this$0.gridAtomList[iSymm][this.threadIndex][index] = iAtom;
            int[] nArray = this.this$0.gridAtomCount[iSymm];
            int n2 = this.threadIndex;
            nArray[n2] = nArray[n2] + 1;
            double[] fm = this.fracMultipoles[iSymm][iAtom];
            double[][] splx = this.bSplines.splineX[iSymm][iAtom];
            double[][] sply = this.bSplines.splineY[iSymm][iAtom];
            double[][] splz = this.bSplines.splineZ[iSymm][iAtom];
            int igrd0 = this.bSplines.initGrid[iSymm][iAtom][0];
            int jgrd0 = this.bSplines.initGrid[iSymm][iAtom][1];
            k0 = this.bSplines.initGrid[iSymm][iAtom][2];
            double c = fm[0];
            double dx = fm[1];
            double dy = fm[2];
            double dz = fm[3];
            double qxx = fm[4];
            double qyy = fm[5];
            double qzz = fm[6];
            double qxy = fm[7];
            double qxz = fm[8];
            double qyz = fm[9];
            for (int ith3 = 0; ith3 < this.this$0.bSplineOrder; ++ith3) {
                int k;
                if ((k = ScalarMath.mod((int)(++k0), (int)this.this$0.fftZ)) < lbZ || k > ubZ) continue;
                double[] splzi = splz[ith3];
                double v0 = splzi[0];
                double v1 = splzi[1];
                double v2 = splzi[2];
                double c0 = c * v0;
                double dx0 = dx * v0;
                double dy0 = dy * v0;
                double dz1 = dz * v1;
                double qxx0 = qxx * v0;
                double qyy0 = qyy * v0;
                double qzz2 = qzz * v2;
                double qxy0 = qxy * v0;
                double qxz1 = qxz * v1;
                double qyz1 = qyz * v1;
                double c0dz1qzz2 = c0 + dz1 + qzz2;
                double dy0qyz1 = dy0 + qyz1;
                double dx0qxz1 = dx0 + qxz1;
                int j0 = jgrd0;
                for (int ith2 = 0; ith2 < this.this$0.bSplineOrder; ++ith2) {
                    int j;
                    int rowIndex;
                    if (lb > (rowIndex = this.rowRegion.rowIndexForYZ(j = ScalarMath.mod((int)(++j0), (int)this.this$0.fftY), k)) || rowIndex > ub) continue;
                    double[] splyi = sply[ith2];
                    double u0 = splyi[0];
                    double u1 = splyi[1];
                    double u2 = splyi[2];
                    double term0 = Math.fma(c0dz1qzz2, u0, Math.fma(dy0qyz1, u1, qyy0 * u2));
                    double term1 = Math.fma(dx0qxz1, u0, qxy0 * u1);
                    double term2 = qxx0 * u0;
                    int i0 = igrd0;
                    for (int ith1 = 0; ith1 < this.this$0.bSplineOrder; ++ith1) {
                        int i = ScalarMath.mod((int)(++i0), (int)this.this$0.fftX);
                        int ii = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        double[] splxi = splx[ith1];
                        double current = this.this$0.splineBuffer.get(ii);
                        double updated = Math.fma(splxi[0], term0, current);
                        updated = Math.fma(splxi[1], term1, updated);
                        updated = Math.fma(splxi[2], term2, updated);
                        this.this$0.splineBuffer.put(ii, updated);
                    }
                }
            }
        }

        private void gridFixedChargeDensity(int iSymm, int iAtom, int lb, int ub) {
            boolean atomContributes = false;
            int k0 = this.bSplines.initGrid[iSymm][iAtom][2];
            int lbZ = this.this$0.RowIndexZ(lb);
            int ubZ = this.this$0.RowIndexZ(ub);
            for (int ith3 = 0; ith3 < this.this$0.bSplineOrder; ++ith3) {
                int k;
                if (lbZ > (k = ScalarMath.mod((int)(++k0), (int)this.this$0.fftZ)) || k > ubZ) continue;
                atomContributes = true;
                break;
            }
            if (!atomContributes) {
                return;
            }
            int n = this.threadIndex;
            this.this$0.splineCount[n] = this.this$0.splineCount[n] + 1;
            int index = this.this$0.gridAtomCount[iSymm][this.threadIndex];
            this.this$0.gridAtomList[iSymm][this.threadIndex][index] = iAtom;
            int[] nArray = this.this$0.gridAtomCount[iSymm];
            int n2 = this.threadIndex;
            nArray[n2] = nArray[n2] + 1;
            double[] fm = this.fracMultipoles[iSymm][iAtom];
            double[][] splx = this.bSplines.splineX[iSymm][iAtom];
            double[][] sply = this.bSplines.splineY[iSymm][iAtom];
            double[][] splz = this.bSplines.splineZ[iSymm][iAtom];
            int igrd0 = this.bSplines.initGrid[iSymm][iAtom][0];
            int jgrd0 = this.bSplines.initGrid[iSymm][iAtom][1];
            k0 = this.bSplines.initGrid[iSymm][iAtom][2];
            double c = fm[0];
            for (int ith3 = 0; ith3 < this.this$0.bSplineOrder; ++ith3) {
                int k;
                if ((k = ScalarMath.mod((int)(++k0), (int)this.this$0.fftZ)) < lbZ || k > ubZ) continue;
                double[] splzi = splz[ith3];
                double v0 = splzi[0];
                double c0 = c * v0;
                int j0 = jgrd0;
                for (int ith2 = 0; ith2 < this.this$0.bSplineOrder; ++ith2) {
                    int j;
                    int rowIndex;
                    if (lb > (rowIndex = this.rowRegion.rowIndexForYZ(j = ScalarMath.mod((int)(++j0), (int)this.this$0.fftY), k)) || rowIndex > ub) continue;
                    double[] splyi = sply[ith2];
                    double u0 = splyi[0];
                    double term0 = c0 * u0;
                    int i0 = igrd0;
                    for (int ith1 = 0; ith1 < this.this$0.bSplineOrder; ++ith1) {
                        int i = ScalarMath.mod((int)(++i0), (int)this.this$0.fftX);
                        int ii = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        double[] splxi = splx[ith1];
                        double current = this.this$0.splineBuffer.get(ii);
                        double updated = Math.fma(splxi[0], term0, current);
                        this.this$0.splineBuffer.put(ii, updated);
                    }
                }
            }
        }

        public void start() {
            int n = this.threadIndex = this.getThreadIndex();
            this.this$0.splinePermanentTime[n] = this.this$0.splinePermanentTime[n] - System.nanoTime();
            for (int i = 0; i < this.this$0.nSymm; ++i) {
                this.this$0.gridAtomCount[i][this.threadIndex] = 0;
            }
        }

        void setPermanent(double[][][] fracMultipoles) {
            this.fracMultipoles = fracMultipoles;
        }

        private void setUse(boolean[] use) {
            this.use = use;
        }
    }

    private class RowInducedLoop
    extends RowLoop {
        private final BSplineRegion bSplineRegion;
        private double[][][] inducedDipoleFrac;
        private double[][][] inducedDipoleFracCR;
        private boolean[] use;
        final /* synthetic */ ReciprocalSpace this$0;

        RowInducedLoop(ReciprocalSpace reciprocalSpace, RowRegion region, BSplineRegion splines) {
            ReciprocalSpace reciprocalSpace2 = reciprocalSpace;
            Objects.requireNonNull(reciprocalSpace2);
            this.this$0 = reciprocalSpace2;
            super(region.nAtoms, region.nSymm, region);
            this.inducedDipoleFrac = null;
            this.inducedDipoleFracCR = null;
            this.use = null;
            this.bSplineRegion = splines;
        }

        public void finish() {
            int threadIndex;
            int n = threadIndex = this.getThreadIndex();
            this.this$0.splineInducedTime[n] = this.this$0.splineInducedTime[n] + System.nanoTime();
        }

        @Override
        public void gridDensity(int iSymm, int iAtom, int lb, int ub) {
            if (this.use != null && !this.use[iAtom]) {
                return;
            }
            int lbZ = this.this$0.RowIndexZ(lb);
            int ubZ = this.this$0.RowIndexZ(ub);
            double[] ind = this.inducedDipoleFrac[iSymm][iAtom];
            double ux = ind[0];
            double uy = ind[1];
            double uz = ind[2];
            double[] indCR = this.inducedDipoleFracCR[iSymm][iAtom];
            double px = indCR[0];
            double py = indCR[1];
            double pz = indCR[2];
            double[][] splx = this.bSplineRegion.splineX[iSymm][iAtom];
            double[][] sply = this.bSplineRegion.splineY[iSymm][iAtom];
            double[][] splz = this.bSplineRegion.splineZ[iSymm][iAtom];
            int igrd0 = this.bSplineRegion.initGrid[iSymm][iAtom][0];
            int jgrd0 = this.bSplineRegion.initGrid[iSymm][iAtom][1];
            int k0 = this.bSplineRegion.initGrid[iSymm][iAtom][2];
            for (int ith3 = 0; ith3 < this.this$0.bSplineOrder; ++ith3) {
                int k;
                if ((k = ScalarMath.mod((int)(++k0), (int)this.this$0.fftZ)) < lbZ || k > ubZ) continue;
                double[] splzi = splz[ith3];
                double v0 = splzi[0];
                double v1 = splzi[1];
                double dx0 = ux * v0;
                double dy0 = uy * v0;
                double dz1 = uz * v1;
                double px0 = px * v0;
                double py0 = py * v0;
                double pz1 = pz * v1;
                int j0 = jgrd0;
                for (int ith2 = 0; ith2 < this.this$0.bSplineOrder; ++ith2) {
                    int j;
                    int rowIndex;
                    if (lb > (rowIndex = this.rowRegion.rowIndexForYZ(j = ScalarMath.mod((int)(++j0), (int)this.this$0.fftY), k)) || rowIndex > ub) continue;
                    double[] splyi = sply[ith2];
                    double u0 = splyi[0];
                    double u1 = splyi[1];
                    double term0 = Math.fma(dz1, u0, dy0 * u1);
                    double term1 = dx0 * u0;
                    double termp0 = Math.fma(pz1, u0, py0 * u1);
                    double termp1 = px0 * u0;
                    int i0 = igrd0;
                    for (int ith1 = 0; ith1 < this.this$0.bSplineOrder; ++ith1) {
                        int i = ScalarMath.mod((int)(++i0), (int)this.this$0.fftX);
                        int ii = Complex3D.interleavedIndex((int)i, (int)j, (int)k, (int)this.this$0.fftX, (int)this.this$0.fftY);
                        double[] splxi = splx[ith1];
                        double current = this.this$0.splineBuffer.get(ii);
                        double currenti = this.this$0.splineBuffer.get(ii + 1);
                        double updated = Math.fma(splxi[0], term0, Math.fma(splxi[1], term1, current));
                        double udpatedi = Math.fma(splxi[0], termp0, Math.fma(splxi[1], termp1, currenti));
                        this.this$0.splineBuffer.put(ii, updated);
                        this.this$0.splineBuffer.put(ii + 1, udpatedi);
                    }
                }
            }
        }

        @Override
        public void run(int lb, int ub) {
            int ti = this.getThreadIndex();
            for (int iSymm = 0; iSymm < this.this$0.nSymm; ++iSymm) {
                int[] list = this.this$0.gridAtomList[iSymm][ti];
                int n = this.this$0.gridAtomCount[iSymm][ti];
                for (int i = 0; i < n; ++i) {
                    int iAtom = list[i];
                    this.gridDensity(iSymm, iAtom, lb, ub);
                }
            }
        }

        public void setUse(boolean[] use) {
            this.use = use;
        }

        public void start() {
            int threadIndex;
            int n = threadIndex = this.getThreadIndex();
            this.this$0.splineInducedTime[n] = this.this$0.splineInducedTime[n] - System.nanoTime();
        }

        void setInducedDipoles(double[][][] inducedDipoleFrac, double[][][] inducedDipoleFracCR) {
            this.inducedDipoleFrac = inducedDipoleFrac;
            this.inducedDipoleFracCR = inducedDipoleFracCR;
        }
    }

    private class PermanentPhiRegion
    extends ParallelRegion {
        final PermanentPhiLoop[] permanentPhiLoop;
        private final BSplineRegion bSplineRegion;
        private double[][] cartPermPhi;
        private double[][] fracPermPhi;
        final /* synthetic */ ReciprocalSpace this$0;

        PermanentPhiRegion(ReciprocalSpace reciprocalSpace, BSplineRegion bSplineRegion) {
            ReciprocalSpace reciprocalSpace2 = reciprocalSpace;
            Objects.requireNonNull(reciprocalSpace2);
            this.this$0 = reciprocalSpace2;
            this.bSplineRegion = bSplineRegion;
            this.permanentPhiLoop = new PermanentPhiLoop[reciprocalSpace.threadCount];
            for (int i = 0; i < reciprocalSpace.threadCount; ++i) {
                this.permanentPhiLoop[i] = new PermanentPhiLoop(this);
            }
        }

        public void run() {
            try {
                int threadID = this.getThreadIndex();
                this.execute(0, this.this$0.nAtoms - 1, this.permanentPhiLoop[threadID]);
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
        }

        void setPermanentPhi(double[][] cartPermanentPhi, double[][] fracPermanentPhi) {
            this.cartPermPhi = cartPermanentPhi;
            this.fracPermPhi = fracPermanentPhi;
        }

        public class PermanentPhiLoop
        extends IntegerForLoop {
            final /* synthetic */ PermanentPhiRegion this$1;

            public PermanentPhiLoop(PermanentPhiRegion this$1) {
                PermanentPhiRegion permanentPhiRegion = this$1;
                Objects.requireNonNull(permanentPhiRegion);
                this.this$1 = permanentPhiRegion;
            }

            public void finish() {
                int threadIndex;
                int n = threadIndex = this.getThreadIndex();
                this.this$1.this$0.permanentPhiTime[n] = this.this$1.this$0.permanentPhiTime[n] + System.nanoTime();
            }

            public void run(int lb, int ub) {
                for (int n = lb; n <= ub; ++n) {
                    int j;
                    double[][] splx = this.this$1.bSplineRegion.splineX[0][n];
                    double[][] sply = this.this$1.bSplineRegion.splineY[0][n];
                    double[][] splz = this.this$1.bSplineRegion.splineZ[0][n];
                    int[] igrd = this.this$1.bSplineRegion.initGrid[0][n];
                    int igrd0 = igrd[0];
                    int jgrd0 = igrd[1];
                    int k0 = igrd[2];
                    double tuv000 = 0.0;
                    double tuv100 = 0.0;
                    double tuv010 = 0.0;
                    double tuv001 = 0.0;
                    double tuv200 = 0.0;
                    double tuv020 = 0.0;
                    double tuv002 = 0.0;
                    double tuv110 = 0.0;
                    double tuv101 = 0.0;
                    double tuv011 = 0.0;
                    double tuv300 = 0.0;
                    double tuv030 = 0.0;
                    double tuv003 = 0.0;
                    double tuv210 = 0.0;
                    double tuv201 = 0.0;
                    double tuv120 = 0.0;
                    double tuv021 = 0.0;
                    double tuv102 = 0.0;
                    double tuv012 = 0.0;
                    double tuv111 = 0.0;
                    for (int ith3 = 0; ith3 < this.this$1.this$0.bSplineOrder; ++ith3) {
                        int k = ScalarMath.mod((int)(++k0), (int)this.this$1.this$0.fftZ);
                        int j0 = jgrd0;
                        double tu00 = 0.0;
                        double tu10 = 0.0;
                        double tu01 = 0.0;
                        double tu20 = 0.0;
                        double tu11 = 0.0;
                        double tu02 = 0.0;
                        double tu30 = 0.0;
                        double tu21 = 0.0;
                        double tu12 = 0.0;
                        double tu03 = 0.0;
                        for (int ith2 = 0; ith2 < this.this$1.this$0.bSplineOrder; ++ith2) {
                            int j2 = ScalarMath.mod((int)(++j0), (int)this.this$1.this$0.fftY);
                            int i0 = igrd0;
                            double t0 = 0.0;
                            double t1 = 0.0;
                            double t2 = 0.0;
                            double t3 = 0.0;
                            for (int ith1 = 0; ith1 < this.this$1.this$0.bSplineOrder; ++ith1) {
                                int i = ScalarMath.mod((int)(++i0), (int)this.this$1.this$0.fftX);
                                int ii = Complex3D.interleavedIndex((int)i, (int)j2, (int)k, (int)this.this$1.this$0.fftX, (int)this.this$1.this$0.fftY);
                                double tq = this.this$1.this$0.splineBuffer.get(ii);
                                double[] splxi = splx[ith1];
                                t0 = Math.fma(tq, splxi[0], t0);
                                t1 = Math.fma(tq, splxi[1], t1);
                                t2 = Math.fma(tq, splxi[2], t2);
                                t3 = Math.fma(tq, splxi[3], t3);
                            }
                            double[] splyi = sply[ith2];
                            double u0 = splyi[0];
                            double u1 = splyi[1];
                            double u2 = splyi[2];
                            double u3 = splyi[3];
                            tu00 = Math.fma(t0, u0, tu00);
                            tu10 = Math.fma(t1, u0, tu10);
                            tu01 = Math.fma(t0, u1, tu01);
                            tu20 = Math.fma(t2, u0, tu20);
                            tu11 = Math.fma(t1, u1, tu11);
                            tu02 = Math.fma(t0, u2, tu02);
                            tu30 = Math.fma(t3, u0, tu30);
                            tu21 = Math.fma(t2, u1, tu21);
                            tu12 = Math.fma(t1, u2, tu12);
                            tu03 = Math.fma(t0, u3, tu03);
                        }
                        double[] splzi = splz[ith3];
                        double v0 = splzi[0];
                        double v1 = splzi[1];
                        double v2 = splzi[2];
                        double v3 = splzi[3];
                        tuv000 = Math.fma(tu00, v0, tuv000);
                        tuv100 = Math.fma(tu10, v0, tuv100);
                        tuv010 = Math.fma(tu01, v0, tuv010);
                        tuv001 = Math.fma(tu00, v1, tuv001);
                        tuv200 = Math.fma(tu20, v0, tuv200);
                        tuv020 = Math.fma(tu02, v0, tuv020);
                        tuv002 = Math.fma(tu00, v2, tuv002);
                        tuv110 = Math.fma(tu11, v0, tuv110);
                        tuv101 = Math.fma(tu10, v1, tuv101);
                        tuv011 = Math.fma(tu01, v1, tuv011);
                        tuv300 = Math.fma(tu30, v0, tuv300);
                        tuv030 = Math.fma(tu03, v0, tuv030);
                        tuv003 = Math.fma(tu00, v3, tuv003);
                        tuv210 = Math.fma(tu21, v0, tuv210);
                        tuv201 = Math.fma(tu20, v1, tuv201);
                        tuv120 = Math.fma(tu12, v0, tuv120);
                        tuv021 = Math.fma(tu02, v1, tuv021);
                        tuv102 = Math.fma(tu10, v2, tuv102);
                        tuv012 = Math.fma(tu01, v2, tuv012);
                        tuv111 = Math.fma(tu11, v1, tuv111);
                    }
                    double[] out = this.this$1.fracPermPhi[n];
                    out[0] = tuv000;
                    out[1] = tuv100;
                    out[2] = tuv010;
                    out[3] = tuv001;
                    out[4] = tuv200;
                    out[5] = tuv020;
                    out[6] = tuv002;
                    out[7] = tuv110;
                    out[8] = tuv101;
                    out[9] = tuv011;
                    out[10] = tuv300;
                    out[11] = tuv030;
                    out[12] = tuv003;
                    out[13] = tuv210;
                    out[14] = tuv201;
                    out[15] = tuv120;
                    out[16] = tuv021;
                    out[17] = tuv102;
                    out[18] = tuv012;
                    out[19] = tuv111;
                    double[] in = out;
                    out = this.this$1.cartPermPhi[n];
                    out[0] = this.this$1.this$0.transformFieldMatrix[0][0] * in[0];
                    for (j = 1; j < 4; ++j) {
                        out[j] = 0.0;
                        for (int k = 1; k < 4; ++k) {
                            out[j] = Math.fma(this.this$1.this$0.transformFieldMatrix[j][k], in[k], out[j]);
                        }
                    }
                    for (j = 4; j < 10; ++j) {
                        out[j] = 0.0;
                        for (int k = 4; k < 10; ++k) {
                            out[j] = Math.fma(this.this$1.this$0.transformFieldMatrix[j][k], in[k], out[j]);
                        }
                    }
                }
            }

            public IntegerSchedule schedule() {
                return IntegerSchedule.fixed();
            }

            public void start() {
                int threadIndex;
                int n = threadIndex = this.getThreadIndex();
                this.this$1.this$0.permanentPhiTime[n] = this.this$1.this$0.permanentPhiTime[n] - System.nanoTime();
            }
        }
    }

    private class InducedPhiRegion
    extends ParallelRegion {
        final InducedPhiLoop[] inducedPhiLoops;
        private final BSplineRegion bSplineRegion;
        private double[][] cartInducedDipolePhi;
        private double[][] cartInducedDipolePhiCR;
        private double[][] fracInducedDipolePhi;
        private double[][] fracInducedDipolePhiCR;
        final /* synthetic */ ReciprocalSpace this$0;

        InducedPhiRegion(ReciprocalSpace reciprocalSpace, BSplineRegion bSplineRegion) {
            ReciprocalSpace reciprocalSpace2 = reciprocalSpace;
            Objects.requireNonNull(reciprocalSpace2);
            this.this$0 = reciprocalSpace2;
            this.bSplineRegion = bSplineRegion;
            this.inducedPhiLoops = new InducedPhiLoop[reciprocalSpace.threadCount];
            for (int i = 0; i < reciprocalSpace.threadCount; ++i) {
                this.inducedPhiLoops[i] = new InducedPhiLoop(this);
            }
        }

        public void run() {
            try {
                int threadID = this.getThreadIndex();
                this.execute(0, this.this$0.nAtoms - 1, this.inducedPhiLoops[threadID]);
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
        }

        void setInducedDipolePhi(double[][] cartInducedDipolePhi, double[][] cartInducedDipolePhiCR, double[][] fracInducedDipolePhi, double[][] fracInducedDipolePhiCR) {
            this.cartInducedDipolePhi = cartInducedDipolePhi;
            this.cartInducedDipolePhiCR = cartInducedDipolePhiCR;
            this.fracInducedDipolePhi = fracInducedDipolePhi;
            this.fracInducedDipolePhiCR = fracInducedDipolePhiCR;
        }

        public class InducedPhiLoop
        extends IntegerForLoop {
            final /* synthetic */ InducedPhiRegion this$1;

            public InducedPhiLoop(InducedPhiRegion this$1) {
                InducedPhiRegion inducedPhiRegion = this$1;
                Objects.requireNonNull(inducedPhiRegion);
                this.this$1 = inducedPhiRegion;
            }

            public void finish() {
                int threadIndex;
                int n = threadIndex = this.getThreadIndex();
                this.this$1.this$0.inducedPhiTime[n] = this.this$1.this$0.inducedPhiTime[n] + System.nanoTime();
            }

            public void run(int lb, int ub) {
                for (int n = lb; n <= ub; ++n) {
                    int j;
                    double[][] splx = this.this$1.bSplineRegion.splineX[0][n];
                    double[][] sply = this.this$1.bSplineRegion.splineY[0][n];
                    double[][] splz = this.this$1.bSplineRegion.splineZ[0][n];
                    int[] igrd = this.this$1.bSplineRegion.initGrid[0][n];
                    int igrd0 = igrd[0];
                    int jgrd0 = igrd[1];
                    int k0 = igrd[2];
                    double tuv000 = 0.0;
                    double tuv100 = 0.0;
                    double tuv010 = 0.0;
                    double tuv001 = 0.0;
                    double tuv200 = 0.0;
                    double tuv020 = 0.0;
                    double tuv002 = 0.0;
                    double tuv110 = 0.0;
                    double tuv101 = 0.0;
                    double tuv011 = 0.0;
                    double tuv300 = 0.0;
                    double tuv030 = 0.0;
                    double tuv003 = 0.0;
                    double tuv210 = 0.0;
                    double tuv201 = 0.0;
                    double tuv120 = 0.0;
                    double tuv021 = 0.0;
                    double tuv102 = 0.0;
                    double tuv012 = 0.0;
                    double tuv111 = 0.0;
                    double tuv000p = 0.0;
                    double tuv100p = 0.0;
                    double tuv010p = 0.0;
                    double tuv001p = 0.0;
                    double tuv200p = 0.0;
                    double tuv020p = 0.0;
                    double tuv002p = 0.0;
                    double tuv110p = 0.0;
                    double tuv101p = 0.0;
                    double tuv011p = 0.0;
                    double tuv300p = 0.0;
                    double tuv030p = 0.0;
                    double tuv003p = 0.0;
                    double tuv210p = 0.0;
                    double tuv201p = 0.0;
                    double tuv120p = 0.0;
                    double tuv021p = 0.0;
                    double tuv102p = 0.0;
                    double tuv012p = 0.0;
                    double tuv111p = 0.0;
                    for (int ith3 = 0; ith3 < this.this$1.this$0.bSplineOrder; ++ith3) {
                        int k = ScalarMath.mod((int)(++k0), (int)this.this$1.this$0.fftZ);
                        int j0 = jgrd0;
                        double tu00 = 0.0;
                        double tu10 = 0.0;
                        double tu01 = 0.0;
                        double tu20 = 0.0;
                        double tu11 = 0.0;
                        double tu02 = 0.0;
                        double tu30 = 0.0;
                        double tu21 = 0.0;
                        double tu12 = 0.0;
                        double tu03 = 0.0;
                        double tu00p = 0.0;
                        double tu10p = 0.0;
                        double tu01p = 0.0;
                        double tu20p = 0.0;
                        double tu11p = 0.0;
                        double tu02p = 0.0;
                        double tu30p = 0.0;
                        double tu21p = 0.0;
                        double tu12p = 0.0;
                        double tu03p = 0.0;
                        for (int ith2 = 0; ith2 < this.this$1.this$0.bSplineOrder; ++ith2) {
                            int j2 = ScalarMath.mod((int)(++j0), (int)this.this$1.this$0.fftY);
                            int i0 = igrd0;
                            double t0 = 0.0;
                            double t1 = 0.0;
                            double t2 = 0.0;
                            double t3 = 0.0;
                            double t0p = 0.0;
                            double t1p = 0.0;
                            double t2p = 0.0;
                            double t3p = 0.0;
                            for (int ith1 = 0; ith1 < this.this$1.this$0.bSplineOrder; ++ith1) {
                                int i = ScalarMath.mod((int)(++i0), (int)this.this$1.this$0.fftX);
                                int ii = Complex3D.interleavedIndex((int)i, (int)j2, (int)k, (int)this.this$1.this$0.fftX, (int)this.this$1.this$0.fftY);
                                double tq = this.this$1.this$0.splineBuffer.get(ii);
                                double tp = this.this$1.this$0.splineBuffer.get(ii + 1);
                                double[] splxi = splx[ith1];
                                double s0 = splxi[0];
                                double s1 = splxi[1];
                                double s2 = splxi[2];
                                double s3 = splxi[3];
                                t0 = Math.fma(tq, s0, t0);
                                t1 = Math.fma(tq, s1, t1);
                                t2 = Math.fma(tq, s2, t2);
                                t3 = Math.fma(tq, s3, t3);
                                t0p = Math.fma(tp, s0, t0p);
                                t1p = Math.fma(tp, s1, t1p);
                                t2p = Math.fma(tp, s2, t2p);
                                t3p = Math.fma(tp, s3, t3p);
                            }
                            double[] splyi = sply[ith2];
                            double u0 = splyi[0];
                            double u1 = splyi[1];
                            double u2 = splyi[2];
                            double u3 = splyi[3];
                            tu00 = Math.fma(t0, u0, tu00);
                            tu10 = Math.fma(t1, u0, tu10);
                            tu01 = Math.fma(t0, u1, tu01);
                            tu20 = Math.fma(t2, u0, tu20);
                            tu11 = Math.fma(t1, u1, tu11);
                            tu02 = Math.fma(t0, u2, tu02);
                            tu30 = Math.fma(t3, u0, tu30);
                            tu21 = Math.fma(t2, u1, tu21);
                            tu12 = Math.fma(t1, u2, tu12);
                            tu03 = Math.fma(t0, u3, tu03);
                            tu00p = Math.fma(t0p, u0, tu00p);
                            tu10p = Math.fma(t1p, u0, tu10p);
                            tu01p = Math.fma(t0p, u1, tu01p);
                            tu20p = Math.fma(t2p, u0, tu20p);
                            tu11p = Math.fma(t1p, u1, tu11p);
                            tu02p = Math.fma(t0p, u2, tu02p);
                            tu30p = Math.fma(t3p, u0, tu30p);
                            tu21p = Math.fma(t2p, u1, tu21p);
                            tu12p = Math.fma(t1p, u2, tu12p);
                            tu03p = Math.fma(t0p, u3, tu03p);
                        }
                        double[] splzi = splz[ith3];
                        double v0 = splzi[0];
                        double v1 = splzi[1];
                        double v2 = splzi[2];
                        double v3 = splzi[3];
                        tuv000 = Math.fma(tu00, v0, tuv000);
                        tuv100 = Math.fma(tu10, v0, tuv100);
                        tuv010 = Math.fma(tu01, v0, tuv010);
                        tuv001 = Math.fma(tu00, v1, tuv001);
                        tuv200 = Math.fma(tu20, v0, tuv200);
                        tuv020 = Math.fma(tu02, v0, tuv020);
                        tuv002 = Math.fma(tu00, v2, tuv002);
                        tuv110 = Math.fma(tu11, v0, tuv110);
                        tuv101 = Math.fma(tu10, v1, tuv101);
                        tuv011 = Math.fma(tu01, v1, tuv011);
                        tuv300 = Math.fma(tu30, v0, tuv300);
                        tuv030 = Math.fma(tu03, v0, tuv030);
                        tuv003 = Math.fma(tu00, v3, tuv003);
                        tuv210 = Math.fma(tu21, v0, tuv210);
                        tuv201 = Math.fma(tu20, v1, tuv201);
                        tuv120 = Math.fma(tu12, v0, tuv120);
                        tuv021 = Math.fma(tu02, v1, tuv021);
                        tuv102 = Math.fma(tu10, v2, tuv102);
                        tuv012 = Math.fma(tu01, v2, tuv012);
                        tuv111 = Math.fma(tu11, v1, tuv111);
                        tuv000p = Math.fma(tu00p, v0, tuv000p);
                        tuv100p = Math.fma(tu10p, v0, tuv100p);
                        tuv010p = Math.fma(tu01p, v0, tuv010p);
                        tuv001p = Math.fma(tu00p, v1, tuv001p);
                        tuv200p = Math.fma(tu20p, v0, tuv200p);
                        tuv020p = Math.fma(tu02p, v0, tuv020p);
                        tuv002p = Math.fma(tu00p, v2, tuv002p);
                        tuv110p = Math.fma(tu11p, v0, tuv110p);
                        tuv101p = Math.fma(tu10p, v1, tuv101p);
                        tuv011p = Math.fma(tu01p, v1, tuv011p);
                        tuv300p = Math.fma(tu30p, v0, tuv300p);
                        tuv030p = Math.fma(tu03p, v0, tuv030p);
                        tuv003p = Math.fma(tu00p, v3, tuv003p);
                        tuv210p = Math.fma(tu21p, v0, tuv210p);
                        tuv201p = Math.fma(tu20p, v1, tuv201p);
                        tuv120p = Math.fma(tu12p, v0, tuv120p);
                        tuv021p = Math.fma(tu02p, v1, tuv021p);
                        tuv102p = Math.fma(tu10p, v2, tuv102p);
                        tuv012p = Math.fma(tu01p, v2, tuv012p);
                        tuv111p = Math.fma(tu11p, v1, tuv111p);
                    }
                    double[] out = this.this$1.fracInducedDipolePhi[n];
                    out[0] = tuv000;
                    out[1] = tuv100;
                    out[2] = tuv010;
                    out[3] = tuv001;
                    out[4] = tuv200;
                    out[5] = tuv020;
                    out[6] = tuv002;
                    out[7] = tuv110;
                    out[8] = tuv101;
                    out[9] = tuv011;
                    out[10] = tuv300;
                    out[11] = tuv030;
                    out[12] = tuv003;
                    out[13] = tuv210;
                    out[14] = tuv201;
                    out[15] = tuv120;
                    out[16] = tuv021;
                    out[17] = tuv102;
                    out[18] = tuv012;
                    out[19] = tuv111;
                    double[] in = out;
                    out = this.this$1.cartInducedDipolePhi[n];
                    out[0] = this.this$1.this$0.transformFieldMatrix[0][0] * in[0];
                    for (j = 1; j < 4; ++j) {
                        out[j] = 0.0;
                        for (int k = 1; k < 4; ++k) {
                            out[j] = Math.fma(this.this$1.this$0.transformFieldMatrix[j][k], in[k], out[j]);
                        }
                    }
                    for (j = 4; j < 10; ++j) {
                        out[j] = 0.0;
                        for (int k = 4; k < 10; ++k) {
                            out[j] = Math.fma(this.this$1.this$0.transformFieldMatrix[j][k], in[k], out[j]);
                        }
                    }
                    out = this.this$1.fracInducedDipolePhiCR[n];
                    out[0] = tuv000p;
                    out[1] = tuv100p;
                    out[2] = tuv010p;
                    out[3] = tuv001p;
                    out[4] = tuv200p;
                    out[5] = tuv020p;
                    out[6] = tuv002p;
                    out[7] = tuv110p;
                    out[8] = tuv101p;
                    out[9] = tuv011p;
                    out[10] = tuv300p;
                    out[11] = tuv030p;
                    out[12] = tuv003p;
                    out[13] = tuv210p;
                    out[14] = tuv201p;
                    out[15] = tuv120p;
                    out[16] = tuv021p;
                    out[17] = tuv102p;
                    out[18] = tuv012p;
                    out[19] = tuv111p;
                    in = out;
                    out = this.this$1.cartInducedDipolePhiCR[n];
                    out[0] = this.this$1.this$0.transformFieldMatrix[0][0] * in[0];
                    for (j = 1; j < 4; ++j) {
                        out[j] = 0.0;
                        for (int k = 1; k < 4; ++k) {
                            out[j] = Math.fma(this.this$1.this$0.transformFieldMatrix[j][k], in[k], out[j]);
                        }
                    }
                    for (j = 4; j < 10; ++j) {
                        out[j] = 0.0;
                        for (int k = 4; k < 10; ++k) {
                            out[j] = Math.fma(this.this$1.this$0.transformFieldMatrix[j][k], in[k], out[j]);
                        }
                    }
                }
            }

            public IntegerSchedule schedule() {
                return IntegerSchedule.fixed();
            }

            public void start() {
                int threadIndex;
                int n = threadIndex = this.getThreadIndex();
                this.this$1.this$0.inducedPhiTime[n] = this.this$1.this$0.inducedPhiTime[n] - System.nanoTime();
            }
        }
    }
}

