/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.nonbonded;

import edu.rit.pj.IntegerSchedule;
import edu.rit.util.Range;
import java.util.logging.Logger;

public class PairwiseSchedule
extends IntegerSchedule {
    private static final Logger logger = Logger.getLogger(PairwiseSchedule.class.getName());
    private final int nThreads;
    private final Range[] ranges;
    private final boolean[] threadDone;
    private int nAtoms;
    private int threadOffset;

    public PairwiseSchedule(int nThreads, int nAtoms, Range[] ranges) {
        this.nAtoms = nAtoms;
        this.nThreads = nThreads;
        this.threadOffset = 0;
        this.ranges = ranges;
        this.threadDone = new boolean[nThreads];
    }

    public boolean isFixedSchedule() {
        return true;
    }

    public Range next(int threadID) {
        if (!this.threadDone[threadID]) {
            this.threadDone[threadID] = true;
            return this.ranges[threadID];
        }
        return null;
    }

    public void setAtoms(int nAtoms) {
        this.nAtoms = nAtoms;
    }

    public void start(int nThreads, Range chunkRange) {
        assert (nThreads == this.nThreads);
        assert (chunkRange.lb() == 0);
        assert (chunkRange.ub() == this.nAtoms - 1);
        for (int i = 0; i < nThreads; ++i) {
            this.threadDone[i] = false;
        }
    }

    void updateRanges(int totalInteractions, int atomsWithInteractions, int[] listCount) {
        int id = 0;
        int goal = totalInteractions / (this.nThreads + this.threadOffset);
        int num = 0;
        int start = 0;
        for (int i = 0; i < this.nAtoms; ++i) {
            int j;
            if ((num += listCount[i]) >= goal) {
                if (id == this.nThreads - 1) {
                    this.ranges[id] = new Range(start, this.nAtoms - 1);
                    break;
                }
                this.ranges[id] = new Range(start, i);
                num = 0;
                ++id;
                start = i + 1;
                if (start != this.nAtoms) continue;
                if (atomsWithInteractions > this.nThreads + this.threadOffset + 1) {
                    ++this.threadOffset;
                    this.updateRanges(totalInteractions, atomsWithInteractions, listCount);
                    break;
                }
                for (j = id; j < this.nThreads; ++j) {
                    this.ranges[j] = null;
                }
                break;
            }
            if (i != this.nAtoms - 1) continue;
            if (id < this.nThreads - 1 && atomsWithInteractions > this.nThreads + this.threadOffset + 1) {
                ++this.threadOffset;
                this.updateRanges(totalInteractions, atomsWithInteractions, listCount);
                break;
            }
            this.ranges[id] = new Range(start, this.nAtoms - 1);
            for (j = id + 1; j < this.nThreads; ++j) {
                this.ranges[j] = null;
            }
        }
        this.threadOffset = 0;
    }
}

