/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.constraint;

import ffx.numerics.Constraint;

public class ShakeChargeConstraint
implements Constraint {
    final int nConstraints;
    final double tol;
    final int c;
    final double maxIters = 150.0;

    public ShakeChargeConstraint(int nConstraints, int c, double tol) {
        this.nConstraints = nConstraints;
        this.c = c;
        this.tol = tol;
    }

    public void applyConstraintToStep(double[] xPrior, double[] xNew, double[] masses, double tol) {
    }

    public void applyChargeConstraintToStep(double[] x, double[] masses) {
        boolean done = false;
        int iter = 0;
        while (!done) {
            done = true;
            ++iter;
            double totalLambda = 0.0;
            double totalInverseMass = 0.0;
            for (int i = 0; i < this.nConstraints; ++i) {
                double lambda = Math.sin(x[i]) * Math.sin(x[i]);
                totalLambda += lambda;
                totalInverseMass += 1.0 / masses[i];
            }
            double delta = totalLambda - (double)this.c;
            if (Math.abs(delta) > this.tol) {
                done = false;
                double term = delta / totalInverseMass;
                for (int i = 0; i < this.nConstraints; ++i) {
                    double g = -term * Math.sin(2.0 * x[i]);
                    x[i] = x[i] - g * -418.4 / masses[i] * 0.01;
                }
            }
            if (!((double)iter >= 150.0)) continue;
            throw new RuntimeException("SHAKE Charge Constraint -- Warning, Charge Constraint not Satisfied");
        }
    }

    public void applyConstraintToVelocities(double[] x, double[] v, double[] masses, double tol) {
    }

    public int[] constrainedAtomIndices() {
        return new int[0];
    }

    public boolean constraintSatisfied(double[] x, double tol) {
        return false;
    }

    public boolean constraintSatisfied(double[] x, double[] v, double xTol, double vTol) {
        return false;
    }

    public int getNumDegreesFrozen() {
        return 0;
    }
}

