/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands.test;

import ffx.numerics.math.DoubleMath;
import ffx.potential.MolecularAssembly;
import ffx.potential.Utilities;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedUtils;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.Molecule;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.Residue;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.parameters.ForceField;
import ffx.potential.parsers.CIFFilter;
import ffx.potential.parsers.PDBFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.potential.utils.Superpose;
import ffx.utilities.FFXBinding;
import ffx.utilities.FFXCommand;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import javax.vecmath.Point3d;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.util.FastMath;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.graph.rebond.RebondTool;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.AtomMatcher;
import org.openscience.cdk.isomorphism.BondMatcher;
import org.openscience.cdk.isomorphism.VentoFoggia;
import org.openscience.cdk.tools.periodictable.PeriodicTable;
import picocli.CommandLine;

@CommandLine.Command(description={" Reorder the atoms of an XYZ file based on atomic weight."}, name="test.ReorderAtoms")
public class ReorderAtoms
extends PotentialCommand {
    @CommandLine.Option(names={"-a", "--atomType"}, paramLabel="false", defaultValue="false", description={"Change atom types of first file to match second."})
    private static boolean atomType = false;
    @CommandLine.Option(names={"--sw", "--swap"}, paramLabel="false", defaultValue="false", description={"Switch positions of equivalent atoms (untested for >2 atoms)."})
    private static boolean swap = false;
    @CommandLine.Option(names={"-m", "--match"}, paramLabel="false", defaultValue="false", description={"Match atom indices based on structure."})
    private static boolean match = false;
    @CommandLine.Option(names={"-r", "--reorder"}, paramLabel="false", defaultValue="false", description={"Reorder atoms based on environment."})
    private static boolean reorder = false;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"Atomic coordinate files to reorder in XYZ/ARC format. If 2, change file 1 to match file 2."})
    private List<String> filenames;
    private double bondTolerance = 0.2;

    public ReorderAtoms() {
    }

    public ReorderAtoms(FFXBinding binding) {
        super(binding);
    }

    public ReorderAtoms(String[] args) {
        super(args);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public ReorderAtoms run() {
        block134: {
            block136: {
                block135: {
                    block133: {
                        ReorderAtoms.logger.warning(" The ReorderAtoms command is under development.\n  Please verify the output.");
                        System.setProperty("vdwterm", "false");
                        if (!this.init()) {
                            return null;
                        }
                        if (!ReorderAtoms.reorder && !ReorderAtoms.swap) break block133;
                        if (ReorderAtoms.match || ReorderAtoms.atomType) {
                            ReorderAtoms.logger.warning(" Currently each flag (i.e., atomType, match, or reorder must be run individually. ");
                        }
                        for (String filename : this.filenames) {
                            this.potentialFunctions.openAll(filename);
                            systemFilter = this.potentialFunctions.getFilter();
                            numModels = systemFilter.countNumModels();
                            saveLocation = new File(filename);
                            saveFile = this.potentialFunctions.versionFile(saveLocation);
                            for (i = 0; i < numModels; ++i) {
                                assembly = systemFilter.getActiveMolecularSystem();
                                atoms = assembly.getAtomArray();
                                atomList0 = assembly.getAtomList();
                                nAtoms = atoms.length;
                                newAssembly = new MolecularAssembly(assembly.getName());
                                bondList = assembly.getBondList();
                                atomListSize = atomList0.size();
                                for (j = 0; j < atomListSize; ++j) {
                                    for (k = 0; k < atomListSize; ++k) {
                                        if (j == k || atomList0.get(j).getIndex() == atomList0.get(k).getIndex()) continue;
                                        ac = new AtomComparator(this);
                                        if (ReorderAtoms.logger.isLoggable(Level.FINER)) {
                                            ReorderAtoms.logger.finer(" Compare atom: " + String.valueOf(atomList0.get(j)) + " and " + String.valueOf(atomList0.get(k)));
                                        }
                                        if ((value = ac.compare(atomList0.get(j), atomList0.get(k))) == 0) {
                                            ReorderAtoms.logger.info(" This " + String.valueOf(atomList0.get(j)) + " and " + String.valueOf(atomList0.get(k)) + " are \"equivalent\".");
                                            if (!ReorderAtoms.swap) continue;
                                            temp = atomList0.get(j);
                                            atomList0.set(j, atomList0.get(k));
                                            atomList0.set(k, temp);
                                            continue;
                                        }
                                        if (value >= 0 || !ReorderAtoms.reorder) continue;
                                        if (ReorderAtoms.logger.isLoggable(Level.FINER)) {
                                            ReorderAtoms.logger.finer(" Swapped " + String.valueOf(atomList0.get(j)) + " and " + String.valueOf(atomList0.get(k)) + ".");
                                        }
                                        temp = atomList0.get(j);
                                        atomList0.set(j, atomList0.get(k));
                                        atomList0.set(k, temp);
                                    }
                                }
                                originalOrder = new int[nAtoms];
                                for (j = 0; j < nAtoms; ++j) {
                                    originalOrder[j] = atoms[j].getIndex();
                                    if (!ReorderAtoms.logger.isLoggable(Level.FINE)) continue;
                                    ReorderAtoms.logger.fine(String.format(" Original index for atom %3d: %3d New index: %3d", new Object[]{j, originalOrder[j], atomList0.get(j).getIndex()}));
                                }
                                atomList = new ArrayList<ffx.potential.bonded.Atom>();
                                atomIndex = 1;
                                for (j = 0; j < nAtoms; ++j) {
                                    a = atomList0.get(j);
                                    xyz = new double[]{a.getX(), a.getY(), a.getZ()};
                                    atom = new ffx.potential.bonded.Atom(atomIndex++, a.getName(), a.getAtomType(), xyz);
                                    atomList.add(atom);
                                }
                                for (Bond bond : bondList) {
                                    a1 = bond.getAtom(0);
                                    a2 = bond.getAtom(1);
                                    index1 = -1;
                                    index2 = -1;
                                    counter = 0;
                                    for (ffx.potential.bonded.Atom atom : atomList0) {
                                        index = atom.getIndex();
                                        if (index == a1.getIndex()) {
                                            index1 = counter;
                                        } else if (index == a2.getIndex()) {
                                            index2 = counter;
                                        }
                                        ++counter;
                                    }
                                    if (index1 == -1 || index2 == -1) {
                                        ReorderAtoms.logger.severe(String.format(" Index1 (%3d) and Index2 (%3d) suggests error for bond: %s", new Object[]{index1, index2, bond}));
                                    }
                                    newA1 = atomList.get(index1);
                                    newA2 = atomList.get(index2);
                                    b = new Bond(newA1, newA2);
                                    b.setBondType(bond.getBondType());
                                }
                                newAssembly.setForceField(assembly.getForceField());
                                newAssembly.setPotential(assembly.getPotentialEnergy());
                                newAssembly.setCrystal(assembly.getCrystal());
                                newAssembly.setFile(assembly.getFile());
                                Utilities.biochemistry(newAssembly, atomList);
                                filter = new XYZFilter(saveFile, newAssembly, assembly.getForceField(), assembly.getProperties());
                                if (numModels > 1) {
                                    filter.writeFile(saveFile, true);
                                } else {
                                    filter.writeFile(saveFile, false);
                                }
                                systemFilter.readNext(false, false);
                                if (numModels > 1) {
                                    ReorderAtoms.logger.info(String.format(" Saved structure %d to " + saveFile.getName(), new Object[]{i + 1}));
                                    continue;
                                }
                                ReorderAtoms.logger.info(String.format(" Saved to " + saveFile.getName(), new Object[0]));
                            }
                        }
                        break block134;
                    }
                    if (!ReorderAtoms.match || this.filenames == null || this.filenames.size() <= 1) break block135;
                    this.potentialFunctions.openAll(this.filenames.get(0));
                    systemFilter1 = this.potentialFunctions.getFilter();
                    this.potentialFunctions.openAll(this.filenames.get(1));
                    systemFilter2 = this.potentialFunctions.getFilter();
                    ReorderAtoms.logger.info(" Matching atom order between files.");
                    assembly1 = systemFilter1.getActiveMolecularSystem();
                    assembly2 = systemFilter2.getActiveMolecularSystem();
                    molecules1 = assembly1.getMolecules();
                    molecules2 = assembly2.getMolecules();
                    numMol2 = molecules2.size();
                    molDone = new boolean[numMol2];
                    totalNumAtoms = 0;
                    atomList = new ArrayList<ffx.potential.bonded.Atom>();
                    atomIndex = 1;
                    saveLocation = new File(this.filenames.get(0));
                    saveFile = this.potentialFunctions.versionFile(saveLocation);
                    newAssembly = new MolecularAssembly(assembly1.getName());
                    newAssembly.setForceField(assembly1.getForceField());
                    newAssembly.setPotential(assembly1.getPotentialEnergy());
                    newAssembly.setCrystal(assembly1.getCrystal());
                    newAssembly.setFile(assembly1.getFile());
                    for (MSNode mol1 : molecules1) {
                        atoms1List = mol1.getAtomList();
                        numAtoms = atoms1List.size();
                        ReorderAtoms.logger.info(String.format(" Molecule1 with %3d atoms: %s", new Object[]{numAtoms, mol1.toString()}));
                        equivalents = new ArrayList<ArrayList<E>>();
                        equivalent = new boolean[numAtoms];
                        numEquiv = 0;
                        for (i = 0; i < numAtoms; ++i) {
                            for (j = 1; j < numAtoms; ++j) {
                                if (i == j || (value = (ac = new AtomComparator(this)).compare(atoms1List.get(i), atoms1List.get(j))) != 0) continue;
                                equivalent[i] = true;
                                equivalent[j] = true;
                                iIndex = -1;
                                jIndex = -1;
                                for (k = 0; k < numEquiv; ++k) {
                                    list = (List)equivalents.get(k);
                                    if (list.contains(i)) {
                                        iIndex = k;
                                    }
                                    if (list.contains(j)) {
                                        jIndex = k;
                                    }
                                    if (iIndex >= 0 && jIndex >= 0) break;
                                }
                                if (iIndex == -1 && jIndex == -1) {
                                    ij = new ArrayList<Integer>();
                                    ij.add(i);
                                    ij.add(j);
                                    equivalents.add(ij);
                                    ++numEquiv;
                                    continue;
                                }
                                if (iIndex >= 0 && jIndex == -1) {
                                    ((List)equivalents.get(iIndex)).add(j);
                                    continue;
                                }
                                if (iIndex != -1 || jIndex < 0) continue;
                                ((List)equivalents.get(jIndex)).add(i);
                            }
                        }
                        numUnique = 0;
                        for (boolean value : equivalent) {
                            if (value) continue;
                            ++numUnique;
                        }
                        xyz1 = new double[numAtoms * 3];
                        mass = new double[numAtoms];
                        compCoords1 = new double[numUnique * 3];
                        compMass = new double[numUnique];
                        index = 0;
                        indexUnique = 0;
                        for (i = 0; i < numAtoms; ++i) {
                            a = atoms1List.get(i);
                            if (!equivalent[i]) {
                                compCoords1[indexUnique * 3] = a.getX();
                                compCoords1[indexUnique * 3 + 1] = a.getY();
                                compCoords1[indexUnique * 3 + 2] = a.getZ();
                                compMass[indexUnique++] = a.getMass();
                            }
                            xyz1[index * 3] = a.getX();
                            xyz1[index * 3 + 1] = a.getY();
                            xyz1[index * 3 + 2] = a.getZ();
                            mass[index++] = a.getMass();
                        }
                        for (l = 0; l < numMol2; ++l) {
                            mol2 = molecules2.get(l);
                            atoms2List = mol2.getAtomList();
                            numAtoms2 = atoms2List.size();
                            ReorderAtoms.logger.info(String.format(" Molecule2 with %3d atoms: %s", new Object[]{numAtoms2, mol2.toString()}));
                            if (numAtoms != numAtoms2 || molDone[l]) continue;
                            xyz2 = new double[numAtoms2 * 3];
                            compCoords2 = new double[numUnique * 3];
                            index = 0;
                            indexUnique = 0;
                            for (i = 0; i < numAtoms; ++i) {
                                a = atoms2List.get(i);
                                if (!equivalent[i]) {
                                    compCoords2[indexUnique * 3] = a.getX();
                                    compCoords2[indexUnique * 3 + 1] = a.getY();
                                    compCoords2[indexUnique++ * 3 + 2] = a.getZ();
                                }
                                xyz2[index * 3] = a.getX();
                                xyz2[index * 3 + 1] = a.getY();
                                xyz2[index++ * 3 + 2] = a.getZ();
                            }
                            if (compCoords1.length == 0 || compCoords2.length == 0) {
                                ReorderAtoms.logger.info(String.format(" Comparison Coordinates invalid (1: %3d 2: %3d) %3d of %3d unique atoms.", new Object[]{compCoords1.length, compCoords2.length, numUnique, numAtoms}));
                                compCoords1 = xyz1;
                                compCoords2 = xyz2;
                                compMass = mass;
                            }
                            translate1 = Superpose.calculateTranslation(compCoords1, compMass);
                            translate2 = Superpose.calculateTranslation(compCoords2, compMass);
                            Superpose.applyTranslation(compCoords1, translate1);
                            Superpose.applyTranslation(compCoords2, translate2);
                            Superpose.applyTranslation(xyz1, translate1);
                            Superpose.applyTranslation(xyz2, translate2);
                            rotation = Superpose.calculateRotation(compCoords1, compCoords2, compMass);
                            Superpose.applyRotation(compCoords2, rotation);
                            Superpose.applyRotation(xyz2, rotation);
                            compRMSD = Superpose.superpose(compCoords1, compCoords2, compMass);
                            ReorderAtoms.logger.info(String.format(" Unique atom RMSD: %9.4f A", new Object[]{compRMSD}));
                            if (compRMSD > 1.0) {
                                ReorderAtoms.logger.warning(String.format(" Value of %9.3f A may lead to insufficient overlap. Double check produced ordering.", new Object[]{compRMSD}));
                            }
                            block28: for (i = 0; i < numAtoms; ++i) {
                                if (!equivalent[i]) continue;
                                ind = i * 3;
                                coord1 = new double[]{xyz1[ind], xyz1[ind + 1], xyz1[ind + 2]};
                                coord2 = new double[]{xyz2[ind], xyz2[ind + 1], xyz2[ind + 2]};
                                value = Superpose.rmsd(coord1, coord2, new double[]{mass[i]});
                                ReorderAtoms.logger.info(String.format(" Atom %2d distance of %9.3f A", new Object[]{i, value}));
                                for (List list : equivalents) {
                                    if (!list.contains(i)) continue;
                                    minIndex = -1;
                                    minValue = 1.7976931348623157E308;
                                    for (Integer aIndex : list) {
                                        if (i == aIndex) continue;
                                        ind2 = aIndex * 3;
                                        tempCoord = new double[]{xyz1[ind2], xyz1[ind2 + 1], xyz1[ind2 + 2]};
                                        v0 = new double[]{mass[i]};
                                        value2 = Superpose.rmsd(tempCoord, coord2, v0);
                                        if (!(value2 < minValue)) continue;
                                        minIndex = aIndex;
                                        minValue = value2;
                                    }
                                    if (minValue < value) {
                                        temp = atoms1List.get(i);
                                        atoms1List.set(i, atoms1List.get(minIndex));
                                        atoms1List.set(minIndex, temp);
                                        tempCoord = new double[]{xyz1[ind], xyz1[ind + 1], xyz1[ind + 2]};
                                        ind2 = minIndex * 3;
                                        xyz1[ind] = xyz1[ind2];
                                        xyz1[ind + 1] = xyz1[ind2 + 1];
                                        xyz1[ind + 2] = xyz1[ind2 + 2];
                                        xyz1[ind2] = tempCoord[0];
                                        xyz1[ind2 + 1] = tempCoord[1];
                                        xyz1[ind2 + 2] = tempCoord[2];
                                    }
                                    value = Superpose.rmsd(new double[]{xyz1[ind], xyz1[ind + 1], xyz1[ind + 2]}, new double[]{xyz2[ind], xyz2[ind + 1], xyz2[ind + 2]}, new double[]{mass[i]});
                                    ReorderAtoms.logger.info(String.format(" Atom %2d distance updated to %9.3f A", new Object[]{i, value}));
                                    continue block28;
                                }
                            }
                            compRMSD = Superpose.superpose(xyz1, xyz2, mass);
                            ReorderAtoms.logger.info(String.format(" Final RMSD: %9.4f A", new Object[]{compRMSD}));
                            for (j = 0; j < numAtoms; ++j) {
                                a = atoms1List.get(j);
                                xyz = new double[]{a.getX(), a.getY(), a.getZ()};
                                atom = new ffx.potential.bonded.Atom(atomIndex++, a.getName(), a.getAtomType(), xyz);
                                atomList.add(atom);
                            }
                            bondList = mol1.getBondList();
                            for (Bond bond : bondList) {
                                a1 = bond.getAtom(0);
                                a2 = bond.getAtom(1);
                                index1 = -1;
                                index2 = -1;
                                counter = 0;
                                for (ffx.potential.bonded.Atom atom : atoms1List) {
                                    aIndex = atom.getIndex();
                                    if (aIndex == a1.getIndex()) {
                                        index1 = counter;
                                    } else if (aIndex == a2.getIndex()) {
                                        index2 = counter;
                                    }
                                    ++counter;
                                }
                                if (index1 == -1 || index2 == -1) {
                                    ReorderAtoms.logger.severe(String.format(" Index1 (%3d) and Index2 (%3d) suggests error for bond: %s", new Object[]{index1, index2, bond}));
                                }
                                newA1 = atomList.get(index1 + totalNumAtoms);
                                newA2 = atomList.get(index2 + totalNumAtoms);
                                ReorderAtoms.logger.info(String.format(" index1 %3d Index2 %3d", new Object[]{index1, index2}));
                                if (newA1.isBonded(newA2)) continue;
                                b = new Bond(newA1, newA2);
                                b.setBondType(bond.getBondType());
                            }
                            molDone[l] = true;
                            totalNumAtoms += numAtoms;
                        }
                        if (Arrays.asList(new boolean[][]{molDone}).contains(false)) continue;
                        break;
                    }
                    Utilities.biochemistry(newAssembly, atomList);
                    filter = new XYZFilter(saveFile, newAssembly, newAssembly.getForceField(), newAssembly.getProperties());
                    filter.writeFile(saveFile, true);
                    ReorderAtoms.logger.info(String.format(" Saved to " + saveFile.getName(), new Object[0]));
                    break block134;
                }
                if (!ReorderAtoms.atomType || this.filenames == null || this.filenames.size() <= 1) break block136;
                this.potentialFunctions.openAll(this.filenames.get(0));
                systemFilter1 = this.potentialFunctions.getFilter();
                this.potentialFunctions.openAll(this.filenames.get(1));
                systemFilter2 = this.potentialFunctions.getFilter();
                ReorderAtoms.logger.info(" Changing atom types in file 1 to match file 2.");
                assembly1 = systemFilter1.getActiveMolecularSystem();
                do {
                    assembly2 = systemFilter2.getActiveMolecularSystem();
                    atoms1 = assembly1.getAtomArray();
                    atoms2 = assembly2.getAtomArray();
                    xyzatoms = new ArrayList<ArrayList>();
                    outputAssembly = new MolecularAssembly(assembly1.getName());
                    numHydrogen = 0;
                    for (ffx.potential.bonded.Atom atom : atoms2) {
                        if (!atom.isHydrogen()) continue;
                        ++numHydrogen;
                    }
                    entitiesInput = assembly2.getAllBondedEntities();
                    molIndices = assembly2.getMoleculeNumbers();
                    numEntitiesInput = entitiesInput.size();
                    shiftIndices = new int[numEntitiesInput];
                    count = 0;
                    for (i = 0; i < numEntitiesInput; ++i) {
                        for (int ind : molIndices) {
                            if (ind != i) continue;
                            ++count;
                        }
                        shiftIndices[i] = count;
                    }
                    if (ReorderAtoms.logger.isLoggable(Level.FINE)) {
                        ReorderAtoms.logger.fine(String.format(" Number of entities in input: %d", new Object[]{numEntitiesInput}));
                        for (MSNode entity : entitiesInput) {
                            ReorderAtoms.logger.fine(String.format(" Entity: %s", new Object[]{entity.getName()}));
                            size = entity.getAtomList().size();
                            ReorderAtoms.logger.fine(String.format("   Entity Size: %3d", new Object[]{size}));
                            if (size > 0) {
                                ReorderAtoms.logger.fine(String.format("   Entity First Atom: %s", new Object[]{entity.getAtomList().get(0).toString()}));
                                continue;
                            }
                            ReorderAtoms.logger.warning(" Entity did not contain atoms.");
                        }
                    }
                    for (MSNode mol : entitiesInput) {
                        xyzatoms.add((ArrayList)mol.getAtomList());
                    }
                    atomIndex = 1;
                    ReorderAtoms.logger.info(" Num Entities Input: " + numEntitiesInput);
                    for (i = 0; i < numEntitiesInput; ++i) {
                        mol = entitiesInput.get(i);
                        numInputMolAtoms = ((ArrayList)xyzatoms.get(i)).size();
                        numMolHydrogen = 0;
                        for (ffx.potential.bonded.Atom atom : (ArrayList)xyzatoms.get(i)) {
                            if (!atom.isHydrogen()) continue;
                            ++numMolHydrogen;
                        }
                        if (ReorderAtoms.logger.isLoggable(Level.FINE)) {
                            ReorderAtoms.logger.fine(String.format(" Current entity number of atoms: %d (%d + %dH)", new Object[]{numInputMolAtoms, numInputMolAtoms - numMolHydrogen, numMolHydrogen}));
                        }
                        xyzCDKAtoms = new AtomContainer();
                        for (ffx.potential.bonded.Atom atom : (ArrayList)xyzatoms.get(i)) {
                            atomName = PeriodicTable.getSymbol((int)atom.getAtomType().atomicNumber);
                            xyzCDKAtoms.addAtom((IAtom)new Atom(atomName, new Point3d(atom.getXYZ(null))));
                        }
                        nAtoms = atoms1.length;
                        nInputAtoms = atoms2.length;
                        zPrime = nAtoms % nInputAtoms == 0 ? nAtoms / nInputAtoms : (nAtoms % (nInputAtoms - numHydrogen) == 0 ? nAtoms / (nInputAtoms - numHydrogen) : 1);
                        ReorderAtoms.logger.info(" Original ZPrime: " + zPrime);
                        bonds = mol.getBondList();
                        order = IBond.Order.SINGLE;
                        xyzBonds = bonds.size();
                        if (xyzBonds == 0) {
                            ReorderAtoms.logger.warning(" No bonds detected in input structure. Please check input.\n If correct, separate non-bonded entities into multiple CIFs.");
                        }
                        for (Object xyzBond : bonds) {
                            atom0Index = xyzBond.getAtom(0).getXyzIndex();
                            atom1Index = xyzBond.getAtom(1).getXyzIndex();
                            v1 = shiftIndex = molIndices[atom0Index] == 0 ? 0 : shiftIndices[molIndices[atom0Index] - 1];
                            if (ReorderAtoms.logger.isLoggable(Level.FINER)) {
                                ReorderAtoms.logger.finer(String.format(" Bonded atom 1: %d, Bonded atom 2: %d", new Object[]{atom0Index, atom1Index}));
                                ReorderAtoms.logger.finer(String.format(" Atom0: %3d Atom1: %3d Shift: %3d final0,1: %3d, %3d MolIndex: %3d ShiftIndex: %3d", new Object[]{atom0Index, atom1Index, shiftIndex, atom0Index - shiftIndex - 1, atom1Index - shiftIndex - 1, molIndices[atom0Index], shiftIndices[molIndices[atom0Index]]}));
                            }
                            xyzCDKAtoms.addBond(atom0Index - shiftIndex - 1, atom1Index - shiftIndex - 1, order);
                        }
                        factory = AtomTypeFactory.getInstance((String)"org/openscience/cdk/config/data/jmol_atomtypes.txt", (IChemObjectBuilder)xyzCDKAtoms.getBuilder());
                        xyzBond = xyzCDKAtoms.atoms().iterator();
                        while (xyzBond.hasNext()) {
                            atom = (IAtom)xyzBond.next();
                            CIFFilter.setAtomTypes(factory, atom);
                            try {
                                factory.configure(atom);
                            }
                            catch (Exception ex) {
                                ReorderAtoms.logger.info(" Failed to configure atoms from CIF.\n" + String.valueOf(ex) + "\n" + Arrays.toString(ex.getStackTrace()));
                            }
                        }
                        zindices = new ArrayList<ArrayList<E>>();
                        counter = 0;
                        cifBonds = CIFFilter.bondAtoms(atoms1, this.bondTolerance);
                        if (ReorderAtoms.logger.isLoggable(Level.FINE)) {
                            ReorderAtoms.logger.fine(String.format(" Created %d bonds between input atoms (%d in input).", new Object[]{cifBonds, xyzBonds}));
                        }
                        atomPool = new ArrayList<ffx.potential.bonded.Atom>(Arrays.asList(atoms1));
                        try {
                            while (!atomPool.isEmpty()) {
                                molecule = new ArrayList<ffx.potential.bonded.Atom>();
                                CIFFilter.collectAtoms((ffx.potential.bonded.Atom)atomPool.get(0), molecule);
                                if (ReorderAtoms.logger.isLoggable(Level.FINER)) {
                                    ReorderAtoms.logger.finer(String.format(" Molecule (%d) Size: %d", new Object[]{counter, molecule.size()}));
                                }
                                indices = new ArrayList<Integer>();
                                while (!molecule.isEmpty()) {
                                    atom = molecule.remove(0);
                                    indices.add(atom.getIndex());
                                    atomPool.remove(atom);
                                }
                                if (ReorderAtoms.logger.isLoggable(Level.FINER)) {
                                    ReorderAtoms.logger.finer(String.format(" Molecule %d: %d atoms are ready and %d remain (%d atoms in input, %d atoms in CIF). ", new Object[]{counter + 1, indices.size(), atomPool.size(), nInputAtoms, nAtoms}));
                                }
                                zindices.add(indices);
                                ++counter;
                            }
                        }
                        catch (Exception e) {
                            ReorderAtoms.logger.severe(" Failed to separate copies within the asymmetric unit." + String.valueOf(e) + "\n" + Utilities.stackTraceToString(e));
                        }
                        zPrime = zindices.size();
                        ReorderAtoms.logger.info(" Zprime: " + zPrime);
                        cifCDKAtomsArr = new AtomContainer[zPrime];
                        for (j = 0; j < zPrime; ++j) {
                            block137: {
                                if (zPrime > 1) {
                                    ReorderAtoms.logger.info(String.format("\n Attempting entity %d of %d", new Object[]{j + 1, zPrime}));
                                }
                                currentList = (ArrayList)zindices.get(j);
                                cifMolAtoms = currentList.size();
                                if (ReorderAtoms.logger.isLoggable(Level.FINE)) {
                                    ReorderAtoms.logger.fine(String.format(" CIF atoms in current: %d", new Object[]{cifMolAtoms}));
                                }
                                if (cifMolAtoms % numInputMolAtoms != 0 && cifMolAtoms % (numInputMolAtoms - numMolHydrogen) != 0) break block137;
                                cifCDKAtomsArr[j] = new AtomContainer();
                                for (Iterator<T> integer : currentList) {
                                    atomName = PeriodicTable.getSymbol((int)atoms1[integer.intValue() - 1].getAtomType().atomicNumber);
                                    cifCDKAtomsArr[j].addAtom((IAtom)new Atom(atomName, new Point3d(atoms1[integer.intValue() - 1].getXYZ(null))));
                                }
                                nullCDKAtoms = new AtomContainer();
                                for (IAtom atom : cifCDKAtomsArr[j].atoms()) {
                                    if (atom.toString() != null) continue;
                                    nullCDKAtoms.addAtom(atom);
                                }
                                cifCDKAtomsArr[j].remove((IAtomContainer)nullCDKAtoms);
                                factory = AtomTypeFactory.getInstance((String)"org/openscience/cdk/config/data/jmol_atomtypes.txt", (IChemObjectBuilder)cifCDKAtomsArr[j].getBuilder());
                                integer = cifCDKAtomsArr[j].atoms().iterator();
                                while (integer.hasNext()) {
                                    atom = (IAtom)integer.next();
                                    CIFFilter.setAtomTypes(factory, atom);
                                    try {
                                        factory.configure(atom);
                                    }
                                    catch (Exception ex) {
                                        ReorderAtoms.logger.info(" Failed to configure CIF atoms.\n" + String.valueOf(ex) + "\n" + Utilities.stackTraceToString(ex));
                                    }
                                }
                                rebonder = new RebondTool(2.0, 0.5, this.bondTolerance);
                                try {
                                    rebonder.rebond((IAtomContainer)cifCDKAtomsArr[j]);
                                }
                                catch (Exception ex) {
                                    ReorderAtoms.logger.info("Failed to rebond CIF atoms.\n" + String.valueOf(ex) + "\n" + Utilities.stackTraceToString(ex));
                                }
                                cifMolBonds = cifCDKAtomsArr[j].getBondCount();
                                if (ReorderAtoms.logger.isLoggable(Level.FINE)) {
                                    ReorderAtoms.logger.fine(String.format(" Number of CIF bonds: %d (%d in input)", new Object[]{cifMolBonds, xyzBonds}));
                                }
                                if (cifMolBonds == 0 || cifMolBonds % xyzBonds != 0) ** GOTO lbl500
                                pattern = VentoFoggia.findIdentical((IAtomContainer)xyzCDKAtoms, (AtomMatcher)AtomMatcher.forElement(), (BondMatcher)BondMatcher.forAny());
                                p = pattern.match((IAtomContainer)cifCDKAtomsArr[j]);
                                pLength = p.length;
                                if (p != null && pLength == numInputMolAtoms) {
                                    for (k = 0; k < pLength; ++k) {
                                        if (ReorderAtoms.logger.isLoggable(Level.FINEST)) {
                                            ReorderAtoms.logger.finest(String.format(" %d input %s -> CIF %s", new Object[]{k, xyzCDKAtoms.getAtom(k).getSymbol(), cifCDKAtomsArr[j].getAtom(p[k]).getSymbol()}));
                                        }
                                        point3d = cifCDKAtomsArr[j].getAtom(p[k]).getPoint3d();
                                        ((ffx.potential.bonded.Atom)((ArrayList)xyzatoms.get(i)).get(k)).setXYZ(new double[]{point3d.x, point3d.y, point3d.z});
                                    }
                                } else {
                                    if (!ReorderAtoms.logger.isLoggable(Level.FINE)) continue;
                                    ReorderAtoms.logger.fine(String.format(" Atoms from CIF (%d) and input (%d) structures don't match.", new Object[]{p.length, nAtoms}));
                                    continue;
lbl500:
                                    // 1 sources

                                    if (xyzBonds - numMolHydrogen == 0 || cifMolBonds % (xyzBonds - numMolHydrogen) == 0) {
                                        if (ReorderAtoms.logger.isLoggable(Level.FINE)) {
                                            ReorderAtoms.logger.info(" CIF may contain implicit hydrogen -- attempting to patch.");
                                        }
                                        pattern = VentoFoggia.findSubstructure((IAtomContainer)cifCDKAtomsArr[j], (AtomMatcher)AtomMatcher.forElement(), (BondMatcher)BondMatcher.forAny());
                                        p = pattern.match((IAtomContainer)xyzCDKAtoms);
                                        pLength = p.length;
                                        if (p != null && pLength == numInputMolAtoms - numMolHydrogen) {
                                            for (k = 0; k < pLength; ++k) {
                                                point3d = cifCDKAtomsArr[j].getAtom(k).getPoint3d();
                                                ((ffx.potential.bonded.Atom)((ArrayList)xyzatoms.get(i)).get(p[k])).setXYZ(new double[]{point3d.x, point3d.y, point3d.z});
                                            }
                                            lastKnownAtom1 = null;
                                            knownCount = 0;
                                            for (ffx.potential.bonded.Atom hydrogen : (ArrayList)xyzatoms.get(i)) {
                                                if (!hydrogen.isHydrogen()) continue;
                                                bond0 = hydrogen.getBonds().get(0);
                                                atom1 = bond0.get1_2(hydrogen);
                                                angle0_2 = 0.0;
                                                anglesList = hydrogen.getAngles();
                                                atom2 = null;
                                                switch (anglesList.size()) {
                                                    case 0: {
                                                        hydrogen.moveTo(new double[]{atom1.getX() - 0.6, atom1.getY() - 0.6, atom1.getZ() - 0.6});
                                                        break;
                                                    }
                                                    case 1: {
                                                        for (Angle angle : anglesList) {
                                                            atom2 = angle.get1_3(hydrogen);
                                                            if (atom2 != null) {
                                                                angle0_2 = angle.angleType.angle[0];
                                                            }
                                                            if (angle0_2 == 0.0) continue;
                                                            break;
                                                        }
                                                        if (!ReorderAtoms.$assertionsDisabled && atom2 == null) {
                                                            throw new AssertionError();
                                                        }
                                                        bonds2 = atom2.getBonds();
                                                        atom3 = bonds2.size() > 1 && atom1 == bonds2.get(0).get1_2(atom2) ? bonds2.get(1).get1_2(atom2) : bonds2.get(0).get1_2(atom2);
                                                        diAng = DoubleMath.dihedralAngle((double[])hydrogen.getXYZ(null), (double[])atom1.getXYZ(null), (double[])atom2.getXYZ(null), (double[])atom3.getXYZ(null));
                                                        if (atom1 != atom3) {
                                                            BondedUtils.intxyz(hydrogen, atom1, bond0.bondType.distance, atom2, angle0_2, atom3, Math.toDegrees(diAng), 0);
                                                            break;
                                                        }
                                                        coord = new double[]{atom2.getX(), atom2.getY(), atom3.getZ()};
                                                        mag = FastMath.sqrt((double)(coord[0] * coord[0] + coord[1] * coord[1] + coord[2] * coord[2]));
                                                        coord[0] = coord[0] / mag;
                                                        coord[1] = coord[1] / mag;
                                                        coord[2] = coord[2] / mag;
                                                        hydrogen.moveTo(atom1.getX() - coord[0], atom1.getY() - coord[1], atom1.getZ() - coord[2]);
                                                        break;
                                                    }
                                                    default: {
                                                        atom2B = null;
                                                        angle0_2B = 0.0;
                                                        proposedAngle = 0.0;
                                                        chiral = 1;
                                                        for (Angle angle : anglesList) {
                                                            proposedAtom = angle.get1_3(hydrogen);
                                                            if (proposedAtom != null && !proposedAtom.isHydrogen()) {
                                                                proposedAngle = angle.angleType.angle[0];
                                                            }
                                                            if (proposedAngle != 0.0) {
                                                                if (angle0_2 != 0.0) {
                                                                    atom2B = proposedAtom;
                                                                    angle0_2B = proposedAngle;
                                                                } else {
                                                                    atom2 = proposedAtom;
                                                                    angle0_2 = proposedAngle;
                                                                }
                                                                proposedAngle = 0.0;
                                                            }
                                                            if (angle0_2 == 0.0 || angle0_2B == 0.0) continue;
                                                            break;
                                                        }
                                                        if (lastKnownAtom1 == null || lastKnownAtom1 != atom1) {
                                                            lastKnownAtom1 = atom1;
                                                            knownCount = 0;
                                                        } else {
                                                            ++knownCount;
                                                        }
                                                        if (angle0_2B == 0.0) {
                                                            chiral = 0;
                                                            if (!ReorderAtoms.$assertionsDisabled && atom2 == null) {
                                                                throw new AssertionError();
                                                            }
                                                            bonds2 = atom2.getBonds();
                                                            atom2B = atom1 == bonds2.get(0).get1_2(atom2) ? bonds2.get(1).get1_2(atom2) : bonds2.get(0).get1_2(atom2);
                                                            angle0_2B = 180.0 - 120.0 * (double)knownCount;
                                                        } else if (anglesList.size() == 2) {
                                                            chiral = 3;
                                                        } else if (knownCount == 1) {
                                                            chiral = -1;
                                                        }
                                                        BondedUtils.intxyz(hydrogen, atom1, bond0.bondType.distance, atom2, angle0_2, atom2B, angle0_2B, chiral);
                                                    }
                                                }
                                            }
                                        } else {
                                            ReorderAtoms.logger.info(String.format(" Substructure match failed (%d vs expected %d)", new Object[]{pLength, numInputMolAtoms - numMolHydrogen}));
                                        }
                                    }
                                }
                                molecule = mol instanceof Polymer != false ? new Polymer(((Polymer)mol).getChainID(), mol.getName(), true) : new Molecule(mol.getName());
                                newAtomList = new ArrayList<ffx.potential.bonded.Atom>();
                                for (ffx.potential.bonded.Atom atom : (ArrayList)xyzatoms.get(i)) {
                                    if (molecule instanceof Polymer) {
                                        molAtom = new ffx.potential.bonded.Atom(atomIndex++, atom.getName(), atom.getAltLoc(), atom.getXYZ(null), atom.getResidueName(), atom.getResidueNumber(), atom.getChainID(), atom.getOccupancy(), atom.getTempFactor(), atom.getSegID());
                                        molAtom.setAtomType(atom.getAtomType());
                                    } else {
                                        molAtom = new ffx.potential.bonded.Atom(atomIndex++, atom.getName(), atom.getAtomType(), atom.getXYZ(null));
                                        if (atom.getResidueName() != null) {
                                            molAtom.setResName(atom.getResidueName());
                                        }
                                    }
                                    newAtomList.add(molAtom);
                                }
                                bondList = mol.getBondList();
                                for (Bond bond : bondList) {
                                    a1 = bond.getAtom(0);
                                    a2 = bond.getAtom(1);
                                    if (ReorderAtoms.logger.isLoggable(Level.FINE)) {
                                        ReorderAtoms.logger.fine(String.format(" Bonded atom 1: %d, Bonded atom 2: %d", new Object[]{a1.getXyzIndex(), a2.getXyzIndex()}));
                                    }
                                    shiftIndex = molIndices[molIndex = a1.getXyzIndex()] == 0 ? 0 : shiftIndices[molIndices[molIndex] - 1];
                                    newA1 = (ffx.potential.bonded.Atom)newAtomList.get(a1.getIndex() - shiftIndex - 1);
                                    newA2 = (ffx.potential.bonded.Atom)newAtomList.get(a2.getIndex() - shiftIndex - 1);
                                    bond2 = new Bond(newA1, newA2);
                                    bond2.setBondType(bond.getBondType());
                                }
                                res = null;
                                for (ffx.potential.bonded.Atom atom : newAtomList) {
                                    if (molecule instanceof Polymer) {
                                        polyMol = (Polymer)mol;
                                        if (res == null) {
                                            res = new Residue(atom.getResidueName(), atom.getResidueNumber(), polyMol.getResidue(atom.getResidueNumber()).getResidueType());
                                        } else if (res.getResidueNumber() != atom.getResidueNumber()) {
                                            if (ReorderAtoms.logger.isLoggable(Level.FINER)) {
                                                ReorderAtoms.logger.finer(" Added Residue " + res.getResidueNumber() + " " + res.getName());
                                            }
                                            molecule.addMSNode(res);
                                            res = new Residue(atom.getResidueName(), atom.getResidueNumber(), polyMol.getResidue(atom.getResidueNumber()).getResidueType());
                                        }
                                        res.addMSNode(atom);
                                        continue;
                                    }
                                    molecule.addMSNode(atom);
                                }
                                if (molecule instanceof Polymer && res != null) {
                                    if (ReorderAtoms.logger.isLoggable(Level.FINER)) {
                                        ReorderAtoms.logger.finer(" Added Final Residue " + res.getResidueNumber() + " " + res.getName());
                                    }
                                    molecule.addMSNode(res);
                                }
                                outputAssembly.addMSNode(molecule);
                                continue;
                            }
                            if (!ReorderAtoms.logger.isLoggable(Level.INFO)) continue;
                            ReorderAtoms.logger.info(String.format(" Number of atoms in CIF (%d) molecule do not match input (%d + %dH = %d).", new Object[]{cifMolAtoms, nInputAtoms - numMolHydrogen, numMolHydrogen, nInputAtoms}));
                        }
                    }
                    if (ReorderAtoms.logger.isLoggable(Level.FINE)) {
                        ReorderAtoms.logger.fine(String.format("\n Output Assembly Atoms: %d", new Object[]{outputAssembly.getAtomList().size()}));
                    }
                    outputAssembly.setPotential(assembly2.getPotentialEnergy());
                    if (assembly1.getCrystal() != null) {
                        outputAssembly.setCrystal(assembly1.getCrystal());
                    }
                    outputAssembly.setForceField(assembly2.getForceField());
                    outputAssembly.setFile(assembly1.getFile());
                    outputAssembly.setName(assembly1.getName());
                    if (outputAssembly.getAtomList().size() < 1) {
                        ReorderAtoms.logger.info(" Atom types could not be matched. File could not be written.");
                    } else if (!ReorderAtoms.writeOutputFile(outputAssembly, systemFilter1)) {
                        ReorderAtoms.logger.info(" Output assembly file could not be written.");
                    }
                    outputAssembly.destroy();
                } while (systemFilter1.readNext());
                break block134;
            }
            ReorderAtoms.logger.info(this.helpString());
        }
        return this;
    }

    private static boolean writeOutputFile(MolecularAssembly ma, SystemFilter systemFilter) {
        File saveFile;
        File file = systemFilter.getFiles().get(0);
        String dir = FilenameUtils.getFullPath((String)file.getAbsolutePath()) + File.separator;
        Object fileName = FilenameUtils.removeExtension((String)FilenameUtils.getName((String)file.getAbsolutePath()));
        String spacegroup = ma.getCrystal() != null ? ma.getCrystal().getUnitCell().spaceGroup.shortName : null;
        List<MSNode> entities = ma.getAllBondedEntities();
        if (systemFilter instanceof PDBFilter) {
            if (entities.size() > 1) {
                fileName = (String)fileName + "_z" + entities.size();
            }
            saveFile = new File(dir + (String)fileName + ".pdb");
        } else {
            saveFile = systemFilter.countNumModels() > 1 ? new File(dir + (String)fileName + "_reorder.arc") : XYZFilter.version(new File(dir + (String)fileName + ".xyz"));
        }
        ForceField ff = ma.getForceField();
        CompositeConfiguration properties = ma.getProperties();
        if (systemFilter instanceof PDBFilter) {
            PDBFilter pdbFilter = new PDBFilter(saveFile, ma, ff, properties);
            pdbFilter.writeFile(saveFile, true);
        } else {
            XYZFilter xyzFilter = new XYZFilter(saveFile, ma, ff, properties);
            xyzFilter.writeFile(saveFile, true);
        }
        logger.info("\n Saved output file:        " + saveFile.getAbsolutePath());
        File propertyFile = new File(saveFile.getParentFile(), FilenameUtils.removeExtension((String)saveFile.getName()) + ".properties");
        if (!propertyFile.exists()) {
            try {
                String patch;
                String forceFieldProperty;
                FileWriter fw = new FileWriter(propertyFile, false);
                BufferedWriter bw = new BufferedWriter(fw);
                ForceField forceField = ma.getForceField();
                String parameters = forceField.getString("parameters", "none");
                if (parameters != null && !parameters.equalsIgnoreCase("none")) {
                    bw.write(String.format("parameters %s\n", parameters));
                }
                if ((forceFieldProperty = forceField.getString("forcefield", "none")) != null && !forceFieldProperty.equalsIgnoreCase("none")) {
                    bw.write(String.format("forcefield %s\n", forceFieldProperty));
                }
                if ((patch = forceField.getString("patch", "none")) != null && !patch.equalsIgnoreCase("none")) {
                    bw.write(String.format("patch %s\n", patch));
                }
                bw.write(String.format("spacegroup %s\n", spacegroup));
                if (entities.size() > 1) {
                    bw.write("intermolecular-softcore true\n");
                }
                logger.info("\n Saved properties file: " + propertyFile.getAbsolutePath() + "\n");
                bw.close();
            }
            catch (Exception ex) {
                logger.info("Failed to write files.\n" + Utilities.stackTraceToString(ex));
            }
        } else {
            logger.info("\n Property file already exists:  " + propertyFile.getAbsolutePath() + "\n");
        }
        return true;
    }

    private final class AtomComparator
    implements Comparator<ffx.potential.bonded.Atom> {
        private AtomComparator(ReorderAtoms reorderAtoms) {
            Objects.requireNonNull(reorderAtoms);
        }

        @Override
        public int compare(ffx.potential.bonded.Atom a1, ffx.potential.bonded.Atom a2) {
            int comp = Integer.compare(a1.getMoleculeNumber(), a2.getMoleculeNumber());
            if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                FFXCommand.logger.finer(String.format(" Different Molecule Number (%d vs %d)", a1.getMoleculeNumber(), a2.getMoleculeNumber()));
            }
            if (comp == 0) {
                comp = Integer.compare(a1.getResidueNumber(), a2.getResidueNumber());
                if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                    FFXCommand.logger.finer(String.format(" Different Residue Numbers %d vs %d", a1.getResidueNumber(), a2.getResidueNumber()));
                }
                if (comp == 0) {
                    comp = -Double.compare(a1.getMass(), a2.getMass());
                    if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                        FFXCommand.logger.finer(String.format(" Different Masses %6.3f %6.3f", a1.getMass(), a2.getMass()));
                    }
                    if (comp == 0) {
                        comp = Integer.compare(a1.getAtomType().type, a2.getAtomType().type);
                        if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                            FFXCommand.logger.finer(String.format(" Different Atom Types (%d vs %d)", a1.getAtomType().type, a2.getAtomType().type));
                        }
                        if (comp == 0) {
                            comp = Integer.compare(a1.getBonds().size(), a2.getBonds().size());
                            if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                                FFXCommand.logger.finer(String.format(" Different Bond Sizes (%d vs %d)", a1.getBonds().size(), a2.getBonds().size()));
                            }
                            if (comp == 0) {
                                comp = Integer.compare(a1.get12List().size(), a2.get12List().size());
                                if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                                    FFXCommand.logger.finer(String.format(" Different 1-2 Size (%d vs %d).", a1.get12List().size(), a2.get12List().size()));
                                }
                                if (comp == 0) {
                                    ffx.potential.bonded.Atom a22;
                                    ffx.potential.bonded.Atom a12;
                                    int i;
                                    for (i = 0; i < a1.get12List().size() && (comp = this.shallowCompare(a12 = a1.get12List().get(i), a22 = a2.get12List().get(i))) == 0; ++i) {
                                    }
                                    if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                                        FFXCommand.logger.finer(" Different 1-2 Shallow.");
                                    }
                                    if (comp == 0) {
                                        comp = Integer.compare(a1.get13List().size(), a2.get13List().size());
                                        if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                                            FFXCommand.logger.finer(" Different 1-3 Size.");
                                        }
                                        if (comp == 0) {
                                            ffx.potential.bonded.Atom a23;
                                            ffx.potential.bonded.Atom a13;
                                            for (i = 0; i < a1.get13List().size() && (comp = this.shallowCompare(a13 = a1.get13List().get(i), a23 = a2.get13List().get(i))) == 0; ++i) {
                                            }
                                            if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                                                FFXCommand.logger.finer(" Different 1-3 Shallow.");
                                            }
                                            if (comp == 0) {
                                                comp = Integer.compare(a1.get14List().size(), a2.get14List().size());
                                                if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                                                    FFXCommand.logger.finer(" Different 1-4 Size.");
                                                }
                                                if (comp == 0) {
                                                    ffx.potential.bonded.Atom a24;
                                                    ffx.potential.bonded.Atom a14;
                                                    for (i = 0; i < a1.get14List().size() && (comp = this.shallowCompare(a14 = a1.get14List().get(i), a24 = a2.get14List().get(i))) == 0; ++i) {
                                                    }
                                                    if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                                                        FFXCommand.logger.finer(" Different 1-4 Shallow.");
                                                    }
                                                    if (comp == 0) {
                                                        comp = Integer.compare(a1.get15List().size(), a2.get15List().size());
                                                        if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                                                            FFXCommand.logger.finer(" Different 1-5 Size.");
                                                        }
                                                        if (comp == 0) {
                                                            ffx.potential.bonded.Atom a25;
                                                            ffx.potential.bonded.Atom a15;
                                                            for (i = 0; i < a1.get15List().size() && (comp = this.shallowCompare(a15 = a1.get15List().get(i), a25 = a2.get15List().get(i))) == 0; ++i) {
                                                            }
                                                            if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                                                                FFXCommand.logger.finer(" Different 1-5 Shallow.");
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return comp;
        }

        private int shallowCompare(ffx.potential.bonded.Atom a1, ffx.potential.bonded.Atom a2) {
            int comp = Integer.compare(a1.getBonds().size(), a2.getBonds().size());
            if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                FFXCommand.logger.finer(" Different Shallow Bond Size.");
            }
            if (comp == 0) {
                comp = Integer.compare(a1.getAtomType().type, a2.getAtomType().type);
                if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                    FFXCommand.logger.finer(" Different Shallow Atom Type.");
                }
                if (comp == 0) {
                    comp = Integer.compare(a1.get12List().size(), a2.get12List().size());
                    if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                        FFXCommand.logger.finer(" Different Shallow 1-2 Size.");
                    }
                    if (comp == 0) {
                        comp = Integer.compare(a1.get13List().size(), a2.get13List().size());
                        if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                            FFXCommand.logger.finer(" Different Shallow 1-3 Size.");
                        }
                        if (comp == 0) {
                            comp = Integer.compare(a1.get14List().size(), a2.get14List().size());
                            if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                                FFXCommand.logger.finer(" Different Shallow 1-4 Size.");
                            }
                            if (comp == 0) {
                                comp = Integer.compare(a1.get15List().size(), a2.get15List().size());
                                if (FFXCommand.logger.isLoggable(Level.FINER) && comp != 0) {
                                    FFXCommand.logger.finer(" Different Shallow 1-5 Size.");
                                }
                            }
                        }
                    }
                }
            }
            return comp;
        }
    }
}

