/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands.test;

import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Residue;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.cli.GradientOptions;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.extended.ExtendedSystem;
import ffx.potential.terms.AnglePotentialEnergy;
import ffx.potential.terms.BondPotentialEnergy;
import ffx.potential.terms.ImproperTorsionPotentialEnergy;
import ffx.potential.terms.OutOfPlaneBendPotentialEnergy;
import ffx.potential.terms.PiOrbitalTorsionPotentialEnergy;
import ffx.potential.terms.StretchBendPotentialEnergy;
import ffx.potential.terms.TorsionPotentialEnergy;
import ffx.potential.terms.TorsionTorsionPotentialEnergy;
import ffx.potential.terms.UreyBradleyPotentialEnergy;
import ffx.utilities.FFXBinding;
import ffx.utilities.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.math3.util.FastMath;
import picocli.CommandLine;

@CommandLine.Command(description={" Test the potential energy gradient for CpHMD."}, name="test.PhGradient")
public class PhGradient
extends PotentialCommand {
    @CommandLine.Mixin
    GradientOptions gradientOptions;
    @CommandLine.Mixin
    AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Option(names={"--pH", "--constantPH"}, paramLabel="7.4", description={"Constant pH value for the test."})
    double pH = 7.4;
    @CommandLine.Option(names={"--esvLambda"}, paramLabel="0.5", description={"ESV Lambda at which to test gradient."})
    double esvLambda = 0.5;
    @CommandLine.Option(names={"--scanLambdas"}, paramLabel="false", description={"Scan titration and tautomer lambda landscape."})
    boolean scan = false;
    @CommandLine.Option(names={"--testEndStateEnergies"}, paramLabel="false", description={"Test both ESV energy end states as if the polarization damping factor is initialized from the respective protonated or deprotonated state"})
    boolean testEndstateEnergies = false;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file in PDB format."})
    String filename = null;
    private ForceFieldEnergy energy;
    public HashMap<String, double[]> endstateEnergyMap = new HashMap();
    public int nFailures = 0;
    public int nESVFailures = 0;
    public double minEnergy = 0.0;
    public String minLambdaList = "";

    public PhGradient() {
    }

    public PhGradient(FFXBinding binding) {
        super(binding);
    }

    public PhGradient(String[] args) {
        super(args);
    }

    public PhGradient run() {
        List atomsToTest;
        if (!this.init()) {
            return this;
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info("\n Testing the atomic coordinate gradient of " + this.filename + "\n");
        this.energy = this.activeAssembly.getPotentialEnergy();
        ExtendedSystem esvSystem = new ExtendedSystem(this.activeAssembly, this.pH, null);
        esvSystem.setConstantPh(this.pH);
        List<Residue> extendedResidues = esvSystem.getExtendedResidueList();
        List<Residue> titratingResidues = esvSystem.getTitratingResidueList();
        List<Residue> tautomerResidues = esvSystem.getTautomerizingResidueList();
        int numESVs = esvSystem.getExtendedResidueList().size();
        this.energy.attachExtendedSystem(esvSystem);
        logger.info(String.format(" Attached extended system with %d residues.", numESVs));
        for (Residue residue : extendedResidues) {
            esvSystem.setTitrationLambda(residue, this.esvLambda);
            esvSystem.setTautomerLambda(residue, this.esvLambda);
        }
        Atom[] atoms = this.activeAssembly.getAtomArray();
        int nAtoms = atoms.length;
        this.atomSelectionOptions.setActiveAtoms(this.activeAssembly);
        double step = this.gradientOptions.getDx();
        logger.info(" Finite-difference step size:\t" + step);
        boolean print = this.gradientOptions.getVerbose();
        logger.info(" Verbose printing:\t\t" + print);
        if (this.gradientOptions.getGradientAtoms().equalsIgnoreCase("NONE")) {
            logger.info(" The gradient of no atoms will be evaluated.");
            return this;
        }
        if (this.gradientOptions.getGradientAtoms().equalsIgnoreCase("ALL")) {
            logger.info(" Checking gradient for all active atoms.\n");
            atomsToTest = new ArrayList();
            IntStream.range(0, nAtoms).forEach(val -> atomsToTest.add(val));
        } else {
            atomsToTest = StringUtils.parseAtomRanges((String)" Gradient atoms", (String)this.gradientOptions.getGradientAtoms(), (int)nAtoms);
            logger.info(" Checking gradient for active atoms in the range: " + this.gradientOptions.getGradientAtoms() + "\n");
        }
        HashMap<Integer, Integer> allToActive = new HashMap<Integer, Integer>();
        int nActive = 0;
        for (int i = 0; i < nAtoms; ++i) {
            Atom atom = atoms[i];
            if (!atom.isActive()) continue;
            allToActive.put(i, nActive);
            ++nActive;
        }
        int n = this.energy.getNumberOfVariables();
        double[] x = new double[n];
        double[] g = new double[n];
        this.energy.getCoordinates(x);
        this.energy.energyAndGradient(x, g);
        int index = 0;
        double[][] allAnalytic = new double[nAtoms][3];
        for (Atom a : atoms) {
            a.getXYZGradient(allAnalytic[index++]);
        }
        double expGrad = 1000.0;
        double gradientTolerance = this.gradientOptions.getTolerance();
        double width = 2.0 * step;
        double avLen = 0.0;
        double avGrad = 0.0;
        double expGrad2 = expGrad * expGrad;
        int nTested = 0;
        Iterator iterator = atomsToTest.iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            Atom a0 = atoms[k];
            if (!a0.isActive()) continue;
            ++nTested;
            double[] analytic = allAnalytic[k];
            int ia = (Integer)allToActive.get(k);
            int i3 = ia * 3;
            int i0 = i3 + 0;
            int i1 = i3 + 1;
            int i2 = i3 + 2;
            double[] numeric = new double[3];
            double orig = x[i0];
            x[i0] = x[i0] + step;
            double e = this.energy.energy(x);
            x[i0] = orig - step;
            x[i0] = orig;
            numeric[0] = (e -= this.energy.energy(x)) / width;
            orig = x[i1];
            x[i1] = x[i1] + step;
            e = this.energy.energy(x);
            x[i1] = orig - step;
            x[i1] = orig;
            numeric[1] = (e -= this.energy.energy(x)) / width;
            orig = x[i2];
            x[i2] = x[i2] + step;
            e = this.energy.energy(x);
            x[i2] = orig - step;
            x[i2] = orig;
            numeric[2] = (e -= this.energy.energy(x)) / width;
            double dx = analytic[0] - numeric[0];
            double dy = analytic[1] - numeric[1];
            double dz = analytic[2] - numeric[2];
            double len = dx * dx + dy * dy + dz * dz;
            avLen += len;
            len = FastMath.sqrt((double)len);
            double grad2 = analytic[0] * analytic[0] + analytic[1] * analytic[1] + analytic[2] * analytic[2];
            avGrad += grad2;
            if (len > gradientTolerance) {
                logger.info(String.format(" %s\n Failed: %10.6f\n", a0, len) + String.format(" Analytic: (%12.4f, %12.4f, %12.4f)\n", analytic[0], analytic[1], analytic[2]) + String.format(" Numeric:  (%12.4f, %12.4f, %12.4f)\n", numeric[0], numeric[1], numeric[2]));
                ++this.nFailures;
            } else {
                logger.info(String.format(" %s\n Passed: %10.6f\n", a0, len) + String.format(" Analytic: (%12.4f, %12.4f, %12.4f)\n", analytic[0], analytic[1], analytic[2]) + String.format(" Numeric:  (%12.4f, %12.4f, %12.4f)", numeric[0], numeric[1], numeric[2]));
            }
            if (grad2 > expGrad2) {
                logger.info(String.format(" Atom %d has an unusually large gradient: %10.6f", ia + 1, Math.sqrt(grad2)));
            }
            logger.info("\n");
        }
        avLen /= (double)nTested;
        if ((avLen = FastMath.sqrt((double)avLen)) > gradientTolerance) {
            logger.info(String.format(" Test failure: RMSD from analytic solution is %10.6f > %10.6f", avLen, gradientTolerance));
        } else {
            logger.info(String.format(" Test success: RMSD from analytic solution is %10.6f < %10.6f", avLen, gradientTolerance));
        }
        logger.info(String.format(" Number of atoms failing analytic test: %d", this.nFailures));
        avGrad /= (double)nTested;
        avGrad = FastMath.sqrt((double)avGrad);
        if (avGrad > expGrad) {
            logger.info(String.format(" Unusually large RMS gradient: %10.6f > %10.6f", avGrad, expGrad));
        } else {
            logger.info(String.format(" RMS gradient: %10.6f", avGrad));
        }
        this.energy.setCoordinates(x);
        this.energy.getCoordinates(x);
        this.energy.energyAndGradient(x, g);
        double[] esvDerivs = esvSystem.getDerivatives();
        for (int i = 0; i < titratingResidues.size(); ++i) {
            double fdDerivTitr;
            double errorTitr;
            double eMinusTitr = 0.0;
            double ePlusTitr = 0.0;
            double eMinusTaut = 0.0;
            double ePlusTaut = 0.0;
            Residue residue = titratingResidues.get(i);
            int tautomerIndex = tautomerResidues.indexOf(residue) + titratingResidues.size();
            if (this.esvLambda + step > 1.0) {
                logger.info("Backward finite difference being applied. Consider using a smaller step size than the default in this case.\n");
                esvSystem.setTitrationLambda(residue, this.esvLambda - 2.0 * step);
                eMinusTitr = this.energy.energy(x);
                esvSystem.setTitrationLambda(residue, this.esvLambda);
                ePlusTitr = this.energy.energy(x);
                if (esvSystem.isTautomer(residue)) {
                    esvSystem.setTautomerLambda(residue, this.esvLambda - 2.0 * step);
                    eMinusTaut = this.energy.energy(x);
                    esvSystem.setTautomerLambda(residue, this.esvLambda);
                    ePlusTaut = this.energy.energy(x);
                }
            } else if (this.esvLambda - step < 0.0) {
                logger.info("Forward finite difference being applied. Consider using a smaller step size than the default in this case.\n");
                esvSystem.setTitrationLambda(residue, this.esvLambda + 2.0 * step);
                ePlusTitr = this.energy.energy(x);
                esvSystem.setTitrationLambda(residue, this.esvLambda);
                eMinusTitr = this.energy.energy(x);
                if (esvSystem.isTautomer(residue)) {
                    esvSystem.setTautomerLambda(residue, this.esvLambda + 2.0 * step);
                    ePlusTaut = this.energy.energy(x);
                    esvSystem.setTautomerLambda(residue, this.esvLambda);
                    eMinusTaut = this.energy.energy(x);
                }
            } else {
                esvSystem.setTitrationLambda(residue, this.esvLambda + step);
                ePlusTitr = this.energy.energy(x);
                esvSystem.setTitrationLambda(residue, this.esvLambda - step);
                eMinusTitr = this.energy.energy(x);
                esvSystem.setTitrationLambda(residue, this.esvLambda);
                if (esvSystem.isTautomer(residue)) {
                    esvSystem.setTautomerLambda(residue, this.esvLambda + step);
                    ePlusTaut = this.energy.energy(x);
                    esvSystem.setTautomerLambda(residue, this.esvLambda - step);
                    eMinusTaut = this.energy.energy(x);
                    esvSystem.setTautomerLambda(residue, this.esvLambda);
                }
            }
            if ((errorTitr = FastMath.abs((double)((fdDerivTitr = (ePlusTitr - eMinusTitr) / width) - esvDerivs[i]))) > gradientTolerance) {
                logger.info(String.format(" Residue: %s Chain: %s ESV %d\n Failed: %10.6f\n", residue.toString(), residue.getChainID(), i, errorTitr) + String.format(" Analytic: %12.4f vs. Numeric: %12.4f\n", esvDerivs[i], fdDerivTitr));
                ++this.nESVFailures;
            } else {
                logger.info(String.format(" Residue: %s Chain: %s ESV %d\n Passed: %10.6f\n", residue.toString(), residue.getChainID(), i, errorTitr) + String.format(" Analytic: %12.4f vs. Numeric: %12.4f\n", esvDerivs[i], fdDerivTitr));
            }
            if (esvSystem.isTautomer(residue)) {
                double fdDerivTaut = (ePlusTaut - eMinusTaut) / width;
                int ti = tautomerIndex;
                double errorTaut = FastMath.abs((double)(fdDerivTaut - esvDerivs[ti]));
                if (errorTaut > gradientTolerance) {
                    logger.info(String.format(" Residue: %s (Tautomer) Chain: %s ESV %d\n Failed: %10.6f\n", residue.toString(), residue.getChainID(), ti, errorTaut) + String.format(" Analytic: %12.4f vs. Numeric: %12.4f\n", esvDerivs[ti], fdDerivTaut));
                    ++this.nESVFailures;
                } else {
                    logger.info(String.format(" Residue: %s (Tautomer) Chain: %s ESV %d\n Passed: %10.6f\n", residue.toString(), residue.getChainID(), ti, errorTaut) + String.format(" Analytic: %12.4f vs. Numeric: %12.4f\n", esvDerivs[ti], fdDerivTaut));
                }
            }
            if (this.nESVFailures <= 0) continue;
            logger.info(String.format(" %d ESVs failed the gradient test.\n", this.nESVFailures));
        }
        if (this.nESVFailures == 0) {
            logger.info(" All ESVs passed the gradient test.\n");
        }
        if (this.scan) {
            for (Residue residue : esvSystem.getTitratingResidueList()) {
                esvSystem.setTitrationLambda(residue, 0.0);
                esvSystem.setTautomerLambda(residue, 0.0);
            }
            this.scanLambdas(esvSystem, this.energy, x);
            this.printPermutations(esvSystem, titratingResidues.size(), this.energy, x);
        }
        if (this.testEndstateEnergies) {
            this.testEndState(x, esvSystem, 0.0, 0.0);
            this.testEndState(x, esvSystem, 1.0, 0.0);
        }
        return this;
    }

    private void printPermutations(ExtendedSystem esvSystem, int numESVs, ForceFieldEnergy energy, double[] x) {
        for (Residue residue : esvSystem.getTitratingResidueList()) {
            esvSystem.setTitrationLambda(residue, 0.0);
        }
        energy.getCoordinates(x);
        this.printPermutationsR(esvSystem, numESVs - 1, energy, x);
        logger.info("Minimum Energy:" + this.minEnergy + " acheived with lambdas: " + this.minLambdaList);
    }

    private void printPermutationsR(ExtendedSystem esvSystem, int esvID, ForceFieldEnergy energy, double[] x) {
        for (int i = 0; i <= 1; ++i) {
            Residue residue = esvSystem.getTitratingResidueList().get(esvID);
            esvSystem.setTitrationLambda(residue, i);
            if (esvID != 0) {
                this.printPermutationsR(esvSystem, esvID - 1, energy, x);
                continue;
            }
            String lambdaList = esvSystem.getLambdaList();
            logger.info(String.format("Lambda List: %s", lambdaList));
            double stateEnergy = energy.energy(x, true);
            if (stateEnergy < this.minEnergy) {
                this.minEnergy = stateEnergy;
                this.minLambdaList = lambdaList;
            }
            logger.info("\n");
        }
    }

    private void scanLambdas(ExtendedSystem esvSystem, ForceFieldEnergy energy, double[] x) {
        int nTitrESVs = esvSystem.getTitratingResidueList().size();
        double[][][] peLandscape = new double[nTitrESVs][11][11];
        for (int i = 0; i < nTitrESVs; ++i) {
            Residue residue = esvSystem.getTitratingResidueList().get(i);
            for (int j = 0; j < 11; ++j) {
                esvSystem.setTitrationLambda(residue, (double)j / 10.0);
                for (int k = 0; k < 11; ++k) {
                    esvSystem.setTautomerLambda(residue, (double)k / 10.0);
                    peLandscape[i][j][k] = energy.energy(x, false);
                }
            }
            esvSystem.setTitrationLambda(residue, 0.0);
            esvSystem.setTautomerLambda(residue, 0.0);
        }
        StringBuilder tautomerHeader = new StringBuilder("      X\u2192 ");
        for (int k = 0; k < 11; ++k) {
            double lb = (double)k / 10.0;
            tautomerHeader.append(String.format("%1$12s", "[" + lb + "]"));
        }
        tautomerHeader.append("\n\u03bb\u2193");
        for (int i = 0; i < nTitrESVs; ++i) {
            logger.info(String.format("ESV: %d \n", i));
            logger.info(tautomerHeader.toString());
            for (int j = 0; j < 11; ++j) {
                double lb = (double)j / 10.0;
                StringBuilder histogram = new StringBuilder();
                for (int k = 0; k < 11; ++k) {
                    StringBuilder hisvalue = new StringBuilder();
                    String value = String.format("%5.4f", peLandscape[i][j][k]);
                    hisvalue.append(String.format("%1$12s", value));
                    histogram.append((CharSequence)hisvalue);
                }
                logger.info("[" + lb + "]    " + String.valueOf(histogram));
            }
            logger.info("\n");
        }
    }

    private void testEndState(double[] x, ExtendedSystem esvSystem, double titrLambda, double tautLambda) {
        TorsionTorsionPotentialEnergy torsionTorsionPotentialEnergy;
        PiOrbitalTorsionPotentialEnergy piOrbitalTorsionPotentialEnergy;
        ImproperTorsionPotentialEnergy improperTorsionPotentialEnergy;
        TorsionPotentialEnergy torsionPotentialEnergy;
        OutOfPlaneBendPotentialEnergy ofPlaneBendPotentialEnergy;
        UreyBradleyPotentialEnergy ureyBradleyPotentialEnergy;
        StretchBendPotentialEnergy stretchBendPotentialEnergy;
        AnglePotentialEnergy anglePotentialEnergy;
        for (Residue residue : esvSystem.getTitratingResidueList()) {
            esvSystem.setTitrationLambda(residue, titrLambda);
            esvSystem.setTautomerLambda(residue, tautLambda);
        }
        for (Atom atom : esvSystem.getExtendedAtoms()) {
            int atomIndex = atom.getArrayIndex();
            if (!esvSystem.isTitratingHeavy(atomIndex) || atom.getPolarizeType() == null) continue;
            double endstatePolar = esvSystem.getTitrationUtils().getPolarizability(atom, titrLambda, tautLambda, atom.getPolarizeType().polarizability);
            double sixth = 0.16666666666666666;
            atom.getPolarizeType().pdamp = FastMath.pow((double)endstatePolar, (double)sixth);
        }
        String lambdaList = esvSystem.getLambdaList();
        this.energy.setCoordinates(x);
        this.energy.getCoordinates(x);
        double stateEnergy = this.energy.energy(x, true);
        double[] energyAndInteractionList = new double[26];
        BondPotentialEnergy bondPotentialEnergy = this.energy.getBondPotentialEnergy();
        if (bondPotentialEnergy != null) {
            energyAndInteractionList[0] = bondPotentialEnergy.getEnergy();
            energyAndInteractionList[1] = bondPotentialEnergy.getNumberOfBonds();
        }
        if ((anglePotentialEnergy = this.energy.getAnglePotentialEnergy()) != null) {
            energyAndInteractionList[2] = anglePotentialEnergy.getEnergy();
            energyAndInteractionList[3] = anglePotentialEnergy.getNumberOfAngles();
        }
        if ((stretchBendPotentialEnergy = this.energy.getStretchBendPotentialEnergy()) != null) {
            energyAndInteractionList[4] = stretchBendPotentialEnergy.getEnergy();
            energyAndInteractionList[5] = stretchBendPotentialEnergy.getNumberOfStretchBends();
        }
        if ((ureyBradleyPotentialEnergy = this.energy.getUreyBradleyPotentialEnergy()) != null) {
            energyAndInteractionList[6] = ureyBradleyPotentialEnergy.getEnergy();
            energyAndInteractionList[7] = ureyBradleyPotentialEnergy.getNumberOfUreyBradleys();
        }
        if ((ofPlaneBendPotentialEnergy = this.energy.getOutOfPlaneBendPotentialEnergy()) != null) {
            energyAndInteractionList[8] = ofPlaneBendPotentialEnergy.getEnergy();
            energyAndInteractionList[9] = ofPlaneBendPotentialEnergy.getNumberOfOutOfPlaneBends();
        }
        if ((torsionPotentialEnergy = this.energy.getTorsionPotentialEnergy()) != null) {
            energyAndInteractionList[10] = torsionPotentialEnergy.getEnergy();
            energyAndInteractionList[11] = torsionPotentialEnergy.getNumberOfTorsions();
        }
        if ((improperTorsionPotentialEnergy = this.energy.getImproperTorsionPotentialEnergy()) != null) {
            energyAndInteractionList[12] = improperTorsionPotentialEnergy.getEnergy();
            energyAndInteractionList[13] = improperTorsionPotentialEnergy.getNumberOfImproperTorsions();
        }
        if ((piOrbitalTorsionPotentialEnergy = this.energy.getPiOrbitalTorsionPotentialEnergy()) != null) {
            energyAndInteractionList[14] = piOrbitalTorsionPotentialEnergy.getEnergy();
            energyAndInteractionList[15] = piOrbitalTorsionPotentialEnergy.getNumberOfPiOrbitalTorsions();
        }
        if ((torsionTorsionPotentialEnergy = this.energy.getTorsionTorsionPotentialEnergy()) != null) {
            energyAndInteractionList[16] = torsionTorsionPotentialEnergy.getEnergy();
            energyAndInteractionList[17] = torsionTorsionPotentialEnergy.getNumberOfTorsionTorsions();
        }
        energyAndInteractionList[18] = this.energy.getVanDerWaalsEnergy();
        energyAndInteractionList[19] = this.energy.getVanDerWaalsInteractions();
        energyAndInteractionList[20] = this.energy.getPermanentMultipoleEnergy();
        energyAndInteractionList[21] = this.energy.getPermanentInteractions();
        energyAndInteractionList[22] = this.energy.getPolarizationEnergy();
        energyAndInteractionList[23] = this.energy.getPermanentInteractions();
        energyAndInteractionList[24] = this.energy.getEsvBiasEnergy();
        energyAndInteractionList[25] = this.energy.getTotalEnergy();
        this.endstateEnergyMap.put(lambdaList, energyAndInteractionList);
    }

    @Override
    public List<Potential> getPotentials() {
        List<Object> potentials = this.energy == null ? Collections.emptyList() : Collections.singletonList(this.energy);
        return potentials;
    }
}

