/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import edu.rit.pj.ParallelTeam;
import ffx.potential.bonded.Atom;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.nonbonded.implicit.ConnollyRegion;
import ffx.potential.nonbonded.implicit.GaussVol;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXBinding;
import org.apache.commons.math3.util.FastMath;
import picocli.CommandLine;

@CommandLine.Command(name="Volume", description={" Calculate the surface area and volume using the GaussVol (default) or Connolly algorithm."})
public class Volume
extends PotentialCommand {
    private static final double rminToSigma = 1.0 / FastMath.pow((double)2.0, (double)0.16666666666666666);
    @CommandLine.Option(names={"-c", "--connolly"}, paramLabel="false", description={"Use the Connolly algorithm to compute solvent excluded volume and solvent accessible surface area."})
    private boolean connolly = false;
    @CommandLine.Option(names={"-m", "--molecular"}, paramLabel="false", description={"For Connolly, compute molecular volume and surface area (instead of SEV/SASA)."})
    private boolean molecular = false;
    @CommandLine.Option(names={"--vdW", "--vanDerWaals"}, paramLabel="false", description={"For Connolly, compute van der Waals volume and surface area (instead of SEV/SASA)"})
    private boolean vdW = false;
    @CommandLine.Option(names={"-p", "--probe"}, paramLabel="1.4", description={"For Connolly, set the exclude radius (SASA) or probe radius (molecular surface). Ignored for vdW."})
    private double probe = 1.4;
    @CommandLine.Option(names={"-y", "--includeHydrogen"}, paramLabel="false", description={"Include Hydrogen in calculation volume and surface area."})
    private boolean includeHydrogen = false;
    @CommandLine.Option(names={"-s", "--sigma"}, paramLabel="false", description={"Use sigma radii instead of Rmin."})
    private boolean sigma = false;
    @CommandLine.Option(names={"-o", "--offset"}, paramLabel="0.0", description={"Add an offset to all atomic radii for GaussVol volume and surface area."})
    private double offset = 0.0;
    @CommandLine.Option(names={"-v", "--verbose"}, paramLabel="false", description={"Print out all components of volume of molecule and offset."})
    private boolean verbose = false;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file in PDB or XYZ format."})
    private String filename = null;
    public double totalVolume = 0.0;
    public double totalSurfaceArea = 0.0;

    public Volume() {
    }

    public Volume(FFXBinding binding) {
        super(binding);
    }

    public Volume(String[] args) {
        super(args);
    }

    public Volume run() {
        if (!this.init()) {
            return this;
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info("\n Calculating volume and surface area for " + this.filename);
        Atom[] atoms = this.activeAssembly.getAtomArray();
        int nAtoms = atoms.length;
        if (!this.connolly) {
            double[][] positions = new double[nAtoms][3];
            int index = 0;
            for (Atom atom : atoms) {
                positions[index][0] = atom.getX();
                positions[index][1] = atom.getY();
                positions[index][2] = atom.getZ();
                ++index;
            }
            ForceField forceField = this.activeAssembly.getForceField();
            if (this.includeHydrogen) {
                forceField.addProperty("GAUSSVOL_HYDROGEN", "true");
            }
            if (this.sigma) {
                forceField.addProperty("GAUSSVOL_USE_SIGMA", "true");
            }
            if (this.offset > 0.0) {
                forceField.addProperty("GAUSSVOL_RADII_OFFSET", Double.toString(this.offset));
            }
            if (!forceField.hasProperty("GAUSSVOL_RADII_SCALE")) {
                forceField.addProperty("GAUSSVOL_RADII_SCALE", Double.toString(1.0));
            }
            ParallelTeam parallelTeam = new ParallelTeam();
            GaussVol gaussVol = new GaussVol(atoms, this.activeAssembly.getForceField(), parallelTeam);
            long time = -System.nanoTime();
            gaussVol.computeVolumeAndSA(positions);
            time += System.nanoTime();
            if (this.verbose) {
                logger.info(String.format("\n Maximum depth of overlaps in tree: %d", gaussVol.getMaximumDepth()));
                logger.info(String.format(" Total number of overlaps in tree: %d", gaussVol.getTotalNumberOfOverlaps()));
                double[] radii = gaussVol.getRadii();
                index = 0;
                for (Atom atom : atoms) {
                    logger.info(String.format(" %5d %4s: %6.4f", index, atom.getName(), radii[index]));
                    ++index;
                }
            }
            logger.info("\n GaussVol Surface Area and Volume\n");
            if (this.sigma) {
                logger.info(String.format("  Radii:                  Sigma", new Object[0]));
            } else {
                logger.info(String.format("  Radii:                   Rmin", new Object[0]));
            }
            logger.info(String.format("  Radii offset:        %8.4f (Ang)", this.offset));
            logger.info(String.format("  Include hydrogen:    %8b", this.includeHydrogen));
            logger.info(String.format("  Volume:            %10.4f (Ang^3)", gaussVol.getVolume()));
            logger.info(String.format("  Surface Area:      %10.4f (Ang^2)", gaussVol.getSurfaceArea()));
            logger.info(String.format("  Time:              %10.4f (sec)", (double)time * 1.0E-9));
            this.totalVolume = gaussVol.getVolume();
            this.totalSurfaceArea = gaussVol.getSurfaceArea();
        } else {
            double exclude = 0.0;
            if (this.vdW) {
                exclude = 0.0;
                this.probe = 0.0;
            } else if (!this.molecular) {
                exclude = this.probe;
                this.probe = 0.0;
            }
            double[] radii = new double[nAtoms];
            int index = 0;
            for (Atom atom : atoms) {
                radii[index] = atom.getVDWType().radius / 2.0;
                if (this.sigma) {
                    int n = index;
                    radii[n] = radii[n] * rminToSigma;
                }
                boolean hydrogen = atom.isHydrogen();
                if (!this.includeHydrogen && hydrogen) {
                    radii[index] = 0.0;
                }
                ++index;
            }
            int nThreads = 1;
            ConnollyRegion connollyRegion = new ConnollyRegion(atoms, radii, nThreads);
            connollyRegion.setExclude(exclude);
            connollyRegion.setProbe(this.probe);
            long time = -System.nanoTime();
            connollyRegion.runVolume();
            time += System.nanoTime();
            double zero = 0.0;
            if (this.vdW || this.probe == zero && exclude == zero) {
                logger.info("\n Connolly van der Waals Surface Area and Volume\n");
            } else if (!this.molecular) {
                logger.info("\n Connolly Solvent Accessible Surface Area and Solvent Excluded Volume\n");
                logger.info(String.format("  Exclude radius:      %8.4f (Ang)", exclude));
            } else {
                logger.info("\n Connolly Molecular Surface Area and Volume");
                logger.info(String.format("  Probe radius:       %8.4f (Ang)", this.probe));
            }
            if (this.sigma) {
                logger.info(String.format("  Radii:                  Sigma", new Object[0]));
            } else {
                logger.info(String.format("  Radii:                   Rmin", new Object[0]));
            }
            logger.info(String.format("  Include hydrogen:    %8b", this.includeHydrogen));
            logger.info(String.format("  Volume:            %10.4f (Ang^3)", connollyRegion.getVolume()));
            logger.info(String.format("  Surface Area:      %10.4f (Ang^2)", connollyRegion.getSurfaceArea()));
            logger.info(String.format("  Time:              %10.4f (sec)", (double)time * 1.0E-9));
            this.totalVolume = connollyRegion.getVolume();
            this.totalSurfaceArea = connollyRegion.getSurfaceArea();
        }
        return this;
    }
}

