/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.crystal.SymOp;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.cli.SaveOptions;
import ffx.potential.parameters.ForceField;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.utilities.FFXBinding;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(name="SaveAsXYZ", description={" Save the system as an XYZ file."})
public class SaveAsXYZ
extends PotentialCommand {
    @CommandLine.Mixin
    private SaveOptions saveOptions = new SaveOptions();
    @CommandLine.Option(names={"-p", "--pos-offset"}, paramLabel="0", description={"Positive offset of atom types in the new file"})
    private int posOffset = 0;
    @CommandLine.Option(names={"-n", "--neg-offset"}, paramLabel="0", description={"Negative offset of atom types in the new file."})
    private int negOffset = 0;
    @CommandLine.Option(names={"-r", "--random"}, paramLabel="X", description={"Apply a random Cartesian SymOp with translation range -X .. X."})
    private double scalar = -1.0;
    @CommandLine.Option(names={"--fs", "--firstSnapshot"}, paramLabel="-1", defaultValue="-1", description={"First snapshot to write out (indexed from 0)."})
    private int firstSnapshot = -1;
    @CommandLine.Option(names={"--ls", "--lastSnapshot"}, paramLabel="-1", defaultValue="-1", description={"Last snapshot to write out (indexed from 0)."})
    private int lastSnapshot = -1;
    @CommandLine.Option(names={"--si", "--snapshotIncrement"}, paramLabel="1", defaultValue="1", description={"Increment between written snapshots."})
    private int snapshotIncrement = 1;
    @CommandLine.Option(names={"--wd", "--writeToDirectories"}, paramLabel="false", defaultValue="false", description={"Write snapshots to numbered subdirectories."})
    private boolean writeToDirectories = false;
    @CommandLine.Option(names={"--alt", "--alternateLocation"}, paramLabel="A", defaultValue="A", description={"Choose an alternate location for the PDB file (not supported for PDBs with multiple models."})
    private Character alternateLocation = Character.valueOf('A');
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file PDB format."})
    private String filename = null;

    public SaveAsXYZ() {
    }

    public SaveAsXYZ(FFXBinding binding) {
        super(binding);
    }

    public SaveAsXYZ(String[] args) {
        super(args);
    }

    public SaveAsXYZ run() {
        if (!this.init()) {
            return this;
        }
        MolecularAssembly[] molecularAssemblies = this.getActiveAssemblies(this.filename);
        if (molecularAssemblies == null) {
            logger.info(this.helpString());
            return this;
        }
        if (molecularAssemblies.length > 1) {
            Character currentAltLoc = this.activeAssembly.getAlternateLocation();
            logger.info("\n Current alternate location: " + currentAltLoc);
            if (!currentAltLoc.equals(this.alternateLocation)) {
                for (MolecularAssembly molecularAssembly : molecularAssemblies) {
                    Character altLoc = molecularAssembly.getAlternateLocation();
                    if (!altLoc.equals(this.alternateLocation)) continue;
                    this.activeAssembly = molecularAssembly;
                    logger.info(" Switching to alternate location: " + altLoc);
                    break;
                }
            }
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        SystemFilter openFilter = this.potentialFunctions.getFilter();
        int numModels = openFilter.countNumModels();
        int offset = 0;
        if (this.posOffset > 0) {
            offset = this.posOffset;
        }
        if (this.negOffset > 0) {
            offset = -this.negOffset;
        }
        if (offset != 0) {
            logger.info("\n Offset atom types by " + offset);
            ForceField forceField = this.activeAssembly.getForceField();
            forceField.renumberForceField(0, offset, 0);
        }
        if (this.scalar > 0.0) {
            SymOp symOp = SymOp.randomSymOpFactory((double)this.scalar);
            logger.info(String.format("\n Applying random Cartesian SymOp\n: %s", symOp));
            Atom[] atoms = this.activeAssembly.getAtomArray();
            double[] xyz = new double[3];
            for (Atom atom : atoms) {
                atom.getXYZ(xyz);
                SymOp.applyCartesianSymOp((double[])xyz, (double[])xyz, (SymOp)symOp);
                atom.setXYZ(xyz);
            }
        }
        String dirString = this.getBaseDirString(this.filename);
        Object name = FilenameUtils.getName((String)this.filename);
        if (this.firstSnapshot >= 0) {
            XYZFilter snapshotFilter = new XYZFilter(new File(dirString + (String)name), this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
            openFilter.readNext(true);
            int counter = 0;
            int snapshotCounter = 0;
            logger.info(" Writing snapshots from " + this.firstSnapshot + " to " + this.lastSnapshot + " with increment " + this.snapshotIncrement);
            boolean reset = true;
            while (openFilter.readNext(reset)) {
                reset = false;
                int counterOffset = counter - this.firstSnapshot;
                if (counter >= this.firstSnapshot && (this.lastSnapshot < 0 || counter <= this.lastSnapshot) && counterOffset % this.snapshotIncrement == 0) {
                    File snapshotFile;
                    if (this.writeToDirectories) {
                        String subdirectory = FilenameUtils.concat((String)dirString, (String)Integer.toString(snapshotCounter));
                        new File(subdirectory).mkdirs();
                        snapshotFile = new File(FilenameUtils.concat((String)subdirectory, (String)name));
                    } else {
                        snapshotFile = new File(FilenameUtils.concat((String)dirString, (String)(FilenameUtils.removeExtension((String)name) + "." + counter + ".xyz")));
                    }
                    this.potentialFunctions.versionFile(snapshotFile);
                    this.saveOptions.preSaveOperations(this.activeAssembly);
                    logger.info("\n Writing out XYZ for " + String.valueOf(snapshotFile));
                    snapshotFilter.writeFile(snapshotFile, true);
                    ++snapshotCounter;
                }
                ++counter;
            }
            return this;
        }
        logger.info("\n Writing out XYZ for " + this.filename);
        if (numModels <= 1) {
            name = FilenameUtils.removeExtension((String)name) + ".xyz";
            saveFile = new File(dirString + (String)name);
            this.saveOptions.preSaveOperations(this.activeAssembly);
            this.potentialFunctions.save(this.activeAssembly, saveFile);
        } else {
            name = FilenameUtils.removeExtension((String)name) + ".arc";
            saveFile = new File(dirString + (String)name);
            saveFile = this.potentialFunctions.versionFile(saveFile);
            this.saveOptions.preSaveOperations(this.activeAssembly);
            this.potentialFunctions.save(this.activeAssembly, saveFile);
            XYZFilter saveFilter = (XYZFilter)this.potentialFunctions.getFilter();
            while (openFilter.readNext(false)) {
                this.saveOptions.preSaveOperations(this.activeAssembly);
                saveFilter.writeFile(saveFile, true);
            }
        }
        return this;
    }
}

