/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.potential.cli.PotentialCommand;
import ffx.potential.cli.SaveOptions;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.utils.PotentialsUtils;
import ffx.utilities.FFXBinding;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(name="SaveAsP1", description={" Expand the system to P1 and then save it."})
public class SaveAsP1
extends PotentialCommand {
    @CommandLine.Mixin
    private SaveOptions saveOptions = new SaveOptions();
    @CommandLine.Option(names={"--lmn", "--replicatesVector"}, paramLabel="", defaultValue="", description={"Dimension of replicates crystal (e.g., \"2,2,2\" for a 2 x 2 x 2)."})
    private String lmn = "";
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file in PDB or XYZ format."})
    private String filename = null;

    public SaveAsP1() {
    }

    public SaveAsP1(FFXBinding binding) {
        super(binding);
    }

    public SaveAsP1(String[] args) {
        super(args);
    }

    public SaveAsP1 run() {
        boolean noReplicate;
        if (!this.init()) {
            return this;
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info("\n Expanding to P1 for " + this.filename);
        String dirString = this.getBaseDirString(this.filename);
        String name = FilenameUtils.getName((String)this.filename);
        String ext = FilenameUtils.getExtension((String)name);
        name = FilenameUtils.removeExtension((String)name);
        String[] tokens = this.lmn.trim().replaceAll(" +", "").split(",");
        int numTokens = tokens.length;
        int[] replicatesVector = new int[3];
        if (numTokens == 0 || numTokens == 1 && tokens[0].isEmpty()) {
            noReplicate = true;
        } else if (numTokens == 1) {
            noReplicate = false;
            replicatesVector[0] = Integer.parseInt(tokens[0]);
            replicatesVector[1] = Integer.parseInt(tokens[0]);
            replicatesVector[2] = Integer.parseInt(tokens[0]);
        } else if (numTokens == 3) {
            noReplicate = false;
            replicatesVector[0] = Integer.parseInt(tokens[0]);
            replicatesVector[1] = Integer.parseInt(tokens[1]);
            replicatesVector[2] = Integer.parseInt(tokens[2]);
        } else {
            logger.warning(" Replicates indices could not be parsed (should be a comma separated list of integers). Saving as P1.");
            noReplicate = true;
        }
        if (ext.toUpperCase().contains("XYZ")) {
            File saveLocation = SystemFilter.version(new File(dirString + name + ".xyz"));
            logger.info(" Saving P1 file to: " + String.valueOf(saveLocation));
            if (noReplicate) {
                this.potentialFunctions.saveAsXYZinP1(this.activeAssembly, saveLocation);
            } else {
                this.potentialFunctions.saveAsXYZasReplicates(this.activeAssembly, saveLocation, replicatesVector);
            }
        } else {
            File saveLocation = SystemFilter.version(new File(dirString + name + ".pdb"));
            logger.info(" Saving symmetry mates file to: " + String.valueOf(saveLocation));
            if (noReplicate) {
                this.potentialFunctions.saveAsPDBinP1(this.activeAssembly, saveLocation);
            } else if (this.potentialFunctions instanceof PotentialsUtils) {
                ((PotentialsUtils)this.potentialFunctions).saveAsPDBinP1(this.activeAssembly, saveLocation, replicatesVector);
            }
        }
        return this;
    }
}

