/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.cli.PotentialCommand;
import ffx.utilities.FFXBinding;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="MoveIntoUnitCell", description={" Move all molecules into the unit cell."})
public class MoveIntoUnitCell
extends PotentialCommand {
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file in PDB or XYZ format."})
    private String filename = null;
    protected MolecularAssembly[] molecularAssemblies = null;
    public double[][] origCoordinates = null;
    public double[][] unitCellCoordinates = null;

    public MoveIntoUnitCell() {
    }

    public MoveIntoUnitCell(FFXBinding binding) {
        super(binding);
    }

    public MoveIntoUnitCell(String[] args) {
        super(args);
    }

    public MoveIntoUnitCell run() {
        if (!this.init()) {
            return this;
        }
        this.molecularAssemblies = this.getActiveAssemblies(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info("\n Moving molecular centers of mass into the unit cell for " + this.filename + "\n");
        for (MolecularAssembly molecularAssembly : this.molecularAssemblies) {
            Atom atom;
            int index;
            Atom[] atoms = molecularAssembly.getAtomArray();
            int nAtoms = atoms.length;
            this.origCoordinates = new double[nAtoms][3];
            this.unitCellCoordinates = new double[nAtoms][3];
            for (index = 0; index < nAtoms; ++index) {
                atom = atoms[index];
                this.origCoordinates[index][0] = atom.getX();
                this.origCoordinates[index][1] = atom.getY();
                this.origCoordinates[index][2] = atom.getZ();
            }
            molecularAssembly.moveAllIntoUnitCell();
            for (index = 0; index < nAtoms; ++index) {
                atom = atoms[index];
                this.unitCellCoordinates[index][0] = atom.getX();
                this.unitCellCoordinates[index][1] = atom.getY();
                this.unitCellCoordinates[index][2] = atom.getZ();
            }
        }
        this.saveByOriginalExtension(this.molecularAssemblies, this.filename);
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        return this.getPotentialsFromAssemblies(this.molecularAssemblies);
    }
}

