/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.crystal.Crystal;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.cli.PotentialCommand;
import ffx.utilities.FFXBinding;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="Frac2Cart", description={" Convert from fractional to Cartesian coordinates."})
public class Frac2Cart
extends PotentialCommand {
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The atomic coordinate file in PDB or XYZ format."})
    private String filename = null;
    private MolecularAssembly[] molecularAssemblies;
    private double[][] cartCoordinates = null;
    private double[][] fracCoordinates = null;

    public Frac2Cart() {
    }

    public Frac2Cart(FFXBinding binding) {
        super(binding);
    }

    public Frac2Cart(String[] args) {
        super(args);
    }

    public double[][] getCart() {
        return this.cartCoordinates;
    }

    public double[][] getFrac() {
        return this.fracCoordinates;
    }

    public Frac2Cart run() {
        if (!this.init()) {
            return this;
        }
        this.molecularAssemblies = this.getActiveAssemblies(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info("\n Converting from fractional to Cartesian coordinates for " + this.filename);
        for (MolecularAssembly ma : this.molecularAssemblies) {
            Crystal crystal = ma.getCrystal().getUnitCell();
            Atom[] atoms = ma.getAtomArray();
            int nAtoms = atoms.length;
            this.fracCoordinates = new double[nAtoms][3];
            this.cartCoordinates = new double[nAtoms][3];
            double[] frac = new double[3];
            double[] cart = new double[3];
            for (int index = 0; index < nAtoms; ++index) {
                Atom atom = atoms[index];
                atom.getXYZ(frac);
                crystal.toCartesianCoordinates(frac, cart);
                boolean active = atom.isActive();
                atom.setActive(true);
                atom.moveTo(cart);
                atom.setActive(active);
                this.cartCoordinates[index][0] = cart[0];
                this.cartCoordinates[index][1] = cart[1];
                this.cartCoordinates[index][2] = cart[2];
                this.fracCoordinates[index][0] = frac[0];
                this.fracCoordinates[index][1] = frac[1];
                this.fracCoordinates[index][2] = frac[2];
            }
        }
        this.saveByOriginalExtension(this.molecularAssemblies, this.filename);
        this.binding.setVariable("cart", (Object)this.cartCoordinates);
        this.binding.setVariable("frac", (Object)this.fracCoordinates);
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        return this.getPotentialsFromAssemblies(this.molecularAssemblies);
    }
}

