/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.potential.cli.PotentialCommand;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.io.FastaReaderHelper;
import org.biojava.nbio.core.sequence.io.FastaWriterHelper;
import picocli.CommandLine;

@CommandLine.Command(name="Fasta", description={" Fasta outputs a sub-sequence from a FASTA file."})
public class Fasta
extends PotentialCommand {
    @CommandLine.Option(names={"-f", "--firstResidue"}, paramLabel="1", defaultValue="1", description={"Define the first Fasta residue to keep (index of the first residue is 1)."})
    private int firstResidue = 1;
    @CommandLine.Option(names={"-l", "--lastResidue"}, paramLabel="-1", defaultValue="-1", description={"Define the last Fasta residue to keep (index of the last residue is n)."})
    private int lastResidue = -1;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"A file in FASTA format."})
    private String fastaName = null;

    public Fasta() {
    }

    public Fasta(FFXBinding binding) {
        super(binding);
    }

    public Fasta(String[] args) {
        super(args);
    }

    public Fasta run() {
        if (!this.init()) {
            return this;
        }
        if (this.fastaName == null) {
            logger.info(this.helpString());
            return this;
        }
        logger.info("\n Opening FASTA " + this.fastaName);
        try {
            Map fastaData = FastaReaderHelper.readFastaProteinSequence((File)new File(this.fastaName));
            if (fastaData == null || fastaData.isEmpty()) {
                logger.warning(" No sequences found in FASTA file: " + this.fastaName);
                return this;
            }
            ProteinSequence sequence = (ProteinSequence)fastaData.values().iterator().next();
            String seq = sequence.getSequenceAsString();
            int length = seq.length();
            logger.info(String.format("\n %s of length: %d\n %s", sequence.getOriginalHeader(), length, seq));
            if (this.firstResidue < 1 || this.firstResidue > length) {
                this.firstResidue = 1;
            }
            if (this.lastResidue < this.firstResidue || this.lastResidue > length) {
                this.lastResidue = length;
            }
            ProteinSequence proteinSequence = new ProteinSequence(seq.substring(this.firstResidue - 1, this.lastResidue));
            proteinSequence.setOriginalHeader(sequence.getOriginalHeader());
            length = proteinSequence.getLength();
            logger.info(String.format("\n New sequence from residue %d to residue %d is of length %d: \n %s", this.firstResidue, this.lastResidue, length, proteinSequence));
            ArrayList<ProteinSequence> proteinSequenceCollection = new ArrayList<ProteinSequence>();
            proteinSequenceCollection.add(proteinSequence);
            String dirString = this.getBaseDirString(this.fastaName);
            File saveFile = this.potentialFunctions.versionFile(new File(dirString + FilenameUtils.getName((String)this.fastaName)));
            logger.info(String.format("\n Saving new Fasta file to: %s", saveFile.getAbsolutePath()));
            FastaWriterHelper.writeProteinSequence((File)saveFile, proteinSequenceCollection);
        }
        catch (Exception e) {
            logger.warning(" Exception processing FASTA file: " + e.getMessage());
        }
        return this;
    }
}

