/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.potential.cli.PotentialCommand;
import ffx.potential.parameters.ForceField;
import ffx.potential.parsers.ForceFieldFilter;
import ffx.potential.parsers.OpenMMXmlFilter;
import ffx.utilities.FFXBinding;
import ffx.utilities.Keyword;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(name="FFtoXML", description={" Write a force field as an XML file."})
public class FFtoXML
extends PotentialCommand {
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"The force field file."})
    private String filename = null;

    public FFtoXML() {
    }

    public FFtoXML(FFXBinding binding) {
        super(binding);
    }

    public FFtoXML(String[] args) {
        super(args);
    }

    public FFtoXML run() {
        if (!this.init()) {
            return this;
        }
        CompositeConfiguration props = Keyword.loadProperties(null);
        props.setProperty("parameters", (Object)this.filename);
        ForceFieldFilter forceFieldFilter = new ForceFieldFilter(props);
        ForceField forceField = forceFieldFilter.parse();
        String saveName = this.getBaseDirString(this.filename) + FilenameUtils.removeExtension((String)FilenameUtils.getName((String)this.filename));
        OpenMMXmlFilter xmlFilter = new OpenMMXmlFilter(forceField, saveName);
        try {
            xmlFilter.toXML();
        }
        catch (Exception e) {
            logger.severe(" Error writing XML: " + e.getMessage());
        }
        return this;
    }
}

