/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.crystal.Crystal;
import ffx.numerics.Potential;
import ffx.potential.AssemblyState;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.bonded.Torsion;
import ffx.potential.cli.AlchemicalOptions;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.cli.TopologyOptions;
import ffx.potential.parsers.PDBFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.potential.utils.StructureMetrics;
import ffx.utilities.FFXBinding;
import ffx.utilities.StringUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import java.util.logging.Level;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(name="Energy", description={" Compute the force field potential energy."})
public class Energy
extends PotentialCommand {
    @CommandLine.Mixin
    private AtomSelectionOptions atomSelectionOptions = new AtomSelectionOptions();
    @CommandLine.Mixin
    private AlchemicalOptions alchemicalOptions = new AlchemicalOptions();
    @CommandLine.Mixin
    private TopologyOptions topologyOptions = new TopologyOptions();
    @CommandLine.Option(names={"-m", "--moments"}, paramLabel="false", defaultValue="false", description={"Print out electrostatic moments."})
    private boolean moments = false;
    @CommandLine.Option(names={"--rg", "--gyrate"}, paramLabel="false", defaultValue="false", description={"Print out the radius of gyration."})
    private boolean gyrate = false;
    @CommandLine.Option(names={"--in", "--inertia"}, paramLabel="false", defaultValue="false", description={"Print out the moments of inertia."})
    private boolean inertia = false;
    @CommandLine.Option(names={"-g", "--gradient"}, paramLabel="false", defaultValue="false", description={"Compute the atomic gradient as well as energy."})
    private boolean gradient = false;
    @CommandLine.Option(names={"--fl", "--findLowest"}, paramLabel="0", defaultValue="0", description={"Return the n lowest energies from an ARC/PDB file."})
    private int fl = 0;
    @CommandLine.Option(names={"-v", "--verbose"}, paramLabel="false", defaultValue="false", description={"Print out all energy components for each snapshot."})
    private boolean verbose = false;
    @CommandLine.Option(names={"--dc", "--densityCutoff"}, paramLabel="0.0", defaultValue="0.0", description={"Create ARC file of structures above a specified density."})
    private double dCutoff = 0.0;
    @CommandLine.Option(names={"--ec", "--energyCutoff"}, paramLabel="0.0", defaultValue="0.0", description={"Create ARC file of structures within a specified energy of the lowest energy structure."})
    private double eCutoff = 0.0;
    @CommandLine.Option(names={"--pd", "--printDihedral"}, paramLabel="", defaultValue="", description={"Atom indices to print dihedral angle values."})
    private String dihedralAtoms = "";
    @CommandLine.Option(names={"--pb", "--printBondedTerms"}, paramLabel="", defaultValue="false", description={"Print all bonded energy terms."})
    private boolean printBondedTerms = false;
    @CommandLine.Parameters(arity="1..4", paramLabel="file", description={"The atomic coordinate file in PDB or XYZ format."})
    private List<String> filenames = null;
    public double energy = 0.0;
    public ForceFieldEnergy forceFieldEnergy = null;
    private AssemblyState assemblyState = null;
    private Potential potential;
    MolecularAssembly[] topologies;

    public Energy() {
    }

    public Energy(FFXBinding binding) {
        super(binding);
    }

    public Energy(String[] args) {
        super(args);
    }

    public Energy run() {
        SystemFilter systemFilter;
        LambdaInterface linter;
        if (!this.init()) {
            return this;
        }
        int numTopologies = this.topologyOptions.getNumberOfTopologies(this.filenames);
        int threadsPerTopology = this.topologyOptions.getThreadsPerTopology(numTopologies);
        this.topologies = new MolecularAssembly[numTopologies];
        this.alchemicalOptions.setAlchemicalProperties();
        this.topologyOptions.setAlchemicalProperties(numTopologies);
        if (this.filenames == null || this.filenames.isEmpty()) {
            this.activeAssembly = this.getActiveAssembly(this.filenames);
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.filenames = new ArrayList<String>();
            this.filenames.add(this.activeAssembly.getFile().getName());
            this.topologies[0] = this.alchemicalOptions.processFile(this.topologyOptions, this.activeAssembly, 0);
        } else {
            logger.info(String.format(" Initializing %d topologies...", numTopologies));
            for (int i = 0; i < numTopologies; ++i) {
                this.topologies[i] = this.alchemicalOptions.openFile(this.potentialFunctions, this.topologyOptions, threadsPerTopology, this.filenames.get(i), i);
            }
            this.activeAssembly = this.topologies[0];
        }
        if (this.topologies.length == 1) {
            this.atomSelectionOptions.setActiveAtoms(this.topologies[0]);
        }
        StringBuilder sb = new StringBuilder("\n Calculating energy of ");
        this.potential = this.topologyOptions.assemblePotential(this.topologies, sb);
        logger.info(sb.toString());
        LambdaInterface lambdaInterface = linter = this.potential instanceof LambdaInterface ? (LambdaInterface)this.potential : null;
        if (linter != null) {
            linter.setLambda(this.alchemicalOptions.getInitialLambda());
        }
        String filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info("\n Running Energy on " + filename);
        this.forceFieldEnergy = this.activeAssembly.getPotentialEnergy();
        int nVars = this.potential.getNumberOfVariables();
        double[] x = new double[nVars];
        this.potential.getCoordinates(x);
        if (this.gradient) {
            double[] g = new double[nVars];
            int nAts = nVars / 3;
            this.energy = this.potential.energyAndGradient(x, g, true);
            logger.info(String.format("    Atom       X, Y and Z Gradient Components (kcal/mol/A)", new Object[0]));
            for (int i = 0; i < nAts; ++i) {
                int i3 = 3 * i;
                logger.info(String.format(" %7d %16.8f %16.8f %16.8f", i + 1, g[i3], g[i3 + 1], g[i3 + 2]));
            }
        } else {
            this.energy = this.potential.energy(x, true);
        }
        if (this.moments) {
            this.forceFieldEnergy.getPmeNode().computeMoments(this.activeAssembly.getActiveAtomArray(), false);
        }
        if (this.gyrate) {
            double rg = StructureMetrics.radiusOfGyration(this.activeAssembly.getActiveAtomArray());
            logger.info(String.format(" Radius of gyration:           %10.5f A", rg));
        }
        if (this.inertia) {
            StructureMetrics.momentsOfInertia(this.activeAssembly.getActiveAtomArray(), false, true, true);
        }
        ArrayList<Integer> unique = null;
        if (this.dihedralAtoms != null && !this.dihedralAtoms.isEmpty()) {
            unique = new ArrayList<Integer>(StringUtils.parseAtomRanges((String)"Dihedral Atoms", (String)this.dihedralAtoms, (int)this.activeAssembly.getAtomList().size()));
            Energy.printDihedral(this.activeAssembly, unique);
        }
        if (this.printBondedTerms) {
            this.forceFieldEnergy.logBondedTermsAndRestraints();
        }
        if ((systemFilter = this.potentialFunctions.getFilter()) instanceof XYZFilter || systemFilter instanceof PDBFilter) {
            File saveFile;
            String name;
            int numSnaps = this.fl;
            double lowestEnergy = this.energy;
            this.assemblyState = new AssemblyState(this.activeAssembly);
            int index = 1;
            PriorityQueue lowestEnergyQueue = null;
            if (this.fl > 0) {
                lowestEnergyQueue = new PriorityQueue(numSnaps, Collections.reverseOrder());
                lowestEnergyQueue.add(new StateContainer(this.assemblyState, lowestEnergy));
            }
            int numModels = systemFilter.countNumModels();
            double[] densities = new double[numModels];
            double[] energies = new double[numModels];
            energies[0] = this.energy;
            while (systemFilter.readNext()) {
                Crystal crystal = this.activeAssembly.getCrystal();
                densities[++index - 1] = crystal.getDensity(this.activeAssembly.getMass());
                this.forceFieldEnergy.setCrystal(crystal);
                this.forceFieldEnergy.getCoordinates(x);
                if (this.verbose) {
                    logger.info(String.format(" Snapshot %4d", index));
                    if (!crystal.aperiodic()) {
                        logger.info(String.format("\n Density:                                %6.3f (g/cc)", crystal.getDensity(this.activeAssembly.getMass())));
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(crystal.toString());
                        }
                    }
                    this.energy = this.forceFieldEnergy.energy(x, true);
                } else {
                    this.energy = this.forceFieldEnergy.energy(x, false);
                    logger.info(String.format(" Snapshot %4d: %16.8f (kcal/mol)", index, this.energy));
                }
                energies[index - 1] = this.energy;
                if (this.energy < lowestEnergy) {
                    lowestEnergy = this.energy;
                }
                if (this.fl > 0) {
                    StateContainer sc = new StateContainer(new AssemblyState(this.activeAssembly), this.energy);
                    if (lowestEnergyQueue.size() < numSnaps) {
                        lowestEnergyQueue.add(sc);
                    } else {
                        StateContainer worst = (StateContainer)lowestEnergyQueue.peek();
                        if (worst != null && this.energy < worst.getEnergy()) {
                            lowestEnergyQueue.poll();
                            lowestEnergyQueue.add(sc);
                        }
                    }
                }
                if (this.moments) {
                    this.forceFieldEnergy.getPmeNode().computeMoments(this.activeAssembly.getActiveAtomArray(), false);
                }
                if (this.gyrate) {
                    double rg = StructureMetrics.radiusOfGyration(this.activeAssembly.getActiveAtomArray());
                    logger.info(String.format(" Radius of gyration:          %10.5f A", rg));
                }
                if (this.inertia) {
                    StructureMetrics.momentsOfInertia(this.activeAssembly.getActiveAtomArray(), false, true, true);
                }
                if (this.dihedralAtoms != null && !this.dihedralAtoms.isEmpty()) {
                    Energy.printDihedral(this.activeAssembly, unique);
                }
                if (!this.printBondedTerms) continue;
                this.forceFieldEnergy.logBondedTermsAndRestraints();
            }
            String dirString = this.getBaseDirString(filename);
            if ((this.eCutoff > 0.0 || this.dCutoff > 0.0) && numModels > 1) {
                SystemFilter writeFilter;
                systemFilter.readNext(true);
                this.activeAssembly = systemFilter.getActiveMolecularSystem();
                name = FilenameUtils.getName((String)filename);
                String ext = FilenameUtils.getExtension((String)name);
                name = FilenameUtils.removeExtension((String)name);
                if (ext.toUpperCase().contains("XYZ")) {
                    saveFile = new File(dirString + name + ".xyz");
                    writeFilter = new XYZFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
                    this.potentialFunctions.saveAsXYZ(this.activeAssembly, saveFile);
                } else if (ext.toUpperCase().contains("ARC")) {
                    saveFile = new File(dirString + name + ".arc");
                    saveFile = this.potentialFunctions.versionFile(saveFile);
                    writeFilter = new XYZFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
                    logger.info(" Saving to " + saveFile.getAbsolutePath());
                    try {
                        saveFile.createNewFile();
                    }
                    catch (Exception exception) {}
                } else {
                    saveFile = new File(dirString + name + ".pdb");
                    saveFile = this.potentialFunctions.versionFile(saveFile);
                    writeFilter = new PDBFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
                    if (numModels > 1 && writeFilter instanceof PDBFilter) {
                        ((PDBFilter)writeFilter).setModelNumbering(0);
                    }
                    try {
                        saveFile.createNewFile();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int structNum = 0;
                do {
                    if (this.dCutoff > 0.0 && this.eCutoff > 0.0) {
                        if (energies[structNum] < lowestEnergy + this.eCutoff && densities[structNum] > this.dCutoff) {
                            if (systemFilter instanceof PDBFilter) {
                                pdbFilter = (PDBFilter)systemFilter;
                                pdbFilter.writeFile(saveFile, true, false, false);
                                try {
                                    Files.writeString(saveFile.toPath(), (CharSequence)"ENDMDL\n", StandardOpenOption.APPEND);
                                }
                                catch (Exception exception) {}
                            } else if (systemFilter instanceof XYZFilter) {
                                writeFilter.writeFile(saveFile, true);
                            }
                        }
                    } else if (this.dCutoff > 0.0) {
                        if (densities[structNum] > this.dCutoff) {
                            if (systemFilter instanceof PDBFilter) {
                                pdbFilter = (PDBFilter)systemFilter;
                                pdbFilter.writeFile(saveFile, true, false, false);
                                try {
                                    Files.writeString(saveFile.toPath(), (CharSequence)"ENDMDL\n", StandardOpenOption.APPEND);
                                }
                                catch (Exception exception) {}
                            } else if (systemFilter instanceof XYZFilter) {
                                writeFilter.writeFile(saveFile, true);
                            }
                        }
                    } else if (this.eCutoff > 0.0 && energies[structNum] < lowestEnergy + this.eCutoff) {
                        if (systemFilter instanceof PDBFilter) {
                            pdbFilter = (PDBFilter)systemFilter;
                            pdbFilter.writeFile(saveFile, true, false, false);
                            try {
                                Files.writeString(saveFile.toPath(), (CharSequence)"ENDMDL\n", StandardOpenOption.APPEND);
                            }
                            catch (Exception exception) {}
                        } else if (systemFilter instanceof XYZFilter) {
                            writeFilter.writeFile(saveFile, true);
                        }
                    }
                    ++structNum;
                } while (systemFilter.readNext());
                if (systemFilter instanceof PDBFilter) {
                    try {
                        Files.writeString(saveFile.toPath(), (CharSequence)"END\n", StandardOpenOption.APPEND);
                    }
                    catch (Exception pdbFilter) {
                        // empty catch block
                    }
                }
            }
            if (this.fl > 0) {
                if (numSnaps > index) {
                    logger.warning(String.format(" Requested %d snapshots, but file %s has only %d snapshots. All %d energies will be reported", numSnaps, this.filenames, index, index));
                    numSnaps = index;
                }
                name = FilenameUtils.getName((String)this.filenames.get(0));
                logger.info(" Saving the " + numSnaps + " lowest energy snapshots to " + dirString + name);
                SystemFilter saveFilter = this.potentialFunctions.getFilter();
                saveFile = this.potentialFunctions.versionFile(new File(dirString + name));
                int toSave = Math.min(numSnaps, lowestEnergyQueue.size());
                for (int i = 0; i < toSave; ++i) {
                    StateContainer savedState = (StateContainer)lowestEnergyQueue.poll();
                    AssemblyState finalAssembly = savedState.getState();
                    finalAssembly.revertState();
                    String remark = String.format("Potential Energy: %16.8f (kcal/mol)", savedState.getEnergy());
                    logger.info(String.format(" Snapshot %d %s", i + 1, remark));
                    saveFilter.writeFile(saveFile, true, new String[]{remark});
                }
            }
        }
        return this;
    }

    private static void printDihedral(MolecularAssembly molecularAssembly, ArrayList<Integer> indices) {
        if (indices != null && indices.size() == 4) {
            Atom[] atoms = molecularAssembly.getAtomArray();
            Atom atom0 = atoms[indices.get(0)];
            Atom atom1 = atoms[indices.get(1)];
            Atom atom2 = atoms[indices.get(2)];
            Atom atom3 = atoms[indices.get(3)];
            try {
                for (Torsion torsion : atom0.getTorsions()) {
                    if (!torsion.compare(atom0, atom1, atom2, atom3)) continue;
                    logger.info("\n Torsion: " + String.valueOf(torsion));
                    return;
                }
            }
            catch (Exception e) {
                logger.info(" Exception during dihedral print " + String.valueOf(e));
            }
            logger.info("\n No torsion between atoms:\n  " + String.valueOf(atom0) + "\n  " + String.valueOf(atom1) + "\n  " + String.valueOf(atom2) + "\n  " + String.valueOf(atom3));
        }
    }

    @Override
    public List<Potential> getPotentials() {
        if (this.forceFieldEnergy == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.forceFieldEnergy);
    }

    public ForceFieldEnergy getForceFieldEnergy() {
        return this.forceFieldEnergy;
    }

    public double getEnergy() {
        return this.energy;
    }

    private static class StateContainer
    implements Comparable<StateContainer> {
        private final AssemblyState state;
        private final double e;

        StateContainer(AssemblyState state, double e) {
            this.state = state;
            this.e = e;
        }

        AssemblyState getState() {
            return this.state;
        }

        double getEnergy() {
            return this.e;
        }

        @Override
        public int compareTo(StateContainer o) {
            return Double.compare(this.e, o.getEnergy());
        }
    }
}

