/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.commands;

import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.Molecule;
import ffx.potential.cli.PotentialCommand;
import ffx.potential.parameters.BioType;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="Biotype", description={" Print out Biotype records for the atoms in an XYZ file."})
public class Biotype
extends PotentialCommand {
    @CommandLine.Option(names={"--name", "--moleculeName"}, paramLabel="MOL", defaultValue="MOL", description={"The molecule name to use for the Biotype records."})
    private String molName;
    @CommandLine.Option(names={"-a", "--useAtomNames"}, paramLabel="false", defaultValue="false", description={"Use the atom names in the XYZ file."})
    private boolean useAtomNames;
    @CommandLine.Option(names={"-c", "--writeCONECT"}, paramLabel="false", defaultValue="false", description={"Write out CONECT records to append to the PDB file."})
    private boolean writeCONNECT;
    @CommandLine.Option(names={"-w", "--writePDB"}, paramLabel="false", defaultValue="false", description={"Write out a PDB file with the updated atom and molecule names."})
    private boolean writePDB;
    @CommandLine.Parameters(arity="1", paramLabel="files", description={"An XYZ coordinate file."})
    private String filename = null;
    private List<BioType> bioTypes = null;

    public Biotype() {
    }

    public Biotype(FFXBinding binding) {
        super(binding);
    }

    public Biotype(String[] args) {
        super(args);
    }

    public List<BioType> getBioTypes() {
        return this.bioTypes;
    }

    public Biotype run() {
        List<Bond> bonds;
        if (!this.init()) {
            return this;
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        logger.info("\n Running Biotype on " + this.filename);
        Molecule[] molecules = this.activeAssembly.getMoleculeArray();
        Atom[] atoms = this.activeAssembly.getAtomArray();
        if (this.writeCONNECT) {
            for (Atom a : atoms) {
                StringBuilder sb = new StringBuilder(String.format("CONECT%5s", Integer.toString(a.getXyzIndex())));
                bonds = a.getBonds();
                for (Bond b : bonds) {
                    sb.append(String.format("%5s", Integer.toString(b.get1_2(a).getXyzIndex())));
                }
                logger.info(sb.toString());
            }
        }
        if (molecules.length > 1) {
            logger.info(" Biotype is intended for a system with one molecule.");
            return this;
        }
        molecules[0].setName(this.molName);
        this.bioTypes = new ArrayList<BioType>();
        if (!this.useAtomNames) {
            Atom.ElementSymbol[] symbols = Atom.ElementSymbol.values();
            int[] elementCounts = new int[symbols.length + 1];
            for (Atom atom : atoms) {
                int element = atom.getAtomicNumber();
                int n = elementCounts[element];
                String name = symbols[element - 1].name().toUpperCase() + n;
                atom.setName(name);
                elementCounts[element] = n + 1;
            }
        }
        int index = 1;
        for (Atom atom : atoms) {
            atom.setResName(this.molName);
            bonds = atom.getBonds();
            String[] bondString = null;
            if (bonds != null) {
                bondString = new String[bonds.size()];
                int i = 0;
                for (Bond bond : bonds) {
                    bondString[i++] = bond.get1_2(atom).getName();
                }
            }
            BioType biotype = new BioType(index++, atom.getName(), this.molName, atom.getAtomType().type, bondString);
            this.bioTypes.add(biotype);
            logger.info(biotype.toString());
        }
        if (this.writePDB) {
            File pdbFile = this.createOutputFile(this.filename, "pdb");
            logger.info("\n Saving PDB file: " + String.valueOf(pdbFile));
            this.potentialFunctions.saveAsPDB(this.activeAssembly, pdbFile);
        }
        this.binding.setVariable("bioTypes", this.bioTypes);
        return this;
    }
}

