/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.cli;

import edu.rit.pj.ParallelTeam;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.numerics.switching.MultiplicativeSwitch;
import ffx.numerics.switching.PowerSwitch;
import ffx.numerics.switching.SquaredTrigSwitch;
import ffx.numerics.switching.UnivariateSwitchingFunction;
import ffx.potential.DualTopologyEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.QuadTopologyEnergy;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.MSGroup;
import ffx.potential.cli.AlchemicalOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import picocli.CommandLine;

public class TopologyOptions {
    public static final Logger logger = Logger.getLogger(TopologyOptions.class.getName());
    @CommandLine.ArgGroup(heading="%n Alchemical Options for Dual and Quad Topologies%n", validate=false)
    private final TopologyOptionGroup group = new TopologyOptionGroup();

    public String getAlchemicalAtoms2() {
        return this.group.alchemicalAtoms2;
    }

    public String getAlchemicalResidues2() {
        return this.group.alchemicalResidues2;
    }

    public String getUnchargedAtoms2() {
        return this.group.unchargedAtoms2;
    }

    public int getTopologiesInParallel() {
        return this.group.nTopologiesInParallel;
    }

    public String getUnsharedA() {
        return this.group.unsharedA;
    }

    public String getUnsharedB() {
        return this.group.unsharedB;
    }

    public String getLambdaFunction() {
        return this.group.lambdaFunction;
    }

    public int getTopologiesInParallel(int nTopologies) {
        int numParallel;
        int nThreads = ParallelTeam.getDefaultThreadCount();
        if (nThreads % (numParallel = this.getTopologiesInParallel()) != 0) {
            logger.warning(String.format(" Number of threads available %d not evenly divisible by np %d; reverting to sequential.", nThreads, numParallel));
            numParallel = 1;
        } else if (nTopologies % numParallel != 0) {
            logger.warning(String.format(" Number of topologies %d not evenly divisible by np %d; reverting to sequential.", nTopologies, numParallel));
            numParallel = 1;
        }
        return numParallel;
    }

    public int getThreadsPerTopology(int nTopologies) {
        int nThreads = ParallelTeam.getDefaultThreadCount();
        int numParallel = this.getTopologiesInParallel(nTopologies);
        return nThreads / numParallel;
    }

    public int getNumberOfTopologies(@Nullable List<String> topologyFilenames) {
        if (topologyFilenames == null || topologyFilenames.isEmpty()) {
            logger.severe(" No filenames were provided.");
            return 0;
        }
        if (topologyFilenames.size() != 1 && topologyFilenames.size() != 2 && topologyFilenames.size() != 4) {
            logger.severe(" Either 1, 2, or 4 filenames must be provided.!");
            return 0;
        }
        return topologyFilenames.size();
    }

    public Potential assemblePotential(MolecularAssembly[] assemblies, StringBuilder sb) {
        List<Integer> uniqueB;
        List<Integer> uniqueA;
        UnivariateSwitchingFunction sf;
        int nargs = assemblies.length;
        int numPar = this.getTopologiesInParallel(nargs);
        UnivariateSwitchingFunction univariateSwitchingFunction = sf = nargs > 1 ? this.getSwitchingFunction() : null;
        if (assemblies.length >= 4) {
            uniqueA = this.getUniqueAtomsA(assemblies[0]);
            uniqueB = this.getUniqueAtomsB(assemblies[2]);
        } else {
            uniqueA = Collections.emptyList();
            uniqueB = Collections.emptyList();
        }
        return this.getTopology(assemblies, sf, uniqueA, uniqueB, numPar, sb);
    }

    public UnivariateSwitchingFunction getSwitchingFunction() {
        PowerSwitch sf;
        String lambdaFunction = this.getLambdaFunction();
        if (!lambdaFunction.equalsIgnoreCase("1.0")) {
            String lf;
            switch (lf = lambdaFunction.toUpperCase()) {
                case "TRIG": {
                    sf = new SquaredTrigSwitch(false);
                    break;
                }
                case "MULT": {
                    sf = new MultiplicativeSwitch(1.0, 0.0);
                    break;
                }
                default: {
                    try {
                        double beta = Double.parseDouble(lf);
                        sf = new PowerSwitch(1.0, beta);
                    }
                    catch (NumberFormatException ex) {
                        logger.warning(String.format("Argument to option -sf %s could not be properly parsed; using default linear switch", lambdaFunction));
                        sf = new PowerSwitch(1.0, 1.0);
                    }
                    break;
                }
            }
        } else {
            sf = new PowerSwitch(1.0, 1.0);
        }
        return sf;
    }

    public List<Integer> getUniqueAtomsA(MolecularAssembly topology) {
        return TopologyOptions.getUniqueAtoms(topology, "A", this.getUnsharedA());
    }

    public Potential getTopology(MolecularAssembly[] topologies, UnivariateSwitchingFunction sf, List<Integer> uniqueA, List<Integer> uniqueB, int numParallel, StringBuilder sb) {
        CrystalPotential potential = null;
        switch (topologies.length) {
            case 1: {
                sb.append("Single Topology ");
                potential = topologies[0].getPotentialEnergy();
                break;
            }
            case 2: {
                sb.append("Dual Topology ");
                DualTopologyEnergy dte = DualTopologyEnergy.energyFactory(topologies[0], topologies[1], sf);
                if (numParallel == 2) {
                    dte.setParallel(true);
                }
                potential = dte;
                break;
            }
            case 4: {
                sb.append("Quad Topology ");
                DualTopologyEnergy dta = new DualTopologyEnergy(topologies[0], topologies[1], sf);
                DualTopologyEnergy dtb = new DualTopologyEnergy(topologies[3], topologies[2], sf);
                QuadTopologyEnergy qte = new QuadTopologyEnergy(dta, dtb, uniqueA, uniqueB);
                if (numParallel >= 2) {
                    qte.setParallel(true);
                    if (numParallel == 4) {
                        dta.setParallel(true);
                        dtb.setParallel(true);
                    }
                }
                potential = qte;
                break;
            }
            default: {
                logger.severe(" Must have 2, 4, or 8 topologies!");
            }
        }
        sb.append(Arrays.stream(topologies).map(MSGroup::toString).collect(Collectors.joining(", ", " [", "] ")));
        return potential;
    }

    public static List<Integer> getUniqueAtoms(MolecularAssembly assembly, String label, String unshared) {
        if (!unshared.isEmpty()) {
            logger.info(" Finding unique atoms for dual topology " + label);
            HashSet<Integer> indices = new HashSet<Integer>();
            String[] toks = unshared.split("\\.");
            Atom[] atoms1 = assembly.getAtomArray();
            for (String range : toks) {
                int rangeEnd;
                Matcher m = AlchemicalOptions.rangeRegEx.matcher(range);
                if (!m.find()) continue;
                int rangeStart = Integer.parseInt(m.group(1));
                int n = rangeEnd = m.group(2) != null ? Integer.parseInt(m.group(2)) : rangeStart;
                if (rangeStart > rangeEnd) {
                    logger.severe(String.format(" Range %s was invalid start was greater than end", range));
                }
                logger.info(String.format(" Range %s for %s, start %d end %d", range, label, rangeStart, rangeEnd));
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format(" First atom in range: %s", atoms1[rangeStart - 1]));
                    if (rangeEnd > rangeStart) {
                        logger.fine(String.format(" Last atom in range: %s", atoms1[rangeEnd - 1]));
                    }
                }
                for (int i = rangeStart; i <= rangeEnd; ++i) {
                    indices.add(i - 1);
                }
            }
            int counter = 0;
            HashSet<Integer> adjustedIndices = new HashSet<Integer>();
            int atomLength = atoms1.length;
            for (int i = 0; i < atomLength; ++i) {
                Atom ai = atoms1[i];
                if (indices.contains(i)) {
                    if (ai.applyLambda()) {
                        logger.warning(String.format(" Ranges defined in %s should not overlap with ligand atoms they are assumed to not be shared.", label));
                    } else {
                        logger.fine(String.format(" Unshared %s: %d variables %d-%d", label, i, counter, counter + 2));
                        for (int j = 0; j < 3; ++j) {
                            adjustedIndices.add(counter + j);
                        }
                    }
                }
                if (ai.applyLambda()) continue;
                counter += 3;
            }
            return adjustedIndices.stream().sorted().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<Integer> getUniqueAtomsB(MolecularAssembly topology) {
        return TopologyOptions.getUniqueAtoms(topology, "B", this.getUnsharedB());
    }

    public boolean hasSoftcore() {
        String alchemicalAtoms2 = this.getAlchemicalAtoms2();
        return alchemicalAtoms2 != null && !alchemicalAtoms2.equalsIgnoreCase("NONE") && !alchemicalAtoms2.equalsIgnoreCase("");
    }

    public void setSecondSystemAlchemistry(MolecularAssembly topology) {
        String alchemicalAtoms2 = this.getAlchemicalAtoms2();
        String alchemicalResidues2 = this.getAlchemicalResidues2();
        AlchemicalOptions.setAlchemicalAtoms(topology, alchemicalAtoms2, alchemicalResidues2);
    }

    public void setSecondSystemUnchargedAtoms(MolecularAssembly topology) {
        String unchargedAtoms2 = this.getUnchargedAtoms2();
        AlchemicalOptions.setUnchargedAtoms(topology, unchargedAtoms2);
    }

    public void setAlchemicalProperties(int numberOfTopologies) {
        if (numberOfTopologies >= 2) {
            System.setProperty("ligand-vapor-elec", "false");
            if (this.hasSoftcore()) {
                System.setProperty("lambdaterm", "true");
            }
        }
    }

    private static class TopologyOptionGroup {
        @CommandLine.Option(names={"--ac2", "--alchemicalAtoms2"}, paramLabel="<selection>", defaultValue="", description={"Specify alchemical atoms for the 2nd topology [ALL, NONE, Range(s): 1-3,6-N]."})
        String alchemicalAtoms2 = "";
        @CommandLine.Option(names={"--acRes2", "--alchemicalResidues2"}, paramLabel="<selection>", defaultValue="", description={"Specify alchemical residues by chain and residue number for the 2nd topology [A4,B21]"})
        String alchemicalResidues2 = "";
        @CommandLine.Option(names={"--uc2", "--unchargedAtoms2"}, paramLabel="<selection>", defaultValue="", description={"Specify atoms without electrostatics for the 2nd topology [ALL, NONE, Range(s): 1-3,6-N]."})
        String unchargedAtoms2 = "";
        @CommandLine.Option(names={"--np", "--nParallel"}, paramLabel="1", description={"Number of topologies to evaluate in parallel"})
        int nTopologiesInParallel = 1;
        @CommandLine.Option(names={"--uaA", "--unsharedA"}, paramLabel="-1", description={"Unshared atoms in the A dual topology (e.g. 1-24.32-65)."})
        String unsharedA = null;
        @CommandLine.Option(names={"--uaB", "--unsharedB"}, paramLabel="-1", description={"Unshared atoms in the B dual topology (e.g. 1-24.32-65)."})
        String unsharedB = null;
        @CommandLine.Option(names={"--sf", "--switchingFunction"}, paramLabel="1.0", description={"Switching function to use for dual topology: options are TRIG, MULT, or a number (original behavior with specified lambda exponent)"})
        String lambdaFunction = "1.0";

        private TopologyOptionGroup() {
        }
    }
}

