/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.cli;

import picocli.CommandLine;

public class TimerOptions {
    @CommandLine.ArgGroup(heading="%n Timing Options%n", validate=false)
    private final TimerOptionGroup group = new TimerOptionGroup();

    public int getIterations() {
        return this.group.iterations;
    }

    public boolean getNoGradient() {
        return this.group.noGradient;
    }

    public int getThreads() {
        return this.group.threads;
    }

    public boolean getVerbose() {
        return this.group.verbose;
    }

    private static class TimerOptionGroup {
        @CommandLine.Option(names={"-n", "--iterations"}, paramLabel="5", defaultValue="5", description={"Number of iterations."})
        public int iterations = 5;
        @CommandLine.Option(names={"--nt", "--threads"}, paramLabel="0", defaultValue="0", description={"Number of SMP threads (0 specifies use of all CPU cores)."})
        public int threads = 0;
        @CommandLine.Option(names={"-g", "--noGradient"}, description={"Ignore computation of the atomic coordinates gradient."})
        public boolean noGradient = false;
        @CommandLine.Option(names={"-v", "--verbose"}, description={"Print the energy for each iteration."})
        public boolean verbose = false;

        private TimerOptionGroup() {
        }
    }
}

