/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.cli;

import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import picocli.CommandLine;

public class SaveOptions {
    @CommandLine.Option(names={"-c", "--constrain"}, paramLabel="false", defaultValue="false", description={"Apply geometric constraints before saving."})
    public boolean constrain = false;
    private double[] x;
    private double[] outputX;

    public void preSaveOperations(MolecularAssembly molecularAssembly) {
        this.preSaveOperations(molecularAssembly.getPotentialEnergy());
    }

    public void preSaveOperations(ForceFieldEnergy forceFieldEnergy) {
        if (this.constrain) {
            int nVars = forceFieldEnergy.getNumberOfVariables();
            if (this.x == null) {
                this.x = new double[nVars];
                this.outputX = new double[nVars];
            }
            this.x = forceFieldEnergy.getCoordinates(this.x);
            System.arraycopy(this.x, 0, this.outputX, 0, nVars);
            forceFieldEnergy.applyAllConstraintPositions(this.x, this.outputX);
            forceFieldEnergy.setCoordinates(this.outputX);
        }
    }
}

