/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.cli;

import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.cli.TopologyOptions;
import ffx.potential.utils.PotentialsFunctions;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import picocli.CommandLine;

public class AlchemicalOptions {
    public static final Logger logger = Logger.getLogger(AlchemicalOptions.class.getName());
    public static final Pattern rangeRegEx = Pattern.compile("([0-9]+)-?([0-9]+)?");
    @CommandLine.ArgGroup(heading="%n Alchemical Options%n", validate=false)
    private final AlchemicalOptionGroup group = new AlchemicalOptionGroup();

    public static void setUnchargedAtoms(MolecularAssembly assembly, String unchargedAtoms) {
        AtomSelectionOptions.actOnAtoms(assembly, unchargedAtoms, (a, b) -> a.setElectrostatics(b == false), "Uncharged");
    }

    public static void setAlchemicalAtoms(MolecularAssembly assembly, String alchemicalAtoms, String alchemicalResidues) {
        AtomSelectionOptions.actOnAtoms(assembly, alchemicalAtoms, Atom::setApplyLambda, "Alchemical");
        AtomSelectionOptions.actOnResidueAtoms(assembly, alchemicalResidues, Atom::setApplyLambda, "Alchemical");
    }

    public String getAlchemicalAtoms() {
        return this.group.alchemicalAtoms;
    }

    public String getAlchemicalResidues() {
        return this.group.alchemicalResidues;
    }

    public String getUnchargedAtoms() {
        return this.group.unchargedAtoms;
    }

    public double getInitialLambda() {
        return this.getInitialLambda(false);
    }

    public double getInitialLambda(boolean quiet) {
        return this.getInitialLambda(1, 0, quiet);
    }

    public double getInitialLambda(int size, int rank) {
        return this.getInitialLambda(size, rank, false);
    }

    public double getInitialLambda(int size, int rank, boolean quiet) {
        double initialLambda = this.group.initialLambda;
        if (initialLambda < 0.0 || initialLambda > 1.0) {
            if (rank == 0 || size < 2) {
                initialLambda = 0.0;
            } else if (rank == size - 1) {
                initialLambda = 1.0;
            } else {
                double dL = 1.0 / (double)(size - 1);
                initialLambda = dL * (double)rank;
            }
            if (!quiet) {
                logger.info(String.format(" Setting lambda to %5.3f.", initialLambda));
            }
        }
        return initialLambda;
    }

    public boolean hasSoftcore() {
        String alchemicalAtoms = this.getAlchemicalAtoms();
        boolean atoms = alchemicalAtoms != null && !alchemicalAtoms.equalsIgnoreCase("NONE") && !alchemicalAtoms.equalsIgnoreCase("");
        String alchemicalResidues = this.getAlchemicalResidues();
        boolean residues = alchemicalResidues != null && !alchemicalResidues.equalsIgnoreCase("NONE") && !alchemicalResidues.equalsIgnoreCase("");
        return atoms || residues;
    }

    public void setFirstSystemAlchemistry(MolecularAssembly topology) {
        AlchemicalOptions.setAlchemicalAtoms(topology, this.getAlchemicalAtoms(), this.getAlchemicalResidues());
    }

    public MolecularAssembly openFile(PotentialsFunctions potentialFunctions, TopologyOptions topologyOptions, int threadsPer, String toOpen, int topNum) {
        potentialFunctions.openAll(toOpen, threadsPer);
        MolecularAssembly molecularAssembly = potentialFunctions.getActiveAssembly();
        return this.processFile(topologyOptions, molecularAssembly, topNum);
    }

    public MolecularAssembly processFile(@Nullable TopologyOptions topologyOptions, MolecularAssembly molecularAssembly, int topNum) {
        int remainder = topNum % 2 + 1;
        switch (remainder) {
            case 1: {
                this.setFirstSystemAlchemistry(molecularAssembly);
                this.setFirstSystemUnchargedAtoms(molecularAssembly);
                break;
            }
            case 2: {
                if (topologyOptions == null) {
                    throw new IllegalArgumentException(" For >= 2 systems, topologyOptions must not be empty!");
                }
                topologyOptions.setSecondSystemAlchemistry(molecularAssembly);
                topologyOptions.setSecondSystemUnchargedAtoms(molecularAssembly);
            }
        }
        return molecularAssembly;
    }

    public void setFirstSystemUnchargedAtoms(MolecularAssembly topology) {
        AlchemicalOptions.setUnchargedAtoms(topology, this.getUnchargedAtoms());
    }

    public void setAlchemicalProperties() {
        if (this.hasSoftcore()) {
            System.setProperty("lambdaterm", "true");
        }
    }

    private static class AlchemicalOptionGroup {
        @CommandLine.Option(names={"-l", "--lambda"}, paramLabel="-1", description={"Initial lambda value."})
        double initialLambda = -1.0;
        @CommandLine.Option(names={"--ac", "--alchemicalAtoms"}, paramLabel="<selection>", defaultValue="", description={"Specify alchemical atoms [ALL, NONE, Range(s): 1-3,6-N]."})
        String alchemicalAtoms = "";
        @CommandLine.Option(names={"--acRes", "--alchemicalResidues"}, paramLabel="<selection>", defaultValue="", description={"Specify alchemical residues by chain and residue number [A4,B21]"})
        String alchemicalResidues = "";
        @CommandLine.Option(names={"--uc", "--unchargedAtoms"}, paramLabel="<selection>", defaultValue="", description={"Specify atoms without electrostatics [ALL, NONE, Range(s): 1-3,6-N]."})
        String unchargedAtoms = "";

        private AlchemicalOptionGroup() {
        }
    }
}

