/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.bonded;

import ffx.numerics.atomic.AtomicDoubleArray3D;
import ffx.numerics.math.Double3;
import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.Angle;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.bonded.Torsion;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.TorsionTorsionType;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class TorsionTorsion
extends BondedTerm
implements LambdaInterface {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(TorsionTorsion.class.getName());
    private static final double[][] wt = new double[][]{{1.0, 0.0, -3.0, 2.0, 0.0, 0.0, 0.0, 0.0, -3.0, 0.0, 9.0, -6.0, 2.0, 0.0, -6.0, 4.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.0, 0.0, -9.0, 6.0, -2.0, 0.0, 6.0, -4.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.0, -6.0, 0.0, 0.0, -6.0, 4.0}, {0.0, 0.0, 3.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -9.0, 6.0, 0.0, 0.0, 6.0, -4.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -3.0, 2.0, -2.0, 0.0, 6.0, -4.0, 1.0, 0.0, -3.0, 2.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 3.0, -2.0, 1.0, 0.0, -3.0, 2.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0, 2.0, 0.0, 0.0, 3.0, -2.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.0, -2.0, 0.0, 0.0, -6.0, 4.0, 0.0, 0.0, 3.0, -2.0}, {0.0, 1.0, -2.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0, 6.0, -3.0, 0.0, 2.0, -4.0, 2.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.0, -6.0, 3.0, 0.0, -2.0, 4.0, -2.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0, 3.0, 0.0, 0.0, 2.0, -2.0}, {0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.0, -3.0, 0.0, 0.0, -2.0, 2.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, -2.0, 1.0, 0.0, -2.0, 4.0, -2.0, 0.0, 1.0, -2.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 2.0, -1.0, 0.0, 1.0, -2.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 2.0, -2.0, 0.0, 0.0, -1.0, 1.0}};
    public final Torsion[] torsions = new Torsion[2];
    public TorsionTorsionType torsionTorsionType = null;
    private double lambda = 1.0;
    private double dEdL = 0.0;
    private boolean lambdaTerm = false;

    public TorsionTorsion(Bond firstBond, Angle angle, Bond lastBond, boolean reversed) {
        this.atoms = new Atom[5];
        this.bonds = new Bond[4];
        if (!reversed) {
            this.atoms[1] = angle.atoms[0];
            this.atoms[2] = angle.atoms[1];
            this.atoms[3] = angle.atoms[2];
            this.atoms[0] = firstBond.get1_2(this.atoms[1]);
            this.atoms[4] = lastBond.get1_2(this.atoms[3]);
            this.bonds[0] = firstBond;
            this.bonds[1] = angle.bonds[0];
            this.bonds[2] = angle.bonds[1];
            this.bonds[3] = lastBond;
        } else {
            this.atoms[1] = angle.atoms[2];
            this.atoms[2] = angle.atoms[1];
            this.atoms[3] = angle.atoms[0];
            this.atoms[0] = lastBond.get1_2(this.atoms[1]);
            this.atoms[4] = firstBond.get1_2(this.atoms[3]);
            this.bonds[0] = lastBond;
            this.bonds[1] = angle.bonds[1];
            this.bonds[2] = angle.bonds[0];
            this.bonds[3] = firstBond;
        }
        this.torsions[0] = this.atoms[0].getTorsion(this.atoms[1], this.atoms[2], this.atoms[3]);
        this.torsions[1] = this.atoms[4].getTorsion(this.atoms[3], this.atoms[2], this.atoms[1]);
        this.setID_Key(false);
    }

    public static TorsionTorsion torsionTorsionFactory(Bond firstBond, Angle angle, Bond lastBond, ForceField forceField) {
        int[] c5 = new int[5];
        Atom atom1 = angle.atoms[0];
        Atom atom3 = angle.atoms[2];
        c5[0] = firstBond.get1_2((Atom)atom1).getAtomType().atomClass;
        c5[1] = atom1.getAtomType().atomClass;
        c5[2] = angle.atoms[1].getAtomType().atomClass;
        c5[3] = atom3.getAtomType().atomClass;
        c5[4] = lastBond.get1_2((Atom)atom3).getAtomType().atomClass;
        String key = TorsionTorsionType.sortKey(c5);
        boolean reversed = false;
        TorsionTorsionType torsionTorsionType = forceField.getTorsionTorsionType(key);
        if (torsionTorsionType == null) {
            key = TorsionTorsionType.reverseKey(c5);
            torsionTorsionType = forceField.getTorsionTorsionType(key);
            reversed = true;
        }
        if (torsionTorsionType == null) {
            return null;
        }
        TorsionTorsion torsionTorsion = new TorsionTorsion(firstBond, angle, lastBond, reversed);
        torsionTorsion.torsionTorsionType = torsionTorsionType;
        return torsionTorsion;
    }

    private static void bcucof(double t1, double t2, double[] e, double[] dx, double[] dy, double[] dxy, double[][] c) {
        int i;
        double[] x16 = new double[16];
        double[] cl = new double[16];
        double t1t2 = t1 * t2;
        for (i = 0; i < 4; ++i) {
            x16[i] = e[i];
            x16[i + 4] = dx[i] * t1;
            x16[i + 8] = dy[i] * t2;
            x16[i + 12] = dxy[i] * t1t2;
        }
        for (i = 0; i < 16; ++i) {
            double xx = 0.0;
            for (int k = 0; k < 16; ++k) {
                xx += wt[k][i] * x16[k];
            }
            cl[i] = xx;
        }
        int j = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int k = 0; k < 4; ++k) {
                c[i2][k] = cl[j++];
            }
        }
    }

    @Override
    public double energy(boolean gradient, int threadID, AtomicDoubleArray3D grad, AtomicDoubleArray3D lambdaGrad) {
        this.energy = 0.0;
        this.value = 0.0;
        this.dEdL = 0.0;
        if (!this.getUse()) {
            return this.energy;
        }
        Atom atomA = this.atoms[0];
        Atom atomB = this.atoms[1];
        Atom atomC = this.atoms[2];
        Atom atomD = this.atoms[3];
        Atom atomE = this.atoms[4];
        Double3 va = atomA.getXYZ();
        Double3 vb = atomB.getXYZ();
        Double3 vc = atomC.getXYZ();
        Double3 vd = atomD.getXYZ();
        Double3 ve = atomE.getXYZ();
        Double3 vba = vb.sub(va);
        Double3 vcb = vc.sub(vb);
        Double3 vdc = vd.sub(vc);
        Double3 ved = ve.sub(vd);
        Double3 vt = vba.X(vcb);
        Double3 vu = vcb.X(vdc);
        Double3 vv = vdc.X(ved);
        double rt2 = vt.length2();
        double ru2 = vu.length2();
        double rv2 = vv.length2();
        double rtru2 = rt2 * ru2;
        double rurv2 = ru2 * rv2;
        if (rtru2 != 0.0 && rurv2 != 0.0) {
            double rtru = FastMath.sqrt((double)(rt2 * ru2));
            double rurv = FastMath.sqrt((double)(ru2 * rv2));
            double rcb = vcb.length();
            double cosine1 = FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)(vt.dot(vu) / rtru)));
            double angle1 = FastMath.toDegrees((double)FastMath.acos((double)cosine1));
            double sign = vba.dot(vu);
            if (sign < 0.0) {
                angle1 *= -1.0;
            }
            double rdc = vdc.length();
            double cosine2 = FastMath.min((double)1.0, (double)FastMath.max((double)-1.0, (double)(vu.dot(vv) / rurv)));
            double angle2 = FastMath.toDegrees((double)FastMath.acos((double)cosine2));
            sign = vcb.dot(vv);
            if (sign < 0.0) {
                angle2 *= -1.0;
            }
            double t1 = angle1;
            double t2 = angle2;
            sign = this.chktor();
            t1 *= sign;
            t2 *= sign;
            int nx = this.torsionTorsionType.nx;
            int ny = this.torsionTorsionType.ny;
            int nlow = 0;
            int nhigh = nx - 1;
            while (nhigh - nlow > 1) {
                int nt = (nhigh + nlow) / 2;
                if (this.torsionTorsionType.tx[nt] > t1) {
                    nhigh = nt;
                    continue;
                }
                nlow = nt;
            }
            int xlow = nlow;
            nlow = 0;
            nhigh = ny - 1;
            while (nhigh - nlow > 1) {
                int nt = (nhigh + nlow) / 2;
                if (this.torsionTorsionType.ty[nt] > t2) {
                    nhigh = nt;
                    continue;
                }
                nlow = nt;
            }
            int ylow = nlow;
            double x1l = this.torsionTorsionType.tx[xlow];
            double x1u = this.torsionTorsionType.tx[xlow + 1];
            double y1l = this.torsionTorsionType.ty[ylow];
            double y1u = this.torsionTorsionType.ty[ylow + 1];
            int pos2 = (ylow + 1) * nx + xlow;
            int pos1 = pos2 - nx;
            double[] e = new double[]{this.torsionTorsionType.energy[pos1], this.torsionTorsionType.energy[pos1 + 1], this.torsionTorsionType.energy[pos2 + 1], this.torsionTorsionType.energy[pos2]};
            double[] dx = new double[]{this.torsionTorsionType.dx[pos1], this.torsionTorsionType.dx[pos1 + 1], this.torsionTorsionType.dx[pos2 + 1], this.torsionTorsionType.dx[pos2]};
            double[] dy = new double[]{this.torsionTorsionType.dy[pos1], this.torsionTorsionType.dy[pos1 + 1], this.torsionTorsionType.dy[pos2 + 1], this.torsionTorsionType.dy[pos2]};
            double[] dxy = new double[]{this.torsionTorsionType.dxy[pos1], this.torsionTorsionType.dxy[pos1 + 1], this.torsionTorsionType.dxy[pos2 + 1], this.torsionTorsionType.dxy[pos2]};
            if (!gradient && !this.lambdaTerm) {
                double bcu = this.bcuint(x1l, x1u, y1l, y1u, t1, t2, e, dx, dy, dxy);
                this.energy = this.torsionTorsionType.torTorUnit * bcu * this.lambda;
                this.dEdL = this.torsionTorsionType.torTorUnit * bcu;
            } else {
                double[] ansy = new double[2];
                double bcu1 = this.bcuint1(x1l, x1u, y1l, y1u, t1, t2, e, dx, dy, dxy, ansy);
                this.energy = this.torsionTorsionType.torTorUnit * bcu1 * this.lambda;
                this.dEdL = this.torsionTorsionType.torTorUnit * bcu1;
                double dedang1 = sign * this.torsionTorsionType.torTorUnit * FastMath.toDegrees((double)ansy[0]) * this.lambda;
                double dedang2 = sign * this.torsionTorsionType.torTorUnit * FastMath.toDegrees((double)ansy[1]) * this.lambda;
                Double3 vca = vc.sub(va);
                Double3 vdb = vd.sub(vb);
                Double3 vdt = vt.X(vcb).scaleI(dedang1 / (rt2 * rcb));
                Double3 vdu = vu.X(vcb).scaleI(-dedang1 / (ru2 * rcb));
                Double3 ga = vdt.X(vcb);
                Double3 gb = vca.X(vdt).addI(vdu.X(vdc));
                Double3 gc = vdb.X(vdu).addI(vdt.X(vba));
                Double3 gd = vdu.X(vcb);
                int ia = atomA.getIndex() - 1;
                int ib = atomB.getIndex() - 1;
                int ic = atomC.getIndex() - 1;
                int id = atomD.getIndex() - 1;
                int ie = atomE.getIndex() - 1;
                if (this.lambdaTerm) {
                    lambdaGrad.add(threadID, ia, ga);
                    lambdaGrad.add(threadID, ib, gb);
                    lambdaGrad.add(threadID, ic, gc);
                    lambdaGrad.add(threadID, id, gd);
                }
                if (gradient) {
                    grad.add(threadID, ia, ga.scaleI(this.lambda));
                    grad.add(threadID, ib, gb.scaleI(this.lambda));
                    grad.add(threadID, ic, gc.scaleI(this.lambda));
                    grad.add(threadID, id, gd.scaleI(this.lambda));
                }
                Double3 vec = ve.sub(vc);
                vdt = vu.X(vdc).scaleI(dedang2 / (ru2 * rdc));
                vdu = vv.X(vdc).scaleI(-dedang2 / (rv2 * rdc));
                gb = vdt.X(vdc);
                gc = vdb.X(vdt).addI(vdu.X(ved));
                gd = vdt.X(vcb).addI(vec.X(vdu));
                Double3 ge = vdu.X(vdc);
                if (this.lambdaTerm) {
                    lambdaGrad.add(threadID, ib, gb);
                    lambdaGrad.add(threadID, ic, gc);
                    lambdaGrad.add(threadID, id, gd);
                    lambdaGrad.add(threadID, ie, ge);
                }
                if (gradient) {
                    grad.add(threadID, ib, gb.scaleI(this.lambda));
                    grad.add(threadID, ic, gc.scaleI(this.lambda));
                    grad.add(threadID, id, gd.scaleI(this.lambda));
                    grad.add(threadID, ie, ge.scaleI(this.lambda));
                }
            }
        }
        return this.energy;
    }

    public Atom getChiralAtom() {
        Atom atom = null;
        List<Bond> bnds = this.atoms[2].getBonds();
        if (bnds.size() == 4) {
            Atom atom1 = null;
            Atom atom2 = null;
            for (Bond b : bnds) {
                Atom a = b.get1_2(this.atoms[2]);
                if (a == this.atoms[1] || a == this.atoms[3]) continue;
                if (atom1 == null) {
                    atom1 = a;
                    continue;
                }
                atom2 = a;
            }
            if (atom1.getType() > atom2.getType()) {
                atom = atom1;
            }
            if (atom2.getType() > atom1.getType()) {
                atom = atom2;
            }
            if (atom1.getAtomicNumber() > atom2.getAtomicNumber()) {
                atom = atom1;
            }
            if (atom2.getAtomicNumber() > atom1.getAtomicNumber()) {
                atom = atom2;
            }
        }
        return atom;
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public void setLambda(double lambda) {
        if (this.applyAllLambda()) {
            this.lambdaTerm = true;
            this.lambda = lambda;
        } else {
            this.lambdaTerm = false;
            this.lambda = 1.0;
        }
    }

    @Override
    public double getd2EdL2() {
        return 0.0;
    }

    @Override
    public double getdEdL() {
        if (this.lambdaTerm) {
            return this.dEdL;
        }
        return 0.0;
    }

    @Override
    public void getdEdXdL(double[] gradient) {
    }

    public void log() {
        logger.info(String.format(" %s %6d-%s %6d-%s %6d-%s %6d-%s %10.4f", "Torsional-Torsion", this.atoms[0].getIndex(), this.atoms[0].getAtomType().name, this.atoms[1].getIndex(), this.atoms[1].getAtomType().name, this.atoms[2].getIndex(), this.atoms[2].getAtomType().name, this.atoms[3].getIndex(), this.atoms[3].getAtomType().name, this.energy));
    }

    @Override
    public String toString() {
        return String.format("%s  (%7.2f,%7.2f,%7.2f)", this.id, this.torsions[0].value, this.torsions[1].value, this.energy);
    }

    private double chktor() {
        double[] vc0 = new double[3];
        double[] vc1 = new double[3];
        double[] vc2 = new double[3];
        List<Bond> bonds = this.atoms[2].getBonds();
        if (bonds.size() == 4) {
            Atom atom1 = null;
            Atom atom2 = null;
            for (Bond b : bonds) {
                Atom a = b.get1_2(this.atoms[2]);
                if (a == this.atoms[1] || a == this.atoms[3]) continue;
                if (atom1 == null) {
                    atom1 = a;
                    continue;
                }
                atom2 = a;
            }
            Atom atom = null;
            if (atom1.getType() > atom2.getType()) {
                atom = atom1;
            }
            if (atom2.getType() > atom1.getType()) {
                atom = atom2;
            }
            if (atom1.getAtomicNumber() > atom2.getAtomicNumber()) {
                atom = atom1;
            }
            if (atom2.getAtomicNumber() > atom1.getAtomicNumber()) {
                atom = atom2;
            }
            if (atom != null) {
                double[] ad = new double[3];
                double[] a1 = new double[3];
                double[] a2 = new double[3];
                double[] a3 = new double[3];
                atom.getXYZ(ad);
                this.atoms[1].getXYZ(a1);
                this.atoms[2].getXYZ(a2);
                this.atoms[3].getXYZ(a3);
                DoubleMath.sub((double[])ad, (double[])a2, (double[])vc0);
                DoubleMath.sub((double[])a1, (double[])a2, (double[])vc1);
                DoubleMath.sub((double[])a3, (double[])a2, (double[])vc2);
                double volume = vc0[0] * (vc1[1] * vc2[2] - vc1[2] * vc2[1]) + vc1[0] * (vc2[1] * vc0[2] - vc2[2] * vc0[1]) + vc2[0] * (vc0[1] * vc1[2] - vc0[2] * vc1[1]);
                if (volume < 0.0) {
                    return -1.0;
                }
            }
        }
        return 1.0;
    }

    private double bcuint(double x1l, double x1u, double y1l, double y1u, double t1, double t2, double[] e, double[] dx, double[] dy, double[] dxy) {
        double[][] c = new double[4][4];
        double deltax = x1u - x1l;
        double deltay = y1u - y1l;
        TorsionTorsion.bcucof(deltax, deltay, e, dx, dy, dxy, c);
        double tx = (t1 - x1l) / deltax;
        double ux = (t2 - y1l) / deltay;
        double ret = 0.0;
        for (int i = 3; i >= 0; --i) {
            ret = tx * ret + ((c[i][3] * ux + c[i][2]) * ux + c[i][1]) * ux + c[i][0];
        }
        return ret;
    }

    private double bcuint1(double x1l, double x1u, double y1l, double y1u, double t1, double t2, double[] e, double[] dx, double[] dy, double[] dxy, double[] ansy) {
        double[][] c = new double[4][4];
        double deltax = x1u - x1l;
        double deltay = y1u - y1l;
        TorsionTorsion.bcucof(deltax, deltay, e, dx, dy, dxy, c);
        double tx = (t1 - x1l) / deltax;
        double ux = (t2 - y1l) / deltay;
        double ret = 0.0;
        ansy[0] = 0.0;
        ansy[1] = 0.0;
        for (int i = 3; i >= 0; --i) {
            ret = tx * ret + ((c[i][3] * ux + c[i][2]) * ux + c[i][1]) * ux + c[i][0];
            ansy[0] = ux * ansy[0] + (3.0 * c[3][i] * tx + 2.0 * c[2][i]) * tx + c[1][i];
            ansy[1] = tx * ansy[1] + (3.0 * c[i][3] * ux + 2.0 * c[i][2]) * ux + c[i][1];
        }
        ansy[0] = ansy[0] / deltax;
        ansy[1] = ansy[1] / deltay;
        return ret;
    }
}

